// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifdef GL_GRAPHICS
#define PROTEIN_GRAPHICS
#endif
#ifdef BOINC_GRAPHICS
#define PROTEIN_GRAPHICS
#endif
#ifdef PROTEIN_GRAPHICS
#ifndef _PROTEIN_GRAPHICS_H_
#define _PROTEIN_GRAPHICS_H_

// Here's where the protein graphics routines go.

#include "pose.h"

using numeric::xyzVector_float;

namespace protein_graphics {

	namespace graphics_states_param {
		//lin backbone display state
		const size_t Num_BBdisplayState = 5;
		enum BBdisplayState { SHOW_NOBB, SHOW_CARTOON, SHOW_BACKBONE, SHOW_CYLINDER, SHOW_BB_SPACEFILL };

		//lin sidechain display state
		const size_t Num_SCdisplayState = 4;
		enum SCdisplayState { SHOW_NOSC, SHOW_STICK, SHOW_WIREFRAME, SHOW_SC_SPACEFILL };

		//lin ligand display state
		const size_t Num_LIGdisplayState = 4;
		enum LIGdisplayState { SHOW_NOLIG, SHOW_LIG_STICK, SHOW_BALL_AND_STICK, SHOW_LIG_SPACEFILL };

		//lin color state
		const size_t Num_ColorModes = 5;
		enum ColorMode { RAINBOW_COLOR, CPK_COLOR, RESIDUE_COLOR, RAINBOW_CPK_COLOR, RESIDUE_CPK_COLOR };

		//lin trajectory state
		const size_t Num_TrajectoryState = 5;
		enum TrajectoryState { SHOW_LOW, SHOW_BEST, SHOW_MC_TRIALS, SHOW_ALL_TRIALS };

	}
	using namespace graphics_states_param;

	//lin define the graphics state
  class GraphicsState {
	public:
		BBdisplayState BBdisplay_state;
 		SCdisplayState SCdisplay_state;
		LIGdisplayState LIGdisplay_state;
		ColorMode Color_mode;
		TrajectoryState Trajectory_state;
		xyzVector_float previous_vertex1, previous_vertex2, previous_width_vector;

    GraphicsState() :
			BBdisplay_state (SHOW_CARTOON),//default
			SCdisplay_state (SHOW_STICK),//default
			LIGdisplay_state (SHOW_BALL_AND_STICK),//default
			Color_mode (RAINBOW_COLOR),//default
			Trajectory_state (SHOW_ALL_TRIALS),//default
      previous_vertex1( 0.0 ), previous_vertex2( 0.0 ), previous_width_vector( 0.0 )
    {}

    GraphicsState(
									BBdisplayState BBdisplay_state_in,
									SCdisplayState SCdisplay_state_in,
									LIGdisplayState LIGdisplay_state_in,
									ColorMode Color_mode_in,
									TrajectoryState Trajectory_state_in
								 ) :
			BBdisplay_state (BBdisplay_state_in),
			SCdisplay_state (SCdisplay_state_in),
			LIGdisplay_state (LIGdisplay_state_in),
			Color_mode (Color_mode_in),
			Trajectory_state (Trajectory_state_in),
      previous_vertex1( 0.0 ), previous_vertex2( 0.0 ), previous_width_vector( 0.0 )
    {}
  };

	//lin set show sidechain
	void
	set_show_sc_array( FArray1D_bool & allow_sc );

	// ge the show_sc
	bool
	get_show_sc( int const ii );

	// set show_repack
	void
	set_show_repack( bool state, int show_repack_fps );

	// get show_repack
	bool
	get_show_repack( int count = 1 );// default is 1

	/// Draws the pose.
	void draw_pose(const pose_ns::Pose & pose,
								 GraphicsState & gs,
								 bool fullatom = true, bool centered = false);

	/// Draws the pose defined by the given parameters.
	void draw_pose(int const total_residue,
				   const FArray3DB_float & full_coord,
				   const FArray3DB_float & Eposition,
				   const FArray1DB_int & res,
				   const FArray1DB_int & res_variant,
				   const FArray1DB_char & secstruct,
				   const FArray2DB_float & occupancy,
				   protein_graphics::GraphicsState & gs,
				   bool fullatom = true, bool centered = false);

	void
	plot_timeseries(
		std::vector< float > const & data,
		bool const vertical,
		float const min,
		float const max );

	void
	plot_2D(
		std::vector< float > const & xdata,
		std::vector< float > const & ydata,
		float const xmin,
		float const xmax,
		float const ymin,
		float const ymax );

	void
	get_bounds(
	   std::vector< float > const & data,
	   float & min,
	   float & max
	   );

	void
	writeStrokeString(
										const std::string & text_string,
										float xscale,
										float yscale
										 );

	//lin update packer to misc
	void
	graphics_new_packer_to_misc(
			RotamerSet const & rotamer_set,
			FArray1D_int const & state_on_node);

}

#endif /* _PROTEIN_GRAPHICS_H_ */
#endif
