// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "refine_structure.h"
#include "after_opts.h"
#include "constraints.h"
#include "counters.h"
#include "crankshaft.h"
#include "diagnostics_rosetta.h"
#include "files_paths.h"
#include "fragments.h"
#include "fullatom.h"
#include "minimize.h"
#include "misc.h"
#include "monte_carlo.h"
#include "nblist.h"
#include "param.h"
#include "ramachandran.h"
#include "recover.h"
#include "refold.h"
#include "score.h"
#include "score_ns.h"
#include "smallmove.h"
#include "torsion_bbmove_trials.h"

// Utility Headers
#include <utility/io/izstream.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/formatted.io.hh>

// C++ Headers
#include <cmath>
#include <fstream>
#include <iostream>


// Namespaces
namespace refine_control {
	float init_temp = { 2.0 };
	float final_temp = { 2.0 };
	int cycles1 = { 2000 };
	int cycles2 = { 500 };
	int cycles3 = { 500 };
	int nloop1 = { 40 };
	int nloop2 = { 10 };
	int nloop3 = { 10 };
	float helix1 = { 2.0 };
	float helix2 = { 2.0 };
	float helix3 = { 2.0 };
	float strand1 = { 5.0 };
	float strand2 = { 3.0 };
	float strand3 = { 2.0 };
	float loop1 = { 5.0 };
	float loop2 = { 3.0 };
	float loop3 = { 2.0 };
	float noe_weight = { 2.0 };
	float rdc_weight = { 50.0 };
}


////////////////////////////////////////////////////////////////////////////////
/// @begin refine_structure
///
/// @brief
///car  refinement via wobble and chuck moves, centroid and full atom
///car assumes all arrays are initialized, position, best, low, low_sc
///car alreay occupied.
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
refine_structure()
{

	using namespace misc;
	using namespace refine_control;

	//int size;
	float cutoff;
	int nloop,cycles;
	float gamma, temperature;

//------------------------------------------------
	if ( get_fast_refine_protocol() ) {
		refine_structure_fast();
		return;
	}
	refine_setup();

	std::cout << "Starting structure refinement via simmulated annealing" << std::endl;
	monte_carlo_set_simannealing(true);
	set_fullatom_flag(false);
	classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
	choose_frag_set_top_N_frags(200);
	minimize_exclude_sstype(true,false);
	score_set_cst_weight(noe_weight);
	score_set_dpl_weight(rdc_weight/5);
	score_set_cst_mode(3);
	score_set_lj_weight(1.0);
	minimize_set_local_min(true,5);

	nloop = nloop1 + nloop2 + nloop3;
	cycles = cycles1 + cycles2 + cycles3;
	gamma = std::pow( (final_temp/init_temp), (1.0f/float(nloop*cycles)) );
	temperature = init_temp;
	monte_carlo_set_temp(temperature);

	std::cout << "regular moves..." << std::endl;
	//size = 3;
	cutoff = 60.0;
	recover_LOW(score7);
	logfile_output(0);

	main_minimize_trial(score7,"dfpmin");
	logfile_output(0);

	reset_trial_counters();
	set_smallmove_size(helix1,strand1,loop1);
	for ( int jk = 1; jk <= nloop1; ++jk ) {
		if ( jk == 30 ) {
			score_set_dpl_weight(rdc_weight);
			recover_LOW(score7);
		}
		for ( int j = 1; j <= cycles1; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
			main_small_trial(score7,j*jk);
			main_shear_trial(score7,j*jk);
			main_wobble_trial(3,cutoff,score7,j,1,8);
			main_wobble_trial(1,cutoff,score7,j,1,8);
		}
		refold(1,total_residue);
		logfile_output(jk);
	}

	output_trial_counters( std::cout );

	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "linmin moves..." << std::endl;
	set_use_nblist(true);
	set_smallmove_size(helix2,strand2,loop2);
	//size = 3;
	cutoff = 60.0;

	recover_LOW(score7);
	logfile_output(0);

	main_minimize_trial(score7,"dfpmin");
	logfile_output(0);

	reset_trial_counters();
	for ( int jk = 1; jk <= nloop2; ++jk ) {
		for ( int j = 1; j <= cycles2; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
			main_small_min_trial(5,score7,j*jk,"linmin");
			main_shear_min_trial(5,score7,j*jk,"linmin");
			main_crank_min_trial(1,cutoff,score7,j,1,2,"linmin");
			main_crank_min_trial(3,cutoff,score7,j,1,2,"linmin");
			main_wobble_min_trial(1,cutoff,score7,j,1,8,"linmin");
		}
		refold(1,total_residue);
		logfile_output(jk);
	}                     // jk

	output_trial_counters( std::cout );


	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "dfpmin moves..." << std::endl;
	set_smallmove_size(helix3,strand3,loop3);
	recover_LOW(score7);
	logfile_output(0);

	main_minimize_trial(score7,"dfpmin");
	logfile_output(0);

	reset_trial_counters();
	for ( int jk = 1; jk <= nloop3; ++jk ) {
		for ( int j = 1; j <= cycles3; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
			main_small_min_trial(5,score7,j*jk,"dfpmin");
			main_shear_min_trial(5,score7,j*jk,"dfpmin");
			main_crank_min_trial(1,cutoff,score7,j,1,2,"dfpmin");
			main_crank_min_trial(3,cutoff,score7,j,1,2,"dfpmin");
			main_wobble_min_trial(1,cutoff,score7,j,1,8,"dfpmin");
		}
		refold(1,total_residue);
		logfile_output(jk);
	}                     // jk

	output_trial_counters( std::cout );

}


////////////////////////////////////////////////////////////////////////////////
/// @begin refine_structure_fast
///
/// @brief
///car  refinement via wobble and chuck moves, centroid and full atom
///car assumes all arrays are initialized, position, best, low, low_sc
///car alreay occupied.
///
/// @detailed
///cdb   this fast refine protocol is intended for use with NMR structures
///cdb   and comparative models where the goal is to preserve the overall
///cdb   topology but to exchange out the local structure with fragments
///
/// @global_read
///// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
refine_structure_fast()
{

	using namespace misc;
	using namespace refine_control;

	//int size;
	float cutoff;
	int cycles;
	float gamma, temperature;

//------------------------------------------------

	std::cout << "Starting refinement by replacing local structure with fragments" << std::endl;
	set_refine_control_fast();
	// reset default values in refine_control namespace to values
	// appropriate for fast protocol.  if a refine control file exists, these
	// will be overwritten by the next call
	refine_setup();
	monte_carlo_set_simannealing(true);
	set_fullatom_flag(false);
	classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
	choose_frag_set_top_N_frags(200);
	minimize_exclude_sstype(true,false);
	score_set_cst_weight(noe_weight);
	score_set_dpl_weight(rdc_weight/5);
	score_set_cst_mode(1);
	score_set_lj_weight(1.0);
	minimize_set_local_min(true,5);

	cycles = cycles1 + cycles2 + cycles3;
	gamma = std::pow( (final_temp/init_temp), (1.0f/float(cycles)) );
	temperature = init_temp;
	monte_carlo_set_temp(temperature);

	std::cout << "smooth moves..." << " cst_wt" << noe_weight << std::endl;

	cutoff = 60.0;
	recover_LOW(score7);
	logfile_output(0);

	reset_trial_counters();
	set_smallmove_size(helix1,strand1,loop1);

	float smooth_cutoff=50.;
		for ( int j = 1; j <= cycles1; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
// use smooth moves here to avoid check on helix length in choose_fragment
			main_smooth_trial(9,smooth_cutoff,score7,j);
			main_smooth_trial(3,smooth_cutoff,score7,j);
			main_wobble_trial(9,260.0,score7,j,1,8);
			main_wobble_trial(3,260.0,score7,j,1,8);
		}
		refold(1,total_residue);
		logfile_output(0);


	output_trial_counters( std::cout );

	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "linmin moves..." << std::endl;
	set_use_nblist(true);
	set_smallmove_size(helix2,strand2,loop2);

	cutoff = 60.0;

	recover_LOW(score7);
	logfile_output(0);

	main_minimize_trial(score7,"dfpmin");
	logfile_output(0);

	reset_trial_counters();
		for ( int j = 1; j <= cycles2; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
			main_crank_min_trial(1,200.,score7,j,1,2,"linmin");
			main_crank_min_trial(3,200.,score7,j,1,2,"linmin");
			main_wobble_min_trial(3,200.,score7,j,1,5,"linmin");
			main_wobble_min_trial(1,200.,score7,j,1,2,"linmin");
		}
		refold(1,total_residue);
		logfile_output(0);


	output_trial_counters( std::cout );


	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "-----------------------------------------------------" << std::endl;
	std::cout << "dfpmin moves..." << std::endl;
	set_smallmove_size(helix3,strand3,loop3);
	recover_LOW(score7);
	logfile_output(0);

	main_minimize_trial(score7,"dfpmin");
	logfile_output(0);

	reset_trial_counters();

		for ( int j = 1; j <= cycles3; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
			main_small_min_trial(5,score7,j,"linmin");
			main_shear_min_trial(15,score7,j,"linmin");
			main_crank_min_trial(1,60.,score7,j,1,2,"linmin");
			main_wobble_min_trial(1,60.,score7,j,1,3,"linmin");
		}
		refold(1,total_residue);
		logfile_output(0);


	output_trial_counters( std::cout );

}

////////////////////////////////////////////////////////////////////////////////
/// @begin refine_setup
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
refine_setup()
{
	using namespace files_paths;
	using namespace refine_control;


//car set temperature range...

//car self initialization
	static bool refine_init = { false };
	static std::string last_protein;
	static char last_chain = { ' ' };

//car default temperatures

//car default number of move trials

//car default smallmove step
// all helix 0

//car format for refinement setup file
//car name: 2ptl_.refine
//car lines in all caps are comments:
//car ---------------------
//car TEMPERATURE
//car 5.0
//car 0.5
//car REGULAR MOVES
//car 40
//car 500
//car 0.0 5.0 5.0
//car linmin MOVES
//car 10
//car 100
//car 0.0 3.0 3.0
//car dfpmin MOVES
//car 10
//car 100
//car 0.0 1.0 1.0
//car NOE, RDC weight
//car 2.0
//car 50.0
//car ---------------------

//car initialize last_protein,last_chain for first call
	if ( !refine_init ) {
		last_protein = protein_name;
		last_chain = protein_chain;
	}

//car check to see if were on a new protein
	if ( last_protein != protein_name || last_chain != protein_chain )
	 refine_init = false;

	if ( refine_init ) return;
	refine_init = true;
	last_protein = protein_name;
	last_chain = protein_chain;

	std::string const filename( start_path + protein_name_prefix + protein_name + protein_chain + ".refine" );
	std::cout << "Looking for refinement input file: " << filename << std::endl;
	start_x.clear();
	start_x.open( filename );
	if ( !start_x ) {
		std::cout << "unable to find refine input file: " << start_x.filename() << std::endl;
		std::cout << "using default values" << std::endl;
		start_x.clear();
		return;
	}
	start_x >> skip; // temperatures
	start_x >> init_temp >> skip;
	start_x >> final_temp >> skip;
	std::cout << "initial temperature: " << F( 4, 1, init_temp ) << std::endl;
	std::cout << "final temperature: " << F( 4, 1, final_temp ) << std::endl;
	start_x >> skip; // regular moves
	start_x >> nloop1 >> skip;
	start_x >> cycles1 >> skip;
	start_x >> bite( 3, helix1 ) >> skip( 1 ) >>
	 bite( 3, strand1 ) >> skip( 1 ) >> bite( 3, loop1 ) >> skip;
	std::cout << "Regular moves: " << I( 4, nloop1 ) <<
	 " x " << I( 4, cycles1 ) << " steps" << std::endl;
	std::cout << "   move sizes: helix" << F( 4, 1, helix1 ) << std::endl;
	std::cout << "               strand" << F( 4, 1, strand1 ) << std::endl;
	std::cout << "               other" << F( 4, 1, loop1 ) << std::endl;
	start_x >> skip; // linmin moves
	start_x >> nloop2 >> skip;
	start_x >> cycles2 >> skip;
	start_x >> bite( 3, helix2 ) >> skip( 1 ) >>
	 bite( 3, strand2 ) >> skip( 1 ) >> bite( 3, loop2 ) >> skip;
	std::cout << "linmin moves: " << I( 4, nloop2 ) <<
	 " x " << I( 4, cycles2 ) << " steps" << std::endl;
	std::cout << "   move sizes: helix" << F( 4, 1, helix2 ) << std::endl;
	std::cout << "               strand" << F( 4, 1, strand2 ) << std::endl;
	std::cout << "               other" << F( 4, 1, loop2 ) << std::endl;
	start_x >> skip; // dfpmin moves
	start_x >> nloop3 >> skip;
	start_x >> cycles2 >> skip;
	start_x >> bite( 3, helix3 ) >> skip( 1 ) >>
	 bite( 3, strand3 ) >> skip( 1 ) >> bite( 3, loop3 ) >> skip;
	std::cout << "dfpmin moves: " << I( 4, nloop3 ) <<
	 " x " << I( 4, cycles3 ) << " steps" << std::endl;
	std::cout << "   move sizes: helix" << F( 4, 1, helix3 ) << std::endl;
	std::cout << "               strand" << F( 4, 1, strand3 ) << std::endl;
	std::cout << "               other" << F( 4, 1, loop3 ) << std::endl;
	start_x >> skip; // cst, dpl weight
	start_x >> noe_weight >> skip;
	if ( start_x.fail() ) goto L100;
	start_x >> rdc_weight >> skip;
	if ( start_x.fail() ) goto L100;
	std::cout << "noe weight: " << F( 4, 1, noe_weight ) << std::endl;
	std::cout << "rdc weight: " << F( 4, 1, rdc_weight ) << std::endl;

L100:
	start_x.close();
	start_x.clear();

}

////////////////////////////////////////////////////////////////////////////////
/// @begin logfile_output
///
/// @brief
///
/// @detailed
///
/// @param  jk - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
logfile_output( int jk )
{
	using namespace counters;
	using namespace misc;
	using namespace scores;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	float fav,alw,gen;

	eval_procheck_rama(phi,psi,res,total_residue,fav,alw,gen);
	if ( jk <= 0 ) {
		std::cout << "jk nlowacc   score    low_sc low_rms rms_min vdw" <<
		 "   rama     pc  dipolar  fav  alw  gen  dis" << std::endl;
	}
	std::cout << I( 2, jk ) << ' ' << I( 5, n_low_accept ) << ' ' << ' ' <<
	 F( 9, 2, scorefxn() ) << ' '; // Sequence point
	std::cout << F( 9, 2, low_score ) << ' ' <<
	 F( 5, 2, low_rms ) << ' ' << F( 5, 2, rms_min ) << ' ' <<
	 F( 7, 2, vdw_score ) << ' ' << F( 7, 2, ramachandran_score ) << ' ' <<
	 F( 7, 2, pc_score ) << ' ' << F( 7, 2, dipolar_score ) << ' ' <<
	 F( 4, 2, fav ) << ' ' << F( 4, 2, alw ) << ' ' <<
	 F( 4, 2, gen ) << ' ' << F( 4, 2, 1.0-fav-alw-gen ) << std::endl;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_fast_refine_protocol
///
/// @brief
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool
get_fast_refine_protocol()
{
	static int protocol = { 0 }; // 0 = undef; 1=fast; 2=standard

	if ( protocol == 0 ) {
		protocol = ( truefalseoption("fast") ? 1 : 2 );
	}

	return ( protocol == 1 );
}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_refine_control_fast
///
/// @brief
///    set refine control parameters to values suitable for fast refine protocol
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
void
set_refine_control_fast()
{
	using namespace refine_control;

	static bool refine_control_init = { false };
	if ( refine_control_init ) return;
	refine_control_init = true;

	init_temp = 4.0;
	final_temp = 2.0;
	cycles1 = 500;
	cycles2 = 300;
	cycles3 = 100;
	noe_weight = .05;
}
