#!/bin/bash
#  CVS information:
#  $Revision: 5779 $
#  $Date: 2005-02-11 03:44:55 +0200 (Fri, 11 Feb 2005) $
#  $Author: chu $

# remove trailing space from the files in the current dir.
# currently only for *.cc and *.h files

if [ $# -eq 0 ]
    then
    echo Usage: $(basename $0) ? "<file1 file2 ...> or <ALL>"
    echo Info: remove trailing spaces from  \*\.cc and \*\.h files
    exit
fi

if [ $1 == "ALL" ]
    then
    files=$(\ls *.cc; \ls *.h)
else
    files=$(echo $@ | sed 's/\/$//g')
fi


for p in $files
  do
  if [ -s $p ]
      then
      cat $p | sed -e 's/ *$//' > tmp_$p
      mv tmp_$p $p
  else
      echo WARNING: $p does NOT exist, skipping...
  fi
done

exit