// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.10 $
//  $Date: 2005/10/26 20:30:45 $
//  $Author: flo $

#ifndef INCLUDED_rotamer_explosion_ns
#define INCLUDED_rotamer_explosion_ns

//Rosetta Headers
#include "pose_fwd.h"
#include "DesignMap.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// C++ Headers
#include <string>

//forward declarations
#include "RotamerSetFWD.h"


namespace rotamer_explosion {

  extern pose_ns::Pose *rotmin_pose;
  extern pose_ns::Score_weight_map *rotmin_score_weight_map;
	extern std::map<int,bool> rotamers_to_minimize;
	extern std::map<int,float> rotamer_lig_energies;

}


bool
screen_exploded_rotamers_ligand(
	int const ppos,
	int const paa,
	int const paav,
	FArray1DB_float & temp_chi,
	DesignMap const & design_map
);

bool
prescreen_base_rotamer_ligand_contacts(
	int const seqpos,
	int const aa,
	int const aav,
	FArray1Da_float base_chi
);

void screen_rotamer_set_for_ligand_contacts(
	const FArray3D_float & full_coord,
	RotamerSet const & rotamer_set,
	std::map<int,bool> & best_rotamers,
	int screen_start_rotamer
);

#endif
