// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_rotamer_functions
#define INCLUDED_rotamer_functions


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Ds.hh>
#include <ObjexxFCL/FArray2Ds.hh>
#include <ObjexxFCL/FArray3Ds.fwd.hh>

// C++ Headers
#include <list>

// forward declarations
#include "PackerTask_fwd.h" // class DesignMap
#include "pose_fwd.h" //need pose for rotamer minimization

namespace rotamer_minimization {
	// chu
	extern FArray1D_float sc_chi;  // all the chi angles for each rotamer tried.
	extern FArray1D_float start_chi;
	extern FArray2D_float sc_rotcoord; // the coord for this rotamer
	extern FArray1D_float sc_rot_born_radius;
	extern FArray1D_float sc_rotactcoord;
	extern FArray1D_int sc_rotid; // all the rotamer id ...
	extern int sc_seqpos; // sequence position of the current residue with side-chain minimized
	extern int sc_aa; // residue type of ...
	extern int sc_aav; // variant type
	extern int sc_nfree; // num of freedom on this side-chain
}

void get_extrachi(
  int const aa,
  int const aav,
  FArray1Da_float base_chi,
  FArray1Da_float base_sd,
  int & neighbors,
	std::list< FArray1D_float > & total_chi_set,
	std::list< FArray1D_int > & total_rot_set,
  int const seqpos,
  const DesignMap & design_map
);

void get_exrotset_from_db(
  int const aa,
  FArray1Da_float base_chi,
  FArray1Da_float base_sd,
  bool const is_buried,
	std::list< FArray1D_float > & total_chi_set,
	std::list< FArray1D_int > & total_rot_set
);

void calc_exrotset_from_exflags(
  int const aa,
  int const aav,
  FArray1Da_float base_chi,
  FArray1Da_float base_sd,
  bool const is_buried,
	std::list< FArray1D_float > & total_chi_set,
	std::list< FArray1D_int > & total_rot_set,
  int const seqpos,
  DesignMap const & design_map
);

bool
screen_exploded_rotamers(
	int const ppos,
	int const paa,
	int const paav,
	FArray1DB_float & temp_chi,
	DesignMap const & design_map,
	bool const rot_explosion_prescreen
);

bool
is_chi_proton_rotamer(
	int aa,
	int aav,
	int chino
);

void
get_ser_thr_hchi(
	bool const is_extra,
	int & count,
	FArray1Da_float chi
);

void
get_rna_hchi(
	bool const is_extra,
	int & count,
	FArray1Da_float chi
);

void
get_tyr_hchi(
	bool const is_extra,
	int & count,
	FArray1Da_float chi
);

void
get_rot_coord(
	FArray3DB_float const & full_coord,
	int const aa,
	int const aav,
	FArray1Da_float chi,
	FArray2Da_float rotcoord,
	int const seqpos
);

void
get_rot_coord(
	FArray3DB_float & full_coord,
	int const aa,
	int const aav,
	FArray1Da_float chi,
	FArray2Da_float rotcoord,
	int const seqpos,
	FArray2Da_float template_coord
);

void
get_coords_by_name_and_placement(
	int const aa,
	int const source_aav,
	FArray2Da_float source_coords,
	int const target_aav,
	FArray2Da_float target_coords
);

bool
coord_match_aa(
	int const aa,
	int const aav,
	FArray2Da_float coord
);

short
get_aa_rotno_to_packedrotno(
	int aa,
	int aav,
	FArray1Da_int rot
);

void
rotamer_from_chi(
	FArray1Da_float chi,
	int const aan,
	FArray1Da_int rot
);

float
sidechain_rmsd(
	int const aa1,
	int const aav1,
	FArray2Da_float coord1,
	int const aa2,
	int const aav2,
	FArray2Da_float coord2
);

#endif
