// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8960 $
//  $Date: 2006-06-27 23:21:46 -0700 (Tue, 27 Jun 2006) $
//  $Author: possu $

#ifndef INCLUDED_saxs_model
#define INCLUDED_saxs_model

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


void
eval_saxs_model_score(
   float & saxs_model_score
);

float
calc_diff_to_saxs_model();

void
calculate_saxs_profile(
			     FArray3Da_float  pos,
			     FArray2Da_float  centroid,
					 FArray1D_double & saxs_profile
);

void
read_saxs_profile();

void
initialize_saxs_profile();

void
input_saxs_profile_from_file();

void
input_saxs_model_from_file();

void
output_saxs_profile( std::string fullname );

bool
get_saxs_model_score_flag();

bool
get_saxs_model_flag();

bool
get_output_saxs_profile_flag();

double
get_saxs_model_power();

float
get_saxs_model_weight();

void
initialize_saxs_basis();

void
atomicnumber_centroid_initializer( FArray1D_int & atomic_number_centroid );

#endif
