// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $

#ifndef INCLUDED_score_name
#define INCLUDED_score_name


// Rosetta Headers

// ObjexxFCL Headers

// C++ Headers
#include <cstdlib>


namespace pose_ns
{
	enum Score_name {
		SCORE,// 0D scores: keep this at line 20!
		VDW,
		VDW_CACHE, // just for vdw.cc
		ENV,
		PAIR,
		CB,
		SHEET,
		SSPAIR, // avoid conflict with ObjexxFCL::SS
		HS,
		RSIGMA,
		RAMACHANDRAN,
		RG,
		CO,
		CONTACT_MJ,
		CHAINBREAK,
		EDENSITY,
		EXTRA,
		DUMMY_MODEL,
		NSD,
		FA_ATR, // fullatom scores...
		FA_REP,
		FA_SOL,
    FA_ELEC,
		FA_PAIR,
		FA_REF,
		FA_DUN,
		FA_PROB,
		FA_H2O,
		HB_SRBB,
		HB_LRBB,
		HB_SC,
		SIDECHAIN_BOND_ANGLE,
		FA_INTRA,
		GSOLT,
		GB,
//    ELEC, // SJF DEBUGGING
		PLANE,
		SASA,
		SASA_PACK,
		ENERGY_PACK,
		DELG_PACK,
		BOND_ANGLE,
		ATOMPAIR_CST,
		COORD_CST,
		CHAINBREAK_CST,
		PHIPSI_CST, // new-style torsion tethering
		OMEGA_CST, // new-style torsion tethering
		CHI_CST, // new-style torsion tethering
		KIN_1D_CST, // atomtree torsion tether
		KIN_3D_CST, // atomtree coord-angle/torsion tether
		PHIPSI, // old phipsi torsion tether
		OMEGA, // old omega torsion tether
		TETHER, // old torsion tether
		SYMM,
		DNA_AA, // defunct
		DNA_R,  // see older revisions on dna branch
		DNA_BS, // dna base-step
		DNA_BP, // dna base-pair
		RNA_BS, // rna base stacking (low res)
		RNA_BP_W, // rna base pairing (low res) Watson-Crick edge
		RNA_BP_H, // rna base pairing (low res) Hoogsteen edge
		RNA_BP_S, // rna base pairing (low res) Sugar edge
		RNA_AXIS, // rna base pairing (low res)
		RNA_STAGGER, // rna base pairing (low res)
		RNA_BULGE, // rna favor bulges...
		RNA_NONBASEBASE, // Hydrogen bonds between bases and non-bases (phosphates/sugar oxygens)
		RNA_O2STAR, // low res 2'-OH/backbone score.
		RNA_PHOSPHATE, // low res phosphate-phosphate repulsion.
		RNA_CONTACT, // specified rna base pairs.
		RNA_LONG_RANGE_CONTACT, // specified rna low-resolution contacts.
		RNA_SASA, // specified solvent-accessible surface area (e.g., from footprinting)
		CUT_WEIGHT,
		RMSD,// diagnostics
		RMSD_MIN,
		MAXSUB,
		BARCODE,
		BARCODE_ENERGY,
		CST_SCORE,
		RMSD_G,
		START_RMSD,
		SS_LOWSTRAND,
		SS_CUTOFF,
		PC_MODE,
		CHAINBREAK_OVERLAP,
		FA_SCOREFXN,
		BBONLY_SCOREFXN,
		RNAONLY_SCOREFXN,

		/*docking specific begin --chu*/
		DOCK_SCOREFXN,
		DOCK_ENV,
		DOCK_PAIR,
		DOCK_CONT,
		DOCK_CONT_CAP,
		DOCK_VDW,
		DOCK_SITE_CST,
		DOCK_FAB,
		DOCK_FAB_CAP,
		DOCK_WSL_ELEC,
    DOCK_ELEC,
		/*docking specific end --chu*/

		/*domain insertion specific begin -- Monica Berrondo */
		DOM_SCOREFXN,
		DOM_CONT,
		DOM_CONT_CAP,
		DOM_DIST_CST,
		DOM_VDW,
		/* domain insertion specific end -- Monica Berrondo */

		/*antibody loop mode score begin -- aroop */
		LOOP_SCOREFXN,
		LOOP_CONTACT,
		/*antibody loop mode score end -- aroop */

		DUNENERGY, // 1D scores
		PROBENERGY,
		INTRARESENERGY,
		BONDANGLEENERGY,
		RESENERGY,
		UNFENERGY,
		ATR_PAIR, // 2D scores
		REP_PAIR,
		SOL_PAIR,
    ELEC_PAIR,
		GB_PAIR,
		CENDIST,
		CST_PAIR,
		BBHB_CACHE,
		VDW_PAIR, // 2D
		RNA_BASE_STACK_ARRAY,
		RNA_BASE_STACK_AXIS_ARRAY, //2D
		RNA_BASE_PAIR_ARRAY,
		RNA_BASE_AXIS_ARRAY,
		RNA_BASE_STAGGER_ARRAY,
		RNA_BASE_GEOMETRY_ORIENTATION_ARRAY,
		RNA_BASE_GEOMETRY_HEIGHT_ARRAY //3D
	};
}

#endif
