// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7151 $
//  $Date: 2005-12-15 03:59:57 +0200 (Thu, 15 Dec 2005) $
//  $Author: mtyka $


#ifndef INCLUDED_socketcom
#define INCLUDED_socketcom

// The code below is using linux specific socket libraries
#ifdef __linux__

double sillywait(int n);
int sendDataBlock(int sockd,const char *data,unsigned int length);
int recvDataBlock(int sockd, char **data);
int recvDataBlock_fastmem(int sockd, char *data, int maxlength);
int setup_listening_port(unsigned short int port);
int setup_connection_to_server( unsigned short int port,
															 const char *srvaddress,
															 int nattempts,
															 int waitbetween);

//////////////////////////////////////////
//
// ROSETTA specific stuff

// client requests
#define RDIST_CLNT_GETID           12
#define RDIST_CLNT_EXCHANGEPDBNAME 13
#define RDIST_CLNT_LOGOFF          14

// server responces
#define RDIST_SRV_ERROR            128
#define RDIST_SRV_RETRY            129
#define RDIST_SRV_FINISH           130
#define RDIST_SRV_STARTEXTENDED    131
#define RDIST_SRV_IDLE             132

int request_new_id(int sockfd);
int request_logoff(int sockfd, int myid);
int request_new_structure(int sockfd,                   // Socket Handle
													const std::string &finishedpdb,            // pointer to memory with the finished pdb
													int structureid,              // id of parent structure
													std::string &controlstruct, //  will contain 64 bytes of mode-specific commands/parameters
													std::string &newpdbfile);

// Mode specific control structures
// *HAVE* to be 16 ints (64 bytes) long !!

// null control structure (dummy)
struct null_control{
	int dummy[16];         // fill up to 16 ints
};

// abinitio
struct abinitio_control{
	int id;
	int stage1_ncycles;
	int stage2_ncycles;
	int stage3_nloops;
	int stage3_ncycles;
	int stage4_nloops;
	int stage4_ncycles;
	int dummy[9];         // fill up to 16 ints
};


// abinitio
struct relax_control{
	int do_stage1;
	int stage1_ncycles;
	int do_stage2;
	int stage2_ncycles;
	int do_stage3;
	int stage3_ncycles;
	int do_stage4;
	int stage4_ncycles;
	int do_stage5;
	int stage5_ncycles;
	int dummy[6];         // fill up to 16 ints
};


#endif
#endif
