// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $


// Unit headers
#include "spline.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Utility Headers
#include <utility/vector1.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <string>
#include <sstream>


using namespace std;
using namespace utility;

void
spline_fill_marked_gaps(
	FArray1Da_float x,
	FArray1Da_float y,
	FArray1Da_float dy,
	float badval,
	bool verbose
)
{
  FArray1D_bool good(x.size1());
  for ( int ii = 1; ii <= (int)x.size1(); ++ii )
    good(ii) = (y(ii)!=badval);
  spline_fill_gaps(x,y,dy,good,verbose);
}


// below is a bad hack...
// it interpolates between a single start and end point
// start point if first "bad" value in the array
// end point is the last "bad" value in the array
// to be more useful, it should interpolate separately between
// all gaps
void
spline_fill_gaps(
	FArray1Da_float x,
	FArray1Da_float y,
	FArray1Da_float dy,
	FArray1Da_bool  good,
	bool verbose
)
{
  using namespace utility;
//	std::cout << "xsize1 " << x.size1() << " ysize1 " << y.size1() << std::endl;
  assert(x.size1()==y.size1()==dy.size1()==good.size1());
  //assert(good(1) && good((int)good.size1()));
  bool test = true;
  if(verbose) cout << "X SIZE " << (int)x.size1() << endl;
  if(test) {
    for ( int ii = 1; ii <= (int)x.size1(); ++ii )
      if(verbose) cout << y(ii) << ' ';
    if(verbose) cout << endl;
  }

  // check that ends are good
  if(!good(1)) {
       y(1) = 0;
      dy(1) = 0;
    good(1) = true;
  }
  if(!good((int)good.size())) {
       y((int)good.size()) = 0;
      dy((int)good.size()) = 0;
    good((int)good.size()) = true;
  }

  vector1<int> vecbegin;
  vector1<int> vecend;
  {
    int begin = 1;
    int end   = 1;
    //int count = 1;
    while ( true ) {
      while ( good(begin) && begin <= (int)good.size() )
	++begin;
      if ( begin > (int)good.size() )
	break;
      --begin; // begin is just before interpolated section
      end = begin+1;
      while ( !good(end) && end <= (int)good.size() )
	++end;
      if ( begin > (int)good.size() ) {
	cout << "spline.cc: RAN OFF END OF GOOD ARRAY!!" << endl;
	break;
      }
      vecbegin.push_back(begin);
      vecend.push_back(end);
      begin = end;
    }
  }

  //if(begin >end )
  //  return;

  for ( int kk = 1; kk <= (int)vecbegin.size(); ++kk ) {

    int const begin = vecbegin[kk];
    int const end   = vecend  [kk];

    if(verbose) cout << "SPLINE interpolating between "<< begin+1 << " and " << end-1 << endl;

    float dy1 = dy(begin);
    float dy2 = dy(end);
    if( dy1 < -9e8 ) {
      dy1 = (y(begin)-y(begin-1)) / (x(begin)-x(begin-1));
    }
    if( dy2 < -9e8 ) {
      dy2 = (y(end+1)-y(end))     / (x(end+1)-x(end));
    }

    vector1<float> xv;
    vector1<float> yv;
    for(int ii=begin; ii<=end;ii++) {
      if(good(ii)) {
	xv.push_back(x(ii));
	yv.push_back(y(ii));
	if(verbose) cout << "INTAG " << x(ii) << ' ' << y(ii) << endl;
      }
    }
    vector1<float> ddy = spline_second_derivative(xv,yv,dy1,dy2);
    for(int ii=begin; ii<=end;ii++) {
      spline_interpolate(xv,yv,ddy,x(ii),y(ii),dy(ii));
      if(verbose)  cout << "OUTTAG " << x(ii) << ' ' << y(ii) << ' ' << dy(ii) << endl;
    }

    int const N = (int)dy.size1();
    if(dy(1) <  -9e8)
      dy(1) =  (y(2)-y(1)) / (x(2)-x(1));
    for ( int ii = 2; ii <= N-1; ii++)
      if( dy(ii) < -9e8 )
	dy(ii) = (y(ii+1)-y(ii-1)) / (x(ii+1)-x(ii-1));
    if(dy(1) < -9e8)
      dy(1) =  (y(N)-y(N-1)) / (x(N)-x(N-1));

  }

    // this following is how the spline function should work...
  // fill all gaps and treat single given points as anchors
  // within a "gap"
//   if(0) {

//   //FArray1D_float ynew(y);
//   int N = (int)x.size1();
//   vector1<float> xi;
//   vector1<float> yi;
//   float yp1,ypn;
//   int start=0,finish=0;
//   assert( good(1) && good(2) && good(N-1) && good(N) );

//   for(int ii = 3; ii <= (int)x.size1()-1; ii++) {

//     // start new interp region (bad Yii and Yii-1/2 good not in interp)
//     if( start==0 && !good(ii) ) {
//       if(verbose) cout << ii << " start new interp region" << endl;
//       assert( good(ii-2) && good(ii-1) );
//       start = ii;
//       xi.push_back(x(start-1));
//       yi.push_back(y(start-1));
//       // finish interp region       ( good Yii & Yii+1 & in interp)
//     } else if ( start !=0 && good(ii) && good(ii+1) ) {
//       if(verbose) cout << ii << " finish interp region " << endl;
//       finish = ii-1;
//       if(verbose) cout << ii << " finish interp region 2" << endl;
//       yp1 = ( y(start -1) - y(start -2) ) / ( x(start -1) - x(start -2) );
//       ypn = ( y(finish+2) - y(finish+1) ) / ( x(finish+2) - x(finish+1) );
//       if(verbose) cout << ii << " finish interp region 3 " << yp1 << ' ' << ypn << endl;
//       xi.push_back(x(finish-1));
//       yi.push_back(y(finish-1));
//       if(verbose) cout << ii << " finish interp region 4" << endl;
//       vector1<float> y2 = spline_second_derivative(xi,yi,yp1,ypn);
//       if(verbose) cout << ii << " finish interp region 5" << endl;
//       //      for(
//       for(int jj = start; jj <= finish; jj++)
// 	spline_interpolate(xi,yi,y2,x(jj),y(jj),dy(jj));
//       if(verbose) cout << ii << " finish interp region 6" << endl;
//       xi.clear();
//       yi.clear();
//       //y(ii) = y(ii);
//       start = 0;
//       finish = 0;
//       // in interp region & add point ( good Yii and bad Yii+1  )
//     } else if ( start != 0 && good(ii) && !good(ii+1) ) {
//       if(verbose) cout << ii << " in interp region & add point" << endl;
//       xi.push_back(x(ii));
//       yi.push_back(y(ii));
//       //y(ii) = y(ii); // shouldn't be necessary
//       // in interp region and skip point
//     } else if ( start != 0 && !good(ii) ) {
//       if(verbose) cout << ii << " in interp region and skip point" << endl;
//       ; // do nothing
//     } else if ( start == 0 && good(ii) ) {
//       if(verbose) cout << ii << " do nothing" << endl;
//       //y(ii) = y(ii);
//     } else {
//       //barf!
//       if(verbose) cout << ii << " spline_interpolate: BAD CONDITION" << endl;
//     }

//   }
//   }

//   if(test) {
//     if(verbose) cout << "s='";
//     for ( int ii = 1; ii <= (int)x.size1(); ii++)
//       if(verbose) cout << y(ii) << ' ' ;
//     if(verbose) cout << "'" << endl;
//   }

}

//Given arrays x[1..n] and y[1..n] containing a tabulated function,
//i.e., y i = f(xi),with x1 < x2 <...<xN , and given values yp1 and
//ypn for the first derivative of the interpolating function at
//points 1 and n, respectively, this routine returns an array y2[1..n]
//that contains the second derivatives of the interpolating function
//at the tabulated points xi.Ifyp1 and/or ypn are equal to 1  10 30
//or larger, the routine is signaled to set the corresponding
//boundary condition for a natural spline, with zero second
//derivative on that boundary.
utility::vector1<float>
spline_second_derivative(
	utility::vector1<float> const & x,
	utility::vector1<float> const & y,
	float yp1,
	float ypn,
	bool verbose
)
{

  float p,qn,sig,un;

  if(verbose) cout << "spline second derivative 1 yp1 " << yp1 << " ypn " << ypn<< endl;
  if(verbose) cout << "                      x:" ;
  for(int ii=1; ii<=(int)x.size();ii++)
    if(verbose) cout << ' ' << x[ii] ;
  if(verbose) cout << endl;
  if(verbose) cout << "                      y:" ;
  for(int ii=1; ii<=(int)y.size();ii++)
    if(verbose) cout << ' ' << y[ii] ;
  if(verbose) cout << endl;

  int n = x.size();
  utility::vector1<float> y2(n);
  utility::vector1<float> u(n-1);

  if(verbose) cout << "spline second derivative 2 "<< n <<  endl;
  //The lower boundary condition is set either to be  nat-ural  y2[1]=u[1]=0.0;
  if (yp1 > 0.99e30) {
    //or else to have a specified first derivative.
    y2[1] = u[1]=0.0;
  } else {
    y2[1] = -0.5;
    u[1]=(3.0/(x[2]-x[1]))*((y[2]-y[1])/(x[2]-x[1])-yp1);
  }
  if(verbose) cout << "spline second derivative 3 " << u[1] << endl;
  //This is the decomposition loop of the tridiagonal al-gorithm.
  //y2 and u are used for tem-porary storage of the decomposed factors.

  for (int i=2; i<=n-1; i++) {
    sig=(x[i]-x[i-1])/(x[i+1]-x[i-1]);
    p=sig*y2[i-1]+2.0;
    y2[i]=(sig-1.0)/p;
    u[i]=(y[i+1]-y[i])/(x[i+1]-x[i]) - (y[i]-y[i-1])/(x[i]-x[i-1]);
    u[i]=(6.0*u[i]/(x[i+1]-x[i-1])-sig*u[i-1])/p;
    if(verbose) cout << i << ' ' << y2[i] << ' ' << u[i] << endl;
  }
  if(verbose) cout << "spline second derivative 4 "<< endl;
  //The upper boundary condition is set either to be  natural  qn=un=0.0;
  if (ypn > 0.99e30) {
    qn = un = 0.0;
  } else { //or else to have a specified first derivative.
    qn=0.5;
    un=(3.0/(x[n]-x[n-1]))*(ypn-(y[n]-y[n-1])/(x[n]-x[n-1]));
  }
  if(verbose) cout << "spline second derivative 5 "<< endl;
  //This is the backsubstitution loop of the tridiagonal algorithm
  y2[n]=(un-qn*u[n-1])/(qn*y2[n-1]+1.0);
  if(verbose) cout << "spline second derivative 6 "<< endl;
  for( int k=n-1; k>=1; k--) {
    if(verbose) cout << k << ' ' << y2[k] << ' ' << u[k] << endl;
    y2[k]=y2[k]*y2[k+1]+u[k];
  }
  if(verbose) cout << "spline second derivative 7 "<< endl;
  return y2;
}

// !!!!!!!!!! THIS COULD BE MADE MUCH FASTER IF XA ARE IN ORDER
//                  AND IT WAS MODIFIED NOT TO LOOK UP "BIN"
//Given the arrays xa[1..n] and ya[1..n], which tabulate a function
//(with the xai s in order), and given the array y2a[1..n], which
//is the output from spline above, and given a value of x, this
//routine returns a cubic-spline interpolated value y.
void spline_interpolate(
	utility::vector1<float> const & xa,
	utility::vector1<float> const & ya,
	utility::vector1<float> const & y2a,
	float x, float & y, float & dy,
	bool verbose
)
{
  int klo,khi,k;
  float h,b,a;

  //We will find the right place in the table by means of bisection.
  //This is optimal if sequential calls to this routine are at
  //random values of x. If sequential calls are in order, and
  //closely spaced, one would do better to store previous values
  //of klo and khi and test if they remain appropriate on the next call.
  int n = xa.size();
  klo=1;
  khi=n;
  while (khi-klo > 1) {
    k=(khi+klo) >> 1;
    if (xa[k] > x)
      khi=k;
    else
      klo=k;
  }
  //klo and khi now bracket the input value of x.
  h=xa[khi]-xa[klo];
  if (h == 0.0)
    if(verbose) cout << "spline interpolate: Bad xa input to routine splint" << endl;
  //The xa s must be dis-tinct.
  a=(xa[khi]-x)/h;
  b=(x-xa[klo])/h;
  //Cubic spline polynomial is now evaluated.
  y  = a*ya[klo]+b*ya[khi] + ( (a*a*a-a)*y2a[klo] + (b*b*b-b)*y2a[khi] ) *(h*h)/6.0;
  dy = (ya[khi]-ya[klo])/h + ( (3*b*b-1)*y2a[khi] - (3*a*a-1)*y2a[klo] ) *  h  /6.0;
}


///////////////////////////////////////////////////////////////
//    below is all some stupid tests...
//       please ignore
///////////////////////////////////////////////////////////////
//d <- read.table("tmp.data"); plot(d[,1],d[,2],type='l'); lines(d[,3],d[,4],col=2)



float  f(float x) { return x*x; }

float df(float x) { return 2*x; }


bool test_spline(
	vector1<float> const & x,
	vector1<float> const & y,
	float dy1, float dy2,
	vector1<float> const & xi,
	vector1<float> const & yi,
	vector1<float> const & dyi
)
{
  float tmpy,tmpdy;
  vector1<float> ddy = spline_second_derivative(x,y,dy1,dy2);
  for(int ii=1; ii<=(int)x.size(); ii++) {
    cout << "TAGINPUT  " << x[ii] << ' ' << y[ii] << endl;
  }
  for(int ii=1; ii<=(int)xi.size(); ii++) {
    spline_interpolate(x,y,ddy,xi[ii],tmpy,tmpdy);
    cout << "TAGOUTPUT " << ii << ' ' << xi[ii] << ' ' << yi[ii] << ' ' << dyi[ii]
	 <<  ' ' << tmpy << ' ' << tmpdy <<  endl;
    assert(tmpy==yi[ii]&&tmpdy==dyi[ii]);
  }
  return false;
}






bool test_spline(float x1, float x2,
		 float y1, float y2,
		 float dy1, float dy2,
		 float x, float  y, float dy)
{

  vector1<float> xi;
  vector1<float> yi;
  float tmpy,tmpdy;
  xi.clear();  yi.clear();
  xi.push_back(x1);  yi.push_back(y1);
  xi.push_back(x2);  yi.push_back(y2);
  vector1<float> ddy = spline_second_derivative(xi,yi,dy1,dy2);
  spline_interpolate(xi,yi,ddy,x,tmpy,tmpdy);
  cout << x << ' ' << y << ' ' << tmpy << ' ' << tmpdy <<  endl;
  return tmpy==y && tmpdy == dy;
}


bool test_spline(float * xa, float * ya, int N1,
		 float dy1, float dy2,
		 float * xia, float * yia, float * dya, int N2)
{
  vector1<float> x  (xa, xa+N1);
  vector1<float> y  (ya, ya+N1);
  vector1<float> xi (xia,xia+N2);
  vector1<float> yi (yia,yia+N2);
  vector1<float> dyi(dya,dya+N2);
  return test_spline(x,y,dy1,dy2,xi,yi,dyi);
}


bool test_spline() {

  using namespace utility;

  //FArray1D_float  x(10,0.0f);
  //FArray1D_float  y(10,-8e8);
  //FArray1D_float dy(10,0.0f);
  //FArray1D_bool  good(10,false);

//   for(int ii = 1; ii <= 10; ii++){
//     x(ii) = ((float)ii);
//     if(
//        ii == 1  ||
//        ii == 2  ||
//        //       ii == 4  ||
//        //ii == 6  ||
//        ii == 9  ||
//        ii == 10
//        ) {
//       y(ii) =  f((float)ii);
//       dy(ii) = df((float)ii);
//       good(ii) = true;
//       cout << ii << endl;
//     } else {
//       y(ii) =  f((float)ii)+100;
//       dy(ii) = df((float)ii)+100;
//     }
//   }

//   vector1<float> xi;
//   vector1<float> yi;
//   xi.push_back(x(2));
//   yi.push_back(y(2));
//   xi.push_back(x(5));
//   yi.push_back(y(5));
//   xi.push_back(x(9));
//   yi.push_back(y(9));

//   int start  = 3;
//   int finish = 9;
//   float dy1 = ( y(start -1) - y(start -2) ) / ( x(start -1) - x(start -2) );
//   float dy2 = ( y(finish+2) - y(finish+1) ) / ( x(finish+2) - x(finish+1) );


  test_spline(0,1,0,1,1,1,0.5,0.5,1);
  test_spline(0,1,     0,1,0,2,0.5,0.25,1);
  test_spline(-1,1, 1,1, -1,1, 0,0,0);
  test_spline( 0,1, 0,1,  0,3, 0.5,0.125,0.75);


//   float x[3] = { 0.0, 0.8, 1.0 };
//   float y[3] = { 0.0, 0.9, 1.0 };
//   float dy1 = 0.0;
//   float dy2 = -0.2;
//   float xi[15] = {0,0.05,0.1,0.15,0.4,0.5,0.6,0.85,0.9,0.95,1.0, 1.1,1.2, 1.3,1.4};
//   float yi[15] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
//   float dyi[15] ={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
//   test_spline(x,y,3,
// 	      dy1,dy2,
// 	      xi,yi,dyi,15);

  ////////////////////////////////////////////////////////

  FArray1D_float x(100,0.0);
  for(int ii=1; ii<=(int)x.size1();ii++) x(ii) = (float)ii / 100.0;
  FArray1D_float  y(100,-1.0);
  FArray1D_float dy(100,0.0);
  y(1) = 0.01;
  y(13) = 0.13*0.13;
  y(50) = 0.25;
  y(80) = 0.8*0.8;
  y(100) = 1;
  dy(1  ) = 0.2;
  dy(100) = 2;


//   for ( int ii = 1; ii <= (int)x.size1(); ii++)
//     cout << F(7,3,x(ii)) << ' ';
//   cout << endl;
//   for ( int ii = 1; ii <= (int)x.size1(); ii++)
//     cout << F(7,3,y(ii)) << ' ';
//   cout << endl;
//   for ( int ii = 1; ii <= (int)x.size1(); ii++)
//     cout << F(7,3,dy(ii)) << ' ';
//   cout << endl;

  spline_fill_marked_gaps(x,y,dy,-1,true);

  //cout << endl;
//   for ( int ii = 1; ii <= (int)x.size1(); ii++)
//     cout << F(7,3,x(ii)) << ' ';
//   cout << endl;
//   for ( int ii = 1; ii <= (int)x.size1(); ii++)
//     cout << F(7,3,y(ii)) << ' ';
//   cout << endl;
//   for ( int ii = 1; ii <= (int)x.size1(); ii++)
//     cout << F(7,3,dy(ii)) << ' ';
//   cout << endl;

  return false;

}
