#ifndef INCLUDED_ObjexxFCL_FArray1Da_FWD_HH
#define INCLUDED_ObjexxFCL_FArray1Da_FWD_HH


// FArray1Da Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray1Da;
class byte;
class ubyte;
class Fstring;


// Types
typedef  FArray1Da< bool >                FArray1Da_bool;
typedef  FArray1Da< byte >                FArray1Da_byte;
typedef  FArray1Da< ubyte >               FArray1Da_ubyte;
typedef  FArray1Da< short int >           FArray1Da_short;
typedef  FArray1Da< int >                 FArray1Da_int;
typedef  FArray1Da< long int >            FArray1Da_long;
typedef  FArray1Da< unsigned short int >  FArray1Da_ushort;
typedef  FArray1Da< unsigned int >        FArray1Da_uint;
typedef  FArray1Da< unsigned long int >   FArray1Da_ulong;
typedef  FArray1Da< std::size_t >         FArray1Da_size_t;
typedef  FArray1Da< std::size_t >         FArray1Da_size;
typedef  FArray1Da< float >               FArray1Da_float;
typedef  FArray1Da< double >              FArray1Da_double;
typedef  FArray1Da< long double >         FArray1Da_longdouble;
typedef  FArray1Da< char >                FArray1Da_char;
typedef  FArray1Da< unsigned char >       FArray1Da_uchar;
typedef  FArray1Da< signed char >         FArray1Da_schar;
typedef  FArray1Da< std::string >         FArray1Da_string;
typedef  FArray1Da< Fstring >             FArray1Da_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray1Da_FWD_HH
