#ifndef INCLUDED_ObjexxFCL_FArray4Da_FWD_HH
#define INCLUDED_ObjexxFCL_FArray4Da_FWD_HH


// FArray4Da Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray4Da;
class byte;
class ubyte;
class Fstring;


// Types
typedef  FArray4Da< bool >                FArray4Da_bool;
typedef  FArray4Da< byte >                FArray4Da_byte;
typedef  FArray4Da< ubyte >               FArray4Da_ubyte;
typedef  FArray4Da< short int >           FArray4Da_short;
typedef  FArray4Da< int >                 FArray4Da_int;
typedef  FArray4Da< long int >            FArray4Da_long;
typedef  FArray4Da< unsigned short int >  FArray4Da_ushort;
typedef  FArray4Da< unsigned int >        FArray4Da_uint;
typedef  FArray4Da< unsigned long int >   FArray4Da_ulong;
typedef  FArray4Da< std::size_t >         FArray4Da_size_t;
typedef  FArray4Da< std::size_t >         FArray4Da_size;
typedef  FArray4Da< float >               FArray4Da_float;
typedef  FArray4Da< double >              FArray4Da_double;
typedef  FArray4Da< long double >         FArray4Da_longdouble;
typedef  FArray4Da< char >                FArray4Da_char;
typedef  FArray4Da< unsigned char >       FArray4Da_uchar;
typedef  FArray4Da< signed char >         FArray4Da_schar;
typedef  FArray4Da< std::string >         FArray4Da_string;
typedef  FArray4Da< Fstring >             FArray4Da_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray4Da_FWD_HH
