// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   LoopInfo.cc
/// @brief  Tracks loop (epitope) info and ranges.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

// unit headers
#include <epigraft/LoopInfo.hh>
#include <epigraft/ResidueRange.hh>

// C++ headers
#include <sstream>
#include <string>

namespace epigraft {

/// @brief add epitope subrange
void
LoopInfo::add_native_subrange(
	ResidueRange const & rr
)
{
	native_subranges_.push_back( rr );
	internal_subranges_.push_back( convert_native_to_internal( rr ) );
}


/// @brief contains native range?
bool
LoopInfo::contains_native_subrange(
	ResidueRange const & rr
) const
{
	for ( int i = 1, ie = native_subranges_.size(); i <= ie; ++i ) {
		if ( native_subranges_[ i ].equals( rr ) ) {
			return true;
		}
	}

	return false;
}

/// @brief report object contents
std::string
LoopInfo::to_string()
{
	std::ostringstream ss;

	ss << "loop: " << id_ << " nres: " << nres() << " full_native_range: " << full_native_range_.to_string() << std::endl;
	ss << "Primary loop? " << is_primary_ << std::endl;
	ss << "   nranges: " << internal_subranges_.size() << std::endl;
	for ( int i = 1, ie = internal_subranges_.size(); i <= ie; ++i ) {
		ResidueRange const & nr = native_subranges_[ i ];
		ResidueRange const & ir = internal_subranges_[ i ];
		ss << "     range: " << nr.to_string() << " "
		                     << ir.to_string() << std::endl;
	}

	return ss.str();
}


} // namespace epigraft
