// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   ResidueRange.hh
/// @brief  ResidueRange, subclasses rootstock::ResidueRange to count properly.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_ResidueRange_HH_
#define INCLUDED_epigraft_ResidueRange_HH_

// package headers
#include <epigraft/epigraft_types.hh>

// rootstock headers
#include <rootstock/ClosedInterval.hh>

namespace epigraft {

/// @brief  ResidueRange, subclasses rootstock::ResidueRange to count properly.
class ResidueRange : public rootstock::ClosedInterval< Integer > {
	
	private: // types
	
		typedef rootstock::ClosedInterval< Integer > Super;

	
	public: // construct/destruct
	
		/// @brief default constructor
		inline
		ResidueRange() : Super() {}
	
		/// @brief constructor
		inline
		ResidueRange(
			Integer left,
			Integer right
		) : Super( left, right )
		{}
	
	
	public: // assignment
	
		/// @brief copy assignment
		inline
		ResidueRange &
		operator =( ResidueRange const & rr )
		{
			if ( this != &rr ) {
				Super::operator=( rr );
			}
			return *this;
		}
	
	
	public: // friend operators
	
		/// @brief ResidueRange + int
		friend
		inline
		ResidueRange
		operator +( ResidueRange const & rr, Integer const & t )
		{
			return ResidueRange( rr.left_ + t, rr.right_ + t );
		}
		
		/// @brief int + ResidueRange
		friend
		inline
		ResidueRange
		operator +( Integer const & t, ResidueRange const & rr )
		{
			return ResidueRange( t + rr.left_, t + rr.right_ );
		}

		/// @brief ResidueRange - int
		friend
		inline
		ResidueRange
		operator -( ResidueRange const & rr, Integer const & t )
		{
			return ResidueRange( rr.left_ - t, rr.right_ - t );
		}
		
		/// @brief int - ResidueRange
		friend
		inline
		ResidueRange
		operator -( Integer const & t, ResidueRange const & rr )
		{
			return ResidueRange( t - rr.left_, t - rr.right_ );
		}
		

	public: // query
	
		/// @brief count properly
		Integer
		length() const
		{
			return Super::length() + 1;
		}
	
};

} // namespace epigraft

#endif /*INCLUDED_epigraft_ResidueRange_HH_*/
