// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   ScaffoldInfo.hh
/// @brief  Tracks scaffold info for epitope-scaffold design.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_ScaffoldInfo_HH_
#define INCLUDED_epigraft_ScaffoldInfo_HH_

// package headers
#include <epigraft/ResidueRange.hh>

// C++ headers
#include <sstream>
#include <string>

namespace epigraft {

/// @brief  Tracks scaffold info for epitope-scaffold design.
class ScaffoldInfo {

	public: // construct/destruct
		
		/// @brief default constructor
		inline
		ScaffoldInfo() {}
		
		/// @brief constructor
		inline
		ScaffoldInfo(
			std::string input_filename,
			ResidueRange epitope_range,
			ResidueRange native_range
		) : input_filename_( input_filename ),
		    epitope_range_( epitope_range ),
		    native_epitope_range_( native_range )
		{}
		
		/// @brief default destructor
		inline
		~ScaffoldInfo() {}
	
	
	public: // accessors
	
		/// @brief input filename
		inline
		std::string const &
		input_filename() const
		{
			return input_filename_;
		}
		
		/// @brief epitope range
		inline
		ResidueRange const &
		epitope_range() const
		{
			return epitope_range_;
		}
		
		/// @brief native range
		inline
		ResidueRange const &
		native_epitope_range() const
		{
			return native_epitope_range_;
		}
	
	
	public: // status
	
		/// @brief report object status
		std::string
		to_string()
		{
			std::ostringstream ss;
			
			ss << input_filename_ << " " << epitope_range_.left() << " " << epitope_range_.right()
			                      << " " << native_epitope_range_.left() << " " << native_epitope_range_.right()
			                      << std::endl;
			
			return ss.str();
		}
	
	private: // data
		std::string input_filename_;
		ResidueRange epitope_range_;
		ResidueRange native_epitope_range_;
};

} // namespace epigraft

#endif /*INCLUDED_epigraft_ScaffoldInfo_HH_*/
