// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   conformation_types.hh
/// @brief  Types for epigraft/conformation
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_conformation_conformation_types_HH_
#define INCLUDED_epigraft_conformation_conformation_types_HH_

// epigraft headers
#include <epigraft/epigraft_types.hh>
#include <epigraft/conformation/DihedralInfo.fwd.hh>

// utility headers
#include <utility/pointer/access_ptr.fwd.hh>
#include <utility/pointer/owning_ptr.fwd.hh>
#include <utility/vector1.fwd.hh>

namespace epigraft {
namespace conformation {


// typedefs to simplify types
typedef utility::pointer::access_ptr< DihedralInfo > DihedralInfoAP;
typedef utility::pointer::owning_ptr< DihedralInfo > DihedralInfoOP;

// typedef to store working combinations of dihedrals
typedef utility::vector1< DihedralInfoAP > DihedralVectorTransient; // for internal calculations, does not incur additional performance penalty of using OP
typedef utility::vector1< DihedralInfoOP > DihedralVector;


} // conformation
} // epigraft

#endif /*INCLUDED_epigraft_conformation_conformation_types_HH_*/
