// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   OutputFilename.hh
/// @brief  filename handling for multigraft top-level protocol
/// @author Yih-En Andrew Ban (yab@u.washington.edu)


#ifndef INCLUDED_epigraft_design_OutputFilename_HH_
#define INCLUDED_epigraft_design_OutputFilename_HH_

// package headers
#include <epigraft/design/design_types.hh>
#include <epigraft/design/ESBundle.hh>

// c++ headers
#include <string>

namespace epigraft {
namespace design {


/// @brief struct for filename tracking
/// @note this was originally internal to multigraft.cc
struct OutputFilename {

	/// @brief default constructor
	OutputFilename()
	{}

	/// @brief string constructor
	OutputFilename(
		std::string fullpath,
		std::string base_filename
	) : path( fullpath ),
	    base( base_filename )
	{}

	/// brief name from ESBundle
	std::string
	name_from_ESBundle(
		ESBundle const & esb,
		bool const & just_base = false
	) const
	{
		std::ostringstream ss;
		if ( !just_base ) {
			ss << path;
		}
		ss << base;
		if ( esb.closure_id > -1 ) {
			ss << ".c" << esb.closure_id;
		}
		if ( esb.design_id > -1 ) {
			ss << ".d" << esb.design_id;
		}
		return ss.str();
	}

	/// @brief with closure id
	std::string
	name_with_closure(
		Integer const & cid,
		bool const & just_base = false
	) const
	{
		std::ostringstream ss;
		if ( !just_base ) {
			ss << path;
		}
		ss << base;
		ss << ".c" << cid;
		return ss.str();
	}

	/// @brief with closure and design id
	std::string
	name_with_closure_and_design(
		Integer const & cid,
		Integer const & did,
		bool const & just_base = false
	) const
	{
		std::ostringstream ss;
		if ( !just_base ) {
			ss << path;
		}
		ss << base;
		ss << ".c" << cid << ".d" << did;
		return ss.str();
	}

	std::string path;
	std::string base;
};

}
}

#endif /*INCLUDED_epigraft_design_multigraft_OutputFilename_HH_*/
