// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   Vall.cc
/// @brief  Holds Vall data.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#include <epigraft/design/Vall.hh>

#include <fragments_ns.h>

#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray4D.hh>

namespace epigraft {
namespace design {


void
Vall::copy_to_global_fragment_array(
	Size const & position,
	Size const & width,
	Integer const & res,
	Integer const & fragment_number,
	Integer const & size_bin
)
{
	Integer idx;
	for ( Size i = 0; i < width; ++i ) {
		fragments::neigh_names::align_name( res, i, size_bin ) = pdb_[ position + i ];
		fragments::neigh_names::align_chain( res, i, size_bin ) = chain_[ position + i ];
		fragments::neigh_names::align_resseq( res, i, size_bin ) = resseq_[ position + i ];

		fragments::neighbors::align_phi( res, fragment_number, i, size_bin ) = phi_[ position + i ];
		fragments::neighbors::align_psi( res, fragment_number, i, size_bin ) = psi_[ position + i ];
		fragments::neighbors::align_omega( res, fragment_number, i, size_bin ) = omega_[ position + i ];

		fragments::neighbors_int::ss_type( res, fragment_number, i, size_bin ) = secstruct_[ position + i ];
		fragments::neigh_names::align_res_id( res, fragment_number, i, size_bin ) = sequence_[ position + i ];
	}
}


} // namespace design
} // namespace epigraft
