// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   decimated_multigraft.hh
/// @brief  Performs closure and design for an epigraft match hit.
///         Decimated for benchmarking.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)
/// @author Bruno Correia (bcorreia@u.washington.edu)


#ifndef INCLUDED_epigraft_design_decimated_multigraft_HH_
#define INCLUDED_epigraft_design_decimated_multigraft_HH_

// package headers
#include <epigraft/design/design_types.hh>
#include <epigraft/design/EpitopeScaffold.fwd.hh>
#include <epigraft/design/ESBundle.fwd.hh>
#include <epigraft/design/MultiGraftStats.fwd.hh>
#include <epigraft/design/OutputFilename.fwd.hh>
#include <epigraft/GraftOptions.fwd.hh>

// rosetta headers
#include <pose.h>

// c++ headers
#include <map>
#include <string>

namespace epigraft {
namespace design {


/// @brief MultiGraft top-level protocol
void
decimated_multigraft(
	GraftOptions const & options
);


/// @brief centroid level build stage
void
build_stage(
	GraftOptions const & options,
	EpitopeScaffold & work_es,
	Pose const & native_ab,
	MultiGraftStage & stage,
	Size & build_attempts
);


/// @brief full-atom design-refine stage
void
dr_stage(
	GraftOptions const & options,
	EpitopeScaffold & work_es,
	Pose const & native_ab,
	MultiGraftStage & stage,
	Size const & checkpoint_index
);


/// @brief output final structure and log
void
final_output(
	EpitopeScaffold const & es,
	std::string const & log_filename,
	std::string const & es_pdb_filename,
	std::string const & scaffold_filename,
	Size const match_counter,
	Real const wt_scaffold_score,
	Real const wt_ddG
);


} // namespace design
} // namespace epigraft


#endif /*INCLUDED_epigraft_design_decimated_multigraft_HH_*/
