// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   design_io.hh
/// @brief  Design i/o functions.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_design_design_io_HH_
#define INCLUDED_epigraft_design_design_io_HH_

// package headers
#include <epigraft/design/design_types.hh>
#include <epigraft/design/GraftInfo.fwd.hh>
#include <epigraft/LoopInfo.fwd.hh>

// utility headers
#include <utility/vector1.fwd.hh>

// C++ headers
#include <map>
#include <set>
#include <string>


namespace epigraft {
namespace design {


/// @brief read keep natural rotamer file for epitope
/// @note  "keep natro" file indicates epitope positions whose sidechains
/// @note  are to be kept/not allowed to be designed
/// @warning currently does not handle insertion codes -- only integer residue numbering!
std::set< Integer >
parse_keep_natro_file(
	String const & filename
);


/// @brief read complementarity design residue file
/// @details residue file contains list of residues on the antibody
/// @details in *native* antibody numbering (including insertion code),
/// @details one residue per line
std::set< String >
parse_complementarity_residue_file(
	String const & filename
);


/// @brief wrapper for Pose dump_pdb -- checks if directory path exists first and makes it if necessary
void
output_pdb(
	String const & filename,
	Pose & pose,
	bool const & include_decoy_features = false,
	bool const & use_pdb_info = true
);


/// @brief match result from file (from output table) and corresponding graft info
/// @brief fill in as much data as possible from given file
void
graft_info_from_file(
	String const & filename,
	utility::vector1< LoopInfo > loops_to_scan,
	std::map< String, utility::vector1< GraftInfo > > & pdb_to_graft_info,
	bool const & using_old_graft_info_format = false
);


/// @brief helper function, search for index of "$" in vector1 of strings
Size
index_of_dollar(
	utility::vector1< String > const & v
);


/// @brief   remove all spaces from string
/// @details first removes all leading/trailing all types of whitespace, then
///          removes all spaces (just spaces, not including other whitespace,
///          like tabs)
String
collapsed_spaces(
	String const & s_in
);


/// @brief   remove all copies of character from string
/// @details removes all copies of character 'c' found in string
String
collapsed_character(
	String const & s_in,
	char const & c
);


} // namespace design
} // namespace epigraft


#endif /*INCLUDED_epigraft_design_design_io_HH_*/
