// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   fragment_functions.hh
/// @brief  Miscellaneous fragment functions.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)
/// @author Possu Huang (possu@u.washington.edu)

#ifndef INCLUDED_epigraft_design_fragment_functions_HH_
#define INCLUDED_epigraft_design_fragment_functions_HH_

// package headers
#include <epigraft/design/design_types.hh>
#include <epigraft/design/LoopClosureInfo.fwd.hh>
#include <epigraft/design/Vall.hh>

// utility headers
#include <utility/vector1.hh>

// C++ headers
#include <set>


namespace epigraft {
namespace design {


/// @brief build 1-mer from 3-mer, for use with Vall only as not all classical fragment data fields filled
void
build_1mer_from_3mer(
	Integer const & total_residue
);


/// @brief parse Vall
void
parse_vall(
	String filename,
	utility::vector1< Vall > & library
);


/// @brief screen fragments sorting by secondary structure and chain break
void
screen_fragments(
	Pose const & pose,
	std::set< LoopClosureInfo > const & closures,
	String const & ss_string,
	String const & aa_string,
	Real const & linear_threshold = 0.5,
	Integer const & n_fragments = 200
);


/// @brief debugging routine, grabs fragment positions in Vall from text file
void
read_fragment_index(
	String const & filename,
//	utility::vector1< Vall > const & library,
	Pose const & pose
);


/// @brief SCRATCH ROUTINE: screen fragments by quadratic chainbreak
///  and output results for all fragments
void
scratch_screen_fragments();


} // namespace design
} // namespace epigraft


#endif /*INCLUDED_epigraft_design_fragment_functions_HH_*/
