// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   multigraft.hh
/// @brief  Performs closure and design for an epigraft match hit.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)
/// @author Bill Schief (schief@u.washington.edu)


#ifndef INCLUDED_epigraft_design_multigraft_HH_
#define INCLUDED_epigraft_design_multigraft_HH_

// package headers
#include <epigraft/design/design_types.hh>
#include <epigraft/design/EpitopeScaffold.fwd.hh>
#include <epigraft/design/ESBundle.fwd.hh>
#include <epigraft/design/MultiGraftStats.fwd.hh>
#include <epigraft/design/OutputFilename.fwd.hh>
#include <epigraft/GraftOptions.fwd.hh>

// c++ headers
#include <map>

namespace epigraft {
namespace design {


/// @brief MultiGraft top-level protocol
void
multigraft(
	GraftOptions const & options
);


/// @brief top-level closure
void
closure_stage(
	GraftOptions const & options,
	OutputFilename const & output_pdb_name,
	EpitopeScaffold const & original_es,
	std::multimap< Real, ESBundle > & closed_epitope_scaffolds,
	MultiGraftStats & statistics,
	MultiGraftStage & stage,
	Integer & checkpoint_index
);


/// @brief   top-level complementarity design
/// @details currently creates one complementarity design per closed scaffold
void
complementarity_design_stage(
	GraftOptions const & options,
	std::multimap< Real, ESBundle > & closed_epitope_scaffolds,
	MultiGraftStage & stage,
	Integer & checkpoint_index
);


/// @brief top-level design
void
design_stage(
	GraftOptions const & options,
	std::multimap< Real, ESBundle > & closed_epitope_scaffolds,
	std::multimap< Real, ESBundle > & designed_epitope_scaffolds,
	MultiGraftStage & stage,
	Integer & checkpoint_index
);


/// @brief top-level refine
void
refine_stage(
	GraftOptions const & options,
	std::multimap< Real, ESBundle > & designed_epitope_scaffolds,
	MultiGraftStats & statistics,
	MultiGraftStage & stage,
	Integer & checkpoint_index
);


/// @brief top-level quality control
void
quality_control_stage(
	GraftOptions const & options,
	std::multimap< Real, ESBundle > & designed_epitope_scaffolds,
	MultiGraftStats & statistics,
	MultiGraftStage & stage,
	Integer & checkpoint_index
);


void
test();


void
old_test();


void
older_test();


} // namespace design
} // namespace epigraft


#endif /*INCLUDED_epigraft_design_multigraft_HH_*/
