// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_epi_graft
#define INCLUDED_epi_graft


// epigraft headers
#include <epigraft/AtomPoint.hh>
#include <epigraft/ResidueRange.hh>

// Rosetta Headers
#include <pose_fwd.h>

// rootstock headers
#include <rootstock/BoundingBox.hh>
#include <rootstock/ClosedInterval.hh>
#include <rootstock/Octree.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.fwd.hh>
#include <ObjexxFCL/FArray2D.fwd.hh>
#include <ObjexxFCL/FArray3D.fwd.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <string>


void
epi_graft();

void
epi_graft_design();

void
add_on_epi_graft_design();


void
get_closure_atom_resnum(
	bool const & fullatom,
	std::string const & graft_dir,
	int const & graft_resnum_1,
	int const & graft_resnum_2,
	int const & jres,
	FArray1D_int & closure_atom,
	FArray1D_int & closure_resnum_scaff,
	FArray1D_int & closure_resnum_graft
);


void
prepare_grafting_protocol_design_matrix(
	pose_ns::Pose & pose,
	int const & nres_Ab,
	int const & begin_move_bb,
	int const & end_move_bb,
	FArray1D_bool const & epitope_natro_start_in_scaff,
	FArray2D_bool & design_matrix
);


void
construct_pose_complex_from_p1_p2(
	pose_ns::Pose const & pose1,
	pose_ns::Pose const & pose2,
	pose_ns::Pose & pose3
);


void
transfer_native_rotamers(
	pose_ns::Pose const & pose1,
	FArray1D_bool const & natro1, //bool at each position
	FArray1D_bool const & natro2, //bool at each position
	pose_ns::Pose & pose2
);

void
orient_pose(
	FArray2DB_float const & coords_3_atoms,
	FArray2Da_float const & new_coords_3_atoms,
	pose_ns::Pose & pose
);

double
superimpose_using_ncaco(
	pose_ns::Pose & pose1,
	int const & pose1_first,
	int const & pose1_last,
	pose_ns::Pose & pose2, //pose2 will be changed, superimposed onto pose1
	int const & pose2_first,
	int const & pose2_last
);


void
design_using_design_matrix(
	pose_ns::Pose & pose_in,
	FArray2D_bool const & design_matrix_local
);

void
close_graft(
	int const & n_loops,
	FArray1DB_int const & loop_begin,
	FArray1DB_int const & loop_end,
	FArray1DB_int const & cut_point,
	int const & nres_disallow_bbmove,
	FArray1DB_int const & list_disallow_bbmove,
	pose_ns::Pose & pose,
	float & chainbreak_score
);

void
setup_loops_for_add_on(
  bool const & rb_moves_used,
  int const & nres_Ab,
  int const & scaff_gap_resnum_1,                 //for loop to be grafted
  int const & scaff_gap_resnum_2,                 //for loop to be grafted
  int const & scaff_gap_resnum_1_already_in_scaff,//for loop already in scaff
  int const & scaff_gap_resnum_2_already_in_scaff,//for loop already in scaff
  int const & n_graft_res_allowed_bbmove_nterm,
  int const & n_graft_res_allowed_bbmove_cterm,
  int const & n_scaff_gap_res_allowed_bbmove_nterm,
  int const & n_scaff_gap_res_allowed_bbmove_cterm,
  int const & resnum_shift_due_to_graft,
  int const & n_loops,
  FArray1DB_int & loop_begin,
  FArray1DB_int & loop_end,
  FArray1DB_int & cut_point,
  int & nres_disallow_bbmove,
  FArray1D_int & list_disallow_bbmove
);

void
setup_loops(
	bool const & rb_moves_used,
	bool const & use_lever_moves,
	std::string const & graft_dir,
	std::string const & graft_align_system,
	int const & scaff_gap_resnum_1,
	int const & scaff_gap_resnum_2,
	int const & n_graft_res_allowed_bbmove_nterm,
	int const & n_graft_res_allowed_bbmove_cterm,
	int const & n_scaff_gap_res_allowed_bbmove_nterm,
	int const & n_scaff_gap_res_allowed_bbmove_cterm,
	int const & resnum_shift_due_to_graft,
	int const & n_loops,
	FArray1DB_int & loop_begin,
	FArray1DB_int & loop_end,
	FArray1DB_int & cut_point,
	int & nres_disallow_bbmove,
	FArray1D_int & list_disallow_bbmove
);

void
make_pose_with_gap(
	pose_ns::Pose & pose,
	int const & gap_begin,
	int const & gap_end,
	pose_ns::Pose & pose_w_gap
);

void
copy_info_to_trim_pose(
	pose_ns::Pose & input_pose,
	FArray1DB_bool const & trim_res,
	pose_ns::Pose & trim_pose        //output
);

//overloaded version of above
void
copy_info_to_trim_pose(
	pose_ns::Pose & input_pose,
	FArray1DB_bool const & trim_res,
	pose_ns::Pose & trim_pose,       //output
	FArray1DB_int & trim_map,         //output
	FArray1DB_int & trim_map_reverse  //output
);

void
evaluate_peptide_prot_interaction_vdwE(
	int const nres_pep,            //input
	FArray1D_int const aa_pep,          //input
	FArray1D_int const aav_pep,         //input
	FArray3D_float const & coords_pep,   //input
	pose_ns::Pose & prot_pose,        //input protein pose
	float & atrE,               //output
	float & repE               //output
);

void
fast_pairenergy_attached_h_no_count_pair(
	int const atom1,
	int const atom2,
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & repE
);


void
convert_resnum_range_to_gly(
	pose_ns::Pose & pose_in,
	int const & resnum1,
	int const & resnum2
);

void
get_alignment_coords(
	pose_ns::Pose const & nat_pep_gly_pose,
	pose_ns::Pose const & scaff_gly_pose,
	std::string const & graft_align_system,
	std::string const & graft_dir,
	int const & graft_resnum_1,
	int const & graft_resnum_2,
	int const & scaff_gap_resnum_1,
	int const & scaff_gap_resnum_2,
	FArray1D_float & coords_pep_cent,
	FArray1D_float & coords_pep_forw,
	FArray1D_float & coords_pep_back,
	FArray1D_float & coords_scaff_cent,
	FArray1D_float & coords_scaff_forw,
	FArray1D_float & coords_scaff_back
);

void
make_scaff_w_graft_gly_pose(
	pose_ns::Pose const & scaff_gly_pose,
	pose_ns::Pose const & graft_notermini_gly_pose,
	int const & scaff_gap_resnum_1,
	int const & scaff_gap_resnum_2,
	int const & nres_scaff_w_graft,
	pose_ns::Pose & scaff_w_graft_gly_pose  //output
);

void
new_make_scaff_w_graft_gly_pose(
                                pose_ns::Pose const & scaff_gly_pose,
                                pose_ns::Pose const & pep_gly_oriented_pose,
                                std::string const & graft_align_system,
                                std::string const & graft_dir,
                                int const & graft_resnum_1,
                                int const & graft_resnum_2,
                                int const & scaff_gap_resnum_1,
                                int const & scaff_gap_resnum_2,
                                int const & nres_scaff_w_graft,
                                pose_ns::Pose & scaff_w_graft_gly_pose  //output
                                );






//make_Ab_scaff_w_graft_gly_pose could be generalized
//it is just a routine to make a pose of a protein complex
//from coords,aa,aav info for one protein and a full pose for the other protein
//

void
make_Ab_scaff_w_graft_gly_pose(
	pose_ns::Pose const & Ab_oriented_pose,
	pose_ns::Pose const & scaff_w_graft_gly_pose,
	pose_ns::Pose & Ab_scaff_w_graft_gly_pose
);

void
read_list_scaff_pdb(
	int & n_scaff,
	FArray1D_string & list_scaff_pdb
);

void
read_list_graft_ranges(
	int & n_graft_ranges,
	FArray2D_int & list_graft_ranges
);

void
get_natro_in_epitope(
  int const nres_epitope,
  int & n_natro_in_epitope,
  FArray1D_int & list_natro_in_epitope,
  FArray1D_bool & natro_in_epitope
);

void
read_epi_loop_info(
	FArray1D_int & nres_epi_loops,
	FArray1D_int & nranges_epi_loops,
	FArray3D_int & ranges_epi_loops
);

void
read_list_superpos_scaff_info(
	FArray1D_string & list_scaff_pdb,
	FArray2D_int & list_range_superposed_in_scaff
);

void
read_list_scaff_info_for_epi_graft_design(
	FArray1D_string & list_graft_dir,
	FArray1D_string & list_graft_align_system,
	FArray2D_int & list_graft_resnums,
	FArray2D_int & list_scaff_gap_resnums,
	FArray1D_string & list_scaff_pdb
);

void
read_list_scaff_info_for_add_on_epi_graft_design(
  FArray1D_int & list_graft_loop_id,
  FArray1D_int & list_graft_range_id,
  FArray2D_int & list_graft_resnums,
  FArray2D_int & list_scaff_gap_resnums,
  FArray1D_int & list_graft_loop_id_already_in_scaff,
  FArray2D_int & list_graft_resnums_already_in_scaff,
  FArray2D_int & list_scaff_gap_resnums_already_in_scaff,
  FArray1D_string & list_scaff_pdb
);

void
get_loop_id_superposed_in_scaff(
	int const & n_scaff,
	FArray2D_int const & list_range_superposed_in_scaff,
	int const & n_epi_loops,
	FArray1D_int const & nranges_epi_loops,
	FArray3D_int const & ranges_epi_loops,
	FArray1D_int & loop_id_superposed_in_scaff
);

void
copy_segment_to_new_pose(
	pose_ns::Pose & pose_in,
	int const & pos1,
	int const & pos2,
	pose_ns::Pose & pose_out
);

void
open_output_file(
	std::string const & output_filename,
	utility::io::ozstream & outfile
);


void
update_conformation_already_scored(
	int const & n,                 //number for conformation just completed
	std::string const & fullname  //path + filename for checkpoint file
);


bool
check_conformation_already_scored(
	int const & no,         //input: number of the current conformation
	std::string const & fullname  //input: path + filename to checkpoint file.
);

void
get_Ab_scaff_refine_pose(
	pose_ns::Pose & Ab_scaff_design_pose,
	pose_ns::Pose & Ab_design_pose,
	pose_ns::Pose & scaff_refine_pose,
	int const & scaff_gap_resnum_1,
	pose_ns::Pose & Ab_refine_pose,
	pose_ns::Pose & Ab_scaff_refine_pose
);

void
get_filename_with_energies(
	std::string const & filename_base,
	float const & energy1,       //Etot
	float const & energy2,        //ddg
	std::string & filename_out    //output filename
);


/////////////////////////////////////////////////////
/* yab: below is additional code for all protocols */
/////////////////////////////////////////////////////


/// @brief cheat here and call copy_segment_to_new_pose using ResidueRange for clarity, merge and clean later
/// @note retains Bill's 'in' -> 'variables' -> 'out' syntax
void
copy_segment_to_new_pose(
	pose_ns::Pose & in,
	epigraft::ResidueRange const & rr,
	pose_ns::Pose & out
);

/// @brief cheat for clarity on merging scaffold and epitope
void
insert_epitope(
	pose_ns::Pose & scaffold,
	pose_ns::Pose & epitope,
	epigraft::ResidueRange const & match_range,
	pose_ns::Pose & result
);


////////////////////////////////////////////////////////
/* yab: below is additional code for epi_graft_design */
////////////////////////////////////////////////////////

/// @brief resets global loop info
void
reset_global_loop_info();

#endif /*INCLUDED_epi_graft*/
