// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   epigraft_types.hh
/// @brief  Types for epigraft.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_epigraft_types_HH_
#define INCLUDED_epigraft_epigraft_types_HH_

// rosetta headers
#include <pose_fwd.h>

// rootstock headers
#include <rootstock/rootstock_types.hh>

namespace epigraft {

// scalar
typedef rootstock::Integer Integer; // int in current Rosetta
typedef rootstock::Real Real; // float in current Rosetta
typedef std::size_t Size;

typedef std::string String;

typedef pose_ns::Pose Pose;

} // namespace epigraft

#endif /*INCLUDED_epigraft_epigraft_types_HH_*/
