// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   glycan_test.cc
/// @brief  Glycan testing ground.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)


// unit headers
#include <epigraft/glycan/glycan_test.hh>

// rootstock headers
#include <rootstock/geometry.hh>

// numeric headers
#include <numeric/xyzVector.hh>

// C++ headers
#include <iostream>


namespace epigraft {
namespace glycan {


/// @brief temporary, glycan testing
void
test()
{
	using numeric::xyzVector;
	
	xyzVector< Real > a( -1.0, 0.0, 1.0 );
	xyzVector< Real > b( -2.0, -3.0, -4.0 );
	xyzVector< Real > c( 1.5, 2.0, 3.0 );
	xyzVector< Real > d( 4.3, 5.1, 6.7 );
	
	Real det = rootstock::orient3D( a, b, c, d );
	std::cout << "SCARLET " << det << std::endl;
}


} // namespace glycan
} // namespace epigraft
