// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

// epigraft headers
#include <epigraft/epi_graft.h> // bills
//#include <epigraft/epigraft_match.hh>
//#include <epigraft/epigraft_rough_match.hh>
//#include <epigraft/AtomPoint.hh>
//#include <epigraft/ResidueRange.hh>
#include <epigraft/grid_dock_and_design.h> //temporary?

// Rosetta Headers
#include "../../aaproperties_pack.h"
#include "../../aa_name_conversion.h"
#include "../../count_pair.h"
#include "../../design.h" // bills
#include "../../input_pdb.h"  // dihedral
#include "../../diagnostics_rosetta.h"
#include "../../disulfides.h" // cys_res_in_disulf
#include "../../after_opts.h"
#include "../../fast_pairenergy.h" // fast_pairenergy
#include "../../files_paths.h"
#include "../../jumping_refold.h"
#include "../../jumping_util.h"  //X_rot, Y_rot, Z_rot
#include "../../knots.h" // rank
#include "../../loops_ns.h" // loop_bool::trim
#include "../../minimize.h"
#include "../../min_debug_ns.h" //diagnostics for bad_min
//#include "../../misc.h" // damn
#include "../../nblist.h" //pose_set_use_nblist
#include "../../pack.h" // pack_rotamers,num_from_res1
#include "../../pack_geom_inline.h" // distance_bk
#include "../../PackerTask.h"
#include "../../param.h" // MAX_POS
#include "../../param_pack.h" // MAX_POS
#include "../../pdbstatistics_pack.h" // hydrogen_interaction_cutoff
#include "../../pose.h"
#include "../../pose_docking.h"//basic pose_docking routines
#include "../../pose_io.h"
#include "../../pose_loops.h"
#include "../../pose_loops_input_ns.h"
#include "../../read_aaproperties.h" // atom_name_from_atom_num
#include "../../refold.h" // get_GL_matrix
#include "../../rms.h" // charlie rms routines
#include "../../runlevel.h"
//vds may need later #include "../../smallmove.h"
#include "../../score.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh> // this might be needed for Atom
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/formatted.io.hh>

// numeric headers
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyz.functions.hh>

// utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <iostream>
#include <set>
#include <string>
#include <vector>


void
grid_dock_and_design()
{
	using namespace pose_ns;

	// scorefxn
	Score_weight_map weight_map( score12 );

	//
	//set basic parameters controlling pose behavior
	//
	bool const fullatom( true );
	bool const ideal_pose( false ); // non-ideal backbone geometry
	bool const read_all_chains( true );
	bool const check_missing( false ); //use this for pose.set_coords throughout
	bool const coords_init( true ); //used in pose_from_misc




	//debug option
	//
	bool const output_debug_pdbs=truefalseoption("output_debug_pdbs");

	//
	//How many designs to minimize?
	//

	int n_designs_to_minimize = 1;
	intafteroption( "n_designs_to_minimize", n_designs_to_minimize, n_designs_to_minimize );


	//
	//Before you read in pdbs, set disulf options automatically
	//
	disulfides::options::find_disulf = true;
	disulfides::options::norepack_disulf = true;

	//
	//Before you read in pdbs, set no_optH
	//
	files_paths::no_optH = truefalseoption("no_optH");

	//
	//file to output scores
	//
	std::string output_filename;
	stringafteroption( "output_file", "none", output_filename );
	if( output_filename == "none" ) {
		std::cout << "Need -output_file <filename> "
              << "on command-line " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
 	}
	//
	//open the output file
	// ( leave it open since we write scores about 1/s or faster )
	utility::io::ozstream outfile;
	open_output_file( output_filename, outfile );

	//
	//Put header in output file...
	//
	outfile   << SS( "complex_min: " )
						<< SS( "iconf" )
						<< SS( " ddg-score" )
						<< SS( "   ddg-atr" )
						<< SS( "   ddg-rep" )
						<< SS( "   ddg-sol" )
						<< SS( "  ddg-hbsc" )
						<< SS( " tot-score" )
						<< SS( "   tot-atr" )
						<< SS( "   tot-rep" )
						<< SS( "   tot-sol" )
						<< SS( "   tot-dun" )
						<< SS( "  tot-hbsc" )
						<< SS( "  tot-prob" )
		//														<< SS( " iconf_overall" )
						<< SS( "    rotX" )
						<< SS( "    rotY" )
						<< SS( "    rotZ" )
						<< SS( "  transX" )
						<< SS( "  transY" )
						<< SS( "  transZ" )
						<< SS( "bad_min?" )
						<< std::endl;


	//
	//checkpoint file for running on clusters
	//
	std::string checkpoint_filename;
	std::string checkpoint_file_w_path;
	stringafteroption( "checkpoint", "none", checkpoint_filename );
	bool using_checkpoint = false;
 	if ( checkpoint_filename == "none" ) {
		std::cout << "no checkpoint_filename, NOT using checkpointing" << std::endl;
	} else {
		using_checkpoint = true;
		checkpoint_file_w_path = files_paths::score_path + checkpoint_filename;
	}

	//
	//Do you want pdbs output for design?
	//
	bool output_pdbs = truefalseoption("output_pdbs");



	// read in the starting complex of target_protein + binder
	Pose starting_complex;
	std::string starting_complex_filename = stringafteroption("starting_complex");
	pose_from_pdb( starting_complex, starting_complex_filename, fullatom, ideal_pose,
								 read_all_chains );
	//starting_complex.dump_pdb( "starting_complex.pdb" );

	// flip symmetric sidechains
	{
		float const start_score( starting_complex.score( weight_map ) );
		starting_complex.refold_sidechains_from_chi();
		if ( runlevel_ns::runlevel > runlevel_ns::quiet ) {
			std::cout << "score-delta from sidechain flip: " <<
				starting_complex.score( weight_map ) - start_score << std::endl;
		}
	}


	int const nres_complex( starting_complex.total_residue() );
	int nres_target(0);
	// set length of partner1:
	// get from commandline
	intafteroption( "nres_target", 0, nres_target );
	if ( nres_target == 0 ) {
		std::cout << "must specify -nres_target <nres> on commandline" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	//save nres for full-length peptide graft
	//
	int const nres_binder = nres_complex - nres_target;


	//make a pose that is target only and score it
	//Assuming that target is first in the input starting_complex
	if ( runlevel_ns::runlevel > runlevel_ns::quiet ) {
		std::cout << "Assuming that target is first in the input starting_complex !! " << std::endl;
	}
	Pose target;
	target.simple_fold_tree( nres_target );
	target.set_fullatom_flag( true, false /*repack*/);
	copy_segment_to_new_pose( starting_complex, 1 /*begin_src*/, nres_target /*end_src*/, target );
	target.score( weight_map );

	float const fa_rep_target ( target.get_0D_score( FA_REP ) );

	//make a pose that is binder only and score it
	Pose binder;
	binder.simple_fold_tree( nres_binder );
	binder.set_fullatom_flag( true, false /*repack*/);
	copy_segment_to_new_pose( starting_complex, nres_target+1 /*begin_src*/, nres_complex /*end_src*/, binder );
	binder.score( weight_map );
	float const fa_rep_binder ( binder.get_0D_score( FA_REP ) );


	//
	//strip suffix and path from start_pdb to use in output filenames
	//
	std::string tmp_name = starting_complex_filename;
	if ( has_suffix( tmp_name, ".gz" ) )
		tmp_name.erase( tmp_name.length() - 3 ); // strip terminal .gz
	if ( has_suffix( tmp_name, ".pdb" ) )
		tmp_name.erase( tmp_name.length() - 4 ); // strip terminal .pdb
	std::string start_pdb_name = tmp_name.substr( tmp_name.find_last_of( '/' ) + 1 );



	//Read in 'mini_resfile'...bypassing normal resfile b/c of undesired global behavior after reading
	//

	FArray1D_int design_positions( nres_complex );//will be redimensioned
	FArray2D_bool design_matrix( param::MAX_AA(), nres_complex, false );
	read_mini_resfile_into_design_matrix( starting_complex, design_positions, design_matrix );
	int const n_design_positions = int(design_positions.size());


	//make a complex that is entirely glycine ( both target and binder )
	Pose complex_gly;
	complex_gly = starting_complex;
	int gly_begin = 1;
	int gly_end = nres_complex;
	convert_resnum_range_to_gly( complex_gly, gly_begin,  gly_end );
	complex_gly.score( weight_map );
	float const fa_rep_complex_gly ( complex_gly.get_0D_score( FA_REP ) );

	if ( output_debug_pdbs ) complex_gly.dump_pdb("complex_gly.pdb");

	//
	//make a pose that is just the target all-gly
	//
	Pose target_gly;
	target_gly.simple_fold_tree( nres_target );
	target_gly.set_fullatom_flag( true, false /*repack*/);
	copy_segment_to_new_pose( complex_gly, 1 /*begin_src*/, nres_target /*end_src*/, target_gly );
	target_gly.score( weight_map );
	float const fa_rep_target_gly ( target_gly.get_0D_score( FA_REP ) );

	//
	//make a pose that is just the binder all-gly
	//
	Pose binder_gly;
	binder_gly.simple_fold_tree( nres_binder );
	binder_gly.set_fullatom_flag( true, false /*repack*/);
	copy_segment_to_new_pose( complex_gly, nres_target+1 /*begin_src*/, nres_complex /*end_src*/, binder_gly );
	binder_gly.score( weight_map );
	float const fa_rep_binder_gly ( binder_gly.get_0D_score( FA_REP ) );


	////////////////////////////////////////////////////////////////////
	//native: now measure clash between epitope backbone and Ab all-atom
	////////////////////////////////////////////////////////////////////

	float const ddg_fa_rep_complex_gly ( fa_rep_complex_gly - fa_rep_binder_gly - fa_rep_target_gly );

	std::cout << "starting complex w/all-gly binder:: "
						<< "farep_complex, farep_target, farep_binder, ddg_farep "
						<< fa_rep_complex_gly << " "
						<< fa_rep_target << " "
						<< fa_rep_binder_gly << " "
						<< ddg_fa_rep_complex_gly << std::endl;


	//
	//Note it is important to put this stuff after the setup of gly things.
	//can't use convert resnum to gly anymore, once you setup a task??



	//
	//design options
	//
	design::try_both_his_tautomers = true;

	/*
	//
	//setup the design Task that will be applied to each docked_complex
	//
  PackerTask Task( starting_complex );

	{
		//
		//variables to set for the call to pack_rotamers
		//
		std::string pack_mode( "design" );
		bool make_output_file( false );
		FArray1D_bool allow_repack_local( param::MAX_RES()(), true );
		bool include_current( true );
		//		bool include_extra ( false );
		//		FArray2D_int extra_rot( param::MAX_CHI, param::MAX_RES()() ); // dummy variable in this instance
		//		FArray2D_float extra_chi( param::MAX_CHI, param::MAX_RES()() ); // dummy variable in this instance

		Task.set_task( pack_mode, make_output_file, allow_repack_local, include_current );
		//		Task.set_task( pack_mode, make_output_file, allow_repack_local,
		//									 include_current, include_extra, extra_rot, extra_chi);
		//bk set variables that specify which residues to vary
		Task.setup_residues_to_vary();//this will read the resfile
	}
	*/




  //
  //read in a list of x,y,z,rotx,roty,rotz to set docked conformations
  //
  int n_dock_conformations_input = 0;
  FArray2D_float list_dock_conformations( 6, n_dock_conformations_input );
  bool dock_conformations_from_file = false;
  if ( truefalseoption ("list_dock_conformations" ) ) {
    dock_conformations_from_file = true;
    read_list_dock_conformations( n_dock_conformations_input, list_dock_conformations );
  }



	//
	//clash thresholds set from command-line
	//
	float max_ddg_fa_rep_gly_default( 100. ); //needs to be tested
	float max_ddg_fa_rep_gly;
	realafteroption("max_ddg_fa_rep_gly", max_ddg_fa_rep_gly_default, max_ddg_fa_rep_gly );

	//
	//how many design iterations at each docked conformation?
	//( default is 10 )
	int n_design_iterations = 10;
	intafteroption( "n_design_iterations", n_design_iterations, n_design_iterations );

	//
	//rotamer trials?
	//
	bool use_rotamer_trials = truefalseoption("use_rotamer_trials");

  //
  //command-line option to specify ranges equivalently for X,Y,Z
  //
  float rot_angle_min = realafteroption( "rot_angle_min", -180.0 );
  float rot_angle_max = realafteroption( "rot_angle_max", -170.0 );
  float rot_angle_delta = realafteroption( "rot_angle_delta", 10.0 );



  //
  //Also allow command-line option to specify X, Y, Z ranges independently
  //this overrides the "equivalent setting" above
  //

  //
  //  X_rot
  //
  float rot_angle_X_min = rot_angle_min; //-180.0;
  float rot_angle_X_max = rot_angle_max; //180.0;
  float rot_angle_X_delta = rot_angle_delta; //10.0;
  rot_angle_X_min = realafteroption( "rot_angle_X_min", rot_angle_X_min );
  rot_angle_X_max = realafteroption( "rot_angle_X_max", rot_angle_X_max );
  rot_angle_X_delta = realafteroption( "rot_angle_X_delta", rot_angle_X_delta );
  int n_X_rot =  int ( std::floor( ( rot_angle_X_max - rot_angle_X_min )/rot_angle_X_delta ) );

  //
  //  Y_rot
  //
  float rot_angle_Y_min = rot_angle_min; //-180.0;
  float rot_angle_Y_max = rot_angle_max; //180.0;
  float rot_angle_Y_delta = rot_angle_delta; //10.0;
  rot_angle_Y_min = realafteroption( "rot_angle_Y_min", rot_angle_Y_min );
  rot_angle_Y_max = realafteroption( "rot_angle_Y_max", rot_angle_Y_max );
  rot_angle_Y_delta = realafteroption( "rot_angle_Y_delta", rot_angle_Y_delta );
  int n_Y_rot =  int ( std::floor( ( rot_angle_Y_max - rot_angle_Y_min )/rot_angle_Y_delta ) );

  //
  //  Z_rot
  //
  float rot_angle_Z_min = rot_angle_min; //-180.0;
  float rot_angle_Z_max = rot_angle_max; //180.0;
  float rot_angle_Z_delta = rot_angle_delta; //10.0;
  rot_angle_Z_min = realafteroption( "rot_angle_Z_min", rot_angle_Z_min );
  rot_angle_Z_max = realafteroption( "rot_angle_Z_max", rot_angle_Z_max );
  rot_angle_Z_delta = realafteroption( "rot_angle_Z_delta", rot_angle_Z_delta );
  int n_Z_rot =  int ( std::floor( ( rot_angle_Z_max - rot_angle_Z_min )/rot_angle_Z_delta ) );

	//
	//  X trans
	//

  float trans_X_min = realafteroption( "trans_X_min", 28.0 );
  float trans_X_max = realafteroption( "trans_X_max", 32.0 );
  float trans_X_delta = realafteroption( "trans_X_delta", 2.0 );
  int n_X = int ( std::floor( ( trans_X_max - trans_X_min )/trans_X_delta ) );

	//
	//  Y trans
	//

  float trans_Y_min = realafteroption( "trans_Y_min", 28.0 );
  float trans_Y_max = realafteroption( "trans_Y_max", 32.0 );
  float trans_Y_delta = realafteroption( "trans_Y_delta", 2.0 );
  int n_Y = int ( std::floor( ( trans_Y_max - trans_Y_min )/trans_Y_delta ) );

	//
	//  Z trans
	//

  float trans_Z_min = realafteroption( "trans_Z_min", 28.0 );
  float trans_Z_max = realafteroption( "trans_Z_max", 32.0 );
  float trans_Z_delta = realafteroption( "trans_Z_delta", 2.0 );
  int n_Z = int ( std::floor( ( trans_Z_max - trans_Z_min )/trans_Z_delta ) );


  if ( !dock_conformations_from_file ) {
		std::cout << "using rot_angle_X_min = " << rot_angle_X_min << std::endl;
		std::cout << "using rot_angle_X_max = " << rot_angle_X_max << std::endl;
		std::cout << "using rot_angle_Y_min = " << rot_angle_Y_min << std::endl;
		std::cout << "using rot_angle_Y_max = " << rot_angle_Y_max << std::endl;
		std::cout << "using rot_angle_Z_min = " << rot_angle_Z_min << std::endl;
		std::cout << "using rot_angle_Z_max = " << rot_angle_Z_max << std::endl;
		std::cout << " " << std::endl;
		std::cout << "n_X_rot, n_Y_rot, n_Z_rot: " << n_X_rot << " " << n_Y_rot << " " << n_Z_rot  << std::endl;
  }


  //
  //kluge to allow looping over specified parameter
  //ranges or over specific conformations
  //
  //we have 6 loops over x,y,z,rotx,roty,rotz ranges that allow
  //us to just scan over ranges of these parameters...
  //
  //but we also want to be able to loop over a list
  //of specific combinations of x,y,z,rotx,roty,rotz
  //so we enclose the 6 loops with an outer loop over
  //the list elements. If no list the outer loop just
  //gets executed once. If yes list then the outer
  //loop controls the 6 inner loops to set the
  //parameters correctly.
  //


  int n_outer_loop;
  if ( dock_conformations_from_file ) {
    n_X = 0;
    n_Y = 0;
    n_Z = 0;
    n_X_rot = 0;
    n_Y_rot = 0;
    n_Z_rot = 0;
    n_outer_loop = n_dock_conformations_input;
  } else {
    n_outer_loop = 1;
  }

  int n_dock_conformations = 0;


  for ( int i_conf = 1; i_conf <= n_outer_loop; i_conf++ ) {
    //
    //if read conf from file then setup "xxx_min" vals
    //in the 6 inner loops to specify a single conformation
    //for each iteration of outer loop.
    //
    if ( dock_conformations_from_file ) {
      rot_angle_X_min = list_dock_conformations( 1, i_conf );
      rot_angle_Y_min = list_dock_conformations( 2, i_conf );
      rot_angle_Z_min = list_dock_conformations( 3, i_conf );
      trans_X_min  = list_dock_conformations( 4, i_conf );
      trans_Y_min  = list_dock_conformations( 5, i_conf );
      trans_Z_min  = list_dock_conformations( 6, i_conf );
    }

		for ( int i_X_rot = 0; i_X_rot <= n_X_rot; i_X_rot++ ) {
			float rot_angle_X = rot_angle_X_min + i_X_rot*rot_angle_X_delta;

			for ( int i_Y_rot = 0; i_Y_rot <= n_Y_rot; i_Y_rot++ ) {
				float rot_angle_Y = rot_angle_Y_min + i_Y_rot*rot_angle_Y_delta;

				for ( int i_Z_rot = 0; i_Z_rot <= n_Z_rot; i_Z_rot++ ) {
					float rot_angle_Z = rot_angle_Z_min + i_Z_rot*rot_angle_Z_delta;

					for ( int i_X = 0; i_X <= n_X; i_X++ ) {
						float trans_X = trans_X_min + i_X*trans_X_delta;

						for ( int i_Y = 0; i_Y <= n_Y; i_Y++ ) {
							float trans_Y = trans_Y_min + i_Y*trans_Y_delta;

							for ( int i_Z = 0; i_Z <= n_Z; i_Z++ ) {
								float trans_Z = trans_Z_min + i_Z*trans_Z_delta;


								++n_dock_conformations;

								if ( using_checkpoint ) {
									bool already_scored = check_conformation_already_scored( n_dock_conformations, checkpoint_file_w_path );
									std::cout << "n, already_scored " << n_dock_conformations << " " << already_scored << std::endl;
									if ( already_scored ) continue;
								}


								std::cout << "i_conf, Xrot, Yrot, Zrot, X, Y, Z: " << I(5,i_conf) << " " << F(8,2,rot_angle_X) << " " << F(8,2,rot_angle_Y) << " " << F(8,2,rot_angle_Z) << ""
													<< F(8,2,trans_X) << " " << F(8,2,trans_Y) << " " << F(8,2,trans_Z) << std::endl;

								///Now:
								//(1) generate new conformation for binder
								//(2) make pose of target+binder all-gly
								//(3) score all-gly for clash and continue to next conformation if too much bb-bb clash
								//(4) if bbbb clash is ok, orient fullatom binder and make fullatom pose of target+binder
								//(5) compute design matrix
								//(6) do the design n times
								//(7) rank the designs
								//(8) take best m designs and minimize them ( rbsc -- must setup a jump to do this )
								//(9) compute total score and ddg, output that information
								//(10) output information on mutations that were made
								//(11) output pdbs if desired.


								//rotation and translation for binder
								//need to keep so can apply to all-gly and fullatom
								//
								numeric::xyzMatrix_double Rxyz = X_rot( rot_angle_X ) * Y_rot( rot_angle_Y ) * Z_rot( rot_angle_Z );
								numeric::xyzVector_double Txyz( trans_X, trans_Y, trans_Z );

								//
								//compute new orientation for binder
								//
								Pose binder_gly_oriented;
								binder_gly_oriented = binder_gly;
								new_orient_pose( binder_gly, Rxyz, Txyz, binder_gly_oriented );

								//
								//make new complex of target (all-gly) + binder (all-gly)
								//
								Pose docked_complex_gly;
								construct_pose_complex_from_p1_p2( target_gly, binder_gly_oriented, docked_complex_gly );

								if ( output_debug_pdbs ) docked_complex_gly.dump_pdb( "docked_complex_gly.pdb" );

								//
								//Compute fa_rep of target(fullatom) and binder(all-gly)
								//

								docked_complex_gly.score( weight_map );
								float fa_rep_docked_complex_gly = docked_complex_gly.get_0D_score( FA_REP );
								float ddg_fa_rep_docked_complex_gly = fa_rep_docked_complex_gly - fa_rep_target - fa_rep_binder_gly;

								//
								// if too much bb-bb clash, continue to next conformation
								//
								if ( ddg_fa_rep_docked_complex_gly > max_ddg_fa_rep_gly ) {
									std::cout << "ddg_fa_rep_docked_complex_gly = " << ddg_fa_rep_docked_complex_gly << " > max...skipping" << std::endl;

									//
									//checkpoint for clusters
									//
									if ( using_checkpoint ) {
										update_conformation_already_scored( i_conf, checkpoint_file_w_path );
									}
									continue;
								}

								//
								//if we made it here, then we can construct the all-atom complex now, and design it, minimize it.
								//


								//
								//compute new orientation for binder
								//
								Pose binder_oriented;
								binder_oriented = binder;
								new_orient_pose( binder, Rxyz, Txyz, binder_oriented );

								//
								//make new complex of target + binder ( both all-atom )
								//
								Pose docked_complex;
								construct_pose_complex_from_p1_p2( target, binder_oriented, docked_complex );

								if ( output_debug_pdbs ) docked_complex.dump_pdb( "docked_complex.pdb" );

								//we should have already read in the resfile...that places restrictions...but we could
								//further restrict design to only those positions at the interface....
								//on the other hand, if we just design and repack the same set every time, then
								//the energies can be compared fairly

								//total scores ( only the unique designs )
								//
								FArray1D_float score_docked_designed_complex( n_design_iterations, 0.0 );
								FArray1D_int rank_to_index_score_docked_designed_complex( n_design_iterations, 0 );

								//record all thes scores ( including non-unique )
								FArray1D_float score_docked_designed_complex_all_iterations( n_design_iterations, 0.0 );

								//vector or FArray of pointers to poses
								//
								//    std::vector< Pose* > pose_list;
								FArray1D< Pose* > pose_array_docked_designed_complex( n_design_iterations );

								//
								//record number of unique designs
								//
								int n_unique_designs = 0;

								for ( int i_design = 1; i_design <= n_design_iterations; i_design++ ) {

									Pose docked_designed_complex;
								  docked_designed_complex = docked_complex;
									//									pack_rotamers( docked_designed_complex, Task );
									design_using_design_matrix( docked_designed_complex, design_matrix );


									//score for this design
									//
									docked_designed_complex.score( weight_map );
									//
									//if we already have a design with this SCORE, then skip to next design iteration
									//
									float score_for_this_design = docked_designed_complex.get_0D_score( SCORE );
									score_docked_designed_complex_all_iterations( i_design ) = score_for_this_design;


									float fa_rep_for_this_design = docked_designed_complex.get_0D_score( FA_REP );
									//							float rough_ddg_fa_rep_for_this_design = fa_rep_for_this_design - fa_rep_target - fa_rep_binder;
									//					bool skip_due_to_clash = false;
									//		if ( rough_ddg_fa_rep_for_this_design > 3000. ) skip_due_to_clash = true;


									std::cout << "design iteration " << i_design << " score = " << score_for_this_design << std::endl;
									//														<< " rough_ddg_fa_rep = " << rough_ddg_fa_rep_for_this_design << std::endl;

									bool skip_this_design = false;
									for ( int i = 1; i < i_design; i++ ) {
										if ( score_for_this_design < score_docked_designed_complex_all_iterations( i )+0.01 &&
												 score_for_this_design > score_docked_designed_complex_all_iterations( i )-0.01) {
											skip_this_design = true;
											break;
										}
									}
									if ( skip_this_design ) {
										std::cout << "skipping this design " << std::endl;
										continue;
									} else {
										n_unique_designs++;
										score_docked_designed_complex( n_unique_designs ) = score_for_this_design;
										std::cout << "i_design, n_unique_designs, score " << i_design << " " << n_unique_designs << " "
															<< score_docked_designed_complex( n_unique_designs ) << std::endl;
									}

									//
									//dump design pdb
									//
									if ( output_debug_pdbs ) docked_designed_complex.dump_pdb( "docked_designed_complex_" + string_of( i_conf ) + "_" + string_of( n_unique_designs ) + ".pdb" );

									//allocate memory for new poses
									//
									Pose * pose_ptr_docked_designed_complex( new Pose );

									//attach pointers to actual poses
									//either from misc
									//pose_from_misc( *pose_ptr, true, false, true );
									//or get it directly
									*pose_ptr_docked_designed_complex = docked_designed_complex;

									//store the pose pointer in an array
									//
									pose_array_docked_designed_complex( n_unique_designs ) = pose_ptr_docked_designed_complex;

									//initialize the rank_to_index arrays
									//
									rank_to_index_score_docked_designed_complex( n_unique_designs ) = n_unique_designs;

								}//design iterations


								std::cout << "done design iterations, n_unique_designs = " << n_unique_designs << std::endl;

								score_docked_designed_complex.redimension( n_unique_designs );
								rank_to_index_score_docked_designed_complex.redimension( n_unique_designs );

								std::cout << "about to rank " << std::endl;

								//rank the ddg values
								//( this sets rank_to_index... in ascending order )
								rank( n_unique_designs, score_docked_designed_complex, rank_to_index_score_docked_designed_complex );

								//error check
								//
								if ( n_designs_to_minimize > n_unique_designs ) {
									std::cout << "WARNING: n_designs_to_minimize > n_unique_designs ... resetting n_designs_to_minimize to n_unique_designs = " <<
										n_unique_designs << std::endl;
									n_designs_to_minimize = n_unique_designs;
								}

								std::cout << "now to minimize" << std::endl;

								//
								//Now minimize the designs
								//
								for ( int i_rank = 1; i_rank <= n_designs_to_minimize; i_rank++ ) {

									//index to the array of designed poses
									int const i_design = rank_to_index_score_docked_designed_complex( i_rank );

									std::cout << "minimize loop: i_rank, i_design " << i_rank << " " << i_design << std::endl;

									Pose & docked_designed_complex( *pose_array_docked_designed_complex( i_design ) ); // 1->

									//
									//Output energies: total E, ddg-bind, and ddg-stability
									//

									docked_designed_complex.score( weight_map );
									float score_out = docked_designed_complex.get_0D_score( SCORE );
									if ( std::abs( score_out - score_docked_designed_complex( i_design ) ) > 0.01 ) {
										std::cout << "!!!!!!!!!!!! WARNING WARNING WARNING WARNING !!!!!!!!!!!!!!!" << std::endl;
										std::cout << "ERROR score disagreement between score_out " << score_out
															<< " and score_docked_designed_complex( i_design ) " << score_docked_designed_complex( i_design ) << std::endl;
										std::cout << "!!!!!!!!!!!! WARNING WARNING WARNING WARNING !!!!!!!!!!!!!!!" << std::endl;
									}
									float  fa_rep_docked_designed_complex  ( docked_designed_complex.get_0D_score( FA_REP ) );
									float  fa_atr_docked_designed_complex  ( docked_designed_complex.get_0D_score( FA_ATR ) );
									float  fa_sol_docked_designed_complex  ( docked_designed_complex.get_0D_score( FA_SOL ) );
									float  fa_dun_docked_designed_complex  ( docked_designed_complex.get_0D_score( FA_DUN ) );
									float  hbsc_docked_designed_complex    ( docked_designed_complex.get_0D_score( HB_SC ) );
									float  fa_prob_docked_designed_complex ( docked_designed_complex.get_0D_score( FA_PROB ) );

									//
									//Here extract scaff and Ab poses and compute ddb_bind and ddg_stability
									//

									//									Pose target_design;
									//									target_design.simple_fold_tree( nres_target );
									//									target_design.set_fullatom_flag( true, false /*repack*/ );
									//									copy_segment_to_new_pose( docked_designed_complex /*src_pose*/,
									//																						1 /*begin_src*/,
									//																						nres_target/*end_src*/,
									//																						target_design /*pose_out*/);
									//									target_design.score( weight_map );
									//									if ( output_debug_pdbs ) target_design.dump_pdb("target_design_" + string_of( i_conf ) + "_" + string_of( i_design ) + ".pdb");

									//									Pose binder_design;
									//									binder_design.simple_fold_tree( nres_binder );
									//									binder_design.set_fullatom_flag( true, false /*repack*/ );
									//									copy_segment_to_new_pose( docked_designed_complex /*src_pose*/,
									//																						nres_target+1                 /*begin_src*/,
									//																						nres_complex           /*end_src*/,
									//																						binder_design    /*pose_out*/);
									//									binder_design.score( weight_map );

									//
									//Setup the jump between target and binder
									//
									pose_docking_build_simple_tree( docked_designed_complex, nres_complex, nres_target );
									pose_docking_set_rb_center ( docked_designed_complex );//rb_center in middle of interface
									docked_designed_complex.set_allow_jump_move( true );//only 1 jump

									// minimize parameters
									minimize_exclude_sstype( false, false );
									minimize_set_vary_phipsi( false );
									minimize_set_vary_omega( false );
									minimize_set_vary_chi( true );
									minimize_set_vary_rb_trans( true );
									minimize_set_vary_rb_angle( true );
									minimize_set_local_min( false, 0 );
									pose_set_use_nblist( true );

									//no rotamer trials
									score_set_try_rotamers( use_rotamer_trials );

									//
									//set allow_chi_move true for interface sidechains...but exclude special positions...according to resfile
									//
									//so the ones that can be minimized are the ones that can (a) repack or design and (b) at the interface
									//well,  maybe we should do the same ones everytime, so energies can be compared...
									//in that case, just use the resfile

									FArray1D_bool allow_bb_move( nres_complex, false );
									FArray1D_bool allow_chi_move ( nres_complex, false );
									for( int i=1; i<=n_design_positions; ++i ) {
										int design_position = design_positions( i );
										allow_chi_move( design_position ) = true; //these are design or repack positions!
										std::cout << I(3,i) << " allowing chi move at " << I(5,design_position) << std::endl;
										//										allow_chi_move( i ) = Task.get_designmap().repack_residue(i);
									}

									docked_designed_complex.set_allow_bb_move( allow_bb_move );
									docked_designed_complex.set_allow_chi_move( allow_chi_move );

									minimize_set_tolerance( 1e-6 );//1e-6
									std::cout << "about to minimize" << std::endl;
									docked_designed_complex.main_minimize( weight_map, "dfpmin" );

									if ( output_debug_pdbs ) docked_designed_complex.dump_pdb("complex_min.pdb");

									//
									//minimization diagnostics...how far did it move? too far?...did the minimizer get unhappy?
									//

									bool bad_min = false;
									if ( std::abs(min_debug::nblist_score_delta_before) > 100.0 || std::abs(min_debug::nblist_score_delta_after) > 100.0 ) {
										bad_min = true;
									}

									//
									//Post-minimization...compute ddg_bind and ddg_total
									//

									Pose target_min;
									target_min.simple_fold_tree( nres_target );
									target_min.set_fullatom_flag( true, false /*repack*/ );
									copy_segment_to_new_pose( docked_designed_complex /*src_pose*/,
																						1 /*begin_src*/,
																						nres_target/*end_src*/,
																						target_min /*pose_out*/);
									target_min.score( weight_map );

									Pose binder_min;
									binder_min.simple_fold_tree( nres_binder );
									binder_min.set_fullatom_flag( true, false /*repack*/ );
									copy_segment_to_new_pose( docked_designed_complex /*src_pose*/,
																						nres_target+1                 /*begin_src*/,
																						nres_complex           /*end_src*/,
																						binder_min    /*pose_out*/);
									binder_min.score( weight_map );

                  float  score_complex_min  ( docked_designed_complex.get_0D_score( SCORE ) );
                  float  fa_rep_complex_min  ( docked_designed_complex.get_0D_score( FA_REP ) );
                  float  fa_atr_complex_min  ( docked_designed_complex.get_0D_score( FA_ATR ) );
                  float  fa_sol_complex_min  ( docked_designed_complex.get_0D_score( FA_SOL ) );
                  float  fa_dun_complex_min  ( docked_designed_complex.get_0D_score( FA_DUN ) );
                  float  hbsc_complex_min    ( docked_designed_complex.get_0D_score( HB_SC ) );
                  float  fa_prob_complex_min ( docked_designed_complex.get_0D_score( FA_PROB ) );


                  float  score_target_min  ( target_min.get_0D_score( SCORE ) );
                  float  fa_rep_target_min  ( target_min.get_0D_score( FA_REP ) );
                  float  fa_atr_target_min  ( target_min.get_0D_score( FA_ATR ) );
                  float  fa_sol_target_min  ( target_min.get_0D_score( FA_SOL ) );
                  float  fa_dun_target_min  ( target_min.get_0D_score( FA_DUN ) );
                  float  hbsc_target_min    ( target_min.get_0D_score( HB_SC ) );
                  float  fa_prob_target_min ( target_min.get_0D_score( FA_PROB ) );

                  float  score_binder_min  ( binder_min.get_0D_score( SCORE ) );
                  float  fa_rep_binder_min  ( binder_min.get_0D_score( FA_REP ) );
                  float  fa_atr_binder_min  ( binder_min.get_0D_score( FA_ATR ) );
                  float  fa_sol_binder_min  ( binder_min.get_0D_score( FA_SOL ) );
                  float  fa_dun_binder_min  ( binder_min.get_0D_score( FA_DUN ) );
                  float  hbsc_binder_min    ( binder_min.get_0D_score( HB_SC ) );
                  float  fa_prob_binder_min ( binder_min.get_0D_score( FA_PROB ) );


									//ddG-bind total score and components
									//
									float ddg_bind_complex_min_score   = score_complex_min - score_target_min - score_binder_min;
									float ddg_bind_complex_min_fa_rep  = fa_rep_complex_min  - fa_rep_target_min  - fa_rep_binder_min;
									float ddg_bind_complex_min_fa_atr  = fa_atr_complex_min  - fa_atr_target_min  - fa_atr_binder_min;
									float ddg_bind_complex_min_fa_sol  = fa_sol_complex_min  - fa_sol_target_min  - fa_sol_binder_min;
									float ddg_bind_complex_min_fa_dun  = fa_dun_complex_min  - fa_dun_target_min  - fa_dun_binder_min;
									float ddg_bind_complex_min_hbsc    = hbsc_complex_min    - hbsc_target_min    - hbsc_binder_min;
									float ddg_bind_complex_min_fa_prob = fa_prob_complex_min - fa_prob_target_min - fa_prob_binder_min;


									//
									//and do the output information
									//

									outfile   << SS( "complex_min: " )
														<< I( 6, i_conf ) << " "
														<< F( 10, 2, ddg_bind_complex_min_score  ) << " "
														<< F( 10, 2, ddg_bind_complex_min_fa_atr ) << " "
														<< F( 10, 2, ddg_bind_complex_min_fa_rep ) << " "
														<< F( 10, 2, ddg_bind_complex_min_fa_sol ) << " "
														<< F( 10, 2, ddg_bind_complex_min_hbsc   ) << " "
														<< F( 10, 2, score_complex_min  ) << " "
														<< F( 10, 2, fa_atr_complex_min ) << " "
														<< F( 10, 2, fa_rep_complex_min ) << " "
														<< F( 10, 2, fa_sol_complex_min ) << " "
														<< F( 10, 2, fa_dun_complex_min ) << " "
														<< F( 10, 2, hbsc_complex_min   ) << " "
														<< F( 10, 2, fa_prob_complex_min) << " "
										//														<< I( 13, i_conf_overall ) << " "
														<< F( 8, 2, rot_angle_X ) << " "
														<< F( 8, 2, rot_angle_Y ) << " "
														<< F( 8, 2, rot_angle_Z ) << " "
														<< F( 8, 2, trans_X ) << " "
														<< F( 8, 2, trans_Y ) << " "
														<< F( 8, 2, trans_Z ) << "   "
														<< SS( bad_min )
														<< std::endl;

									std::cout << "before output_pdbs" << std::endl;
									if ( output_pdbs ) {
										//										Ab_scaff_out_pose.pdb_info().set_use_pdb_numbering( true );
										std::string filename = "complex_min_" + string_of( i_conf ) + ".pdb";
										docked_designed_complex.dump_pdb( files_paths::pdb_out_path + filename );
									}

									std::cout << "finishing minimize_loop" << std::endl;
								}//n_designs_to_minimize

								std::cout << "about to delete pointers " << std::endl;

								//
								//Delete the array of pointers
								//
								//								for ( int i_design = 1; i_design <= n_design_iterations; ++i_design ) {
								for ( int i_design = 1; i_design <= n_unique_designs; ++i_design ) {
									//      delete pose_list[k];
									std::cout << "delete pose " << i_design << std::endl;
									delete pose_array_docked_designed_complex( i_design );
								}

								//
								//checkpoint for clusters
								//
								if ( using_checkpoint ) {
									std::cout << "checkpoint_updating... " << i_conf << SS(checkpoint_file_w_path) << std::endl;
									update_conformation_already_scored( i_conf, checkpoint_file_w_path );
									std::cout << "checkpoint_updated " << i_conf << std::endl;

								}

							}//i_Z
						}//i_Y
					}//i_X
				}//i_Z_rot
			}//i_Y_rot
		}//i_X_rot
	}//i_conf

	//
	//Close the output file
	//
	outfile.close();
	outfile.clear();

}
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////
void
new_orient_pose(
								pose_ns::Pose & pose,
								numeric::xyzMatrix_double const & Rxyz,
								numeric::xyzVector_double const & Txyz,
								pose_ns::Pose & pose_oriented
								)
{

	int const nres = pose.total_residue();

	pose_oriented = pose;

	FArray3D_double fcoord( 3, param::MAX_ATOM(), nres, 0.0);
	FArray3D_float fcoord_oriented( 3, param::MAX_ATOM(), nres, 0.0);


	for ( int i = 1; i <= nres; i++ ) {
		int const aa ( pose.res(i) );
		int const aav ( pose.res_variant(i) );
		int const natoms( aaproperties_pack::natoms(aa,aav) );
		for ( int iatom = 1; iatom <= natoms; iatom++ ) {
			for ( int k = 1; k <= 3; k++ ) {
				fcoord( k, iatom, i ) = pose.full_coord()( k, iatom, i);
			}
			//                        v = (fcoord(1,iatom,i),fcoord(2,iatom,i),fcoord(3,iatom,i));
			numeric::xyzVector_double v( &fcoord( 1, iatom, i));
			numeric::xyzVector_double vnew( Rxyz * v + Txyz );
			//copy back to FArray for set_coords
			for ( int k = 1; k<=3; k++ ) {
				fcoord_oriented( k, iatom, i ) = vnew(k);
			}
		}
	}


	FArray3D_float Epos_oriented( 3, param::MAX_POS, nres );//MAX_POS = 5

	for ( int i = 1; i <= nres; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			Epos_oriented(k,1,i) = fcoord_oriented(k,1,i);
			Epos_oriented(k,2,i) = fcoord_oriented(k,2,i);
			Epos_oriented(k,4,i) = fcoord_oriented(k,3,i);
			Epos_oriented(k,5,i) = fcoord_oriented(k,4,i);
			Epos_oriented(k,3,i) = fcoord_oriented(k,5,i);
		}
	}
	bool const ideal_pose = false;
	bool const check_missing = false;
	pose_oriented.set_coords( ideal_pose, Epos_oriented, fcoord_oriented, check_missing );
}


void
read_list_dock_conformations(
														 int & n_dock_conformations,
														 FArray2D_float & list_dock_conformations
														 )
{


  int const MAX_N_DOCK_CONFORMATIONS = 100000;

	std::string filename;
  filename = stringafteroption( "list_dock_conformations");

	utility::io::izstream infile ( filename );
  if ( ! infile ) {
		std::cout << "read_list_dock_conformations:"
              << " cannot open file " << filename
              << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }


  n_dock_conformations = 0;
	std::string line;
  while( getline( infile, line ) ) {
		std::string blank(line.size(),' ');
    if ( line == blank ) continue;
		std::istringstream line_stream( line );
    ++n_dock_conformations;
    list_dock_conformations.redimension( 6, n_dock_conformations );
    line_stream >>
      list_dock_conformations( 1, n_dock_conformations ) >>
      list_dock_conformations( 2, n_dock_conformations ) >>
      list_dock_conformations( 3, n_dock_conformations ) >>
      list_dock_conformations( 4, n_dock_conformations ) >>
      list_dock_conformations( 5, n_dock_conformations ) >>
      list_dock_conformations( 6, n_dock_conformations );
		std::cout << "n_dock_conformations, list_dock_conformations " << I( 5, n_dock_conformations ) << " "
              << SS( list_dock_conformations( 1, n_dock_conformations )) << " "
              << SS( list_dock_conformations( 2, n_dock_conformations )) << " "
              << SS( list_dock_conformations( 3, n_dock_conformations )) << " "
              << SS( list_dock_conformations( 4, n_dock_conformations )) << " "
              << SS( list_dock_conformations( 5, n_dock_conformations )) << " "
              << SS( list_dock_conformations( 6, n_dock_conformations )) << " "
              << std::endl;
  }
  if ( n_dock_conformations > MAX_N_DOCK_CONFORMATIONS ) {
		std::cout << "ERROR in read_list_dock_conformations:: n_dock_conformations = "
              << n_dock_conformations << " is greater than MAX_N_DOCK_CONFORMATIONS = "
              << MAX_N_DOCK_CONFORMATIONS << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
  if ( n_dock_conformations < 1 ) {
		std::cout << "ERROR in read_list_dock_conformations:: failed to read any dock_conformations " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
}

///////////////////////////////////////////////////////////////////////////////
void
read_mini_resfile_into_design_matrix(
																		 pose_ns::Pose & pose,
																		 FArray1D_int & design_positions,
																		 FArray2D_bool & design_matrix
																		 )
{

	int nres = int(design_positions.size());
	if ( nres==0 ) {
		std::cout << "need to dimension the design_positions array" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}


	std::string filename;
  filename = stringafteroption( "mini_resfile");

	utility::io::izstream infile ( filename );
  if ( ! infile ) {
		std::cout << "read_mini_resfile:"
              << " cannot open file " << filename
              << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }


	int const max_protein_aa = 20;

	//
	//make a list of polar, nonpolar aa ( and exclude cys from nonpolar )
	//
	FArray1D_int polar_aa( max_protein_aa );
	FArray1D_int nonpolar_aa( max_protein_aa );

	int n_polar = 0;
	int n_nonpolar = 0;
	for ( int aa = 1; aa <= max_protein_aa; aa++ ) {
		if ( param_aa::aa_is_polar( aa ) ) {
			++n_polar;
			polar_aa( n_polar ) = aa;
		}
		if ( param_aa::aa_is_nonpolar( aa ) && aa!=param_aa::aa_cys ) {
			++n_nonpolar;
			nonpolar_aa( n_nonpolar ) = aa;
		}
	}

	std::string design_type;
	FArray1D_char aachar( max_protein_aa, ' ' );

	int n_design_positions=0;
	std::string line;
  while( getline( infile, line ) ) {
		std::string blank(line.size(),' ');
    if ( line == blank ) continue;
		std::istringstream line_stream( line );

    ++n_design_positions;
    line_stream >> skip(3) >>
			bite(4,design_positions( n_design_positions )) >>
			skip(6) >> bite(5, design_type ) >> skip(2);
		std::cout << "design_positions( n_design_positions ) " << n_design_positions << " "
							<< design_positions( n_design_positions ) << std::endl;
		//		if ( design_type == "PIKAA" || design_type == "NOTAA" ) {
		for ( int i_aa=1; i_aa <= max_protein_aa; i_aa++ ) {
			line_stream >> bite(aachar( i_aa ));
			if ( aachar( i_aa ) != ' ' ) std::cout << "aachar: " << aachar( i_aa ) << std::endl;
		}
		line_stream >> skip;
		std::cout << "n_design_positions, design_positions " << I( 5, n_design_positions ) << " "
              << SS( design_positions( n_design_positions )) << " "
              << SS( design_type )
              << std::endl;

		int const seqpos = design_positions( n_design_positions );

		if ( design_type == "NATAA" ) {
			int native_aa = pose.res( seqpos );
			design_matrix( native_aa, seqpos ) = true;
		} else {
			if ( design_type == "ALLAA" ) {
				for ( int aa = 1; aa < param_aa::aa_cys; aa++ ) design_matrix( aa, seqpos ) = true;
				for ( int aa = param_aa::aa_cys+1; aa<=max_protein_aa; aa++ ) design_matrix( aa, seqpos ) = true;
			} else {
				if ( design_type == "POLAR" ) {
					for ( int i = 1; i <= n_polar; i++ ) design_matrix( polar_aa( i ), seqpos ) = true;
				} else {
					if ( design_type == "APOLA" ) {
					for ( int i = 1; i <= n_nonpolar; i++ ) design_matrix( nonpolar_aa( i ), seqpos ) = true;
					} else {
						if ( design_type == "PIKAA" ) {
							for ( int i = 1; i <= param::MAX_AA(); ++i ) {
								if ( aachar(i) != ' ' ) {
									int aa;
									num_from_res1(aachar(i),aa);
									design_matrix( aa, seqpos ) = true;
								}
							}
						} else {
							if ( design_type == "NOTAA" ) {
								//count n_disallowed at this position
								int n_disallow = 0;
								for ( int i = 1; i <= param::MAX_AA(); ++i ) {
									if ( aachar(i) == ' ' ) break;
									++n_disallow;
								}
								//allow everything except the disallowed...and cys
								for ( int aa = 1; aa <= max_protein_aa; aa++ ) {
									if ( aa==param_aa::aa_cys ) continue;
									bool allow_this_aa=true;
									for ( int i = 1; i <= n_disallow; ++i ) {
										int aa_disallow;
										num_from_res1(aachar(i),aa_disallow);
										if ( aa == aa_disallow ) {
											allow_this_aa=false;
											break;
										}
									}
									if ( allow_this_aa ) design_matrix( aa, seqpos ) =  true;
								}
							}
						}
					}
				}
			}
		}
  }//while line
  if ( n_design_positions > param::MAX_RES() ) {
		std::cout << "ERROR in read_design_positions:: n_design_positions = "
              << n_design_positions << " is greater than MAXRES = "
              << param::MAX_RES() << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
  if ( n_design_positions < 1 ) {
		std::cout << "ERROR in read_design_positions:: failed to read any design_positions " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }

	//
	//Redimension
	//
	design_positions.redimension( n_design_positions );

}
