// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_grid_dock_and_design
#define INCLUDED_grid_dock_and_design


// Rosetta Headers
#include "../../pose_fwd.h"

// Numeric Headers
#include <numeric/all.fwd.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.fwd.hh>
#include <ObjexxFCL/FArray2D.fwd.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <string>


void
grid_dock_and_design();

void
read_list_dock_conformations(
														 int & n_dock_conformations,
														 FArray2D_float & list_dock_conformations
														 );

void
new_orient_pose(
                pose_ns::Pose & pose,
                numeric::xyzMatrix_double const & Rxyz,
                numeric::xyzVector_double const & Txyz,
                pose_ns::Pose & pose_oriented
                );


void
read_mini_resfile_into_design_matrix(
                                     pose_ns::Pose & pose,
                                     FArray1D_int & design_positions,
                                     FArray2D_bool & design_matrix
                                     );


#endif
