// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8705 $
//  $Date: 2006-06-06 16:15:21 -0700 (Tue, 06 Jun 2006) $
//  $Author: pbradley $


// Rosetta Headers
#include "hiv_trimer.h"
#include "aaproperties_pack.h"
#include "after_opts.h"
#include "are_they_neighbors.h"//use_atom
#include "design.h"
#include "disulfides.h"
#include "disulfides_ns.h"
#include "enzyme.h" //set_enable_ligaa_flag
#include "files_paths.h"
#include "fullatom.h"
#include "fullatom_setup.h"
#include "jumping_refold.h" //pose_to_misc
#include "jumping_util.h"
#include "ligand.h"// for ligand::multi_lig globals
#include "make_pdb.h" //output_fullatom_pdb
#include "minimize.h"
#include "misc.h"
#include "nblist.h"
#include "pack.h"
#include "PackerTask.h"
#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "pose.h"
#include "pose_design.h"
#include "pose_io.h"
#include "pose_ligand.h"
#include "pose_rms.h"
#include "pose_routines.h"
#include "pose_symmetric_docking.h"
#include "read_aa_ss.h"
#include "refold.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"
#include "symmetric_design.h"
#include "util_basic.h"
#include "pose_vdw.h"

#include "jumping_util.h"
#include "util_vector.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/formatted.o.hh>

// Triplet Headers
#include "triplet/triplet.h"
#include "triplet/triplet_functions.h"
#include "triplet/xyzVector.h"
#include "triplet/xyzMatrix.h"

// Utility Headers
#include "utility/basic_sys_util.h"
#include "utility/conversions.h"
#include "utility/izstream.h"
#include "utility/ozstream.h"
#include "utility/file_sys_util.h"

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>

///////////////////////////////////////////////////////////////////////////////
//make and score hiv trimers with glycans

void
hiv_trimer()
{

  using namespace pose_ns;


  // scorefxn
  Score_weight_map weight_map( score12 );
	Score_weight_map centroid_wt_map( score6 );

	float const save_fa_rep_weight = weight_map.get_weight( FA_REP );

	//use_atom used here for cb_dist measurements
	//returns cb atom number for all protein aa except gly
	//returns other chosen atom nums for all other aa
  static FArray1D_int const use_atom( param::MAX_AA(), atn_use_atom_initializer );


  //
  //set basic parameters controlling pose behavior
  //
  bool const fullatom( true );
  bool const ideal_pose( false ); // non-ideal backbone geometry
  bool const read_all_chains( true );
  bool const check_missing( false ); //use this for pose.set_coords throughout
  bool const coords_init( true ); //used in pose_from_misc

	//


	//
	//rotation matrix just for rotating by 120 degrees about z
	//this used to compute prot+glycan coords for monomer2, monomer3
	//
	FArray2D_double Rz120(3,3);
	double const angle_120 = 120.;
	jmp_zrotation(Rz120, angle_120);


	//number of monomers in the oligommer
	int const N = 3;

  //
  //Before you read in pdbs, set disulf options automatically
  //
	disulfides::disulf_options::find_disulf = true;
	disulfides::disulf_options::norepack_disulf = true;


	//
	//input pdb
	//
	std::string start_pdb;
	start_pdb = stringafteroption( "s" );

	//
	//optionally read in Ab pose
	//

	Pose monomer_pose;
	Pose Ab_pose;
	Pose monomer_w_Ab_pose;
	int nres_monomer = 0;
	int nres_monomer_w_Ab = 0;
	int nres_Ab = 0;
	int n_natro_positions_Ab = 0;
	FArray1D_int list_natro_positions_Ab( nres_Ab );//currently dimension 0. gets redimensioned
	FArray1D_bool natro_position_Ab( nres_Ab, false );//currently dimension 0. gets redimensioned
	bool use_Ab = truefalseoption( "use_Ab" );
	if ( use_Ab ) {

		//
		//read in monomer+Ab pose
		//assume the pdb includes glycans as HETATM records
		//but monomer_pose will be protein-only.
		//
		pose_from_pdb( monomer_w_Ab_pose, start_pdb, fullatom, ideal_pose, read_all_chains );
		nres_monomer_w_Ab = monomer_w_Ab_pose.total_residue();
		//
		//Assume that input_monomer_w_Ab_pose has monomer first, Ab second.
		//
		intafteroption( "nres_monomer", 0, nres_monomer );
		if ( nres_monomer == 0 ) {
			std::cout << "if use_Ab is true, you need -nres_monomer <nres> on command-line" << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		// flip symmetric sidechains
		{
			float const start_score( monomer_w_Ab_pose.score( weight_map ) );
			monomer_w_Ab_pose.refold_sidechains_from_chi();
			std::cout << "score-delta from sidechain flip: " <<
				monomer_w_Ab_pose.score( weight_map ) - start_score << std::endl;
		}

		//
		//extract monomer and Ab poses from input complex
		//
		monomer_pose.simple_fold_tree( nres_monomer );
		monomer_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
		monomer_pose.copy_segment( nres_monomer, monomer_w_Ab_pose, 1, 1 );
		nres_Ab = nres_monomer_w_Ab - nres_monomer;
		std::cout << "nres_monomer_w_Ab, nres_monomer, nres_Ab " << nres_monomer_w_Ab << " " << nres_monomer << " " << nres_Ab << std::endl;

		Ab_pose.simple_fold_tree( nres_Ab );
		Ab_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
		Ab_pose.copy_segment( nres_Ab, monomer_w_Ab_pose, 1, nres_monomer+1 );

		Ab_pose.score( weight_map );

		//
		//setup list of natro positions in Ab ( can't be minimized/repacked )
		//
		//exclude disulfides
		//
		int n_disulf_Ab = disulfides::n_disulfides_centroid;
		std::cout << "Ab has disulfides: " << n_disulf_Ab << std::endl;

		FArray1D_int list_cys_resnums_in_disulf_Ab( 2*n_disulf_Ab );
		int n_cys_in_disulf_Ab = 0;
		for ( int i_disulf = 1; i_disulf <= n_disulf_Ab; i_disulf++ ) {
			int resnum1 = disulfides::cys( disulfides::disulf_partner_a( i_disulf ) );
			int resnum2 = disulfides::cys( disulfides::disulf_partner_b( i_disulf ) );
			++n_cys_in_disulf_Ab;
			list_cys_resnums_in_disulf_Ab( n_cys_in_disulf_Ab ) = resnum1;
			++n_cys_in_disulf_Ab;
			list_cys_resnums_in_disulf_Ab( n_cys_in_disulf_Ab ) = resnum2;
		}
		if ( n_cys_in_disulf_Ab != 2*n_disulf_Ab ) {
			std::cout << "ERROR counting disulf Ab " << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		natro_position_Ab.redimension( nres_Ab, false );
		list_natro_positions_Ab.redimension( nres_Ab );
		for ( int i = 1; i <= n_cys_in_disulf_Ab; i++ ) {
			list_natro_positions_Ab( i ) = list_cys_resnums_in_disulf_Ab( i );
			natro_position_Ab( list_natro_positions_Ab( i ) ) = true;
			std::cout << "natro_pos for Ab: " << list_natro_positions_Ab( i ) << std::endl;
		}
		list_natro_positions_Ab.redimension( n_natro_positions_Ab );

		//Ab_pose.dump_pdb( "Ab_pose.pdb", true );

	} else {
		//
		//read in monomer pose
		//assume the pdb includes glycans as HETATM records
		//but monomer_pose will be protein-only.
		//
		pose_from_pdb( monomer_pose, start_pdb, fullatom, ideal_pose, read_all_chains );
		nres_monomer = monomer_pose.total_residue();
		// flip symmetric sidechains
		{
			float const start_score( monomer_pose.score( weight_map ) );
			monomer_pose.refold_sidechains_from_chi();
			std::cout << "score-delta from sidechain flip: " <<
				monomer_pose.score( weight_map ) - start_score << std::endl;
		}
	}


	//test all-gly feature using set_res
	//the problem is that the HA1 and HA2 are in the wrong place after set_res to gly!
	//	Pose test_pose;
	//	test_pose = monomer_pose;
	//	test_pose.score( weight_map );
	//	test_pose.dump_pdb("test_pose1.pdb");
	//	for ( int i_res = 1; i_res <= test_pose.total_residue(); i_res++ ) {
	//		test_pose.set_res( i_res , param_aa::aa_gly );
	//	}
	//	test_pose.score( weight_map );
	//	test_pose.dump_pdb("test_pose2.pdb");
	//	return;


	//
	//minimize sidechains ?
	//
	bool do_minimize = false;
	do_minimize = truefalseoption("do_minimize");

	//
	//minimize, then repack?
	//
	bool do_minrep = false;
	do_minrep = truefalseoption("do_minrep");

	//
	//use symmetry for minimize/repack of trimers?
	//
	bool use_symmetry = false;
	use_symmetry = truefalseoption("use_symmetry");

	//output_pdbs
	bool output_pdbs = false;
	output_pdbs = truefalseoption("output_pdbs");

	//file to output scores
	std::string trimer_scores_filename;
	stringafteroption( "trimer_scores_file", "none", trimer_scores_filename );
	if( trimer_scores_filename == "none" ) {
		std::cout << "Need -trimer_scores_file <filename> "
							<< "on command-line " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	//
	//checkpoint file for running on clusters
	//
	std::string checkpoint_filename;
	std::string checkpoint_file_w_path;
	stringafteroption( "checkpoint", "none", checkpoint_filename );
	bool using_checkpoint = false;
	if ( checkpoint_filename == "none" ) {
		std::cout << "no checkpoint_filename, NOT using checkpointing" << std::endl;
	} else {
		using_checkpoint = true;
		checkpoint_file_w_path = files_paths::score_path + checkpoint_filename;
	}


	//
	//remember monomer scores
	//
	monomer_pose.score( weight_map );
	float const score_monomer = monomer_pose.get_0D_score( SCORE );
	float const fa_rep_monomer = monomer_pose.get_0D_score( FA_REP );
	float const fa_atr_monomer = monomer_pose.get_0D_score( FA_ATR );
	float const fa_sol_monomer = monomer_pose.get_0D_score( FA_SOL );
	float const fa_dun_monomer = monomer_pose.get_0D_score( FA_DUN );
	float const hbsc_monomer = monomer_pose.get_0D_score( HB_SC );
	float const fa_prob_monomer = monomer_pose.get_0D_score( FA_PROB );


	//
	//compute centroid-level score for monomer...used for ddg at centroid-level
	//

	Pose monomer_centroid_pose;
	monomer_centroid_pose = monomer_pose;
	monomer_centroid_pose.set_fullatom_flag( false );
	monomer_centroid_pose.score( centroid_wt_map );
	float score_monomer_centroid   ( monomer_centroid_pose.get_0D_score( SCORE ) );
	float vdw_monomer ( monomer_centroid_pose.get_0D_score( VDW ) );


	//
	//remember disulfides in monomer
	//
	int n_disulf_monomer = disulfides::n_disulfides_centroid;
	FArray1D_int list_cys_resnums_in_disulf_monomer( 2*n_disulf_monomer );
	int n_cys_in_disulf_monomer = 0;
	for ( int i_disulf = 1; i_disulf <= n_disulf_monomer; i_disulf++ ) {
		int const resnum1 = disulfides::cys( disulfides::disulf_partner_a( i_disulf ) );
		int const resnum2 = disulfides::cys( disulfides::disulf_partner_b( i_disulf ) );
		++n_cys_in_disulf_monomer;
		list_cys_resnums_in_disulf_monomer( n_cys_in_disulf_monomer ) = resnum1;
		++n_cys_in_disulf_monomer;
		list_cys_resnums_in_disulf_monomer( n_cys_in_disulf_monomer ) = resnum2;
	}
	if ( n_cys_in_disulf_monomer != 2*n_disulf_monomer ) {
		std::cout << "ERROR counting disulf monomer_w_Ab " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	//
	//setup list of natro positions in monomer ( can't be minimized/repacked )
	//
	//exclude disulfides
	//exclude Asn with glycan attached
	//
	FArray1D_int list_natro_positions_monomer( nres_monomer );
	FArray1D_bool natro_position_monomer( nres_monomer, false );
	int n_natro_positions_monomer = 0;
	for ( int i = 1; i <= n_cys_in_disulf_monomer; i++ ) {
		++n_natro_positions_monomer;
		list_natro_positions_monomer( n_natro_positions_monomer ) = list_cys_resnums_in_disulf_monomer( i );
		natro_position_monomer( list_natro_positions_monomer( n_natro_positions_monomer ) ) = true;
	}
	if ( anchor_resnums_read_from_file ) {
		for ( int i = 1; i <= n_glycan_on_monomer; i++ ) {
		++n_natro_positions_monomer;
		list_natro_positions_monomer( n_natro_positions_monomer ) =	list_anchor_resnums_monomer( i );
		natro_position_monomer( list_natro_positions_monomer( n_natro_positions_monomer ) ) = true;
		}
	}
  list_natro_positions_monomer.redimension( n_natro_positions_monomer );

	if ( truefalseoption("just_minimize_monomer") ) {

		//
		//just minimize chi of the monomer and then return
		//

		std::string keyname;
		keyname = stringafteroption( "keyname" );

		int n_iterations = 0;
		intafteroption("n_iterations",n_iterations,n_iterations);
		if ( n_iterations == 0 ) {
			std::cout << "need n_iterations " << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		//do these matter?
		minimize_set_vary_phipsi( false );
		minimize_set_vary_chi( true );
		minimize_set_vary_omega( false );
		minimize_set_vary_rb_angle( false );
		minimize_set_vary_rb_trans( false );

		bool save_use_nblist = get_use_nblist();
		bool save_try_rotamers = score_get_try_rotamers();
		score_set_try_rotamers( false );//no rotamer trials!
		set_use_nblist( true );

		FArray1D_bool allow_minimize_monomer( nres_monomer, false );
		for ( int i = 1 ; i <= nres_monomer; i++ ) {
			if ( !natro_position_monomer( i ) ) allow_minimize_monomer( i ) = true;
		}

		for ( int iteration = 1; iteration <= n_iterations; iteration++ ) {
			Pose monomer_min_pose;
			monomer_min_pose = monomer_pose;

			monomer_min_pose.set_allow_bb_move( false );
			monomer_min_pose.set_allow_jump_move( false );
			monomer_min_pose.set_allow_chi_move( false );
			monomer_min_pose.set_allow_chi_move( allow_minimize_monomer ); // pass FArray bool

			minimize_set_tolerance( 1e-4 );//1e-6
			weight_map.set_weight( FA_REP, save_fa_rep_weight*0.01 );
			monomer_min_pose.main_minimize( weight_map, "dfpmin" ); //or "linmin"
			minimize_set_tolerance( 1e-5 );//1e-6
			weight_map.set_weight( FA_REP, save_fa_rep_weight*0.1 );
			monomer_min_pose.main_minimize( weight_map, "dfpmin" ); //or "linmin"
			minimize_set_tolerance( 1e-6 );//1e-6
			weight_map.set_weight( FA_REP, save_fa_rep_weight );
			monomer_min_pose.main_minimize( weight_map, "dfpmin" ); //or "linmin"

			std::string filename = files_paths::pdb_out_path + "monomer_min_" + keyname + "_" + string_of( iteration ) + "_.pdb";
			monomer_min_pose.score( weight_map );
			monomer_min_pose.dump_pdb( filename, true );
		}

		return;
	}


	bool const gzip_output_pdb = true;
	//monomer_pose.dump_pdb( "monomer_pose.pdb", gzip_output_pdb );

	std::cout << "nres_monomer = " << nres_monomer << std::endl;


	//
	//score all-glycine trimers
	//
	bool compute_glycine_pose = false;
	compute_glycine_pose = truefalseoption("compute_glycine_pose");

	Pose monomer_gly_pose;
	float score_monomer_gly = 0;
	double fa_rep_monomer_gly = 0;
	float fa_atr_monomer_gly = 0;
	float fa_sol_monomer_gly = 0;
	float fa_dun_monomer_gly = 0;
	float hbsc_monomer_gly = 0;
	float fa_prob_monomer_gly = 0;

	Pose Ab_gly_pose; //used to make trimer_w_Ab_gly below
	Pose monomer_w_Ab_gly_pose;
	float score_monomer_w_Ab_gly = 0;
	double fa_rep_monomer_w_Ab_gly = 0;
	float fa_atr_monomer_w_Ab_gly = 0;
	float fa_sol_monomer_w_Ab_gly = 0;
	float fa_dun_monomer_w_Ab_gly = 0;
	float hbsc_monomer_w_Ab_gly = 0;
	float fa_prob_monomer_w_Ab_gly = 0;


	if ( compute_glycine_pose ) {
		//
		//Make an all-gly version of monomer pose and score it.
		//
		int gly_begin = 1;
		int gly_end = nres_monomer;
		convert_resnum_range_to_gly( monomer_pose, gly_begin,  gly_end, monomer_gly_pose );
		monomer_gly_pose.score( weight_map );

		score_monomer_gly = monomer_gly_pose.get_0D_score( SCORE );
		fa_rep_monomer_gly = monomer_gly_pose.get_0D_score( FA_REP );
		fa_atr_monomer_gly = monomer_gly_pose.get_0D_score( FA_ATR );
		fa_sol_monomer_gly = monomer_gly_pose.get_0D_score( FA_SOL );
		fa_dun_monomer_gly = monomer_gly_pose.get_0D_score( FA_DUN );
		hbsc_monomer_gly = monomer_gly_pose.get_0D_score( HB_SC );
		fa_prob_monomer_gly = monomer_gly_pose.get_0D_score( FA_PROB );

		//		monomer_gly_pose.dump_pdb( "monomer_gly_pose.pdb", true);

	}


	//Not using Ingemar symmetric pose owing to difficulty attaching ligand to trimer
	//either:
	// (1) need to update copy_segment to work with symmetry pose to allow
	//     ligand attachment after symmetry pose setup
	//or
	//(2) need to get around copy_segment in setting up symmetry pose
	//    in Ingemar setup_symm_cn so we can attach ligands to the monomer before
	//    setup symmetry pose
	//

	//
	//optionally read in a list of x,y,z,r to evaluate trimer conformations
	//
	int n_trimer_conformations_input = 0;
	FArray2D_float list_xyzt_trimer_conformations( 4, n_trimer_conformations_input );
	bool trimer_conformations_from_file = false;
	if ( truefalseoption ("list_trimer_conformations" ) ) {
		trimer_conformations_from_file = true;
		read_list_trimer_conformations( n_trimer_conformations_input, list_xyzt_trimer_conformations );
	}


	//
	//command-line option to specify ranges equivalently for X,Y,Z
	//
	float rot_angle_min = realafteroption( "rot_angle_min", -180.0 );
	float rot_angle_max = realafteroption( "rot_angle_max", -170.0 );
	float rot_angle_delta = realafteroption( "rot_angle_delta", 10.0 );

	//
	//Also allow command-line option to specify X, Y, Z ranges independently
	//this overrides the "equivalent setting" above
	//

	//
	//  X
	//
	float rot_angle_X_min = rot_angle_min; //-180.0;
	float rot_angle_X_max = rot_angle_max; //180.0;
	float rot_angle_X_delta = rot_angle_delta; //10.0;
	rot_angle_X_min = realafteroption( "rot_angle_X_min", rot_angle_X_min );
	rot_angle_X_max = realafteroption( "rot_angle_X_max", rot_angle_X_max );
	rot_angle_X_delta = realafteroption( "rot_angle_X_delta", rot_angle_X_delta );
	int n_X =  int ( std::floor( ( rot_angle_X_max - rot_angle_X_min )/rot_angle_X_delta ) );

	//
	//  Y
	//
	float rot_angle_Y_min = rot_angle_min; //-180.0;
	float rot_angle_Y_max = rot_angle_max; //180.0;
	float rot_angle_Y_delta = rot_angle_delta; //10.0;
	rot_angle_Y_min = realafteroption( "rot_angle_Y_min", rot_angle_Y_min );
	rot_angle_Y_max = realafteroption( "rot_angle_Y_max", rot_angle_Y_max );
	rot_angle_Y_delta = realafteroption( "rot_angle_Y_delta", rot_angle_Y_delta );
	int n_Y =  int ( std::floor( ( rot_angle_Y_max - rot_angle_Y_min )/rot_angle_Y_delta ) );

	//
	//  Z
	//
	float rot_angle_Z_min = rot_angle_min; //-180.0;
	float rot_angle_Z_max = rot_angle_max; //180.0;
	float rot_angle_Z_delta = rot_angle_delta; //10.0;
	rot_angle_Z_min = realafteroption( "rot_angle_Z_min", rot_angle_Z_min );
	rot_angle_Z_max = realafteroption( "rot_angle_Z_max", rot_angle_Z_max );
	rot_angle_Z_delta = realafteroption( "rot_angle_Z_delta", rot_angle_Z_delta );
	int n_Z =  int ( std::floor( ( rot_angle_Z_max - rot_angle_Z_min )/rot_angle_Z_delta ) );

	float trans_dist_min = realafteroption( "trans_dist_min", 28.0 );
	float trans_dist_max = realafteroption( "trans_dist_max", 32.0 );
	float trans_dist_delta = realafteroption( "trans_dist_delta", 2.0 );
	int n_T = int ( std::floor( ( trans_dist_max - trans_dist_min )/trans_dist_delta ) );

	if ( !trimer_conformations_from_file ) {

		std::cout << "using rot_angle_X_min = " << rot_angle_X_min << std::endl;
		std::cout << "using rot_angle_X_max = " << rot_angle_X_max << std::endl;
		std::cout << "using rot_angle_Y_min = " << rot_angle_Y_min << std::endl;
		std::cout << "using rot_angle_Y_max = " << rot_angle_Y_max << std::endl;
		std::cout << "using rot_angle_Z_min = " << rot_angle_Z_min << std::endl;
		std::cout << "using rot_angle_Z_max = " << rot_angle_Z_max << std::endl;
		std::cout << " " << std::endl;
		std::cout << "n_X, n_Y, n_Z: " << n_X << " " << n_Y << " " << n_Z  << std::endl;
	}


	//
	//kluge to allow looping over specified parameter
	//ranges or over specific conformations
	//
	//we have 4 loops over x,y,z,t ranges that allow
	//us to just scan over ranges of these parameters...
	//
	//but we also want to be able to loop over a list
	//of specific combinations of x,y,z,t
	//so we enclose the 4 loops with an outer loop over
	//the list elements. If no list the outer loop just
	//gets executed once. If yes list then the outer
	//loop controls the 4 inner loops to set the
	//parameters correctly
	//
	int n_outer_loop;
	if ( trimer_conformations_from_file ) {
		n_T = 0;
		n_X = 0;
		n_Y = 0;
		n_Z = 0;
		n_outer_loop = n_trimer_conformations_input;
	} else {
		n_outer_loop = 1;
	}

	int n_trimer_conformations = 0;

	for ( int i_conf = 1; i_conf <= n_outer_loop; i_conf++ ) {
		//
		//if read conf from file then setup "xxx_min" vals
		//in the 4 inner loops to specify a single conformation
		//for each iteration of outer loop.
		//
		if ( trimer_conformations_from_file ) {
			rot_angle_X_min = list_xyzt_trimer_conformations( 1, i_conf );
			rot_angle_Y_min = list_xyzt_trimer_conformations( 2, i_conf );
			rot_angle_Z_min = list_xyzt_trimer_conformations( 3, i_conf );
			trans_dist_min  = list_xyzt_trimer_conformations( 4, i_conf );
		}
		for ( int i_T = 0; i_T <= n_T; i_T++ ) {
			float trans_dist = trans_dist_min + i_T*trans_dist_delta;

			for ( int i_Z = 0; i_Z <= n_Z; i_Z++ ) {
				float rot_angle_Z = rot_angle_Z_min + i_Z*rot_angle_Z_delta;

				for ( int i_Y = 0; i_Y <= n_Y; i_Y++ ) {
					float rot_angle_Y = rot_angle_Y_min + i_Y*rot_angle_Y_delta;

					for ( int i_X = 0; i_X <= n_X; i_X++ ) {
						float rot_angle_X = rot_angle_X_min + i_X*rot_angle_X_delta;

						++n_trimer_conformations;


						if ( using_checkpoint ) {
							bool already_scored = check_conformation_already_scored( n_trimer_conformations, checkpoint_file_w_path );
							std::cout << "n, already_scored " << n_trimer_conformations << " " << already_scored << std::endl;
							if ( already_scored ) continue;
						}

						//
						//strip suffix and path from start_pdb to use in output filenames
						//
						std::string tmp_name = start_pdb;
						if ( has_suffix( tmp_name, ".gz" ) )
							tmp_name.erase( tmp_name.length() - 3 ); // strip terminal .gz
						if ( has_suffix( tmp_name, ".pdb" ) )
							tmp_name.erase( tmp_name.length() - 4 ); // strip terminal .pdb
						std::string start_pdb_name = tmp_name.substr( tmp_name.find_last_of( '/' ) + 1 );


						std::string base_pdbfilename = start_pdb_name +
							"_" + string_of( rot_angle_X ) +
							"_" + string_of( rot_angle_Y ) +
							"_" + string_of( rot_angle_Z ) +
							"_" + string_of( trans_dist );


						////////////////////////////////////////////////////////////
						// Now compute where the glycans will go on the trimer
						// And attach them !!

						Pose trimer_pose;

						//rotation and translation for monomers 1-3
						//need to keep so can apply to glycan
						//
						FArray2D_double Rxyz(3,3);
						FArray2D_double translation( 3, N, 0.0 );
						compute_rot_trans_for_trimer( rot_angle_X, rot_angle_Y, rot_angle_Z, trans_dist, Rxyz, translation );

						//make trimer from monomer
						//
						make_trimer_pose( monomer_pose, Rz120, Rxyz, translation, trimer_pose );

						int const nres_trimer = trimer_pose.total_residue();

						//At this point the protein has been setup as a trimer
						//

						trimer_pose.score ( weight_map );

						float score_trimer   ( trimer_pose.get_0D_score( SCORE ) );
						double  fa_rep_trimer ( trimer_pose.get_0D_score( FA_REP ) );
						float  fa_atr_trimer ( trimer_pose.get_0D_score( FA_ATR ) );
						float  fa_sol_trimer ( trimer_pose.get_0D_score( FA_SOL ) );
						float  fa_dun_trimer ( trimer_pose.get_0D_score( FA_DUN ) );
						float  hbsc_trimer ( trimer_pose.get_0D_score( HB_SC ) );
						float  fa_prob_trimer ( trimer_pose.get_0D_score( FA_PROB ) );

						//these scores are written out below, along with glycan scores
						//
						std::cout << SS( "trimer_scores: " )
											<< SS( "      score" )
											<< SS( "         atr" )
											<< SS( "         rep" )
											<< SS( "         sol" )
											<< SS( "         dun" )
											<< SS( "        hbsc" )
											<< SS( "        prob" )
											<< std::endl;

						std::cout << SS( "trimer_scores: " )
											<< F( 12, 2, score_trimer ) << " "
											<< F( 12, 2, fa_atr_trimer ) << " "
											<< F( 12, 2, fa_rep_trimer ) << " "
											<< F( 12, 2, fa_sol_trimer ) << " "
											<< F( 12, 2, fa_dun_trimer ) << " "
											<< F( 12, 2, hbsc_trimer   ) << " "
											<< F( 12, 2, fa_prob_trimer) << " "
											<< base_pdbfilename << " "
											<< SS( "NO_GLYCAN" )
											<< std::endl;

						//
						//if we want to do rbmin, we will need a symm_pose for trimer that includes pseudo residues
						//But currently we cannot attach ligands to symm_poses
						//Set coords for trimer_symm_pose now
						//

						float score_trimer_symm = 0;
						double fa_rep_trimer_symm = 0;
						float  fa_atr_trimer_symm = 0;
						float  fa_sol_trimer_symm = 0;
						float  fa_dun_trimer_symm = 0;
						float  hbsc_trimer_symm = 0;
						float  fa_prob_trimer_symm = 0;
						int nres_trimer_symm = 0;

						//
						//symmetric pose with pseudo residues needed for rb_minimization
						//(otherwise my normal trimer_pose would suffice for symmetrical scmin/repack )
						//
						Pose trimer_symm_pose;

						if ( use_symmetry && do_rbmin  ) {

							//we may have a complex but only want to generate trimers for
							//one of the partners ( gp120-cd4)
							//
							//							int first_resnum_for_com = 1;
							//							intafteroption( "first_resnum_for_com", 1, first_resnum_for_com );
							//							int last_resnum_for_com = nres_monomer;
							//							intafteroption( "last_resnum_for_com", nres_monomer, last_resnum_for_com );

							int anchor_rsd = 1;
							//							anchor_rsd = monomer_pose.residue_center_of_mass( first_resnum_for_com, last_resnum_for_com );

							//origin and z_axis
							triplet::xyzVector_float origin( 0.0, 0.0, 0.0 );
							triplet::xyzVector_float z_axis( 0.0, 0.0, 1.0 );

							//symmetry type
							std::string symmetry_type = "cn";

							Pose new_monomer_pose;
							create_monomer_pose( trimer_pose, new_monomer_pose, nres_monomer );

							// Create symmetric trimeric pose ( without glycan or Ab attached )
							create_symmetric_pose( new_monomer_pose, fullatom, N, anchor_rsd, origin, z_axis, symmetry_type, trimer_symm_pose );
							nres_trimer_symm = trimer_symm_pose.total_residue(); // should be nres_trimer+3

							/*
							//this is stuff one would use to change the trimer conformation if one wanted to do
							//that by the symmetry-jump mechanism. I am not using it here b/c I want to rotate around
							//the true c.o.m. of gp120.
							//
							//For safety reset the degrees of freedom before move
							set_allow_dg_free_cn( trimer_symm_pose );

							//    int const trimer_symm_pose_jump_number( trimer_symm_pose.num_jump() / N ); // the 1st symm-jump
							//    pose_ns::Jump trimer_symm_pose_jump( trimer_symm_pose.get_jump( jump_number ) );
							pose_ns::Jump trimer_symm_pose_jump;
							int trimer_symm_pose_jump_number = 0;
							trimer_symm_pose_jump_number = trimer_symm_pose.num_jump() / N; // the 1st symm-jump
							trimer_symm_pose_jump = trimer_symm_pose.get_jump( trimer_symm_pose_jump_number );

							// prob not necessary -- fold in any nonzero offsets to
							// translation,rotation
							trimer_symm_pose_jump.fold_in_rb_deltas();

							// jumps look from the nterminal residue to the cterminal residue
							// reverse the view since the pseudo rsd is c-terminal,
							// and this is the view that's guaranteed to be standard -- ie
							// z-axis is axis of symmetry, etc
							//
							// plus in this view rotation is about the C-alpha of the nterminal
							// residue, ie
							trimer_symm_pose_jump.reverse();

							//rotation about Z, then Y, then X
							trimer_symm_pose_jump.set_rotation ( X_rot( rot_angle_X ) * Y_rot( rot_angle_Y ) * Z_rot( rot_angle_Z ) * trimer_symm_pose_jump.get_rotation());

							trimer_symm_pose_jump.set_translation ( triplet::xyzVector_double( trans_dist, 0, 0 ) + trimer_symm_pose_jump.get_translation());

							// flip back to standard orientation -- n2c -- before setting in pose
							trimer_symm_pose_jump.reverse();

							// pose will replicate this jump to the N-1 other symmetry jumps
							trimer_symm_pose.set_jump( trimer_symm_pose_jump_number, trimer_symm_pose_jump );
							*/

							trimer_symm_pose.score( weight_map );

							score_trimer_symm  = trimer_symm_pose.get_0D_score( SCORE );
							fa_rep_trimer_symm = trimer_symm_pose.get_0D_score( FA_REP );
							fa_atr_trimer_symm = trimer_symm_pose.get_0D_score( FA_ATR );
							fa_sol_trimer_symm = trimer_symm_pose.get_0D_score( FA_SOL );
							fa_dun_trimer_symm = trimer_symm_pose.get_0D_score( FA_DUN );
							hbsc_trimer_symm = trimer_symm_pose.get_0D_score( HB_SC );
							fa_prob_trimer_symm = trimer_symm_pose.get_0D_score( FA_PROB );

						}


						float score_trimer_gly = 0;
					  double fa_rep_trimer_gly = 0;
						float fa_atr_trimer_gly = 0;
						float fa_sol_trimer_gly = 0;
						float fa_dun_trimer_gly = 0;
						float hbsc_trimer_gly = 0;
						float fa_prob_trimer_gly = 0;

						if ( compute_glycine_pose ) {
							//
							//Make an all-gly version of trimer pose and score it.
							//
							//make a pose with all-atom antibody and glycine for epitope
							Pose trimer_gly_pose;

							//One way to do it is to "design" the trimer_pose as all-gly
							//but this is slow. by factor of 4x compared to not doing gly at all.
							//						int gly_begin = 1;
							//						int gly_end = nres_trimer;
							//						convert_resnum_range_to_gly( trimer_pose, gly_begin,  gly_end, trimer_gly_pose );
							//


							//another way to do it is to re-generate the same trimer but starting with all-gly monomer
							//
							make_trimer_pose( monomer_gly_pose, Rz120, Rxyz, translation, trimer_gly_pose );

							trimer_gly_pose.score( weight_map );
							score_trimer_gly = trimer_gly_pose.get_0D_score( SCORE );
							fa_rep_trimer_gly = trimer_gly_pose.get_0D_score( FA_REP );
							fa_atr_trimer_gly = trimer_gly_pose.get_0D_score( FA_ATR );
							fa_sol_trimer_gly = trimer_gly_pose.get_0D_score( FA_SOL );
							fa_dun_trimer_gly = trimer_gly_pose.get_0D_score( FA_DUN );
							hbsc_trimer_gly = trimer_gly_pose.get_0D_score( HB_SC );
							fa_prob_trimer_gly = trimer_gly_pose.get_0D_score( FA_PROB );

							//						trimer_gly_pose.dump_pdb( "trimer_gly_pose.pdb", true);

						}


						//write scores to trimer_scores_file
						//
						{//scope for output
							std::string filename = trimer_scores_filename;

							//want scorefile to live in score_path
							filename = files_paths::score_path + filename;

							// check if file exists
							utility::io::izstream infile ( filename );
							utility::io::ozstream outfile;
							if ( infile ) {
								//							utility::io::ozstream outfile ( filename,  std::ios::app );
								outfile.open_append( filename );
							} else {
								//							utility::io::ozstream outfile ( filename );
								outfile.open( filename );

								if ( ! outfile.good() ) {
									std::cout << "cant open trimer_scores_file for writing: "
														<< filename << std::endl;
									utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
								}
								//
								//only write the header the first time you open the file
								//

								outfile << SS( "trimer_scores: " )
												<< SS( "      score" )
												<< SS( "         atr" )
												<< SS( "         rep" )
												<< SS( "         sol" )
												<< SS( "         dun" )
												<< SS( "        hbsc" )
												<< SS( "        prob" )
												<< SS( "  dist_Nterm" )
												<< std::endl;
							}

							if ( ! outfile.good() ) {
								std::cout << "cant open trimer_scores_file for writing: "
													<< filename << std::endl;
								utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
							}

							if ( compute_glycine_pose ) {

								outfile << SS( "trimer_scores: " )
												<< F( 12, 2, score_trimer_gly ) << " "
												<< F( 12, 2, fa_atr_trimer_gly ) << " "
												<< F( 12, 2, fa_rep_trimer_gly ) << " "
												<< F( 12, 2, fa_sol_trimer_gly ) << " "
												<< F( 12, 2, fa_dun_trimer_gly ) << " "
												<< F( 12, 2, hbsc_trimer_gly   ) << " "
												<< F( 12, 2, fa_prob_trimer_gly) << " "
												<< F( 12, 2, dist_Nterm ) << " "
												<< base_pdbfilename << " "
												<< SS( "TOTAL_BB-ONLY" )
												<< std::endl;

								outfile << SS( "trimer_scores: " )
												<< F( 12, 2, score_trimer_gly  - 3*score_monomer_gly ) << " "
												<< F( 12, 2, fa_atr_trimer_gly - 3*fa_atr_monomer_gly ) << " "
												<< F( 12, 2, fa_rep_trimer_gly - 3*fa_rep_monomer_gly ) << " "
												<< F( 12, 2, fa_sol_trimer_gly - 3*fa_sol_monomer_gly ) << " "
												<< F( 12, 2, fa_dun_trimer_gly - 3*fa_dun_monomer_gly ) << " "
												<< F( 12, 2, hbsc_trimer_gly   - 3*hbsc_monomer_gly ) << " "
												<< F( 12, 2, fa_prob_trimer_gly- 3*fa_prob_monomer_gly ) << " "
												<< F( 12, 2, dist_Nterm ) << " "
												<< base_pdbfilename << " "
												<< SS( "DDG_BB-ONLY" )
												<< std::endl;

							}

							outfile << SS( "trimer_scores: " )
											<< F( 12, 2, score_trimer ) << " "
											<< F( 12, 2, fa_atr_trimer ) << " "
											<< F( 12, 2, fa_rep_trimer ) << " "
											<< F( 12, 2, fa_sol_trimer ) << " "
											<< F( 12, 2, fa_dun_trimer ) << " "
											<< F( 12, 2, hbsc_trimer   ) << " "
											<< F( 12, 2, fa_prob_trimer) << " "
											<< F( 12, 2, dist_Nterm ) << " "
											<< base_pdbfilename << " "
											<< SS( "TOTAL_FA_NO_GLYCAN" )
											<< std::endl;

							outfile << SS( "trimer_scores: " )
											<< F( 12, 2, score_trimer  - 3*score_monomer ) << " "
											<< F( 12, 2, fa_atr_trimer - 3*fa_atr_monomer ) << " "
											<< F( 12, 2, fa_rep_trimer - 3*fa_rep_monomer ) << " "
											<< F( 12, 2, fa_sol_trimer - 3*fa_sol_monomer ) << " "
											<< F( 12, 2, fa_dun_trimer - 3*fa_dun_monomer ) << " "
											<< F( 12, 2, hbsc_trimer   - 3*hbsc_monomer ) << " "
											<< F( 12, 2, fa_prob_trimer- 3*fa_prob_monomer ) << " "
											<< F( 12, 2, dist_Nterm ) << " "
											<< F( 12, 2, score_trimer_centroid - 3*score_monomer ) << " "
											<< base_pdbfilename << " "
											<< SS( "DDG_FA_NO_GLYCAN" )
											<< std::endl;

							//
							//output a single line with 4 farep scores then 4 fa_atr scores, in order: bbonly,fa_no_glycan,fa_w_glycan,glycan_only
							//
							outfile << SS( "trimer_summary_scores: " )
											<< F( 12, 2, score_trimer - 3*score_monomer ) << " "
											<< F( 12, 2, fa_rep_trimer_gly - 3*fa_rep_monomer_gly ) << " "
											<< F( 12, 2, fa_rep_trimer - 3*fa_rep_monomer ) << " "
											<< F( 12, 2, fa_atr_trimer_gly - 3*fa_atr_monomer_gly ) << " "
											<< F( 12, 2, fa_atr_trimer - 3*fa_atr_monomer ) << " "
							outfile << base_pdbfilename;
							outfile << std::endl;

							outfile.close();
							outfile.clear();
						}

						//write scores to standard logfile
						//

						std::cout << SS( "trimer_scores: " )
											<< SS( "      score" )
											<< SS( "         atr" )
											<< SS( "         rep" )
											<< SS( "         sol" )
											<< SS( "         dun" )
											<< SS( "        hbsc" )
											<< SS( "        prob" )
											<< SS( "  dist_Nterm" )
											<< std::endl;


						if ( do_minimize || do_minrep || do_rbmin ) {
							//
							//Do minimization or minimization+repacking !
							//

							//do these matter?
							minimize_set_vary_phipsi( false );
							minimize_set_vary_chi( true );
							minimize_set_vary_omega( false );
							minimize_set_vary_rb_angle( false );
							minimize_set_vary_rb_trans( false );
							//							minimize_set_local_min( false, 0 ); // all non-move-list rsds minimized

							//
							//(1) trimer, no AB, no glycan... sidechain minimize only
							//

							FArray1D_bool interface_position_trimer( nres_trimer, false );
							int n_interface_positions_trimer = 0;
							bool glycan_attached = false;
							bool Ab_attached = false;

							FArray1D_bool natro_position_trimer( nres_trimer, false );
							for ( int i = 1; i <= nres_monomer; i++ ) {
								natro_position_trimer( i ) = natro_position_monomer( i );
								natro_position_trimer( i + nres_monomer ) = natro_position_monomer( i );   //monomer2
								natro_position_trimer( i + 2*nres_monomer ) = natro_position_monomer( i ); //monomer3
							}

							//							for ( int i = 1; i <=nres_trimer; i++ ) {
							//								std::cout << "natro_position_trimer: " << i << " " << natro_position_trimer( i ) << std::endl;
							//							}

							//
							//use trimer_pose here instead of trimer_symm_pose
							//until you update the function to ignore the pseudo residues
							//
							identify_interface_positions( trimer_pose, glycan_attached, Ab_attached,
																						nres_monomer, n_glycan_on_trimer, nres_Ab,
																						natro_position_trimer,
																						interface_position_trimer        /*output*/,
																						n_interface_positions_trimer     /*output*/);

							//							for ( int i = 1; i <= nres_trimer; i++ ) {
							//								if ( interface_position_trimer( i ) ) std::cout << "interface_pos_trimer( i ) " << i << " " << interface_position_trimer( i ) << std::endl;
							//							}

							bool save_use_nblist = get_use_nblist();
							bool save_try_rotamers = score_get_try_rotamers();
							score_set_try_rotamers( false );//no rotamer trials!
							set_use_nblist( true );
							trimer_symm_pose.set_allow_bb_move( false );
							trimer_symm_pose.set_allow_jump_move( false );
							trimer_symm_pose.set_allow_chi_move( false );

							//
							//declare symmetric pose so minimize & repack will utilize symmetry
							//
							if ( use_symmetry ) {
								//								int const njump_monomer = 0;
								//								trimer_pose.setup_symm_info( nres_monomer, njump_monomer, N, "no_pseudo" );
								for ( int i=1; i<= nres_trimer;i++ ) {
									//									std::cout << " i, chi_indep, bb_indep " << i << " " << trimer_symm_pose.symmetry_info().chi_independent( i ) << " "
									//														<< trimer_symm_pose.symmetry_info().bb_independent( i ) << std::endl;
									if ( trimer_symm_pose.symmetry_info().chi_independent( i ) )
										trimer_symm_pose.set_allow_chi_move( i, interface_position_trimer( i ) );
								}
							} else {
								std::cout << "won't minimize trimer unless you ask for -use_symmetry" << std::endl;
								utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
							}

							//
							//Minimize but ramp the fa_rep_weight and the tolerance.
							//

							minimize_set_tolerance( 1e-4 );//1e-6...was 1e-3
							weight_map.set_weight( FA_REP, save_fa_rep_weight*0.01 );
							trimer_symm_pose.main_minimize( weight_map, "dfpmin" ); //or "linmin"
							weight_map.set_weight( FA_REP, save_fa_rep_weight*0.05 );
							trimer_symm_pose.main_minimize( weight_map, "dfpmin" ); //or "linmin"
							weight_map.set_weight( FA_REP, save_fa_rep_weight*0.25 );
							trimer_symm_pose.main_minimize( weight_map, "dfpmin" ); //or "linmin"
							minimize_set_tolerance( 1e-5 );//1e-6...was 1e-4
							weight_map.set_weight( FA_REP, save_fa_rep_weight );
							trimer_symm_pose.main_minimize( weight_map, "dfpmin" ); //or "linmin"

							//
							//total scores after scmin
							//
							trimer_symm_pose.score ( weight_map );
							float score_trimer_scmin   ( trimer_symm_pose.get_0D_score( SCORE ) );
							double  fa_rep_trimer_scmin ( trimer_symm_pose.get_0D_score( FA_REP ) );
							float  fa_atr_trimer_scmin ( trimer_symm_pose.get_0D_score( FA_ATR ) );
							float  fa_sol_trimer_scmin ( trimer_symm_pose.get_0D_score( FA_SOL ) );
							float  fa_dun_trimer_scmin ( trimer_symm_pose.get_0D_score( FA_DUN ) );
							float  hbsc_trimer_scmin ( trimer_symm_pose.get_0D_score( HB_SC ) );
							float  fa_prob_trimer_scmin ( trimer_symm_pose.get_0D_score( FA_PROB ) );

							//							trimer_symm_pose.dump_pdb("trimer_symm_pose_scmin.pdb", true );

							//
							//ddG scores after scmin
							//

							//make a copy of one monomer post-scmin and score it!
							Pose monomer_scmin_pose;
							monomer_scmin_pose.simple_fold_tree( nres_monomer );
							monomer_scmin_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
							monomer_scmin_pose.copy_segment( nres_monomer, trimer_symm_pose, 1 /*begin*/, 1 /*src_begin*/ );
							monomer_scmin_pose.score( weight_map );
							std::cout << "ddg_trimer_min: monomer score " << monomer_scmin_pose.get_0D_score( SCORE ) << std::endl;

							float ddg_score_trimer_scmin = score_trimer_scmin - 3*monomer_scmin_pose.get_0D_score( SCORE );
							double ddg_fa_rep_trimer_scmin = fa_rep_trimer_scmin - 3*monomer_scmin_pose.get_0D_score( FA_REP );
							float ddg_fa_atr_trimer_scmin = fa_atr_trimer_scmin - 3*monomer_scmin_pose.get_0D_score( FA_ATR );
							float ddg_fa_sol_trimer_scmin = fa_sol_trimer_scmin - 3*monomer_scmin_pose.get_0D_score( FA_SOL );
							float ddg_fa_dun_trimer_scmin = fa_dun_trimer_scmin - 3*monomer_scmin_pose.get_0D_score( FA_DUN );
							float ddg_hbsc_trimer_scmin = hbsc_trimer_scmin - 3*monomer_scmin_pose.get_0D_score( HB_SC );
							float ddg_fa_prob_trimer_scmin = fa_prob_trimer_scmin - 3*monomer_scmin_pose.get_0D_score( FA_PROB );

							if ( output_pdbs ) {
								std::string scmin_pdbfilename = files_paths::pdb_out_path + base_pdbfilename + "_scmin" + ".pdb";
								trimer_symm_pose.dump_pdb( scmin_pdbfilename, gzip_output_pdb );
							}


							float score_trimer_minrep = 0;
							double fa_rep_trimer_minrep = 0;
							float fa_atr_trimer_minrep = 0;
							float fa_sol_trimer_minrep = 0;
							float fa_dun_trimer_minrep = 0;
							float hbsc_trimer_minrep = 0;
							float fa_prob_trimer_minrep = 0;
							float ddg_score_trimer_minrep = 0;
							double ddg_fa_rep_trimer_minrep = 0;
							float ddg_fa_atr_trimer_minrep = 0;
							float ddg_fa_sol_trimer_minrep = 0;
							float ddg_fa_dun_trimer_minrep = 0;
							float ddg_hbsc_trimer_minrep = 0;
							float ddg_fa_prob_trimer_minrep = 0;

							if ( do_minrep ) {
								std::cout << "now in minrep " << std::endl;

								if ( use_symmetry ) {
									FArray1D_bool allow_repack_trimer_symm( nres_trimer_symm, false );
									//set allow_repack but not for pseudo residues
									for ( int i=1; i<= nres_trimer;i++ ) {
										if ( trimer_symm_pose.symmetry_info().chi_independent( i ) && interface_position_trimer( i ) )
											allow_repack_trimer_symm( i ) = true;
									}
									trimer_symm_pose.repack( allow_repack_trimer_symm, true /*include_current*/);
								} else {
									std::cout << "won't repack without -use_symmetry" << std::endl;
									utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
								}

								//
								//minrep compute ddG
								//
								trimer_symm_pose.score ( weight_map );

								score_trimer_minrep   = trimer_symm_pose.get_0D_score( SCORE );
								fa_rep_trimer_minrep  = trimer_symm_pose.get_0D_score( FA_REP );
								fa_atr_trimer_minrep  = trimer_symm_pose.get_0D_score( FA_ATR );
								fa_sol_trimer_minrep  = trimer_symm_pose.get_0D_score( FA_SOL );
								fa_dun_trimer_minrep  = trimer_symm_pose.get_0D_score( FA_DUN );
								hbsc_trimer_minrep    = trimer_symm_pose.get_0D_score( HB_SC );
								fa_prob_trimer_minrep = trimer_symm_pose.get_0D_score( FA_PROB );

								//make a copy of one monomer post-minrep and score it!
								Pose monomer_minrep_pose;
								monomer_minrep_pose.simple_fold_tree( nres_monomer );
								monomer_minrep_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
								monomer_minrep_pose.copy_segment( nres_monomer, trimer_symm_pose, 1 /*begin*/, 1 /*src_begin*/ );
								monomer_minrep_pose.score( weight_map );
								std::cout << "ddg_trimer_minrep: monomer score " << monomer_minrep_pose.get_0D_score( SCORE ) << std::endl;

								ddg_score_trimer_minrep   = score_trimer_minrep - 3*monomer_minrep_pose.get_0D_score( SCORE );
								ddg_fa_rep_trimer_minrep  = fa_rep_trimer_minrep - 3*monomer_minrep_pose.get_0D_score( FA_REP );
								ddg_fa_atr_trimer_minrep  = fa_atr_trimer_minrep - 3*monomer_minrep_pose.get_0D_score( FA_ATR );
								ddg_fa_sol_trimer_minrep  = fa_sol_trimer_minrep - 3*monomer_minrep_pose.get_0D_score( FA_SOL );
								ddg_fa_dun_trimer_minrep  = fa_dun_trimer_minrep - 3*monomer_minrep_pose.get_0D_score( FA_DUN );
								ddg_hbsc_trimer_minrep    = hbsc_trimer_minrep - 3*monomer_minrep_pose.get_0D_score( HB_SC );
								ddg_fa_prob_trimer_minrep = fa_prob_trimer_minrep - 3*monomer_minrep_pose.get_0D_score( FA_PROB );

								if ( output_pdbs ) {
									std::string scmin_pdbfilename = files_paths::pdb_out_path + base_pdbfilename + "_minrep" + ".pdb";
									trimer_pose.dump_pdb( scmin_pdbfilename, gzip_output_pdb );
								}
							}//if do_minrep

							//
							//why don't you add info on the conserved residues...
							///

							//
							//write minimize scores to trimer_scores_file
							//
							{//scope for output
								std::string filename = trimer_scores_filename;

								//want scorefile to live in score_path
								filename = files_paths::score_path + filename;

								// check if file exists
								utility::io::izstream infile ( filename );
								utility::io::ozstream outfile;
								if ( infile ) {
									//							utility::io::ozstream outfile ( filename,  std::ios::app );
									outfile.open_append( filename );
								} else {
									//							utility::io::ozstream outfile ( filename );
									outfile.open( filename );

									if ( ! outfile.good() ) {
										std::cout << "cant open trimer_scores_file for writing: "
															<< filename << std::endl;
										utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
									}
									//
									//only write the header the first time you open the file
									//

									outfile << SS( "trimer_scores: " )
													<< SS( "      score" )
													<< SS( "         atr" )
													<< SS( "         rep" )
													<< SS( "         sol" )
													<< SS( "         dun" )
													<< SS( "        hbsc" )
													<< SS( "        prob" )
													<< SS( "  dist_Nterm" )
													<< std::endl;
								}//if infile

								if ( ! outfile.good() ) {
									std::cout << "cant open trimer_scores_file for writing: "
														<< filename << std::endl;
									utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
								}

								outfile << SS( "trimer_scores_scmin: " )
												<< F( 12, 2, score_trimer_scmin ) << " "
												<< F( 12, 2, fa_atr_trimer_scmin ) << " "
												<< F( 12, 2, fa_rep_trimer_scmin ) << " "
												<< F( 12, 2, fa_sol_trimer_scmin ) << " "
												<< F( 12, 2, fa_dun_trimer_scmin ) << " "
												<< F( 12, 2, hbsc_trimer_scmin   ) << " "
												<< F( 12, 2, fa_prob_trimer_scmin) << " "
												<< F( 12, 2, dist_Nterm ) << " "
												<< base_pdbfilename << " "
												<< SS( "TOTAL_FA_NO_GLYCAN_SCMIN" )
												<< std::endl;

								outfile << SS( "trimer_scores_scmin: " )
												<< F( 12, 2, ddg_score_trimer_scmin ) << " "
												<< F( 12, 2, ddg_fa_atr_trimer_scmin ) << " "
												<< F( 12, 2, ddg_fa_rep_trimer_scmin ) << " "
												<< F( 12, 2, ddg_fa_sol_trimer_scmin ) << " "
												<< F( 12, 2, ddg_fa_dun_trimer_scmin ) << " "
												<< F( 12, 2, ddg_hbsc_trimer_scmin ) << " "
												<< F( 12, 2, ddg_fa_prob_trimer_scmin ) << " "
												<< F( 12, 2, dist_Nterm ) << " "
												<< base_pdbfilename << " "
												<< SS( "DDG_FA_NO_GLYCAN_SCMIN" )
												<< std::endl;

								outfile << SS( "trimer_scores_minrep: " )
												<< F( 12, 2, score_trimer_minrep ) << " "
												<< F( 12, 2, fa_atr_trimer_minrep ) << " "
												<< F( 12, 2, fa_rep_trimer_minrep ) << " "
												<< F( 12, 2, fa_sol_trimer_minrep ) << " "
												<< F( 12, 2, fa_dun_trimer_minrep ) << " "
												<< F( 12, 2, hbsc_trimer_minrep   ) << " "
												<< F( 12, 2, fa_prob_trimer_minrep) << " "
												<< F( 12, 2, dist_Nterm ) << " "
												<< base_pdbfilename << " "
												<< SS( "TOTAL_FA_NO_GLYCAN_MINREP" )
												<< std::endl;

								outfile << SS( "trimer_scores_minrep: " )
												<< F( 12, 2, ddg_score_trimer_minrep ) << " "
												<< F( 12, 2, ddg_fa_atr_trimer_minrep ) << " "
												<< F( 12, 2, ddg_fa_rep_trimer_minrep ) << " "
												<< F( 12, 2, ddg_fa_sol_trimer_minrep ) << " "
												<< F( 12, 2, ddg_fa_dun_trimer_minrep ) << " "
												<< F( 12, 2, ddg_hbsc_trimer_minrep ) << " "
												<< F( 12, 2, ddg_fa_prob_trimer_minrep ) << " "
												<< F( 12, 2, dist_Nterm ) << " "
												<< base_pdbfilename << " "
												<< SS( "DDG_FA_NO_GLYCAN_MINREP" )
												<< std::endl;


								outfile.close();
								outfile.clear();
							}//done output
						}//do_minimize || minrep || rb_min

						if ( using_checkpoint ) {
							update_conformation_already_scored( n_trimer_conformations, checkpoint_file_w_path );
						}
					}//i_Z
				}//i_Y
			}//i_X
		}//i_T
	}//i_conf
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//identify positions to repack/minimize between proteins or between protein-ligand (glycan)
void
identify_interface_positions(
														 pose_ns::Pose & pose,        //trimer of proteins at minimum
														 bool const & glycan_attached,    // is glycan also attached?
														 bool const & Ab_attached,  // is antibody (1 copy, to monomer 1) also attached?
														 int const & nres_monomer,
														 int const & nres_glycan,
														 int const & nres_Ab,
														 FArray1D_bool const & natro_position, // positions on protein_trimer that cannot be minimized/repacked
														 FArray1D_bool & interface_position,
														 int & n_interface_positions
														 )
{
	//
	//trimer is constructed in the following order:
	//(1) protein monomers 1-3
	//(2) if glycan is attached, it comes next ( 48 amino acids )
	//(3) if Ab is attached, it comes next
	//

	//	std::cout << "glycan_attached, Ab_attached " << glycan_attached << " " << Ab_attached << std::endl;

	int const nres = pose.total_residue();
	int const nres_protein_trimer = nres_monomer*3;


	//	std::cout << "glycan_attached, Ab_attached " << glycan_attached << " " << Ab_attached << std::endl;
	//	std::cout << "nres_protein_trimer, nres " << nres_protein_trimer << " " << nres << std::endl;

	float const dis_cutoff = 5.5; //angstroms

	//	interface_position = false;

	//
	//error checking
	//
	if ( !glycan_attached && !Ab_attached && nres!=nres_protein_trimer ) {
		std::cout << "ERROR wrong nres " << nres << " nres_monomer " << nres_monomer << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	} else {
		if ( glycan_attached && !Ab_attached && nres!=nres_protein_trimer+nres_glycan ) {
			std::cout << "ERROR wrong nres w/glycan " << nres << " nres_monomer, nres_glycan " << nres_monomer << " " << nres_glycan << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		} else {
			if ( !glycan_attached && Ab_attached && nres!=nres_protein_trimer+nres_Ab ) {
				std::cout << "ERROR wrong nres w/Ab " << nres << " nres_monomer, nres_Ab " << nres_monomer << " " << nres_Ab << std::endl;
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			} else {
				if ( glycan_attached && Ab_attached && nres!=nres_protein_trimer+nres_Ab+nres_glycan ) {
					std::cout << "ERROR wrong nres w/glycan+Ab " << nres << " nres_monomer, nres_glycan, nres_Ab "
										<< nres_monomer << " " << nres_glycan << " " << nres_Ab << std::endl;
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
				}
			}
		}
	}

	//
	//protein-protein contacts first
	//
	//     check contacts between monomer1 and monomer2
	//     then add symmetrical positions to the list since we don't do symmetrical minimize/repack w/Ab breaking symmetry
	//

	//Need to exclude:
	//(1) Asn with attached glycan
	//(2) cysteines in disulfides


	for ( int i = 1; i <= nres_monomer; i++ ) {
		if ( natro_position( i ) ) {
			//			std::cout << "in identify, i is natro " << i << std::endl;
			continue;
		}

    int start_atm1, end_atm1;
    int const aa1 = pose.res( i );
    int const aav1 = pose.res_variant( i );
    if ( aa1 == param_aa::aa_gly ) {
      start_atm1 = 2;
      end_atm1 = 2;
    } else {
      start_atm1 = 5;
      end_atm1 = aaproperties_pack::nheavyatoms( aa1, aav1 );
    }

    for ( int j = nres_monomer+1; j<=2*nres_monomer; ++j ) {
      int start_atm2, end_atm2;
      int aa2 = pose.res( j );
      int aav2 = pose.res_variant( j );
      if ( aa2 == param_aa::aa_gly ) {
        start_atm2 = 2;
        end_atm2 = 2;
      } else {
        start_atm2 = 5;
        end_atm2 = aaproperties_pack::nheavyatoms( aa2, aav2 );
      }

      float dis;
      for ( int atm1 = start_atm1; atm1 <= end_atm1; ++atm1 ) { // atoms pos1
        for ( int atm2 = start_atm2; atm2 <= end_atm2; ++atm2 ) { // atoms pos2
          dis = distance( triplet::xyzVector_float( &( pose.full_coord()(1,atm1,i))),
                          triplet::xyzVector_float( &( pose.full_coord()(1,atm2,j))));
          if ( dis < dis_cutoff ) {
            interface_position( i ) = true;
            interface_position( j ) = true;
						//symmetry positions
						interface_position( i + nres_monomer ) = true;    //monomer 2
						interface_position( i + 2*nres_monomer ) = true;  //monomer 3
						interface_position( j - nres_monomer ) = true;    //monomer 1
						interface_position( j + nres_monomer )  = true;   //monomer 3
						//				std::cout << "identify_interface_position: " << i << " " << j << std::endl;
          }
        } // atm2 -- in monomer2
      } // atm1 -- in monomer1
    }//j -- residues in monomer2
	}//i -- residues in monomer1

	/*
	//debugging.
	for ( int i=1; i<=nres_protein_trimer; i++ ) {
		std::cout << "inside identify: interface_position( i ) " << i << " " << interface_position( i ) << std::endl;
	}
	*/

	int glycan2_start = 0;
	int glycan2_end = 0;
	int glycan3_start = 0;
	int glycan3_end = 0;

	if ( glycan_attached ) {
		//glycan residues come after 3 protein monomers in the pose
		//don't include residues from one monomer interacting with glycans from that same monomer

		int const n_glycan_per_monomer = int( nres_glycan/3 );
		glycan2_start = nres_protein_trimer+n_glycan_per_monomer+1;
		glycan2_end = nres_protein_trimer+2*n_glycan_per_monomer;
		glycan3_start = nres_protein_trimer+2*n_glycan_per_monomer+1;
		glycan3_end = nres_protein_trimer+3*n_glycan_per_monomer;

		//not used currently
		//		int const glycan1_start = nres_protein_trimer+1;
		//		int const glycan1_end = nres_protein_trimer+n_glycan_per_monomer;

		//
		//monomer1--glycan2/3
		//
		for ( int i = 1; i <= nres_monomer; i++ ) {
			if ( natro_position( i ) ) continue;

			int start_atm1, end_atm1;
			int const aa1 = pose.res( i );
			int const aav1 = pose.res_variant( i );
			if ( aa1 == param_aa::aa_gly ) {
				start_atm1 = 2;
				end_atm1 = 2;
			} else {
				start_atm1 = 5;
				end_atm1 = aaproperties_pack::nheavyatoms( aa1, aav1 );
			}

			//
			//monomer1-glycan2
			//
			for ( int j = glycan2_start; j<=glycan2_end; ++j ) {
				int start_atm2, end_atm2;
				int aa2 = pose.res( j );
				int aav2 = pose.res_variant( j );
				if ( aa2 == param_aa::aa_gly ) {
					start_atm2 = 2;
					end_atm2 = 2;
				} else {
					start_atm2 = 1;  //1 for glycan  5;
					end_atm2 = aaproperties_pack::nheavyatoms( aa2, aav2 );
				}

				float dis;
				for ( int atm1 = start_atm1; atm1 <= end_atm1; ++atm1 ) { // atoms pos1
					for ( int atm2 = start_atm2; atm2 <= end_atm2; ++atm2 ) { // atoms pos2
						dis = distance( triplet::xyzVector_float( &( pose.full_coord()(1,atm1,i))),
														triplet::xyzVector_float( &( pose.full_coord()(1,atm2,j))));
						if ( dis < dis_cutoff ) {
							interface_position( i ) = true;
							//							std::cout << "identify_interface_position: monomer1-glycan" << i << " " << j << std::endl;
							//Don't include glycan positions in minimization for now.
							//							interface_position( j ) = true;
							//
							//And here are the symmetry mates:
							//
							interface_position( i+nres_monomer ) = true;//note be careful assigning symmetry mates to the glycans...don't want monomer2/glycan2 etc.
							interface_position( i+2*nres_monomer ) = true;
							//interface_position( j + n_glycan_per_monomer ) = true; //glycan3
							//interface_position( j - n_glycan_per_monomer ) = true; //glycan1
							//							std::cout << "identify_interface_position: monomer2-glycan" << i+nres_monomer << " " << std::endl;
							//							std::cout << "identify_interface_position: monomer3-glycan" << i+2*nres_monomer << " " << std::endl;
						}
					} // atm2
				} // atm1
			}//j

			//
			//monomer1-glycan3
			//
			for ( int j = glycan3_start; j<=glycan3_end; ++j ) {
				int start_atm2, end_atm2;
				int aa2 = pose.res( j );
				int aav2 = pose.res_variant( j );
				if ( aa2 == param_aa::aa_gly ) {
					start_atm2 = 2;
					end_atm2 = 2;
				} else {
					start_atm2 = 1;  //1 for glycan  5;
					end_atm2 = aaproperties_pack::nheavyatoms( aa2, aav2 );
				}

				float dis;
				for ( int atm1 = start_atm1; atm1 <= end_atm1; ++atm1 ) { // atoms pos1
					for ( int atm2 = start_atm2; atm2 <= end_atm2; ++atm2 ) { // atoms pos2
						dis = distance( triplet::xyzVector_float( &( pose.full_coord()(1,atm1,i))),
														triplet::xyzVector_float( &( pose.full_coord()(1,atm2,j))));
						if ( dis < dis_cutoff ) {
							interface_position( i ) = true;
							//							std::cout << "identify_interface_position: monomer1-glycan" << i << " " << j << std::endl;
							//Don't include glycan positions in minimization for now.
							//							interface_position( j ) = true;
							//
							//And here are the symmetry mates:
							//
							interface_position( i+nres_monomer ) = true;//note be careful assigning symmetry mates to the glycans...don't want monomer2/glycan2 etc.
							interface_position( i+2*nres_monomer ) = true;
							//interface_position( j - 2*n_glycan_per_monomer ) = true; //glycan1
							//interface_position( j - n_glycan_per_monomer ) = true; //glycan2
							//							std::cout << "identify_interface_position: monomer2-glycan" << i+nres_monomer << " " << std::endl;
							//							std::cout << "identify_interface_position: monomer3-glycan" << i+2*nres_monomer << " " << std::endl;
						}
					} // atm2
				} // atm1
			}//j

		}//i
	}//glycan_attached


	if ( Ab_attached ) {
		int Ab_start, Ab_end;

		if ( glycan_attached ) {
			Ab_start = nres_protein_trimer + nres_glycan + 1;
			Ab_end = nres;
		} else {
			Ab_start = nres_protein_trimer + 1;
			Ab_end = nres;
		}

		//		std::cout << "Ab_start, Ab_end " << Ab_start << " " << Ab_end << std::endl;

		//
		//monomer2/3--Ab ( don't bother minimizing monomer1-Ab b/c that interaction is from xtal structure )
		//
		for ( int i = nres_monomer+1; i <= nres_protein_trimer; i++ ) {
			if ( natro_position( i ) ) continue;

			int start_atm1, end_atm1;
			int const aa1 = pose.res( i );
			int const aav1 = pose.res_variant( i );
			if ( aa1 == param_aa::aa_gly ) {
				start_atm1 = 2;
				end_atm1 = 2;
			} else {
				start_atm1 = 5;
				end_atm1 = aaproperties_pack::nheavyatoms( aa1, aav1 );
			}

			for ( int j = Ab_start; j<=Ab_end; ++j ) {
				if ( natro_position( j ) ) continue;

				int start_atm2, end_atm2;
				int aa2 = pose.res( j );
				int aav2 = pose.res_variant( j );
				if ( aa2 == param_aa::aa_gly ) {
					start_atm2 = 2;
					end_atm2 = 2;
				} else {
					start_atm2 = 5;
					end_atm2 = aaproperties_pack::nheavyatoms( aa2, aav2 );
				}

				float dis;
				for ( int atm1 = start_atm1; atm1 <= end_atm1; ++atm1 ) { // atoms pos1
					for ( int atm2 = start_atm2; atm2 <= end_atm2; ++atm2 ) { // atoms pos2
						dis = distance( triplet::xyzVector_float( &( pose.full_coord()(1,atm1,i))),
														triplet::xyzVector_float( &( pose.full_coord()(1,atm2,j))));
						if ( dis < dis_cutoff ) {
							interface_position( i ) = true;
							interface_position( j ) = true;
							float const x1 = pose.full_coord()(1,atm1,i);
							float const x2 = pose.full_coord()(1,atm2,j);
							float const y2 = pose.full_coord()(2,atm2,j);
							float const z2 = pose.full_coord()(3,atm2,j);
							//							std::cout << "identify_interface_position: monomer2/3-Ab " << i << " " << j << " "
							//												<< x1 << " " << x2 << " " << y2 << " " << z2 << std::endl;
						}
					} // atm2
				} // atm1
			}//j
		}//i

		if ( glycan_attached ) {
			//
			//Ab--glycan2/3 -- don't bother with Ab-glycan1 b/c that was done already with Molecular Dynamics
			//
			for ( int i = Ab_start; i <= Ab_end; i++ ) {
				if ( natro_position( i ) ) continue;

				int start_atm1, end_atm1;
				int const aa1 = pose.res( i );
				int const aav1 = pose.res_variant( i );
				if ( aa1 == param_aa::aa_gly ) {
					start_atm1 = 2;
					end_atm1 = 2;
				} else {
					start_atm1 = 5;
					end_atm1 = aaproperties_pack::nheavyatoms( aa1, aav1 );
				}

				for ( int j = glycan2_start; j<=glycan3_end; ++j ) {
					int start_atm2, end_atm2;
					int aa2 = pose.res( j );
					int aav2 = pose.res_variant( j );
					if ( aa2 == param_aa::aa_gly ) {
						start_atm2 = 2;
						end_atm2 = 2;
					} else {
						start_atm2 = 1;  //1 for glycan  5;
						end_atm2 = aaproperties_pack::nheavyatoms( aa2, aav2 );
					}

					float dis;
					for ( int atm1 = start_atm1; atm1 <= end_atm1; ++atm1 ) { // atoms pos1
						for ( int atm2 = start_atm2; atm2 <= end_atm2; ++atm2 ) { // atoms pos2
							dis = distance( triplet::xyzVector_float( &( pose.full_coord()(1,atm1,i))),
															triplet::xyzVector_float( &( pose.full_coord()(1,atm2,j))));
							if ( dis < dis_cutoff ) {
								interface_position( i ) = true;
								//Don't include glycan positions in minimization for now.
								//								interface_position( j ) = true;
								//												std::cout << "identify_interface_position: Ab-glycan2/3 " << i << " " << j << std::endl;
							}
						} // atm2
					} // atm1
				}//j
			}//i
		}//glycan_attached
	}//Ab_attached


	//
	//count interface positions
	//
	n_interface_positions = 0;
	for ( int i = 1; i <= nres; i++ ) {
		if ( interface_position( i ) ) {
			++n_interface_positions;
			//			std::cout << "in identify at end, found inter pos " << i << std::endl;
		}
	}

}


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//check-pointing for running on clusters
void
update_conformation_already_scored(
																	 int const & n,                 //number for conformation just completed
																	 std::string const & fullname  //path + filename for checkpoint file
																	 )
{

	//	std::string fullname  = files_paths::score_path + filename;
	utility::io::ozstream my_ozstream( fullname );
	my_ozstream.open( fullname );
	if ( !my_ozstream ) {
		my_ozstream.close();
		my_ozstream.clear();
		return;
	}
	my_ozstream << SS( n ) << '\n'; //std::endl;
	my_ozstream.close();
	my_ozstream.clear();
}


/////////////////////////////////////////////////////////////////////////////////
//has conformation number n already been completed?
bool
check_conformation_already_scored(
																	int const & no,         //input: number of the current conformation
																	std::string const & fullname  //input: path + filename to checkpoint file.
																	)
{

	int last_output;//last conformation completed, according to checkpoint file

	bool already_scored = false;

	//	std::string fullname = files_paths::score_path + filename;
	utility::io::izstream my_izstream( fullname );
	if ( !my_izstream ) { // checkpoint file doesn't exist yet
		last_output = 0;
	} else {
		my_izstream >> last_output; // >> skip; //for some reason skip does not compile.
		int loop_counter(0);
		while ( my_izstream.fail() ) {
			++loop_counter;
			if ( loop_counter > 120 ) {
				last_output = no-1;
				break;
			}
			std::cout << "WARNING: check_conformation_already_scored: can not read from " <<
				fullname.c_str() << std::endl;
			my_izstream.clear();
			my_izstream.close();
			utility::sys_sleep(1);
			my_izstream.open( fullname.c_str() );
			//			my_izstream >> last_start >> skip;
			my_izstream >> last_output; //  >> skip; //for some reason skip does not compile.
			std::cout << "WARNING: no last_output " << no << ' ' << last_output<< std::endl;
		}
	}
	my_izstream.close();
	my_izstream.clear();

	if ( no <= last_output ) {
		already_scored = true;
	} else if ( no == last_output + 1 ) {
		already_scored = false;
	} else if ( no > last_output + 1 ) {
		std::cout << "ERROR: check_conformation_already_scored: no > last_output+1 "
							<< no << ' ' << last_output+1 << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	return already_scored;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//orients antibody to remain attached to monomer 1
//applies same transformations that are applied to protein monomer 1
void
set_Ab_coords_for_trimer(
												 pose_ns::Pose & pose,
												 FArray2D_double const & Rxyz,
												 FArray2D_double const & translation,
												 FArray3D_float & coords_out
												 )
{

	int const nres = pose.total_residue();
	for ( int i_res = 1; i_res <= nres; i_res++ ) {
		int aa = pose.res( i_res );
		int aav = pose.res_variant( i_res );
		int n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa, aav );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			FArray1D_double init_coords( 3 );
			for ( int k = 1; k <= 3; k++ ) {
				init_coords( k ) = pose.full_coord()( k, i_atom, i_res ); //original Ab coords input by pdbfile
			}
			FArray1D_double oriented_coords( 3, 0.0 );

			//
			//do the rotations
			//
			Dvect_multiply( Rxyz, init_coords, oriented_coords );

			//do the translation
			for ( int k = 1; k <= 3; k++ ) {
				coords_out( k, i_atom, i_res ) = oriented_coords( k ) + translation( k, 1 /* 1 for monomer1 */);
			}

		}//i_atom
	}//i_res
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//orients 3 sets of glycans
//starts with globally-stored initial coords in ligand::multi_lig
//applies same transformations that are applied to protein monomers
void
set_glycan_coords_for_trimer(
														 int const & n_glycan_on_monomer,
														 FArray2D_double const & Rz120,
														 FArray2D_double const & Rxyz,
														 FArray2D_double const & translation,
														 FArray4D_float & glycan_coords
														 )
{
	int const N = 3;
	for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {
		int aa_lig = ligand::multi_lig::list_aa_lig( i_lig );
		int aav_lig = ligand::multi_lig::list_aav_lig( i_lig );
		int n_atoms_lig = aaproperties_pack::properties_per_aa_aav::natoms( aa_lig, aav_lig );
		for ( int i_atom = 1; i_atom <= n_atoms_lig; i_atom++ ) {
			FArray1D_double init_coords( 3 );
			for ( int k = 1; k <= 3; k++ ) {
				init_coords( k ) = ligand::multi_lig::multi_lig_coord( k, i_atom, i_lig ); //original glycan coords input by pdbfile
			}
			FArray2D_double oriented_coords( 3, N, 0.0 );

			//
			//do the rotations
			//
			Dvect_multiply( Rxyz, init_coords, oriented_coords( 1, 1 ) );
			Dvect_multiply( Rz120, oriented_coords( 1, 1 ), oriented_coords( 1, 2 ) );
			Dvect_multiply( Rz120, oriented_coords( 1, 2 ), oriented_coords( 1, 3 ) );

			//do the translation
			for ( int i_monomer = 1; i_monomer <= 3; i_monomer++ ) {
				for ( int k = 1; k <= 3; k++ ) {
					glycan_coords( k, i_atom, i_lig, i_monomer ) = oriented_coords( k, i_monomer ) + translation( k, i_monomer );
				}
			}
		}
	}//i_lig = 1 to n_glycan_on_monomer
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//makes a pose for monomer + many attached glycans
//assumes the glycan_coords are pre-oriented for attachment.
//uses some globally stored info in ligand::multi_lig

void
make_monomer_w_glycan(
										 pose_ns::Pose & monomer_pose,
										 int const n_glycan_on_monomer,
										 FArray3D_float const & glycan_coords,
										 bool const & anchor_resnums_read_from_file,
										 FArray1D_int const & list_anchor_resnums_monomer,
										 pose_ns::Pose & monomer_w_glycan_pose
										 )
{

	int const nres_monomer = monomer_pose.total_residue();
	int const nres_monomer_w_glycan = nres_monomer + n_glycan_on_monomer;

	pose_ns::Fold_tree f;
	{//setup fold_tree
		//one jump for each glycan
		//either read in teh anchor residues or
		//find closest residue to each glycan to serve as anchor...should be the ASN!
		int const n_jumps = n_glycan_on_monomer;
		FArray2D_int jumps( 2, n_jumps );
		FArray1D_int cuts( n_jumps );

		for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {

			int anchor_resnum( 0 );              // protein resnum anchoring lig; either read it in or compute from coords below
			int const anchor_atomno( 2 );     // protein atom_num anchoring lig: Calpha
			int const lig_root_atomno( 1 );   // atom in ligand to anchor to
			//			bool const attach_by_jump( true ); // alternative is to attach by a bond

			if ( anchor_resnums_read_from_file ) {
				//get anchor residues from list_anchor_resnums read in for monomer1

				anchor_resnum = list_anchor_resnums_monomer( i_lig );

			} else {

				//get anchor residues from monomer1 coordinates
				//set anchor residues for  monomers 1, 2 and 3
				//

				int n_atoms_lig = ligand::multi_lig::list_n_atoms_lig( i_lig );
				FArray2D_float lig_coord ( 3, n_atoms_lig );
				for ( int i_atom = 1; i_atom <= n_atoms_lig; i_atom++ ) {
					for ( int k = 1; k <= 3; k++ ) {
						lig_coord( k, i_atom ) = glycan_coords( k, i_atom, i_lig );
					}
				}

				// find closest C-alpha to ligand anchor atom
				//Note: we could attach to the ND2 of the anchor ASN residue
				//this would be important if we want to minimize the ASN chi as well as glycan chi
				//
				{
					using triplet::xyzVector_float;
					xyzVector_float const lig_root_xyz( &( lig_coord( 1, lig_root_atomno )));
					float min_d( 1000.0f );
					for ( int i=1; i<= monomer_pose.total_residue(); ++i ) {
						float const d = distance( xyzVector_float( &(monomer_pose.full_coord()(1,anchor_atomno,i))),
																			lig_root_xyz );
						if ( d<min_d ) {
							min_d = d;
							anchor_resnum = i;
						}
					}
				}
			}

			//
			//set anchor residues for  monomer
			//

			//monomer 1
			int resnum_lig = nres_monomer + i_lig;
			jumps( 1, i_lig ) = anchor_resnum;
			jumps( 2, i_lig ) = resnum_lig;
			cuts( i_lig ) = resnum_lig - 1;
			assert( jumps( 1, i_lig ) <= nres_monomer );
			assert( jumps( 2, i_lig ) > nres_monomer && jumps( 2, i_lig ) <= nres_monomer_w_glycan );
			assert( cuts( i_lig ) > 1 );

		}
		//make fold tree from jumps and cuts
		f.tree_from_jumps_and_cuts( nres_monomer_w_glycan, n_jumps, jumps, cuts );
		f.reorder( 1 ); // not necessary but clean to root tree at rsd 1 of protein

		//
		//Before set_coords ( which makes an atom_tree )
		//we have the option to set the root,anchor atomno for jumps as we desire
		//else they will be defaults ( root, anchor = 1 )
		//good to do this after setting up the res, resv info
		//so we can check to make sure the anchor rsd is in fact ASN or whatever
		//we are assuming it to be.
		//
		//						int const n_jumps = n_glycan_on_trimer;
		for ( int i_jump = 1; i_jump <= n_jumps; i_jump++ ) {
			int const atom_num_protein = 2; //Calpha, but this could be ND2 for ASN
			int const atom_num_ligand = 1; //first atom
			f.set_jump_atoms( i_jump, atom_num_protein, atom_num_ligand );
		}

		monomer_w_glycan_pose.set_fold_tree( f );

	}

	//Now fill in res, resv for monomer_w_glycan
	//

	//info for protein-only
	monomer_w_glycan_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
	FArray3D_float monomer_w_glycan_coords( 3, param::MAX_ATOM(), nres_monomer_w_glycan );
	for ( int i_res = 1; i_res <= nres_monomer; ++i_res ) {
		monomer_w_glycan_pose.set_phi        ( i_res, monomer_pose.phi( i_res ) );
		monomer_w_glycan_pose.set_psi        ( i_res, monomer_pose.psi( i_res ) );
		monomer_w_glycan_pose.set_omega      ( i_res, monomer_pose.omega( i_res ) );
		monomer_w_glycan_pose.set_secstruct  ( i_res, monomer_pose.secstruct( i_res ) );
		monomer_w_glycan_pose.set_name       ( i_res, monomer_pose.name( i_res ) );
		monomer_w_glycan_pose.set_res        ( i_res, monomer_pose.res( i_res ) );
		monomer_w_glycan_pose.set_res_variant( i_res, monomer_pose.res_variant( i_res ) );
		int const aa = monomer_pose.res( i_res );
		int const aav = monomer_pose.res_variant( i_res );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa, aav );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			for ( int k = 1; k <= 3; k++ ) {
				monomer_w_glycan_coords( k, i_atom, i_res ) = monomer_pose.full_coord()( k, i_atom, i_res );
			}
		}
	}

	//info for glycan
	for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {
		int i_res = nres_monomer + i_lig;
		int aa_lig = ligand::multi_lig::list_aa_lig( i_lig );
		int aav_lig = ligand::multi_lig::list_aav_lig( i_lig );
		std::string name_lig = param_aa::aa_name3( aa_lig );
		monomer_w_glycan_pose.set_res        ( i_res, aa_lig );
		monomer_w_glycan_pose.set_res_variant( i_res, aav_lig );
		monomer_w_glycan_pose.set_name       ( i_res, name_lig );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa_lig, aav_lig );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			for ( int k = 1; k <= 3; k++ ) {
				monomer_w_glycan_coords( k, i_atom, i_res ) = glycan_coords( k, i_atom, i_lig );
			}
		}
	}

	//Epos for monomer_w_glycan
	//
	FArray3D_float monomer_w_glycan_Epos( 3, param::MAX_POS, nres_monomer_w_glycan );//MAX_POS = 5
	for ( int i = 1; i <= nres_monomer_w_glycan; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			monomer_w_glycan_Epos(k,1,i) = monomer_w_glycan_coords(k,1,i);
			monomer_w_glycan_Epos(k,2,i) = monomer_w_glycan_coords(k,2,i);
			monomer_w_glycan_Epos(k,4,i) = monomer_w_glycan_coords(k,3,i);
			monomer_w_glycan_Epos(k,5,i) = monomer_w_glycan_coords(k,4,i);
			monomer_w_glycan_Epos(k,3,i) = monomer_w_glycan_coords(k,5,i);
		}
	}

	bool const ideal_pose = false;
	bool const check_missing = false;
	monomer_w_glycan_pose.set_coords( ideal_pose, monomer_w_glycan_Epos, monomer_w_glycan_coords, check_missing );
	//monomer_w_glycan_pose.dump_pdb( "monomer_w_glycan_pose.pdb", true );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
void
make_glycan_only_monomer(
												int const n_glycan_on_monomer,
												FArray3D_float const & glycan_coords,
												pose_ns::Pose & glycan_only_monomer_pose
										 )
{

	glycan_only_monomer_pose.simple_fold_tree( n_glycan_on_monomer );

	//Now fill in res, resv for monomer_w_glycan
	//

	//info for protein-only
	glycan_only_monomer_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
	FArray3D_float glycan_only_monomer_coords( 3, param::MAX_ATOM(), n_glycan_on_monomer );

	//info for glycan
	for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {
		int i_res = i_lig;
		int aa_lig = ligand::multi_lig::list_aa_lig( i_lig );
		int aav_lig = ligand::multi_lig::list_aav_lig( i_lig );
		std::string name_lig = param_aa::aa_name3( aa_lig );
		glycan_only_monomer_pose.set_res        ( i_res, aa_lig );
		glycan_only_monomer_pose.set_res_variant( i_res, aav_lig );
		glycan_only_monomer_pose.set_name       ( i_res, name_lig );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa_lig, aav_lig );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			for ( int k = 1; k <= 3; k++ ) {
				glycan_only_monomer_coords( k, i_atom, i_res ) = glycan_coords( k, i_atom, i_lig );
			}
		}
	}


	//Epos for glycan_only_monomer
	//
	FArray3D_float glycan_only_monomer_Epos( 3, param::MAX_POS, n_glycan_on_monomer );//MAX_POS = 5
	for ( int i = 1; i <= n_glycan_on_monomer; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			glycan_only_monomer_Epos(k,1,i) = glycan_only_monomer_coords(k,1,i);
			glycan_only_monomer_Epos(k,2,i) = glycan_only_monomer_coords(k,2,i);
			glycan_only_monomer_Epos(k,4,i) = glycan_only_monomer_coords(k,3,i);
			glycan_only_monomer_Epos(k,5,i) = glycan_only_monomer_coords(k,4,i);
			glycan_only_monomer_Epos(k,3,i) = glycan_only_monomer_coords(k,5,i);
		}
	}

	bool const ideal_pose = false;
	bool const check_missing = false;
	glycan_only_monomer_pose.set_coords( ideal_pose, glycan_only_monomer_Epos, glycan_only_monomer_coords, check_missing );
	//glycan_only_monomer_pose.dump_pdb( "glycan_only_monomer_pose.pdb", true );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
void
make_glycan_only_trimer(
												int const n_glycan_on_monomer,
												FArray4D_float const & glycan_coords,
												pose_ns::Pose & glycan_only_trimer_pose
										 )
{

	int const N = 3;
	int const n_glycan_on_trimer = 3*n_glycan_on_monomer;


	glycan_only_trimer_pose.simple_fold_tree( n_glycan_on_trimer );

	//Now fill in res, resv for trimer_w_glycan
	//

	//info for protein-only
	glycan_only_trimer_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
	FArray3D_float glycan_only_trimer_coords( 3, param::MAX_ATOM(), n_glycan_on_trimer );

	//info for glycan
	for ( int i_monomer = 1; i_monomer <= N; i_monomer++ ) {
		for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {
			int i_res = i_lig + ( i_monomer-1 )*n_glycan_on_monomer;
			int aa_lig = ligand::multi_lig::list_aa_lig( i_lig );
			int aav_lig = ligand::multi_lig::list_aav_lig( i_lig );
			std::string name_lig = param_aa::aa_name3( aa_lig );
			glycan_only_trimer_pose.set_res        ( i_res, aa_lig );
			glycan_only_trimer_pose.set_res_variant( i_res, aav_lig );
			glycan_only_trimer_pose.set_name       ( i_res, name_lig );
			int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa_lig, aav_lig );
			for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
				for ( int k = 1; k <= 3; k++ ) {
					glycan_only_trimer_coords( k, i_atom, i_res ) = glycan_coords( k, i_atom, i_lig, i_monomer );
				}
			}
		}
	}

	//Epos for glycan_only_trimer
	//
	FArray3D_float glycan_only_trimer_Epos( 3, param::MAX_POS, n_glycan_on_trimer );//MAX_POS = 5
	for ( int i = 1; i <= n_glycan_on_trimer; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			glycan_only_trimer_Epos(k,1,i) = glycan_only_trimer_coords(k,1,i);
			glycan_only_trimer_Epos(k,2,i) = glycan_only_trimer_coords(k,2,i);
			glycan_only_trimer_Epos(k,4,i) = glycan_only_trimer_coords(k,3,i);
			glycan_only_trimer_Epos(k,5,i) = glycan_only_trimer_coords(k,4,i);
			glycan_only_trimer_Epos(k,3,i) = glycan_only_trimer_coords(k,5,i);
		}
	}

	bool const ideal_pose = false;
	bool const check_missing = false;
	glycan_only_trimer_pose.set_coords( ideal_pose, glycan_only_trimer_Epos, glycan_only_trimer_coords, check_missing );
	//glycan_only_trimer_pose.dump_pdb( "glycan_only_trimer_pose.pdb", true );
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////
//makes a pose for trimer + many attached glycans
//assumes the glycan_coords are pre-oriented for attachment.
//uses some globally stored info in ligand::multi_lig

void
make_trimer_w_glycan(
										 pose_ns::Pose & trimer_pose,
										 int const n_glycan_on_monomer,
										 FArray4D_float const & glycan_coords,
										 bool const & anchor_resnums_read_from_file,
										 FArray1D_int const & list_anchor_resnums_monomer,
										 pose_ns::Pose & trimer_w_glycan_pose
										 )
{

	int const N = 3;
	int const nres_trimer = trimer_pose.total_residue();
	int const nres_monomer = nres_trimer/3;
	int const n_glycan_on_trimer = 3*n_glycan_on_monomer;
	int const nres_trimer_w_glycan = nres_trimer + n_glycan_on_trimer;

	pose_ns::Fold_tree f;
	{//setup fold_tree
		//one jump for each glycan
		//find closest residue to each glycan to serve as anchor...should be the ASN!
		int const n_jumps = n_glycan_on_trimer;
		FArray2D_int jumps( 2, n_jumps );
		FArray1D_int cuts( n_jumps );

		for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {

			int anchor_resnum( 0 );              // protein resnum anchoring lig; either read it in or compute from coords below
			int const anchor_atomno( 2 );     // protein atom_num anchoring lig: Calpha
			int const lig_root_atomno( 1 );   // atom in ligand to anchor to
			//			bool const attach_by_jump( true ); // alternative is to attach by a bond

			if ( anchor_resnums_read_from_file ) {
				//get anchor residues from list_anchor_resnums read in for monomer1

				anchor_resnum = list_anchor_resnums_monomer( i_lig );

			} else {

				//get anchor residues from monomer1 coordinates
				//set anchor residues for  monomers 1, 2 and 3
				//

				int n_atoms_lig = ligand::multi_lig::list_n_atoms_lig( i_lig );
				FArray2D_float lig_coord ( 3, n_atoms_lig );
				for ( int i_atom = 1; i_atom <= n_atoms_lig; i_atom++ ) {
					for ( int k = 1; k <= 3; k++ ) {
						lig_coord( k, i_atom ) = glycan_coords( k, i_atom, i_lig, 1 /*i_monomer = 1 */);
					}
				}

				// find closest C-alpha to ligand anchor atom
				//Note: we could attach to the ND2 of the anchor ASN residue
				//this would be important if we want to minimize the ASN chi as well as glycan chi
				//
				{
					using triplet::xyzVector_float;
					xyzVector_float const lig_root_xyz( &( lig_coord( 1, lig_root_atomno )));
					float min_d( 1000.0f );
					for ( int i=1; i<= trimer_pose.total_residue(); ++i ) {
						float const d = distance( xyzVector_float( &(trimer_pose.full_coord()(1,anchor_atomno,i))),
																			lig_root_xyz );
						if ( d<min_d ) {
							min_d = d;
							anchor_resnum = i;
						}
					}
				}
			}

			//
			//set anchor residues for  monomers 1, 2 and 3
			//

			//monomer 1
			int resnum_lig = nres_trimer + i_lig;
			jumps( 1, i_lig ) = anchor_resnum;
			jumps( 2, i_lig ) = resnum_lig;
			cuts( i_lig ) = resnum_lig - 1;
			assert( jumps( 1, i_lig ) <= nres_monomer );
			assert( jumps( 2, i_lig ) > nres_trimer && jumps( 2, i_lig ) <= nres_trimer + n_glycan_on_monomer );
			assert( cuts( i_lig ) > 1 );

			//monomer 2
			int i_lig_2 = i_lig + n_glycan_on_monomer;//i_lig_2 = 17 to 32 with 16 glycans on monomer
			int resnum_lig_2 = nres_trimer + i_lig_2;
			jumps( 1, i_lig_2 ) = anchor_resnum + nres_monomer;//protein anchor resnum shifted by symmetry
			jumps( 2, i_lig_2 ) = resnum_lig_2;
			cuts( i_lig_2 ) = resnum_lig_2 - 1;

			//monomer 3
			int i_lig_3 = i_lig + 2*n_glycan_on_monomer;//i_lig_3 = 33 to 48
			int resnum_lig_3 = nres_trimer + i_lig_3;
			jumps( 1, i_lig_3 ) = anchor_resnum + 2*nres_monomer;//protein anchor resnum shifted by symmetry
			jumps( 2, i_lig_3 ) = resnum_lig_3;
			cuts( i_lig_3 ) = resnum_lig_3 - 1;
			assert( cuts( i_lig_3 ) < nres_trimer_w_glycan );

		}
		//make fold tree from jumps and cuts
		f.tree_from_jumps_and_cuts( nres_trimer_w_glycan, n_jumps, jumps, cuts );
		f.reorder( 1 ); // not necessary but clean to root tree at rsd 1 of protein

		//
		//Before set_coords ( which makes an atom_tree )
		//we have the option to set the root,anchor atomno for jumps as we desire
		//else they will be defaults ( root, anchor = 1 )
		//good to do this after setting up the res, resv info
		//so we can check to make sure the anchor rsd is in fact ASN or whatever
		//we are assuming it to be.
		//
		//						int const n_jumps = n_glycan_on_trimer;
		for ( int i_jump = 1; i_jump <= n_jumps; i_jump++ ) {
			int const atom_num_protein = 2; //Calpha, but this could be ND2 for ASN
			int const atom_num_ligand = 1; //first atom
			f.set_jump_atoms( i_jump, atom_num_protein, atom_num_ligand );
		}

		trimer_w_glycan_pose.set_fold_tree( f );

	}

	//Now fill in res, resv for trimer_w_glycan
	//

	//info for protein-only
	trimer_w_glycan_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
	FArray3D_float trimer_w_glycan_coords( 3, param::MAX_ATOM(), nres_trimer_w_glycan );
	for ( int i_res = 1; i_res <= nres_trimer; ++i_res ) {
		trimer_w_glycan_pose.set_phi        ( i_res, trimer_pose.phi( i_res ) );
		trimer_w_glycan_pose.set_psi        ( i_res, trimer_pose.psi( i_res ) );
		trimer_w_glycan_pose.set_omega      ( i_res, trimer_pose.omega( i_res ) );
		trimer_w_glycan_pose.set_secstruct  ( i_res, trimer_pose.secstruct( i_res ) );
		trimer_w_glycan_pose.set_name       ( i_res, trimer_pose.name( i_res ) );
		trimer_w_glycan_pose.set_res        ( i_res, trimer_pose.res( i_res ) );
		trimer_w_glycan_pose.set_res_variant( i_res, trimer_pose.res_variant( i_res ) );
		int const aa = trimer_pose.res( i_res );
		int const aav = trimer_pose.res_variant( i_res );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa, aav );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			for ( int k = 1; k <= 3; k++ ) {
				trimer_w_glycan_coords( k, i_atom, i_res ) = trimer_pose.full_coord()( k, i_atom, i_res );
			}
		}
	}

	//info for glycan
	for ( int i_monomer = 1; i_monomer <= N; i_monomer++ ) {
		for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {
			int i_res = nres_trimer + i_lig + ( i_monomer-1 )*n_glycan_on_monomer;
			int aa_lig = ligand::multi_lig::list_aa_lig( i_lig );
			int aav_lig = ligand::multi_lig::list_aav_lig( i_lig );
			std::string name_lig = param_aa::aa_name3( aa_lig );
			trimer_w_glycan_pose.set_res        ( i_res, aa_lig );
			trimer_w_glycan_pose.set_res_variant( i_res, aav_lig );
			trimer_w_glycan_pose.set_name       ( i_res, name_lig );
			int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa_lig, aav_lig );
			for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
				for ( int k = 1; k <= 3; k++ ) {
					trimer_w_glycan_coords( k, i_atom, i_res ) = glycan_coords( k, i_atom, i_lig, i_monomer );
				}
			}
		}
	}

	//Epos for trimer_w_glycan
	//
	FArray3D_float trimer_w_glycan_Epos( 3, param::MAX_POS, nres_trimer_w_glycan );//MAX_POS = 5
	for ( int i = 1; i <= nres_trimer_w_glycan; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			trimer_w_glycan_Epos(k,1,i) = trimer_w_glycan_coords(k,1,i);
			trimer_w_glycan_Epos(k,2,i) = trimer_w_glycan_coords(k,2,i);
			trimer_w_glycan_Epos(k,4,i) = trimer_w_glycan_coords(k,3,i);
			trimer_w_glycan_Epos(k,5,i) = trimer_w_glycan_coords(k,4,i);
			trimer_w_glycan_Epos(k,3,i) = trimer_w_glycan_coords(k,5,i);
		}
	}

	bool const ideal_pose = false;
	bool const check_missing = false;
	trimer_w_glycan_pose.set_coords( ideal_pose, trimer_w_glycan_Epos, trimer_w_glycan_coords, check_missing );
	//trimer_w_glycan_pose.dump_pdb( "trimer_w_glycan_pose.pdb", true );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
//makes a pose for trimer + Ab + many attached glycans
//assumes the glycan_coords are pre-oriented for attachment.
//uses some globally stored info in ligand::multi_lig
//** Note trimer_w_glycan_pose is fairly complicated so here we just copy those jumps and cuts
//** and then add on the Ab after the glycans
//** So residue numbering will be protein_trimer, then glycan, then Ab.

void
make_trimer_w_glycan_w_Ab(
													pose_ns::Pose & trimer_w_glycan_pose,               //trimer_w_glycan
													pose_ns::Pose & Ab_pose,                   //Ab_pose
													pose_ns::Pose & trimer_w_glycan_w_Ab_pose
													)
{

	int const nres_trimer_w_glycan = trimer_w_glycan_pose.total_residue();
	int const nres_Ab = Ab_pose.total_residue();
	int const nres_trimer_w_glycan_w_Ab = nres_trimer_w_glycan + nres_Ab;

	pose_ns::Fold_tree f_trimer_w_glycan ( trimer_w_glycan_pose.fold_tree() );
	pose_ns::Fold_tree f;
	int const n_jumps_trimer_w_glycan = f_trimer_w_glycan.get_num_jump();
	int const n_jumps = n_jumps_trimer_w_glycan + 1;
	FArray2D_int jumps( 2, n_jumps );
	FArray1D_int cuts( n_jumps );
	FArray2D_int jump_atomno( 2, n_jumps );

	int n_cuts_trimer_w_glycan;
	FArray1D_int const & cuts_trimer_w_glycan
		( trimer_w_glycan_pose.fold_tree().get_fold_tree_cutpoint( n_cuts_trimer_w_glycan ) );

	if ( n_cuts_trimer_w_glycan != n_jumps_trimer_w_glycan ) {
		std::cout << "ERROR: n_jumps_trimer_w_glycan diff than expected: expected, actual " <<
			n_jumps_trimer_w_glycan << " " << n_cuts_trimer_w_glycan << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	for ( int i_jump = 1; i_jump <= n_jumps_trimer_w_glycan; i_jump++ ) {
		jumps( 1, i_jump ) = f_trimer_w_glycan.get_jump_point()( 1, i_jump );
		jumps( 2, i_jump ) = f_trimer_w_glycan.get_jump_point()( 2, i_jump );
		cuts( i_jump ) = cuts_trimer_w_glycan( i_jump );
		jump_atomno( 1, i_jump ) = f_trimer_w_glycan.upstream_atomno( i_jump );
		jump_atomno( 2, i_jump ) = f_trimer_w_glycan.downstream_atomno( i_jump );
	}
	jumps( 1, n_jumps ) = 1;
	jumps( 2, n_jumps ) = nres_trimer_w_glycan + 1;
	cuts( n_jumps ) = nres_trimer_w_glycan;
	jump_atomno( 1, n_jumps ) = 2; //CA
	jump_atomno( 2, n_jumps ) = 2; //CA

	//make fold tree from jumps and cuts
	f.tree_from_jumps_and_cuts( nres_trimer_w_glycan_w_Ab, n_jumps, jumps, cuts );
	f.reorder( 1 ); // not necessary but clean to root tree at rsd 1 of protein

	//
	//Before set_coords ( which makes an atom_tree )
	//we have the option to set the root,anchor atomno for jumps as we desire
	//else they will be defaults ( root, anchor = 1 )
	//good to do this after setting up the res, resv info
	//so we can check to make sure the anchor rsd is in fact ASN or whatever
	//we are assuming it to be.
	//
	for ( int i_jump = 1; i_jump <= n_jumps; i_jump++ ) {
		f.set_jump_atoms( i_jump, jump_atomno( 1, i_jump ), jump_atomno( 2, i_jump ) );
	}

	trimer_w_glycan_w_Ab_pose.set_fold_tree( f );

	//
	//Now fill in res, resv for trimer_w_glycan_w_Ab
	//

	//copy info from trimer_w_glycan
	trimer_w_glycan_w_Ab_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
	FArray3D_float trimer_w_glycan_w_Ab_coords( 3, param::MAX_ATOM(), nres_trimer_w_glycan_w_Ab );
	for ( int i_res = 1; i_res <= nres_trimer_w_glycan; ++i_res ) {
		trimer_w_glycan_w_Ab_pose.set_phi        ( i_res, trimer_w_glycan_pose.phi( i_res ) );
		trimer_w_glycan_w_Ab_pose.set_psi        ( i_res, trimer_w_glycan_pose.psi( i_res ) );
		trimer_w_glycan_w_Ab_pose.set_omega      ( i_res, trimer_w_glycan_pose.omega( i_res ) );
		trimer_w_glycan_w_Ab_pose.set_secstruct  ( i_res, trimer_w_glycan_pose.secstruct( i_res ) );
		trimer_w_glycan_w_Ab_pose.set_name       ( i_res, trimer_w_glycan_pose.name( i_res ) );
		trimer_w_glycan_w_Ab_pose.set_res        ( i_res, trimer_w_glycan_pose.res( i_res ) );
		trimer_w_glycan_w_Ab_pose.set_res_variant( i_res, trimer_w_glycan_pose.res_variant( i_res ) );
		int const aa = trimer_w_glycan_pose.res( i_res );
		int const aav = trimer_w_glycan_pose.res_variant( i_res );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa, aav );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			for ( int k = 1; k <= 3; k++ ) {
				trimer_w_glycan_w_Ab_coords( k, i_atom, i_res ) = trimer_w_glycan_pose.full_coord()( k, i_atom, i_res );
			}
		}
	}

	//info for Ab
	for ( int i_res_Ab = 1; i_res_Ab <= nres_Ab; ++i_res_Ab ) {
		int i_res = i_res_Ab + nres_trimer_w_glycan;
		trimer_w_glycan_w_Ab_pose.set_phi        ( i_res, Ab_pose.phi( i_res_Ab ) );
		trimer_w_glycan_w_Ab_pose.set_psi        ( i_res, Ab_pose.psi( i_res_Ab ) );
		trimer_w_glycan_w_Ab_pose.set_omega      ( i_res, Ab_pose.omega( i_res_Ab ) );
		trimer_w_glycan_w_Ab_pose.set_secstruct  ( i_res, Ab_pose.secstruct( i_res_Ab ) );
		trimer_w_glycan_w_Ab_pose.set_name       ( i_res, Ab_pose.name( i_res_Ab ) );
		trimer_w_glycan_w_Ab_pose.set_res        ( i_res, Ab_pose.res( i_res_Ab ) );
		trimer_w_glycan_w_Ab_pose.set_res_variant( i_res, Ab_pose.res_variant( i_res_Ab ) );
		int const aa = Ab_pose.res( i_res_Ab );
		int const aav = Ab_pose.res_variant( i_res_Ab );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa, aav );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			for ( int k = 1; k <= 3; k++ ) {
				trimer_w_glycan_w_Ab_coords( k, i_atom, i_res ) = Ab_pose.full_coord()( k, i_atom, i_res_Ab );
			}
		}
	}

	//
	//Epos for trimer_w_glycan_w_Ab
	//
	FArray3D_float trimer_w_glycan_w_Ab_Epos( 3, param::MAX_POS, nres_trimer_w_glycan_w_Ab );//MAX_POS = 5
	for ( int i = 1; i <= nres_trimer_w_glycan_w_Ab; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			trimer_w_glycan_w_Ab_Epos(k,1,i) = trimer_w_glycan_w_Ab_coords(k,1,i);
			trimer_w_glycan_w_Ab_Epos(k,2,i) = trimer_w_glycan_w_Ab_coords(k,2,i);
			trimer_w_glycan_w_Ab_Epos(k,4,i) = trimer_w_glycan_w_Ab_coords(k,3,i);
			trimer_w_glycan_w_Ab_Epos(k,5,i) = trimer_w_glycan_w_Ab_coords(k,4,i);
			trimer_w_glycan_w_Ab_Epos(k,3,i) = trimer_w_glycan_w_Ab_coords(k,5,i);
		}
	}

	bool const ideal_pose = false;
	bool const check_missing = false;
	trimer_w_glycan_w_Ab_pose.set_coords( ideal_pose, trimer_w_glycan_w_Ab_Epos, trimer_w_glycan_w_Ab_coords, check_missing );
	//trimer_w_glycan_w_Ab_pose.dump_pdb( "trimer_w_glycan_w_Ab_pose.pdb", true );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
void
compute_rot_trans_for_trimer(
														 float const & rot_angle_X,
														 float const & rot_angle_Y,
														 float const & rot_angle_Z,
														 float const & trans_dist,
														 FArray2D_double & Rxyz,
														 FArray2D_double & translation
														 )
{

	using utility::conversions::radians;

	//rotation about z, then y, then x
	//
	//          FArray2D_double Rxyz(3,3);
	FArray2D_double Rx( 3, 3 );
	FArray2D_double Ry( 3, 3 );
	FArray2D_double Rz( 3, 3 );
	FArray2D_double Ryz( 3, 3 );

	jmp_zrotation(Rz,rot_angle_Z);
	jmp_yrotation(Ry,rot_angle_Y);
	jmp_xrotation(Rx,rot_angle_X);

	mat_multiply3(Ry ,Rz,Ryz);
	mat_multiply3(Rx,Ryz,Rxyz);

	//
	//translation for monomer1 only in x-dir
	//
	translation( 1, 1 ) = trans_dist; //(xdir, monomer1)

	//
	// additional rotation, translation to compute coords for monomer 2 and 3 (prot + glycan)
	//

	//
	//translation vector used to compute prot+glycan coords for monomer2
	//x = -Dsin30, y = +Dcos30;
	//
	double const angle_30 = 30.;
	translation( 1, 2 ) = -trans_dist * std::sin( radians( angle_30 ) );
	translation( 2, 2 ) = trans_dist * std::cos( radians( angle_30 ) );

	//
	//translation vector used to compute prot+glycan coords for monomer3
	//x = -Dsin30, y = -Dcos30;
	//
	translation( 1, 3 ) = translation( 1, 2 );
	translation( 2, 3 ) = -translation( 2, 2 );

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////
void
make_trimer_pose(
								 pose_ns::Pose & monomer_pose,
								 FArray2D_double const & Rz120,
								 FArray2D_double const & Rxyz,
								 FArray2D_double const & translation,
								 pose_ns::Pose & trimer_pose
								 )
{

	int const N = 3;

	int const nres_monomer = monomer_pose.total_residue();

	FArray4D_float monomer_coords( 3, param::MAX_ATOM(), nres_monomer, N );

	//
	//First make protein-only trimer coordinates
	//
	for ( int i_res = 1; i_res <= nres_monomer; i_res++ ) {
		int const aa = monomer_pose.res( i_res );
		int const aav = monomer_pose.res_variant( i_res );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa, aav );

		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			FArray1D_double init_coords( 3 );
			for ( int k = 1; k <= 3; k++ ) {
				init_coords( k ) = monomer_pose.full_coord()( k, i_atom, i_res );
			}


			FArray2D_double oriented_coords( 3, N, 0.0 );
			//
			//do the rotations
			//
			Dvect_multiply( Rxyz, init_coords, oriented_coords( 1, 1 ) );               //monomer1
			Dvect_multiply( Rz120, oriented_coords( 1, 1 ), oriented_coords( 1, 2 ) );  //monomer2
			Dvect_multiply( Rz120, oriented_coords( 1, 2 ), oriented_coords( 1, 3 ) );  //monomer3

			//
			//do the translation
			//
			for ( int i_monomer = 1; i_monomer <= 3; i_monomer++ ) {
				for ( int k = 1; k <= 3; k++ ) {
					monomer_coords( k, i_atom, i_res, i_monomer ) = oriented_coords( k, i_monomer ) + translation( k, i_monomer );
				}
			}
		}
	}//i_res

	//
	//make trimer pose, protein-only
	//
	int const nres_trimer = 3*nres_monomer;
	trimer_pose.simple_fold_tree( nres_trimer );
	trimer_pose.set_fullatom_flag( true, false );// set fullatom and do not repack
	for ( int i = 1; i <= nres_monomer; ++i ) {
		//monomer1
		trimer_pose.set_phi        ( i, monomer_pose.phi(i) );
		trimer_pose.set_psi        ( i, monomer_pose.psi(i) );
		trimer_pose.set_omega      ( i, monomer_pose.omega(i) );
		trimer_pose.set_secstruct  ( i, monomer_pose.secstruct(i) );
		trimer_pose.set_name       ( i, monomer_pose.name(i) );
		trimer_pose.set_res        ( i, monomer_pose.res( i ) );
		trimer_pose.set_res_variant( i, monomer_pose.res_variant( i ) );
		//monomer2
		trimer_pose.set_phi        ( i+nres_monomer, monomer_pose.phi(i) );
		trimer_pose.set_psi        ( i+nres_monomer, monomer_pose.psi(i) );
		trimer_pose.set_omega      ( i+nres_monomer, monomer_pose.omega(i) );
		trimer_pose.set_secstruct  ( i+nres_monomer, monomer_pose.secstruct(i) );
		trimer_pose.set_name       ( i+nres_monomer, monomer_pose.name(i) );
		trimer_pose.set_res        ( i+nres_monomer, monomer_pose.res( i ) );
		trimer_pose.set_res_variant( i+nres_monomer, monomer_pose.res_variant( i ) );
		//monomer3
		trimer_pose.set_phi        ( i+2*nres_monomer, monomer_pose.phi(i) );
		trimer_pose.set_psi        ( i+2*nres_monomer, monomer_pose.psi(i) );
		trimer_pose.set_omega      ( i+2*nres_monomer, monomer_pose.omega(i) );
		trimer_pose.set_secstruct  ( i+2*nres_monomer, monomer_pose.secstruct(i) );
		trimer_pose.set_name       ( i+2*nres_monomer, monomer_pose.name(i) );
		trimer_pose.set_res        ( i+2*nres_monomer, monomer_pose.res( i ) );
		trimer_pose.set_res_variant( i+2*nres_monomer, monomer_pose.res_variant( i ) );
	}

	//
	//fullcoord for trimer
	//
	FArray3D_float trimer_coords( 3, param::MAX_ATOM(), nres_trimer );
	for ( int i_res = 1; i_res <= nres_monomer; i_res++ ) {
		int const aa = monomer_pose.res( i_res );
		int const aav = monomer_pose.res_variant( i_res );
		int const n_atoms = aaproperties_pack::properties_per_aa_aav::natoms( aa, aav );
		for ( int i_atom = 1; i_atom <= n_atoms; i_atom++ ) {
			for ( int i_monomer = 1; i_monomer <= 3; i_monomer++ ) {
				for ( int k = 1; k <= 3; k++ ) {
					trimer_coords( k, i_atom, i_res + (i_monomer-1)*nres_monomer ) = monomer_coords( k, i_atom, i_res, i_monomer );
				}
			}
		}
	}

	//
	//Epos for protein trimer
	//
	FArray3D_float trimer_Epos( 3, param::MAX_POS, nres_trimer );//MAX_POS = 5
	for ( int i = 1; i <= nres_trimer; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			trimer_Epos(k,1,i) = trimer_coords(k,1,i);
			trimer_Epos(k,2,i) = trimer_coords(k,2,i);
			trimer_Epos(k,4,i) = trimer_coords(k,3,i);
			trimer_Epos(k,5,i) = trimer_coords(k,4,i);
			trimer_Epos(k,3,i) = trimer_coords(k,5,i);
		}
	}

	bool const ideal_pose = false;
	bool const check_missing = false;
	trimer_pose.set_coords( ideal_pose, trimer_Epos, trimer_coords, check_missing );
	//trimer_pose.dump_pdb( "trimer_pose.pdb", true );
}


void
output_lig_only_pdb(
                    int const aa,
                    int const aav,
                    FArray2D_float coords,
                    std::string filename
                    )
{

  int const n_atoms =
    aaproperties_pack::natoms( aa, aav );
  int const nres = 1;
  FArray3D_float xyz_out ( 3, n_atoms, nres );
  for ( int i = 1; i <= n_atoms; i++ ) {
    for ( int k = 1; k <= 3 ; k++ ) {
      xyz_out( k, i, nres ) = coords( k, i );
    }
  }
  FArray1D_int aan_out( nres, aa );
  FArray1D_int aav_out( nres, aav );
  char const chain( 'L' );
  int const ndomains( 1 );
  FArray1D_int dom_end( nres, nres );
  FArray2D_float occ( n_atoms, nres, 1.0 );
  FArray2D_float bval( n_atoms, nres, 1.0 );
	utility::io::ozstream my_ozstream( filename );
  if ( !my_ozstream ) {
		std::cout << "Open failed for file: " << filename << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
	std::cout << "Outputting: " << filename << std::endl;
  output_fullatom_pdb(
                      xyz_out( 1, 1, nres ), // (xyz,atom#,res#)coordinates
                      aan_out, // specifies amino acid at each seqpos
                      aav_out, // amino acid variant at each position
                      nres, // # of residues in the protein
                      chain, // protein chain
                      ndomains, // how many domains?
                      dom_end, // end residues of each domain
                      occ( 1, nres ),
                      bval( 1, nres ),
                      my_ozstream
                      );
  my_ozstream.close();
  my_ozstream.clear();
}


///////////////////////////////////////////////////////////////////////////////


void
read_list_trimer_conformations(
															 int & n_conformations,
															 FArray2D_float & list_trimer_conformations
															 )
{


	int const MAX_N_CONFORMATIONS = 100000;

	std::string filename;
  filename = stringafteroption( "list_trimer_conformations");

	utility::io::izstream infile ( filename );
  if ( ! infile ) {
		std::cout << "read_list_trimer_conformations:"
              << " cannot open file " << filename
              << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }

  n_conformations = 0;
	std::string line;
  while( getline( infile, line ) ) {
		std::string blank(line.size(),' ');
    if ( line == blank ) continue;
		std::istringstream line_stream( line );
    ++n_conformations;
    list_trimer_conformations.redimension( 4, n_conformations );
    line_stream >>
			list_trimer_conformations( 1, n_conformations ) >>
			list_trimer_conformations( 2, n_conformations ) >>
			list_trimer_conformations( 3, n_conformations ) >>
			list_trimer_conformations( 4, n_conformations );
		std::cout << "n_conformations, list_trimer_conformations " << I( 5, n_conformations ) << " "
              << SS( list_trimer_conformations( 1, n_conformations )) << " "
              << SS( list_trimer_conformations( 2, n_conformations )) << " "
              << SS( list_trimer_conformations( 3, n_conformations )) << " "
              << SS( list_trimer_conformations( 4, n_conformations )) << " "
							<< std::endl;
  }

	if ( n_conformations > MAX_N_CONFORMATIONS ) {
		std::cout << "ERROR in read_list_trimer_conformations:: n_conformations = "
							<< n_conformations << " is greater than MAX_N_CONFORMATIONS = "
							<< MAX_N_CONFORMATIONS << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	if ( n_conformations < 1 ) {
		std::cout << "ERROR in read_list_trimer_conformations:: failed to read any conformations " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
}

///////////////////////////////////////////////////////////////////////////////


void
read_list_anchor_resnums(
												 FArray1D_int & list_anchor_resnums
												 )
{

	std::string filename;
  filename = stringafteroption( "list_anchor_resnums");

	utility::io::izstream infile ( filename );
  if ( ! infile ) {
		std::cout << "read_list_anchor_resnums:"
              << " cannot open file " << filename
              << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }

  int n_lig = 0;
	std::string line;
  while( getline( infile, line ) ) {
		std::string blank(line.size(),' ');
    if ( line == blank ) continue;
		std::istringstream line_stream( line );
    ++n_lig;
    list_anchor_resnums.redimension( n_lig );
    line_stream >> list_anchor_resnums( n_lig );
		std::cout << "n_lig, list_anchor_resnums " << I( 5, n_lig ) << " "
              << SS( list_anchor_resnums( n_lig ))  << std::endl;
  }

	if ( n_lig > param::MAX_N_LIG ) {
		std::cout << "ERROR in read_list_anchor_resnums:: n_lig = " << n_lig << " is greater than param::MAX_N_LIG = " << param::MAX_N_LIG << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	if ( n_lig < 1 ) {
		std::cout << "ERROR in read_list_anchor_resnums:: failed to read any anchors " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
}
////////////////////////////////////////////////////////////////////////

void
setup_ligand_aa_for_trimer(
													 int const n_glycan_on_monomer
													 )
{
	//
	//Setup all glycan ligands as ligand_aa
	//  glycans on monomer 1 were setup as ligand_aa during read_ligand called during pose_from_pdb
	//  now we must copy global aa information for monomers 2 and 3.
	//

	//increase n_lig to include all glycans on trimer
	ligand::multi_lig::n_lig = 3*n_glycan_on_monomer;

	for ( int i_monomer = 2; i_monomer <= 3; i_monomer++ ) {
		for ( int i_lig = 1; i_lig <= n_glycan_on_monomer; i_lig++ ) {
			int aa_lig  = ligand::multi_lig::list_aa_lig( i_lig );
			int aav_lig = ligand::multi_lig::list_aav_lig( i_lig );
			//bills i_lig_new not used but represents lig1, lig2, lig3...lig50
			//			int i_lig_new   = i_lig  + (i_monomer-1)*n_glycan_on_monomer;
			int aa_lig_new  = aa_lig + (i_monomer-1)*n_glycan_on_monomer;
			int aav_lig_new = aav_lig;
			int n_atoms_lig = aaproperties_pack::properties_per_aa_aav::natoms( aa_lig, aav_lig );
			{//scope
				using namespace aaproperties_pack;
				nheavyatoms( aa_lig_new, aav_lig_new ) = nheavyatoms( aa_lig, aav_lig );
				natoms( aa_lig_new, aav_lig_new ) = 					natoms( aa_lig, aav_lig );

				for ( int i_atom = 1; i_atom <= n_atoms_lig; i_atom++ ) {
					atom_name( i_atom, aa_lig_new, aav_lig_new ) = atom_name( i_atom, aa_lig, aav_lig );
					fullatom_type( i_atom, aa_lig_new, aav_lig_new ) = fullatom_type( i_atom, aa_lig, aav_lig );
					atomic_charge( i_atom, aa_lig_new, aav_lig_new ) = atomic_charge( i_atom, aa_lig, aav_lig );
					//Do we have a problem with these??
					//									enable_ligaa_ns::lig_iocc_weight( i_atom ) = enable_ligaa_ns::lig_iocc_weight( i_atom );
					//									enable_ligaa_ns::lig_icharge( i_atom ) = enable_ligaa_ns::lig_icharge( i_atom );
				}

				nH_polar(  aa_lig_new, aav_lig_new ) = nH_polar(  aa_lig, aav_lig );
				nH_apolar( aa_lig_new, aav_lig_new ) = nH_apolar( aa_lig, aav_lig );
				nH_polar(  aa_lig_new, aav_lig_new ) = nH_polar(  aa_lig, aav_lig );
				for ( int i_atom = 1; i_atom <= nH_polar( aa_lig, aav_lig ); i_atom++ ) {
					Hpos_polar( i_atom, aa_lig_new, aav_lig_new ) = Hpos_polar( i_atom, aa_lig, aav_lig );
				}
				for ( int i_atom = 1; i_atom <= nH_apolar( aa_lig, aav_lig ); i_atom++ ) {
					Hpos_apolar( i_atom, aa_lig_new, aav_lig_new ) = Hpos_apolar( i_atom, aa_lig, aav_lig );
				}
				for ( int i_atom = 1; i_atom <= nH_aromatic( aa_lig, aav_lig ); i_atom++ ) {
					Hpos_aromatic( i_atom, aa_lig_new, aav_lig_new ) = Hpos_aromatic( i_atom, aa_lig, aav_lig );
				}
				nacceptors( aa_lig_new, aav_lig_new ) = nacceptors( aa_lig, aav_lig );
				for ( int i_atom = 1; i_atom <= nacceptors( aa_lig, aav_lig ); i_atom++ ) {
					accpt_pos( i_atom, aa_lig_new, aav_lig_new ) = accpt_pos( i_atom, aa_lig, aav_lig );
				}

				for ( int i_atom = 1; i_atom <= n_atoms_lig; i_atom++ ) {
					nbonded_neighbors( i_atom, aa_lig_new, aav_lig_new ) = nbonded_neighbors( i_atom, aa_lig, aav_lig );
					for ( int i_neib = 1; i_neib <= nbonded_neighbors( i_atom, aa_lig, aav_lig ); i_neib++ ) {
						bonded_neighbor( i_neib, i_atom, aa_lig_new, aav_lig_new ) = bonded_neighbor( i_neib, i_atom, aa_lig, aav_lig );
					}

					nhydrogens_on_atm( i_atom, aa_lig_new, aav_lig_new ) = nhydrogens_on_atm( i_atom, aa_lig, aav_lig );
					for ( int i_hydro = 1; i_hydro <= nhydrogens_on_atm( i_atom, aa_lig, aav_lig ); i_hydro++ ) {
						hydrogens_on_atm( i_hydro, i_atom, aa_lig_new, aav_lig_new ) = hydrogens_on_atm( i_hydro, i_atom, aa_lig, aav_lig );
					}

					//atom nums
					Hbase( i_atom, aa_lig_new, aav_lig_new ) = Hbase( i_atom, aa_lig, aav_lig );
					abase( i_atom, aa_lig_new, aav_lig_new ) = abase( i_atom, aa_lig, aav_lig );
					abase2( i_atom, aa_lig_new, aav_lig_new ) = abase2( i_atom, aa_lig, aav_lig );
				}//i_atom

			}//done filling globals, using aaproperties_pack namespace
		}//i_lig = 1 to n_glycan_on_monomer
	}//i_monomer = 2,3
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
convert_resnum_range_to_gly(
                            pose_ns::Pose & pose_in,
                            int const & resnum1,
                            int const & resnum2,
                            pose_ns::Pose & pose_out
                            )
{

  //
  //error check
  //
  int const nres_pose_in ( pose_in.total_residue() );
  if ( ( resnum1 > resnum2 ) || ( resnum1 < 1 ) || ( resnum2 > nres_pose_in ) ) {
		std::cout << "error convert_resnum_range_to_gly "
              << resnum1 << " " << resnum2 << " " << nres_pose_in << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
	std::cout << "convert_resum_range_to_gly: " << resnum1 << " " << resnum2 << std::endl;
  //
  //fill misc arrays from this pose
  //
  //  Note: must do this (b/c sets total_residue) before setting design_matrix
  //no longer need to go through misc, directly submit pose to pack_rotamers
	//  pose_to_misc( pose_in );
	pose_out = pose_in;

  //
  //Set design globals for design_matrix to control which aa allowed at which positions.
  //

	design::use_design_matrix = true;
	design::design_matrix = false; //design_matrix( MAX_AA(), MAX_RES() );

  //
  //only allow gly in the range resnum1 - resnum2
  //
  for ( int ires = resnum1 ; ires <= resnum2 ; ++ires ) {
		design::design_matrix( param_aa::aa_gly, ires ) = true;
  }

  //
  //variables to set for the call to pack_rotamers
  //
	std::string pack_mode( "design" );
  bool make_output_file( false );
  FArray1D_bool allow_repack_local( param::MAX_RES()(), false );
  bool include_current( false );//not need to be true for gly
  bool include_extra ( false );
  FArray2D_int extra_rot( param::MAX_CHI, param::MAX_RES()() ); // dummy variable in this instance
  FArray2D_float extra_chi( param::MAX_CHI, param::MAX_RES()() ); // dummy variable in this instance

  //yl, Create PackerTask and setup values before pass into pack_rotamers
  PackerTask Task;
  Task.set_task( pack_mode, make_output_file, allow_repack_local,
                 include_current, include_extra, extra_rot, extra_chi);
  //bk set variables that specify which residues to vary
  Task.setup_residues_to_vary();
  //
  //design using misc arrays
  //
	//  pack_rotamers( misc::res, misc::full_coord, misc::res_variant,
  //               misc::total_residue, misc::phi, misc::psi, Task );
	pack_rotamers( pose_out, Task );

  //
  //retrieve design from misc.
  //
	//  bool const fullatom( true );
	//  bool const ideal_pose( false );
	//  bool const coords_init( true );
	//  pose_from_misc( pose_out, fullatom, ideal_pose, coords_init );
}

////////////////////////////////////////////////////////////////////////
void
construct_pose_complex_from_p1_p2(
                                  pose_ns::Pose const & pose1,
                                  pose_ns::Pose const & pose2,
                                  pose_ns::Pose & pose3
                                  )
{
  int const nres1 = pose1.total_residue();
  int const nres2 = pose2.total_residue();
  int const nres3 = nres1 + nres2;

  pose3.simple_fold_tree( nres3 );
  pose3.set_fullatom_flag( true, false );// set fullatom and do not repack

  FArray3D_float fcoord3( 3, param::MAX_ATOM(), nres3 );

  int ires3 = 0;
  for ( int ires = 1; ires <= nres1; ires++ ) {
    ++ires3;
    pose3.set_res        ( ires3, pose1.res( ires ) );
    pose3.set_res_variant( ires3, pose1.res_variant( ires ));
    pose3.set_phi        ( ires3, pose1.phi( ires ) );
    pose3.set_psi        ( ires3, pose1.psi( ires ) );
    pose3.set_omega      ( ires3, pose1.omega( ires ) );
    pose3.set_secstruct  ( ires3, pose1.secstruct( ires ) );
    pose3.set_name       ( ires3, pose1.name( ires ) );
    int const aa( pose1.res( ires ) );
    int const aav( pose1.res_variant( ires ));
    for ( int i_atom = 1; i_atom <= aaproperties_pack::natoms( aa, aav ); ++i_atom ) {
      for ( int k = 1; k <= 3; k++ ) {
        fcoord3( k, i_atom, ires3 ) = pose1.full_coord()( k, i_atom, ires );
      }
    }
  }

  for ( int ires = 1; ires <= nres2; ires++ ) {
    ++ires3;
    pose3.set_res        ( ires3, pose2.res( ires ) );
    pose3.set_res_variant( ires3, pose2.res_variant( ires ));
    pose3.set_phi        ( ires3, pose2.phi( ires ) );
    pose3.set_psi        ( ires3, pose2.psi( ires ) );
    pose3.set_omega      ( ires3, pose2.omega( ires ) );
    pose3.set_secstruct  ( ires3, pose2.secstruct( ires ) );
    pose3.set_name       ( ires3, pose2.name( ires ) );
    int const aa( pose2.res( ires ) );
    int const aav( pose2.res_variant( ires ));
    for ( int i_atom = 1; i_atom <= aaproperties_pack::natoms( aa, aav ); ++i_atom ) {
      for ( int k = 1; k <= 3; k++ ) {
        fcoord3( k, i_atom, ires3 ) = pose2.full_coord()( k, i_atom, ires );
			}
		}
	}


  //Error check
  //
  if ( ! ( ires3 == nres3 ) ) {
		std::cout << "error setting up cmplx pose from p1 p2" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
  //
  //Setup Epos for the new pose
  //
  FArray3D_float Epos3( 3, param::MAX_POS, nres3 );//MAX_POS = 5

  for ( int ires = 1; ires <= nres3; ires++ ) {
    for ( int k = 1; k <= 3; k++ ) {
      Epos3(k,1,ires) = fcoord3(k,1,ires);
      Epos3(k,2,ires) = fcoord3(k,2,ires);
      Epos3(k,4,ires) = fcoord3(k,3,ires);
      Epos3(k,5,ires) = fcoord3(k,4,ires);
      Epos3(k,3,ires) = fcoord3(k,5,ires);
		}
	}
  //finish by setting coords
  //
  bool const ideal_pose ( false );
  bool const check_missing ( false );
  pose3.set_coords( ideal_pose, Epos3, fcoord3, check_missing );
}
////////////////////////////////////////////////////////////////////////
//dumb but convenient way to change coords in a pose
void
orient_pose(
						FArray3D_float const & coords,
						pose_ns::Pose & pose
						)
{
	int const nres = pose.total_residue();
	FArray3D_float Epos( 3, param::MAX_POS, nres );//MAX_POS = 5
	for ( int i = 1; i <= nres; ++i ) {
		for ( int k = 1; k <= 3; ++k ) {
			Epos(k,1,i) = coords(k,1,i);
			Epos(k,2,i) = coords(k,2,i);
			Epos(k,4,i) = coords(k,3,i);
			Epos(k,5,i) = coords(k,4,i);
			Epos(k,3,i) = coords(k,5,i);
		}
	}
	bool const ideal_pose = false;
	bool const check_missing = false;
	pose.set_coords( ideal_pose, Epos, coords, check_missing );
}
