// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8698 $
//  $Date: 2006-06-05 22:50:03 -0700 (Mon, 05 Jun 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_hiv_trimer
#define INCLUDED_hiv_trimer


// Rosetta Headers
//#include "loop_class.h"
#include "pose_fwd.h"
#include "triplet/triplet.h"


#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <string>

void
hiv_trimer();

void
identify_interface_positions(
                             pose_ns::Pose & pose,        //trimer of proteins at minimum
                             bool const & glycan_attached,    // is glycan also attached?
                             bool const & Ab_attached,  // is antibody (1 copy, to monomer 1) also attached?
                             int const & nres_monomer,
                             int const & nres_glycan,
                             int const & nres_Ab,
                             FArray1D_bool const & natro_position, // positions on protein_trimer that cannot be minimized/repacked
                             FArray1D_bool & interface_position,
                             int & n_interface_positions
                             );


void
update_conformation_already_scored(
                                   int const & n,                 //number for conformation just completed
                                   std::string const & fullname  //path + filename for checkpoint file
                                   );
bool
check_conformation_already_scored(
                                  int const & no,         //input: number of the current conformation
                                  std::string const & fullname  //input: path + filename to checkpoint file.
                                  );


void
set_Ab_coords_for_trimer(
                         pose_ns::Pose & pose,
                         FArray2D_double const & Rxyz,
                         FArray2D_double const & translation,
                         FArray3D_float & coords_out
                         );

void
set_glycan_coords_for_trimer(
                             int const & n_glycan_on_monomer,
                             FArray2D_double const & Rz120,
                             FArray2D_double const & Rxyz,
                             FArray2D_double const & translation,
                             FArray4D_float & glycan_coords
                             );


void
make_monomer_w_glycan(
											pose_ns::Pose & monomer_pose,
											int const n_glycan_on_monomer,
											FArray3D_float const & glycan_coords,
											bool const & anchor_resnums_read_from_file,
											FArray1D_int const & list_anchor_resnums_monomer,
											pose_ns::Pose & monomer_w_glycan_pose
											);

void
make_glycan_only_monomer(
												 int const n_glycan_on_monomer,
												 FArray3D_float const & glycan_coords,
												 pose_ns::Pose & glycan_only_monomer_pose
												 );

void
make_glycan_only_trimer(
                        int const n_glycan_on_monomer,
                        FArray4D_float const & glycan_coords,
                        pose_ns::Pose & glycan_only_trimer_pose
												);

void
make_trimer_w_glycan(
                     pose_ns::Pose & trimer_pose,
                     int const n_glycan_on_monomer,
                     FArray4D_float const & glycan_coords,
                     bool const & anchor_resnums_read_from_file,
                     FArray1D_int const & list_anchor_resnums_monomer,
                     pose_ns::Pose & trimer_w_glycan_pose
                     );

void
make_trimer_w_glycan_w_Ab(
                          pose_ns::Pose & trimer_w_glycan_pose,               //trimer_w_glycan
                          pose_ns::Pose & Ab_pose,                   //Ab_pose
                          pose_ns::Pose & trimer_w_glycan_w_Ab_pose
													);

void
compute_rot_trans_for_trimer(
                             float const & rot_angle_X,
                             float const & rot_angle_Y,
                             float const & rot_angle_Z,
                             float const & trans_dist,
                             FArray2D_double & Rxyz,
                             FArray2D_double & translation
                             );

void
make_trimer_pose(
                 pose_ns::Pose & monomer_pose,
                 FArray2D_double const & Rz120,
                 FArray2D_double const & Rxyz,
                 FArray2D_double const & translation,
                 pose_ns::Pose & trimer_pose
                 );

void
output_lig_only_pdb(
                    int const aa,
                    int const aav,
                    FArray2D_float coords,
                    std::string filename
                    );

void
read_list_trimer_conformations(
                               int & n_trimer_conformations,
                               FArray2D_float & list_trimer_conformations
                               );

void
read_list_anchor_resnums(
                         FArray1D_int & list_anchor_resnums
                         );

void
setup_ligand_aa_for_trimer(
                           int const n_glycan_on_monomer
                           );

void
convert_resnum_range_to_gly(
                            pose_ns::Pose & pose_in,
                            int const & resnum1,
                            int const & resnum2,
                            pose_ns::Pose & pose_out
                            );


void
construct_pose_complex_from_p1_p2(
                                  pose_ns::Pose const & pose1,
                                  pose_ns::Pose const & pose2,
                                  pose_ns::Pose & pose3
                                  );

void
orient_pose(
            FArray3D_float const & coords,
            pose_ns::Pose & pose
            );


#endif
