// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12517 $
//  $Date: 2007-02-06 17:49:37 -0800 (Tue, 06 Feb 2007) $
//  $Author: snoeyink $


// Rosetta Headers
#include "ligand_ns.h"
#include "aaproperties_pack.h"
#include "ligand.h"
#include "param.h"
#include "atom.h"
#include "BondSmallMolecule.h"
#include "design.h"
#include "etable.h"
#include "hbonds.h"
#include "hbonds_ns.h"
#include "FArray_xyz_functions.h"
#include "files_paths.h"
#include "random_numbers.h"
#include "runlevel.h"
#include "LigandAtomPairEnergy.h"
#include "make_pdb.h"
#include "orient_rms.h"
#include "param_pack.h"

//utility Headers
#include "orstream.h"
#include "ozstream.h"
#include "utility/constants.h"

// Triplet Headers
#include "triplet/triplet_functions.h"
#include "triplet/xyzVector.h"
#include "triplet/xyzMatrix.h"
#include "triplet/xyzVector_io.h" //kwk needed only for debugging

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

// C++ standard template headers
#include <vector>
#include <cmath>
#include <list>
#include <map>


// Using
using namespace param;



//==============================================================================
//
//     ligand_ns
//
//		Jens Meiler April 2003
//		Kristian Kaufmann November 2005
//
//==============================================================================

//mj fields for hetero atoms, introduced for loop building and ligand docking
//mj and side chain packing for loop building only a simplified clash check is
//mj performed.  for this all atoms are mapped on atom types
//mj 1=N,2=CA,3=CB,4=C,5=O in hetero_atom_cent for docking/packing ROSETTA full
//mj atom types are necesarry => all atoms need to be mapped on the 25 ROSETTA
//mj full atom types in hetero_atom_type! this type is obtained from the PDB
//mj name of the atom.

// Default Constructor for Ligand object
	Ligand::Ligand(){
		fix_ligand_HO=false;
		use_input_ligand=false;
		recompute_ligand_interface=true;
		hetero_born_radius.dimension(param::HETERO_ATOM_MAX());
		virtual_atom_bnd.dimension( param::HETERO_ATOM_MAX());
		virtual_atom_map.dimension( param::HETERO_ATOM_MAX());
		hetero_atom_resid.dimension( param::HETERO_ATOM_MAX(),
			std::string( 3, ' ' ) );
		hetero_atom_hbond_acc.dimension( 3, param::HETERO_ATOM_MAX() );
		hetero_atom_hbond_don.dimension( 4, param::HETERO_ATOM_MAX() );
		anchor_state=0;
		number_of_conformations=0;
		lig_repE=0.0;
		lig_atrE=0.0;
		lig_solE=0.0;
		lig_couE=0.0;
		lig_h2oE=0.0;
		lig_hbE=0.0;
		lig_virE=0.0;
		lig_sumE=0.0;
		lig_sasE=0.0;

		lig_int_repE=0.0;
		lig_int_atrE=0.0;
		lig_int_solvE=0.0;
		lig_int_dihedE=0.0;
		lig_int_coulombE=0.0;
		lig_int_hbE=0.0;

		virtual_atom_count = 0;
		hetero_atom_total_charge = float( 0);
		hetero_atom_hbond_acc_count = 0;
		hetero_atom_hbond_don_count = 0;
		anchor_first.assign(0.0,0.0,0.0);
		anchor_second.assign(0.0,0.0,0.0);
		anchor_third.assign(0.0,0.0,0.0);
		anchor_first_best.assign(0.0,0.0,0.0);
		anchor_second_best.assign(0.0,0.0,0.0);
		anchor_third_best.assign(0.0,0.0,0.0);
		anchor_first_start.assign(0.0,0.0,0.0);
		anchor_second_start.assign(0.0,0.0,0.0);
		anchor_third_start.assign(0.0,0.0,0.0);
		anchor_state=0;
	}

	// Copy Constructor for Ligand object
	Ligand::Ligand( Ligand & p){
		fix_ligand_HO=p.fix_ligand_HO;
		use_input_ligand=p.use_input_ligand;
		recompute_ligand_interface=p.recompute_ligand_interface;
		hetero_born_radius=p.hetero_born_radius;
		virtual_atom_bnd=p.virtual_atom_bnd;
		virtual_atom_map=p.virtual_atom_map;
		hetero_atom_resid=p.hetero_atom_resid;
		hetero_atom_hbond_acc=p.hetero_atom_hbond_acc;
		hetero_atom_hbond_don=p.hetero_atom_hbond_don;
		lig_repE=p.lig_repE;
		lig_atrE=p.lig_atrE;
		lig_solE=p.lig_solE;
		lig_couE=p.lig_couE;
		lig_h2oE=p.lig_h2oE;
		lig_hbE=p.lig_hbE;
		lig_virE=p.lig_virE;
		lig_sumE=p.lig_sumE;
		lig_sasE=p.lig_sasE;

		lig_int_repE=p.lig_int_repE;
		lig_int_atrE=p.lig_int_atrE;
		lig_int_solvE=p.lig_int_solvE;
		lig_int_dihedE=p.lig_int_dihedE;
		lig_int_coulombE=p.lig_int_coulombE;
		lig_int_hbE=p.lig_int_hbE;

		virtual_atom_count=p.virtual_atom_count;
		hetero_atom_total_charge=p.hetero_atom_total_charge;
		hetero_atom_hbond_acc_count=p.hetero_atom_hbond_acc_count;
		hetero_atom_hbond_don_count=p.hetero_atom_hbond_don_count;
		anchor_first_best=p.anchor_first_best;
		anchor_second_best=p.anchor_second_best;
		anchor_third_best=p.anchor_third_best;
		anchor_first_start=p.anchor_first_start;
		anchor_second_start=p.anchor_second_start;
		anchor_third_start=p.anchor_third_start;
		anchor_first=p.anchor_first;
		anchor_second=p.anchor_second;
		anchor_third=p.anchor_third;
		anchor_state=p.anchor_state;
		number_of_conformations=p.number_of_conformations;

		for ( size_t i=0; i<p.atom_vector.size(); i++){
			atom_vector.push_back(new Atom(*(p.atom_vector[i])));
		}
		for ( size_t i=0; i<p.best_coord.size(); i++){
			best_coord.push_back(p.best_coord[i]);
		}
		for ( size_t i=0; i<p.best_bonds.size(); i++){
			start_coord.push_back(p.best_bonds[i]);
		}
		for ( size_t i=0; i<p.start_bonds.size(); i++){
			start_coord.push_back(p.start_bonds[i]);
		}
		for ( size_t i=0; i<p.start_coord.size(); i++){
			start_coord.push_back(p.start_coord[i]);
		}

		std::list<triplet::xyzVector < size_t > > bond_map;
		p.get_bond_map(bond_map);
		setup_bond_graph( bond_map,false);
		calculate_internal_coordinates(true);
	}
	Ligand & Ligand::operator=(Ligand & p){
		if(this!=&p){
			fix_ligand_HO=p.fix_ligand_HO;
		    use_input_ligand=p.use_input_ligand;
			recompute_ligand_interface=p.recompute_ligand_interface;
			hetero_born_radius=p.hetero_born_radius;
			virtual_atom_bnd=p.virtual_atom_bnd;
			virtual_atom_map=p.virtual_atom_map;
			hetero_atom_resid=p.hetero_atom_resid;
			hetero_atom_hbond_acc=p.hetero_atom_hbond_acc;
			hetero_atom_hbond_don=p.hetero_atom_hbond_don;
			lig_repE=p.lig_repE;
			lig_atrE=p.lig_atrE;
			lig_solE=p.lig_solE;
			lig_couE=p.lig_couE;
			lig_h2oE=p.lig_h2oE;
			lig_hbE=p.lig_hbE;
			lig_virE=p.lig_virE;
			lig_sumE=p.lig_sumE;
			lig_sasE=p.lig_sasE;

			lig_int_repE=p.lig_int_repE;
			lig_int_atrE=p.lig_int_atrE;
			lig_int_solvE=p.lig_int_solvE;
			lig_int_dihedE=p.lig_int_dihedE;
			lig_int_coulombE=p.lig_int_coulombE;
			lig_int_hbE=p.lig_int_hbE;

			virtual_atom_count=p.virtual_atom_count;
			hetero_atom_total_charge=p.hetero_atom_total_charge;
			hetero_atom_hbond_acc_count=p.hetero_atom_hbond_acc_count;
			hetero_atom_hbond_don_count=p.hetero_atom_hbond_don_count;
			anchor_first_best=p.anchor_first_best;
			anchor_second_best=p.anchor_second_best;
			anchor_third_best=p.anchor_third_best;
			anchor_first_start=p.anchor_first_start;
			anchor_second_start=p.anchor_second_start;
			anchor_third_start=p.anchor_third_start;
			anchor_first=p.anchor_first;
			anchor_second=p.anchor_second;
			anchor_third=p.anchor_third;
			anchor_state=p.anchor_state;
			number_of_conformations=p.number_of_conformations;

			for ( size_t i=0; i<p.atom_vector.size(); i++){
				atom_vector.push_back(new Atom(*(p.atom_vector[i])));
			}
			for ( size_t i=0; i<p.best_coord.size(); i++){
				best_coord.push_back(p.best_coord[i]);
			}
			for ( size_t i=0; i<p.start_coord.size(); i++){
				start_coord.push_back(p.start_coord[i]);
			}
			for ( size_t i=0; i<p.best_bonds.size(); i++){
				start_coord.push_back(p.best_bonds[i]);
			}
			for ( size_t i=0; i<p.start_bonds.size(); i++){
				start_coord.push_back(p.start_bonds[i]);
			}

			std::list<triplet::xyzVector < size_t > > bond_map;
			p.get_bond_map(bond_map);
			setup_bond_graph( bond_map,false);

			calculate_internal_coordinates(true);



			return *this;
		}
		else{

			return *this;
		}

	}

	// Destructor
	Ligand::~Ligand(){
		for(std::vector<ligand::Ligand_AtomOP >::iterator c_atom=atom_vector.begin();
			c_atom!=atom_vector.end(); c_atom++){
		// Deletes memory associated with Atom * (*c_atom)
			delete (*c_atom);
		}
		atom_vector.clear();
		for(std::vector<ligand::Ligand_BondAP>::iterator c_bond=bond_vector.begin();
			c_bond!=bond_vector.end(); c_bond++){
		// Deletes memory associated with Atom * (*c_atom)
			delete (*c_bond);
		}
		bond_vector.clear();

	}

// =============================================================================
//     function to transfer trail coordinates to FArray2D_float
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_FArray2D_of_coordinates
///
/// @brief
///		Function for transfer of coordinates to FArray2D for compatibility
///		with other rosetta functions
///
/// @detailed
///
/// @param
///		in standard vector of pointers to Atoms
///		out FArray2D_float (passed by reference)
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified 11-15-2005
////////////////////////////////////////////////////////////////////////////////
	void
	Ligand::get_FArray2D_of_coordinates(
		const std::vector < ligand::Ligand_AtomOP > & ligand_atom,
		FArray2D_float & het_coord){
					het_coord.dimension(3,ligand_atom.size());
					std::vector< ligand::Ligand_AtomOP >::const_iterator i;
					int j=1;
					for( i=ligand_atom.begin(); i !=ligand_atom.end();i++){
						FArray1D_float c_coord(3);
						copy_to_FArray(
							(*i)->get_coordinates(), c_coord);
						for(int k=1;k<4;k++){
							het_coord(k,j)=c_coord(k);
						}
						j++;
	                }
				return ;
		}

// =============================================================================
//     void to supply FArray1D of heteroatom charges
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_FArray1D_of_charge
///
/// @brief
///     void to supply FArray of charges required by some Rosetta functions
///
/// @detailed
///
/// @param
///		in standard vector of pointers to Atoms
///		out FArray1D_float (passed by reference)
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Krsitian Kaufmann
/// @last_modified	11-15-2005
////////////////////////////////////////////////////////////////////////////////
	void
	Ligand::get_FArray1D_of_charge(
		const std::vector < ligand::Ligand_AtomOP > & ligand_atom,
		FArray1D_float & het_charge
	){
		het_charge.dimension(ligand_atom.size());
		for (size_t j=0;j<ligand_atom.size();++j){
			het_charge(j+1)=float(ligand_atom[j]->get_partial_charge());
		}
		return;
	}
// =============================================================================
//     void to supply an FArray1D_int of atom types
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_FArray1D_of_atom_type
///
/// @brief
///     supplies FArray of atom types for use in Rosetta Functions
///
/// @detailed
///
/// @param
///		in standard vector of pointers to Atoms
///		out FArray1D_int (passed by reference)
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	11-15-2005
////////////////////////////////////////////////////////////////////////////////
void
Ligand::get_FArray1D_of_atom_type(
	const std::vector < ligand::Ligand_AtomOP > & ligand_atom,
	FArray1D_int & het_atom_type
){
	het_atom_type.dimension(ligand_atom.size());
	for (size_t j=0; j< ligand_atom.size(); ++j){
		het_atom_type(j+1)=ligand_atom[j]->get_ros_atom_type();
	}
	return;
}

// =============================================================================
//     int to setup_bond_graph
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin setup_bond_graph
///
/// @brief
///		given a nonempty array of atom in atom_vector vector
///		will return
///
/// @detailed
///
/// @param
/// @global_read
///		reads from atom_vector
/// @global_write
///		writes to bond_vector
///		writes to trial_roots
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	11-29-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::setup_bond_graph(){
	float atom_distance;
	float max_bond_length;
	int index=0;


	if(atom_vector.size()>200){
		std::cout << "Number of atoms is too great. Try using an mdlfile instead." << std::endl;
		return -1;
	}

	trial_roots.clear();
	bond_vector.clear();
	//following for loop creates bonds from coordinates of atoms in atom_vector
	for(ligand::Atom_Itr start_atom=atom_vector.begin();
		start_atom != atom_vector.end();
		start_atom++){ // Loops over all atoms to ensure each atom is tested for
			//bonding
		std::list< ligand::Ligand_AtomOP >current_atom;
		if((*start_atom)->Is_Root_Atom()){ // keeps while loop from starting on
			current_atom.push_back(*start_atom);// atoms that have already been
			if(current_atom.back()->get_index()==9999){
				//std::cout << current_atom.back()->get_index() << std::endl;
				current_atom.back()->set_index(index);// detected.
				index++;
				//std::cout << current_atom.back()->get_index() << std::endl;
			}
		}
		while( !current_atom.empty()){
			for(ligand::Atom_Itr next_atom=atom_vector.begin();
			next_atom != atom_vector.end();
			next_atom++){ // Loops over all atoms to check for bonding to current
				// atom line at close of loop causes depth first construction
				if (current_atom.back() != (*next_atom) && // checks if bond detection is needed
					!Are_Bonded(current_atom.back(),(*next_atom))){
					atom_distance = distance(
						current_atom.back()->get_coordinates(),
						(*next_atom)->get_coordinates());
					max_bond_length=atom_chem::get_max_bond_length(
						current_atom.back()->get_element_type(),
						(*next_atom)->get_element_type());
					if ( atom_distance < max_bond_length ){
					//	std::cout << "Constructing Bond between";
					//	std::cout << (*(current_atom.back()))->get_pdb_number() << " ";
					//	std::cout << (*next_atom)->get_pdb_number() << std::endl;
						bond_vector.push_back(new BondSmallMolecule(current_atom.back(),(*next_atom)));
						bond_vector.back()->set_bondtype(atom_chem::SINGLE);
						if((*next_atom)->get_index()==9999){
						//std::cout << (*next_atom)->get_index() << std::endl;
						(*next_atom)->set_index(index);
						index++;
						//std::cout << (*next_atom)->get_index() << std::endl;
						}
						// following if else statements check for multiple bonds
						if( current_atom.back()->get_element_type() == atom_chem::CARBON &&
							(*next_atom)->get_element_type() == atom_chem::CARBON){
								if( atom_distance < 1.45 && 1.38 < atom_distance ){
									bond_vector.back()->set_bondtype(atom_chem::AROMATIC);
								}else if( atom_distance < 1.38 &&
									1.26 < atom_distance){
								 	bond_vector.back()->set_bondtype(atom_chem::DOUBLE);
								}else if( atom_distance < 1.26){
									bond_vector.back()->set_bondtype(atom_chem::TRIPLE);
								}
						}// Carbon Carbon
						else if(( current_atom.back()->get_element_type()== atom_chem::CARBON &&
							(*next_atom)->get_element_type()== atom_chem::NITROGEN ) || (
							(*next_atom)->get_element_type()== atom_chem::CARBON &&
							(current_atom.back())->get_element_type()== atom_chem::NITROGEN)){
							if( atom_distance < 1.40 && 1.20 < atom_distance ){
									bond_vector.back()->set_bondtype(atom_chem::AROMATIC);
							}else if( atom_distance < 1.20 &&
								1.18 < atom_distance ){
									bond_vector.back()->set_bondtype(atom_chem::DOUBLE);
							}else if( atom_distance < 1.18){
								bond_vector.back()->set_bondtype(atom_chem::TRIPLE);
							}
						}// Carbon Nitrogen bond
						else if(( current_atom.back()->get_element_type()== atom_chem::CARBON &&
							(*next_atom)->get_element_type()== atom_chem::OXYGEN ) || (
							(*next_atom)->get_element_type()== atom_chem::CARBON &&
							(current_atom.back())->get_element_type()== atom_chem::OXYGEN)){
							if( atom_distance < 1.30){
								bond_vector.back()->set_bondtype(atom_chem::DOUBLE);
							}
						}// Carbon Oxygen bond
						else if(( current_atom.back()->get_element_type()== atom_chem::PHOSPHORUS
							&& (*next_atom)->get_element_type()== atom_chem::OXYGEN ) || (
							(*next_atom)->get_element_type()== atom_chem::PHOSPHORUS &&
							(current_atom.back())->get_element_type()== atom_chem::OXYGEN)){
							if( atom_distance < 1.55){
								bond_vector.back()->set_bondtype(atom_chem::DOUBLE);
							}
						}// Phosphorus Oxygen bond
						else if(( current_atom.back()->get_element_type()== atom_chem::SULFUR &&
							(*next_atom)->get_element_type()== atom_chem::NITROGEN ) || (
							(*next_atom)->get_element_type()== atom_chem::SULFUR &&
							(current_atom.back())->get_element_type()== atom_chem::NITROGEN)){
							if( atom_distance < 1.65){
								bond_vector.back()->set_bondtype(atom_chem::DOUBLE);
							}
						}// Sulfur Nitrogen bond
						else if(( current_atom.back()->get_element_type()== atom_chem::SULFUR &&
							(*next_atom)->get_element_type()== atom_chem::OXYGEN ) || (
							(*next_atom)->get_element_type()== atom_chem::SULFUR &&
							(current_atom.back())->get_element_type()== atom_chem::OXYGEN)){
							if( atom_distance < 1.60){
								bond_vector.back()->set_bondtype(atom_chem::DOUBLE);
							}
						}// Sulfur Oxygen bond
						else if( current_atom.back()->get_element_type()== atom_chem::NITROGEN &&
							(*next_atom)->get_element_type()== atom_chem::NITROGEN ){
							if( atom_distance < 1.23){
								bond_vector.back()->set_bondtype(atom_chem::DOUBLE);}
						}// Nitrogen-Nitrogen
						else if(( current_atom.back()->get_element_type()== atom_chem::NITROGEN &&
							(*next_atom)->get_element_type()==atom_chem::OXYGEN ) || (
							(*next_atom)->get_element_type()== atom_chem::NITROGEN &&
							(current_atom.back())->get_element_type()== atom_chem::OXYGEN)){
							if( atom_distance < 1.19){
								bond_vector.back()->set_bondtype(atom_chem::DOUBLE);
							}
						}// Carbon Nitrogen
						current_atom.push_back(*next_atom);
						next_atom=atom_vector.begin();

					}
				}
			}//next atom loop
			current_atom.pop_back();
		}
	}//start atom loop
	// the following for loop checks for root atoms.
	std::cout << "Checking for multiple ligands." << std::endl;
	for (ligand::Atom_Itr start_atom=atom_vector.begin();
		start_atom!=atom_vector.end();
		start_atom++){
		if ((*start_atom)->Is_Root_Atom()){trial_roots.push_back((*start_atom));}
	}
	if(runlevel_ns::runlevel >= runlevel_ns::inform ){
		std::cout << "There are " << trial_roots.size() << " fragments in the ligand." << std::endl;
	}
	//following loops set ring structures rigid based on the hack in the bond
	// constructor that sets rotable false when a bond connects two branches
	// bond tree has constructed. The implementation envisioned below relies
	// on the depth first bond search implemented above. More to the point
	// if the branch connecting bond doesn't occur between a child atom and
	// another atom further towards the root on the same branch the algorithm
	// won't work.

	std::vector< ligand::Ligand_BondAP > merging_bonds;
	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end();
		current_bond++){
		if (!(*current_bond)->IsRotable()){
			merging_bonds.push_back((*current_bond));
		}
	}
	std::cout << "Setting rings rigid." << std::endl;
	for(ligand::Bond_Itr current_bond=merging_bonds.begin();
		current_bond!=merging_bonds.end();
		current_bond++){
		ligand::Ligand_AtomOP patom1, patom2;
		(*current_bond)->bonded_atoms(patom1,patom2);
		std::list< ligand::Ligand_BondAP > rigid_bonds;
		rigid_bonds.clear();
		int success= set_ring_rigid((*(*current_bond)),patom2, rigid_bonds);
		if (success!=0){ std::cerr << "set_ring_rigid failed." << std::endl;
		}
	}
	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end(); current_bond++){
		if((*current_bond)->get_bondtype()==atom_chem::DOUBLE ||
			(*current_bond)->get_bondtype()==atom_chem::TRIPLE ||
			(*current_bond)->get_bondtype()==atom_chem::AROMATIC){
			(*current_bond)->set_rotability(false);
		}
	}
	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end(); current_bond++){

		if((*current_bond)->IsRotable()){
			ligand::Ligand_AtomOP atom1, atom2;
			(*current_bond)->bonded_atoms(atom1, atom2);
			if(atom1->get_element_type()==atom_chem::HYDROGEN ||
					atom2->get_element_type()==atom_chem::HYDROGEN){

					(*current_bond)->set_rotability(false);
			}else{
				std::list< ligand::Ligand_BondAP > child_bonds;
				atom2->get_childbonds(child_bonds);
				bool not_all_hydrogens=false;
				for(std::list< ligand::Ligand_BondAP >::iterator c_bond=child_bonds.begin();
						c_bond!=child_bonds.end(); c_bond++){

						(*c_bond)->bonded_atoms(atom2, atom1);
						if(atom1->get_element_type()!=atom_chem::HYDROGEN){
							not_all_hydrogens=true;
						}
				}
				(*current_bond)->set_rotability(not_all_hydrogens);
				if(child_bonds.size()==0){
					(*current_bond)->set_rotability(false);
				}
			}
		}
	}

	std::cout << "Exit setup_bond_graph." << std::endl;
	return 1;

}

// =============================================================================
//     int to setup_bond_graph(bond_map)
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin setup_bond_graph
///
/// @brief
///		given a nonempty array of atom in atom_vector vector
///		will return
///
/// @detailed
///
/// @param -[in]- vector of xyzVector<size_t> bond_map
/// @global_read
///		reads from atom_vector
/// @global_write
///		writes to bond_vector
///		writes to trial_roots
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	2-9-2006
////////////////////////////////////////////////////////////////////////////////
int
Ligand::setup_bond_graph(
	std::list< triplet::xyzVector < size_t > > & bond_map,
	int root_atom
){
	size_t i, index;
	index=1;
	triplet::xyzVector<size_t> current_bond;
	std::list< size_t > atom_branch;
	if(root_atom > 0 && size_t(root_atom) < atom_vector.size()){
		atom_branch.push_back(root_atom);
	}else{
		atom_branch.push_back(get_atom_closest_to_centroid());
	}
	atom_vector[atom_branch.back()]->set_index(index);
	index++;
	bool bonds_left=true;
	bool found_bond=false;
	std::list< triplet::xyzVector< size_t > >::iterator
			bond_index=bond_map.begin();
	std::cout << "Setting up Chemical bond graph" << std::endl;
	while(bonds_left){
		i=0;
		std::list< triplet::xyzVector< size_t > >::iterator
			bond_index=bond_map.begin();
//		std::cout << "begin again" << std::endl;
		while(!found_bond && i<bond_map.size() ){
			current_bond=(*bond_index);
//      std::cout << (atom_branch.back()) << std::endl;
			if( current_bond.x()>=atom_vector.size() ||
			    current_bond.y()>=atom_vector.size() ||
			    current_bond.z()> 8){
				std::cout <<" An error was found in the values of the bond_map";
				std::cout << std::endl << "The values are as follows ";
				std::cout << current_bond.x() << " " << current_bond.y() << " ";
				std::cout << current_bond.z() << " from record" << i+1 << std::endl;
			}else if(atom_branch.back()==current_bond.x() &&
					!Are_Bonded(atom_vector[current_bond.x()],
								atom_vector[current_bond.y()])){

				bond_vector.push_back( new BondSmallMolecule(atom_vector[current_bond.x()],
						 atom_vector[current_bond.y()]));
				found_bond=true;
				if(atom_vector[current_bond.y()]->get_index()==9999){
					atom_vector[current_bond.y()]->set_index(index);
					index++;
				}

				if(find(atom_branch.begin(),atom_branch.end(),current_bond.y())
						== atom_branch.end()){
					atom_branch.push_back(current_bond.y());
//					this if block ensures that the depth first search doesn't
//					step back onto a parent_atom but rather continues the search
//					even though it made a bond.
				}

				if(current_bond.z()==0){
					(bond_vector.back())->set_bondtype(atom_chem::NO_BOND);
				}else if (current_bond.z()==1){
					(bond_vector.back())->set_bondtype(atom_chem::SINGLE);
				}else if(current_bond.z()==2){
					(bond_vector.back())->set_bondtype(atom_chem::DOUBLE);
				}else if(current_bond.z()==3){
					(bond_vector.back())->set_bondtype(atom_chem::TRIPLE);
				}else if(current_bond.z()==4){
					(bond_vector.back())->set_bondtype(atom_chem::AROMATIC);
				}else if(current_bond.z()==5){
					(bond_vector.back())->set_bondtype(atom_chem::CONJUGATED);
				}else if(current_bond.z()==6){
					(bond_vector.back())->set_bondtype(atom_chem::HYDROGEN_BOND);
				}else if(current_bond.z()==7){
					(bond_vector.back())->set_bondtype(atom_chem::METALLIC_BOND);
				}else if(current_bond.z()==8){
					(bond_vector.back())->set_bondtype(atom_chem::UNDEFINED_BOND_TYPE);
				}
				bond_map.remove(current_bond);
			}else if((atom_branch.back())==current_bond.y() && !Are_Bonded(atom_vector[current_bond.x()],
								atom_vector[current_bond.y()])){

				bond_vector.push_back( new BondSmallMolecule(atom_vector[current_bond.y()],
						 atom_vector[current_bond.x()]));
				found_bond=true;
				if(atom_vector[current_bond.x()]->get_index()==9999){
					atom_vector[current_bond.x()]->set_index(index);
					index++;
				}

				if(find(atom_branch.begin(),atom_branch.end(),current_bond.x())
						== atom_branch.end()){
					atom_branch.push_back(current_bond.x());
//					this if block ensures that the depth first search doesn't
//					step back onto a parent_atom but rather continues the search
//					even though it made a bond.
				}

				if(current_bond.z()==0){
					(bond_vector.back())->set_bondtype(atom_chem::NO_BOND);
				}else if (current_bond.z()==1){
					(bond_vector.back())->set_bondtype(atom_chem::SINGLE);
				}else if(current_bond.z()==2){
					(bond_vector.back())->set_bondtype(atom_chem::DOUBLE);
				}else if(current_bond.z()==3){
					(bond_vector.back())->set_bondtype(atom_chem::TRIPLE);
				}else if(current_bond.z()==4){
					(bond_vector.back())->set_bondtype(atom_chem::AROMATIC);
				}else if(current_bond.z()==5){
					(bond_vector.back())->set_bondtype(atom_chem::CONJUGATED);
				}else if(current_bond.z()==6){
					(bond_vector.back())->set_bondtype(atom_chem::HYDROGEN_BOND);
				}else if(current_bond.z()==7){
					(bond_vector.back())->set_bondtype(atom_chem::METALLIC_BOND);
				}else if(current_bond.z()==8){
					(bond_vector.back())->set_bondtype(atom_chem::UNDEFINED_BOND_TYPE);
				}
  				bond_map.remove(current_bond);
			}else{
			i++;
			bond_index++;
			if(i==bond_map.size()){
				atom_branch.pop_back();
			}}

			if(atom_branch.empty() && !bond_map.empty()){
				bool found_atom=false;
				size_t j=0;
				do{

					if(atom_vector[j]->get_index()==9999 &&	 !found_atom){
						atom_vector[j]->set_index(index);
						index++;
						atom_branch.push_back(j);
						found_atom=true;
					}
					j++;
				}while(!found_atom && j<=atom_vector.size());
			}// ensures that all atoms are checked for bonds
		}//found_bond
		if(bond_map.empty()){
			bonds_left=false;
		}else{
			found_bond=false;
		}
	}//bonds_left

  // the following for loop checks for root atoms.
	std::cout << "Checking for multiple ligands." << std::endl;
	for (ligand::Atom_Itr start_atom=atom_vector.begin();
		start_atom!=atom_vector.end();
		start_atom++){
		if ((*start_atom)->Is_Root_Atom()){trial_roots.push_back((*start_atom));}
	}
	if( runlevel_ns::runlevel >= runlevel_ns::inform ){
	std::cout << "There are "<< trial_roots.size() << " fragments" << std::endl;
	};
	//following loops set ring structures rigid based on the hack in the bond
	// constructor that sets rotable false when a bond connects to branches
	// bond tree has constructed. The implementation envisioned below relies
	// on the depth first bond search implemented above. More to the point
	// if the branch connecting bond doesn't occur between a child atom and
	// another atom further towards the root on the same branch the algorithm
	// won't work.

	std::vector< ligand::Ligand_BondAP > merging_bonds;
	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end();
		current_bond++){
		if (!(*current_bond)->IsRotable()){
			ligand::Ligand_AtomAP patom1, patom2;
			(*current_bond)->bonded_atoms(patom1,patom2);
			std::cout << patom1->get_pdb_number() << " " << patom2->get_pdb_number() << std::endl;
			merging_bonds.push_back((*current_bond));
		}
	}
	std::cout << "Setting rings rigid." << std::endl;
	for(ligand::Bond_Itr current_bond=merging_bonds.begin();
		current_bond!=merging_bonds.end();
		current_bond++){
		ligand::Ligand_AtomOP patom1, patom2;
		(*current_bond)->bonded_atoms(patom1,patom2);
		std::list< ligand::Ligand_BondAP > rigid_bonds;
		rigid_bonds.clear();
		int success= set_ring_rigid((*(*current_bond)),patom2, rigid_bonds);
		if (success!=0){ std::cerr << "set_ring_rigid failed. Error message " << success << std::endl;
		}
	}

	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end(); current_bond++){
		if((*current_bond)->get_bondtype()==atom_chem::DOUBLE ||
			(*current_bond)->get_bondtype()==atom_chem::TRIPLE ||
			(*current_bond)->get_bondtype()==atom_chem::AROMATIC){
			(*current_bond)->set_rotability(false);
		}
	}

	//this for loops prunes out bonds unneccessary to internal degrees of freedom.
	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end(); current_bond++){

		if((*current_bond)->IsRotable()){
			ligand::Ligand_AtomOP atom1,atom2;
			(*current_bond)->bonded_atoms(atom1, atom2);
			if(atom1->get_element_type()==atom_chem::HYDROGEN ||
					atom2->get_element_type()==atom_chem::HYDROGEN){

					(*current_bond)->set_rotability(false);
			}else{
				std::list< ligand::Ligand_BondAP > child_bonds;
				atom2->get_childbonds(child_bonds);
				bool not_all_hydrogens=false;
				for(std::list< ligand::Ligand_BondAP >::iterator c_bond=child_bonds.begin();
						c_bond!=child_bonds.end(); c_bond++){

						(*c_bond)->bonded_atoms(atom2, atom1);
						if(atom1->get_element_type()!=atom_chem::HYDROGEN){
							not_all_hydrogens=true;
						}
				}
				(*current_bond)->set_rotability(not_all_hydrogens);
				if(child_bonds.size()==0){
					(*current_bond)->set_rotability(false);
				}
			}
		}
	}
	if( runlevel_ns::runlevel >= runlevel_ns::inform ){
		std::cout << "atom1_pdb_number atom2_pdb_number Is_rotatable" << std::endl;
    for(ligand::Bond_Itr j=bond_vector.begin(); j!=bond_vector.end(); j++){
		  ligand::Ligand_AtomAP patom1, patom2;
		  (*j)->bonded_atoms(patom1,patom2);
		  std::cout << patom1->get_pdb_number() << " " << patom2->get_pdb_number() << " " << (*j)->IsRotable() << std::endl;
	  }
  }
	std::cout << "Bond graph setup complete." << std::endl;
	return 1;
}

// =============================================================================
//     int for get_bond_map
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_bond_map
///
/// @brief
///		constructs an mdl style bond_map from the bond_vector vector
///		that can be used to reconstruct the bond network of the ligand
///		when the ligand object is copied.
/// @detailed
///
/// @param
///
/// @global_read
///		reads from bond_vector in ligand object.
///   reads from atom_vector in ligand object.
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	11-29-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::get_bond_map(
	std::list< triplet::xyzVector<size_t> > & bond_map
){
	ligand::Ligand_AtomOP atom_1, atom_2;
	size_t atom_1_index=1;
	size_t atom_2_index=2;
	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end(); current_bond++){
				(*current_bond)->bonded_atoms(atom_1, atom_2);

				for(size_t i=0; i<atom_vector.size();i++){
					if(atom_vector[i]==atom_1){
						atom_1_index=i;
					}
					if(atom_vector[i]==atom_2){
						atom_2_index=i;
					}
				}
				///TODO change to switch statement kwk
				if( (*current_bond)->get_bondtype()==atom_chem::NO_BOND){
					triplet::xyzVector<size_t> bond(atom_1_index,atom_2_index,0);
					bond_map.push_back(bond);
				}else if( (*current_bond)->get_bondtype()==atom_chem::SINGLE){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,1));
				}else if( (*current_bond)->get_bondtype()==atom_chem::DOUBLE){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,2));
				}else if( (*current_bond)->get_bondtype()==atom_chem::TRIPLE){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,3));
				}else if( (*current_bond)->get_bondtype()==atom_chem::AROMATIC){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,4));
				}else if( (*current_bond)->get_bondtype()==atom_chem::CONJUGATED){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,5));
				}else if( (*current_bond)->get_bondtype()==atom_chem::HYDROGEN_BOND){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,6));
				}else if( (*current_bond)->get_bondtype()==atom_chem::METALLIC_BOND){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,7));
				}else if( (*current_bond)->get_bondtype()==atom_chem::UNDEFINED_BOND_TYPE){
					bond_map.push_back(triplet::xyzVector<size_t>(atom_1_index,
						atom_2_index,8));
				}
	}
	return 1;
}






// =============================================================================
//     int for set_ring_rigid
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin set_ring_rigid
///
/// @brief
///		recursive function to set bonds rigid in a ring given that the first
///		bond connects an atom to another atom closer to the root of the tree
///		on the same branch
///
/// @detailed
///
/// @param
///
/// @global_read
///		reads from bond_vector in ligand object.
/// @global_write
///		writes to bond_vector in ligand object.
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	11-29-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::set_ring_rigid(
	BondSmallMolecule & bond,
	ligand::Ligand_AtomOP atom2,
	std::list< ligand::Ligand_BondAP > & rigid_bonds
){
	// bond is the bond connecting the two ring closing atoms.
	// atom2 points to the the atom furhter up the branch
	// rigid_bonds stores the list of bonds traversed until
	// atom2 is found, and then is used to set bonds rigid
	ligand::Ligand_AtomAP patom1=NULL;
	ligand::Ligand_AtomAP patom2=NULL;
	ligand::Ligand_AtomAP patom3=NULL;
	ligand::Ligand_BondAP parent_bond=NULL;
	int success;
	bond.bonded_atoms(patom1,patom2);
//	std::cout << "Entering set_ring_rigid." << std::endl;
	if ( patom1==NULL){ // this should never happen
		return -1; // function failed. found root of tree before ring closure;
	}
	patom1->get_parentbond(parent_bond);
//	std::cout << "Entering set_ring_rigid 2. ";
//	std::cout << patom1->get_pdb_number() << " ";
//	std::cout << atom2->get_pdb_number() << std::endl;
	if ( parent_bond==NULL) { return -1; }// function failed see above
	parent_bond->bonded_atoms(patom3,patom1);
//	std::cout << patom3->get_pdb_number() << std::endl;
//	std::cout << "Entering set_ring_rigid 3." << std::endl;
	if(patom3==atom2){
//	std::cout << "Entering set_ring_rigid 5." << std::endl;
    rigid_bonds.push_back(&bond);
    rigid_bonds.push_back(parent_bond);
		for(std::list< ligand::Ligand_BondAP >::iterator current_bond=rigid_bonds.begin();
			current_bond!=rigid_bonds.end(); current_bond++){
			(*current_bond)->set_rotability(false);
		}
		return 0;
	}else {
//		std::cout << "Entering set_ring_rigid 4." << std::endl;
		rigid_bonds.push_back(&bond);
		success=set_ring_rigid((*parent_bond),atom2,rigid_bonds);
		if(success==0){return 0;}
	}
	return -2; // this should never happen.

}

// =============================================================================
//     int for set_ligand_atom_types
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin set_ligand_atom_types
///
/// @brief
///		Sets the atom_chem::LigandAtomType of all atoms within the atom_vector
///	vector.
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Kristian Kaufmann
///
/// @last_modified	3-16-2006
////////////////////////////////////////////////////////////////////////////////

int
Ligand::set_ligand_atom_types(
){
	// LigandAtomType is based on element, hybridization, and substituent identity
	// and number of substituents.
	// Element should have already been set in the ligand.cc read functions.
	// this function expects that bond_graph to have been set up.

	// first loop over all atoms.
	for( ligand::Atom_Itr current_atom=atom_vector.begin();
				current_atom!=atom_vector.end(); current_atom++){

		switch((*current_atom)->get_element_type()){

			case atom_chem::FLOURINE_ATOM: {
					(*current_atom)->set_ligand_atom_type(atom_chem::FLOURINE_ATOM);
					break;
				}
			case atom_chem::CHLORINE_ATOM: {
					(*current_atom)->set_ligand_atom_type(atom_chem::CHLORINE_ATOM);
					break;
				}
			case atom_chem::BROMINE_ATOM: {
					(*current_atom)->set_ligand_atom_type(atom_chem::BROMINE_ATOM);
					break;
				}
			case atom_chem::IODINE_ATOM: {
					(*current_atom)->set_ligand_atom_type(atom_chem::IODINE_ATOM);
					break;
				}
			case atom_chem::CARBON: {
					//first get hybridization based on bond types
					switch(get_hybridization((*current_atom))){
					// 0= sp3 1=sp2 2=sp
						case 0 :{
					 		switch(get_number_of_hydrogens((*current_atom))){
								case 0 :{ (*current_atom)->set_ligand_atom_type(
																atom_chem::QUATERNARY_CARBON);
													break;// # of H
									}
								case 1 :{ (*current_atom)->set_ligand_atom_type(
																atom_chem::TERTIARY_CARBON);
													break;// # # of H
									}
								case 2 :{ (*current_atom)->set_ligand_atom_type(
																atom_chem::SECONDARY_CARBON);
													break;//# of H
									}
								case 3 :
								case 4 :{ (*current_atom)->set_ligand_atom_type(
																atom_chem::PRIMARY_CARBON);
													break;//# of H
									}
								default :{ (*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
													break;//# of H
									}
					 			}
								break; // case carbon 0 hybridization
							}
					 	case 1 : {
					 		switch(get_number_of_hydrogens((*current_atom))){
								case 0 :{
													if( get_number_of_aromatic_bonds((*current_atom))==2 ||
														get_number_of_aromatic_bonds((*current_atom))==3 ){
														(*current_atom)->set_ligand_atom_type(
															atom_chem::AROMATIC_CARBON);
													}else{
														(*current_atom)->set_ligand_atom_type(
																atom_chem::ALKENE_CARBON);
													}
													break;//# of H
									}// case 0 hydrogens
								case 1 :{
													if(get_number_of_aromatic_bonds((*current_atom))==2 ){
														(*current_atom)->set_ligand_atom_type(
															atom_chem::AROMATIC_CARBON_W_HYDROGEN);
													}else{
														(*current_atom)->set_ligand_atom_type(
																atom_chem::ALKENE_CARBON_W_HYDROGEN);
													}
													break;//# of H


					 				}//case 1 hydrogens
					 		  case 2 :{
					 		  				(*current_atom)->set_ligand_atom_type(
																atom_chem::ALKENE_CARBON_W_HYDROGEN);
					 		    				break;//# of H
					 		  	}//case 2 hydrogens
					 		  default : { (*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
													break;//# of H
					 		  	}

					 			}//switch hydrogens



							break;//case carbon 1 hybridization
						}
						case 2 :{
							(*current_atom)->set_ligand_atom_type(
																atom_chem::ALKYNE_CARBON);
							break;//case carbon 1 hybridization
						}
						default :{
							(*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
							break;//default hybridization
						}

					}//switch hybridization
					break;//case carbon
				}
			case atom_chem::NITROGEN:{
				switch(get_hybridization((*current_atom))){
					case 0:{
						switch(get_number_of_hydrogens((*current_atom))){
							case 0:{
								(*current_atom)->set_ligand_atom_type(
																atom_chem::TERTIARY_NITROGEN);
								break;//# of H 0
							}
							case 1:{
								(*current_atom)->set_ligand_atom_type(
																atom_chem::SECONDARY_NITROGEN);
								break;//# of H 1
							}
							case 2:
							case 3:{
								(*current_atom)->set_ligand_atom_type(
																atom_chem::PRIMARY_NITROGEN);
								break;//# of H 2 or 3
							}
							default : {
								(*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
								break;//# of H default
							}
						}//switch number of hydrogens
						break;//0 hybridization
					}
					case 1:{
						switch(get_number_of_aromatic_bonds((*current_atom))){
							case 2:
							case 3: {
								(*current_atom)->set_ligand_atom_type(
																atom_chem::AROMATIC_NITROGEN);
								break;//# of aromatic bonds 2 or 3
							}
							default: {
								(*current_atom)->set_ligand_atom_type(
																atom_chem::IMINE_NITROGEN);
								break;//# of aromatic bonds default
							}
						}//switch aromatic bonds

						break;//1 hybridization
					}
					case 2:{
						if(get_number_of_double_bonded_oxygens((*current_atom))==2){
							(*current_atom)->set_ligand_atom_type(
																atom_chem::NITRO_NITROGEN);
							break;//hybridization 2 double bonded oxygen 2
						}else{
							(*current_atom)->set_ligand_atom_type(
																atom_chem::NITRILE_NITROGEN);
								break;//hybridization triple bond and two bonds not to oxygen
						}
					}
					case 3:{
						(*current_atom)->set_ligand_atom_type(
																atom_chem::AZIDE_NITROGEN);
						break;//hybridization 3 double bond and triple bond and
					}
					default :{
						(*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
						break;//hybridization default
					}

					}//switch hybridization
					break;//case nitrogen
				}
			case atom_chem::PHOSPHORUS:{
				if(get_number_of_double_bonded_oxygens((*current_atom))>0){
					(*current_atom)->set_ligand_atom_type(
												atom_chem::PHOSPHORUS_W_OXYGEN);

				}else{
					std::list< ligand::Ligand_BondAP > bond_children;
					(*current_atom)->get_childbonds(bond_children);
					if (bond_children.size()==3){
						(*current_atom)->set_ligand_atom_type(
												atom_chem::TERTIARY_PHOSPHORUS);
					}else{
						(*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
					}
				}
					break;//case phosphorus
				}
			case atom_chem::OXYGEN:{
					if(get_number_of_hydrogens((*current_atom))>0){
						(*current_atom)->set_ligand_atom_type(
																atom_chem::HYDROXYL_OXYGEN);
					}else{
						if(get_hybridization((*current_atom))==1){
							(*current_atom)->set_ligand_atom_type(
																atom_chem::KETONE_OXYGEN);
						}else if(get_hybridization((*current_atom))==0){
							(*current_atom)->set_ligand_atom_type(
																atom_chem::ETHER_OXYGEN);
						}else{
							(*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
						}
					}
					break;//case oxygen
				}
			case atom_chem::SULFUR:{
					switch(get_hybridization((*current_atom))){
						case 0: {
								(*current_atom)->set_ligand_atom_type(
																atom_chem::THIOL_SULFUR);
								break;
							}
						case 1:{
								if(get_number_of_double_bonded_oxygens((*current_atom))==1){
									(*current_atom)->set_ligand_atom_type(
																atom_chem::DOUBLE_BONDED_SULFUR_W_ONE_OXYGEN);
								}else{
									(*current_atom)->set_ligand_atom_type(
																atom_chem::DOUBLE_BONDED_SULFUR);
								}
								break;
							}
						case 2:{
								if(get_number_of_double_bonded_oxygens((*current_atom))==2){
									(*current_atom)->set_ligand_atom_type(
																atom_chem::SULPHONIC_SULFUR);
									break;
								}else{
									(*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
									break;
								}

							}
						default: {
								(*current_atom)->set_ligand_atom_type(
																atom_chem::UNDEFINED_ATOM_TYPE);
								break;
							}
					}//hybrization switch
					break;//case sulfur
				}
			default : {
					(*current_atom)->set_ligand_atom_type(atom_chem::UNDEFINED_ATOM_TYPE);
					break;
				}

	}
	if( runlevel_ns::runlevel >= runlevel_ns::inform ){
						std::string atom_name;
						atom_name=(*current_atom)->get_atom_name();
						std::cout << "HETATM " << atom_name << " " << (*current_atom)->get_pdb_number();
						std::cout << " was set to LigandAtomType ";
						std::cout << atom_chem::ligandatomtype_string[
														 (*current_atom)->get_ligand_atom_type()];
						std::cout << std::endl;
	}
	}
	return 1;
}


// =============================================================================
//     size_t get_atom_closest_to_centroid
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin size_t get_atom_closest_to_centroid
///
/// @brief
///		Calculates the centroid of the coordinates in atom_vector and returns
/// the size_t of the vector index of the closest non-hydrogen atom
/// to the centriod.
/// @detailed
///
/// @param
///
/// @global_read
///		reads from atom_vector
/// @global_write
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	2-9-2006
////////////////////////////////////////////////////////////////////////////////
size_t
Ligand::get_atom_closest_to_centroid(
){
	triplet::xyzVector<double> centroid(0.0,0.0,0.0);
	triplet::xyzVector<double> min_distance(100.0,100.0,100.0);
	triplet::xyzVector<double> cent_distance(50.0,50.0,50.0);
	size_t atom_closest = 0;
	for(ligand::Atom_Itr current_atom=atom_vector.begin();
			current_atom!=atom_vector.end(); current_atom++){
		centroid += (*current_atom)->get_coordinates();
	}
	centroid /= double(atom_vector.size());
	for(size_t i=0; i<atom_vector.size();i++){
		if(atom_vector[i]->get_element_type()!=atom_chem::HYDROGEN){
		  cent_distance = centroid-atom_vector[i]->get_coordinates();
		  if(i==0 || cent_distance.length()
		  		< min_distance.length() ){
				min_distance = cent_distance;
				atom_closest=i;
			}
		}
	}
  return atom_closest;
}


// =============================================================================
//     int for get_number_of_double_bonded_oxygens
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_number_of_double_bonded_oxygen
///
/// @brief
///		returns number of double bonded oxygens connected to the given atom.
///
/// @detailed
///		returns 1 in sp2, 2 if sp, and higher for things like Nitro nitrogens
/// @param [in] Atom * atom1
///
///
/// @global_read
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	3-16-2006
////////////////////////////////////////////////////////////////////////////////

int
Ligand::get_number_of_double_bonded_oxygens(
	ligand::Ligand_AtomAP atom1
){
	int number_of_oxygens=0;
	ligand::Ligand_AtomOP this_atom;
	ligand::Ligand_AtomOP other_atom;
	if(!(atom1->Is_Root_Atom())){
		ligand::Ligand_BondAP parentbond;
		atom1->get_parentbond(parentbond);
		if(parentbond->get_bondtype()==atom_chem::DOUBLE){
			parentbond->bonded_atoms(other_atom,this_atom);
			if(other_atom->get_element_type()==atom_chem::OXYGEN){
				number_of_oxygens++;
			}
		}

	}

	std::list< ligand::Ligand_BondAP > bond_children;
	atom1->get_childbonds(bond_children);
	for(std::list< ligand::Ligand_BondAP >::iterator current_bond=bond_children.begin();
			current_bond!=bond_children.end(); current_bond++){

		if((*current_bond)->get_bondtype()==atom_chem::DOUBLE){
			(*current_bond)->bonded_atoms(this_atom,other_atom);
			if(other_atom->get_element_type()==atom_chem::OXYGEN){
				number_of_oxygens++;
			}
		}
	}

	return number_of_oxygens;
}
// =============================================================================
//     int for get_hybridization
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_hybridization
///
/// @brief
///		returns the hybridization of an Atom
///
/// @detailed
///		returns 1 in sp2, 2 if sp, and higher for things like Nitro nitrogens
/// @param [in] Atom * atom1
///
///
/// @global_read
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	3-16-2006
////////////////////////////////////////////////////////////////////////////////

int
Ligand::get_hybridization(
	ligand::Ligand_AtomOP atom1
){


	int i=0;
	int j=0;
	if(!(atom1->Is_Root_Atom())){
		ligand::Ligand_BondAP parentbond;
		atom1->get_parentbond(parentbond);
		switch(parentbond->get_bondtype()){
			case atom_chem::DOUBLE: { i++;break;}
			case atom_chem::TRIPLE: { i +=2;break;}
			case atom_chem::AROMATIC:
			case atom_chem::CONJUGATED: {j++; break;}
			default : { break;}
		}
	}
	std::list< ligand::Ligand_BondAP > bond_children;
	atom1->get_childbonds(bond_children);
	for(std::list< ligand::Ligand_BondAP >::iterator current_bond=bond_children.begin();
				current_bond!=bond_children.end();current_bond++){
		switch((*current_bond)->get_bondtype()){
			case atom_chem::DOUBLE: { i++;break;}
			case atom_chem::TRIPLE: { i +=2;break;}
			case atom_chem::AROMATIC:
			case atom_chem::CONJUGATED: {j++; break;}
			default : { break;}
		}
	}
	i+=int(j/2);
	return i;

}


// =============================================================================
//     int for get_number_of_hydrogens
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_number_of_hydrogens
///
/// @brief
///		returns the number of bound hydrogens
///
/// @detailed
///
/// @param [in] Atom * atom1
///
///
/// @global_read
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	3-16-2006
////////////////////////////////////////////////////////////////////////////////

int
Ligand::get_number_of_hydrogens(
	ligand::Ligand_AtomOP atom1
){
	ligand::Ligand_AtomOP this_atom;
	ligand::Ligand_AtomOP other_atom;
	std::list< ligand::Ligand_BondAP > bond_children;
	int number_of_hydrogens=0;
	if(!(atom1->Is_Root_Atom())){
		ligand::Ligand_BondAP parent_bond;
		atom1->get_parentbond( parent_bond );
		parent_bond->bonded_atoms(other_atom, this_atom);
		if(other_atom->get_element_type()==atom_chem::HYDROGEN){
			number_of_hydrogens++;
		}
	}
	atom1->get_childbonds(bond_children);
	for(std::list< ligand::Ligand_BondAP >::iterator current_bond=bond_children.begin();
			current_bond!=bond_children.end();current_bond++){

		(*current_bond)->bonded_atoms(this_atom, other_atom);
		if(other_atom->get_element_type()==atom_chem::HYDROGEN){
			number_of_hydrogens++;
		}
	}
	return number_of_hydrogens;
}
// =============================================================================
//     int for get_number_of_aromatic_bonds
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_number_of_aromatic_bonds
///
/// @brief
///		returns number of aromatic bonds
///
/// @detailed
///
/// @param [in] Atom * atom1
///
///
/// @global_read
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	3-17-2006
////////////////////////////////////////////////////////////////////////////////

int
Ligand::get_number_of_aromatic_bonds(
	ligand::Ligand_AtomAP atom1
){
	std::list< ligand::Ligand_BondAP > bond_children;
	atom1->get_childbonds(bond_children);
	int number_of_aromatic_bonds=0;
	for(std::list< ligand::Ligand_BondAP >::iterator current_bond=bond_children.begin();
				current_bond!=bond_children.end(); current_bond++){

			if((*current_bond)->get_bondtype()==atom_chem::AROMATIC){
				number_of_aromatic_bonds++;
			}
	}
	if( !atom1->Is_Root_Atom()){
		ligand::Ligand_BondAP parentbond;
		atom1->get_parentbond(parentbond);
		if(parentbond->get_bondtype()==atom_chem::AROMATIC){
				number_of_aromatic_bonds++;
		}
	}
	return number_of_aromatic_bonds;
}


// =============================================================================
//     bool for Are_Bonded
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin Are_Bonded
///
/// @brief
///		Checks whether two Atoms are connected by a bond in
///	the bond_vector vector
/// @detailed
///
/// @param
///		in two pointers to Atom objects
/// @global_read
///		reads from bond_vector in ligand object
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	11-29-2005
////////////////////////////////////////////////////////////////////////////////
bool
Ligand::Are_Bonded(
	ligand::Ligand_AtomAP atom1,
	ligand::Ligand_AtomAP atom2
){
//	std::cout << "Entering Are_Bonded()" << " ";
//	std::cout << atom1->get_pdb_number() << " ";
//	std::cout << atom2->get_pdb_number() << std::endl;
	if( bond_vector.empty()) {return false;}
	ligand::Ligand_AtomAP patom1=NULL;// used for information retrieval
	ligand::Ligand_AtomAP patom2=NULL;
//	std::cout << "Iterating over bonds" << std::endl;
	for (ligand::Bond_Itr i=bond_vector.begin();i!=bond_vector.end();i++){
		(*i)->bonded_atoms(patom1, patom2);
//		std::cout << atom1 <<  " " << atom2 << "a bound atoms" << std::endl;
//		std::cout << patom1 <<  " " << patom2 << "p bound atoms" << std::endl;
//		std::cout << "Checking bond" << " ";
//		std::cout << patom1->get_pdb_number() << " ";
//		std::cout << patom2->get_pdb_number() << std::endl;
		if ( (atom1==patom1 && atom2==patom2) ||
			(atom1==patom2 && atom2==patom1)){ return true;}
	}
//	std::cout << "returning false" << std::endl;
	return false;
}


// =============================================================================
//     bool calculate_internal_coordinates
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin calculate_internal_coordinates()
///
/// @brief
///		 Calculates the intenal coordinates to store in the Bond objects based
///	on the cartesian coordinates stored in the atoms connected by the Bond
/// @detailed
///
/// @param
///
/// @global_read
///		reads from bond_vector
/// @global_write
///		writes to bond_vector
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	11-30-2005
////////////////////////////////////////////////////////////////////////////////
bool
	Ligand::calculate_internal_coordinates( bool initialize ){
// Assumptions
//             A      D
//				\    /
//				 B--C
// Atoms C and D are bonded in the current bond
// Bond containing B and C is the parent bond of C
// Bond containing A and B is the parent bond of B
// the length stored in current bond is the distance between C and D
// the angle of the current bond is the angle between going from C to B and
// vector going from C to D
// the dihedral stored in current bond (CD) is the dihedral of bond BC.
//
// If only one root atom exists in the ligand object then three anchor
// coordinates will be set relative to the root atom position otherwise the
// rules in the following sentence will be followed.
// If C is root the dihedral and angle don't exist and will be set to 0.
// If B is root A will be set to the cross product of vector BC and the vector
//  of the first child bond of C.


//	std::cout << "Initializing internal ligand coordinates." << std::endl;
	bool anchors_set=false;
	if(trial_roots.size()==1){
		if(initialize){
			anchor_first=trial_roots[0]->get_coordinates();
			anchor_first.x()+=2;
			anchor_second=trial_roots[0]->get_coordinates();
			anchor_second.x()-=2;
			anchor_second.y()-=2;
			anchor_second.z()+=2;
			anchor_state++;
			anchor_third=trial_roots[0]->get_coordinates();
		}
 //     std::cout << "kwk help anchor_first " << anchor_first << std::endl;
 //     std::cout << "kwk help anchor_second " << anchor_second << std::endl;
 //     std::cout << "kwk help anchor_third " << anchor_third << std::endl;
		anchors_set=true;
	}

	ligand::Ligand_AtomAP A, B, C, D;
	ligand::Ligand_BondAP other_bond;
	std::list< ligand::Ligand_BondAP > other_bonds;
	C=NULL;
	D=NULL;
	A=NULL;
	B=NULL;
	triplet::xyzVector<double> vectorDC, vectorBC, coordA, coordB, coordC,coordD;
	for (ligand::Bond_Itr current_bond=bond_vector.begin();
	current_bond!=bond_vector.end(); current_bond++){
		(*current_bond)->bonded_atoms(C,D);
		coordD=D->get_coordinates();
		coordC=C->get_coordinates();
		vectorDC= (D->get_coordinates()-C->get_coordinates());
		(*current_bond)->set_length(vectorDC.length());
		if (!(C->Is_Root_Atom())){
			C->get_parentbond(other_bond);
			other_bond->bonded_atoms(B,C);
			coordB=B->get_coordinates();
			vectorBC= (B->get_coordinates()-C->get_coordinates());
			if(!(B->Is_Root_Atom())){
				B->get_parentbond(other_bond);
				other_bond->bonded_atoms(A,B);
				coordA=A->get_coordinates();
			}else{
				if(!anchors_set){
					C->get_childbonds(other_bonds);
					(*other_bonds.begin())->bonded_atoms(C,A);
					coordA=cross_product((A->get_coordinates()-C->get_coordinates()), vectorBC);
					coordA.normalize();
					// this area of the code could be a problem.
					// if coordA is too small it could lead to difficulties.
				}else{
					coordA=anchor_first;
				}
			}
			// setting angle and dihedral
			(*current_bond)->set_angle(acos(dot_product(vectorBC,vectorDC)/
					(vectorDC.length()*vectorBC.length())));
			(*current_bond)->set_dihedral(dihedral( coordA, coordB, coordC, coordD)*utility::constants::d::pi/180);
//			std::cout << "kwkhelp dihedral "<< dihedral( coordA, coordB, coordC, coordD)*utility::constants::d::pi/180 <<  std::endl;
//	    std::cout << "kwk help vectorBC " << vectorBC << std::endl;
//	    std::cout << "kwk help vectorDC " << vectorDC << std::endl;
		}else if(anchors_set){
			coordB=anchor_first;
			vectorBC=anchor_first-C->get_coordinates();
			coordA=anchor_second;
			(*current_bond)->set_angle(acos(dot_product(vectorBC,vectorDC)/
					(vectorDC.length()*vectorBC.length())));
			(*current_bond)->set_dihedral(dihedral( coordA, coordB, coordC, coordD)*utility::constants::d::pi/180);
//		  std::cout << "kwkhelp dihedral "<< dihedral( coordA, coordB, coordC, coordD)*utility::constants::d::pi/180 << std::endl;
		}else{
			(*current_bond)->set_angle(0);
			(*current_bond)->set_dihedral(0);
		}
//		std::cout << (*current_bond)->get_coordinates() << std::endl;
	}//for loop
	return true;
}

// =============================================================================
//     int twist_dihedral
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin twist_dihedral_radians
///
/// @brief
///		 given an angle in radians and a Bond function will change
/// appropriate internal coordinates and global coordinates of ligand atoms
///
/// @detailed
///		The Function is a driver function for a series of other functions which
///	accomplish the rotation. It constructs the appropriate rotation matrix and
///	decides which side of the bond to apply the rotation to based on the number
/// of atoms on each side.
/// @param
///
/// @global_read
///		reads from bond_vector
///		reads from atom_vector
/// @global_write
///		writes to bond_vector
/// 	writes to atom_vector
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	12-14-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::twist_dihedral_radians(
	double dihedral,
	BondSmallMolecule & bond
){
	//std::cout << "Starting twist dihedral" << std::endl;
	ligand::Ligand_AtomAP parent_atom=NULL;
	ligand::Ligand_AtomAP child_atom=NULL;
	ligand::Ligand_AtomAP sibling_atom=NULL;
  ligand::Ligand_AtomAP ancestor_atom=NULL;
  ligand::Ligand_AtomAP place_holder_atom1=NULL;
	bool down_branch=true;
	int size=-1;
	bond.bonded_atoms(parent_atom, child_atom);
	if(!bond.IsRotable()){return -1;} // checks whether bond is rotable.
//following for loop decides which branch the transformation
//should take place on. This is a one time compuational step and should actually
// be incorporated into the setup_bond_graph and stored as a boolean
	ancestor_atom=parent_atom;
	while(size==-1){
		std::list< ligand::Ligand_BondAP > sibling_bonds; // get siblings of child_atom so that
										// the branch size can be determined
		sibling_bonds.clear();
		ancestor_atom->get_childbonds( sibling_bonds);
// atoms are indexed in a depth first fashion. Thus the number of atoms in a
// branch is equal to the difference between the index of an atom and the
// next greatest index of a sibling or ancestor atom.
		for(std::list< ligand::Ligand_BondAP >::iterator current_bond=sibling_bonds.begin();
			current_bond!=sibling_bonds.end(); current_bond++){
				(*current_bond)->bonded_atoms(place_holder_atom1,sibling_atom);
				if(sibling_atom==ancestor_atom){//handles loop closure bonds.
					sibling_atom=place_holder_atom1;
				}
				if( (sibling_atom->get_index()-child_atom->get_index()) > 0
				){
					if(size==-1 ){
						size=sibling_atom->get_index()-child_atom->get_index();
					}else{
						if(size > (sibling_atom->get_index()-
									child_atom->get_index()) &&
									(sibling_atom->get_index()-
									  child_atom->get_index()) != 0){

							size=sibling_atom->get_index()
								-child_atom->get_index();
						}// if
					} // else

				}// first if loop
		}// for loop
		//std::cout << child_atom->get_index() << " " << size <<
		//	" " << ancestor_atom->get_index() << std::endl;
		if(size==-1 && ancestor_atom->Is_Root_Atom()){
			 size=int(atom_vector.size())-child_atom->get_index()+1;
		}else{
			if(size==-1){
				ligand::Ligand_AtomAP place_holder_atom2;// this block redirects ancestor_atom
				// to point to the parent atom of the
				ligand::Ligand_BondAP place_holder_bond; // atom it is currently pointing to.
				ancestor_atom->get_parentbond(place_holder_bond);
				place_holder_bond->bonded_atoms(
					place_holder_atom1,place_holder_atom2);
				if(ancestor_atom==place_holder_atom2){
					ancestor_atom=place_holder_atom1;
				}else{
					ancestor_atom=place_holder_atom2;
				}
				place_holder_atom1=NULL;
				place_holder_atom2=NULL;
				place_holder_bond=NULL;

			}
		}
		//std::cout << child_atom->get_index() << " " << size <<
		//" " << ancestor_atom->get_index() << std::endl;
		//std::cout << "while loop twist dihedral" << std::endl;
	}//while loop
	// following if statement assume one ligand in the bond_graph
	if(size > int(atom_vector.size())/2) { down_branch=false; }
	//std::cout << "direction twist dihedral" << std::endl;

	triplet::xyzVector<double> origin;
	triplet::xyzMatrix<double> rot_matrix=bond.get_rotation_matrix( dihedral, origin);
	//above call retrieves rotation matrix plus origin offset
	//this block updates internal coordinates

	// this a tricky portion of the code due to poor design on my part
	// the chemical dihedral of a bond is actually stored with the child bonds
	// because it is only used to determine the position of the grandchild atoms
	std::list<ligand::Ligand_BondAP > child_bonds;
	child_atom->get_childbonds(child_bonds);
	for(std::list< ligand::Ligand_BondAP >::iterator current_bond=child_bonds.begin();
		current_bond!=child_bonds.end(); current_bond++){

		(*current_bond)->set_dihedral((*current_bond)->get_dihedral()
			+dihedral);
	}

	//std::cout << "internal coordinates twist dihedral" << std::endl;
	// following if blocks updates the coordinates


	if(down_branch){
		for(ligand::Atom_Itr current_atom=atom_vector.begin();
			current_atom!=atom_vector.end(); current_atom++){
			if((*current_atom)->get_index()>child_atom->get_index() &&
			(*current_atom)->get_index()<(size+child_atom->get_index() )){
		//		std::cout << (*current_atom)->get_coordinates() << std::endl;
				(*current_atom)->rotate_atom(rot_matrix,origin);
		//		std::cout << (*current_atom)->get_coordinates() << std::endl;
			}
		}
	}
	// following if block updates coordinates for uptree case.
	if(!down_branch){
		for(ligand::Atom_Itr current_atom=atom_vector.begin();
			current_atom!=atom_vector.end(); current_atom++){
			if((*current_atom)->get_index()<parent_atom->get_index() ||
			((*current_atom)->get_index())>=(size+child_atom->get_index())){
//				std::cout << (*current_atom)->get_coordinates() << std::endl;
				(*current_atom)->rotate_atom(rot_matrix,origin);
//				std::cout << (*current_atom)->get_coordinates() << std::endl;
			}
		}
	}
	//std::cout << "Ending twist dihedral" << std::endl;
	return 1;

}

// =============================================================================
//     int set_best_coordinates
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin set_best_coordinates
///
/// @brief
///		 Stores coordinates from atom_vector and bond_vector into best_coord
/// and best_bonds containers
/// @detailed
///
/// @param
///
/// @global_read
///		reads from bond_vector
///		reads from atom_vector
/// @global_write
///		writes to best_bonds
/// 	writes to best_coord
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	12-27-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::set_best_coordinates()
{
    for ( size_t j = 0; j < atom_vector.size(); ++j ) { // stores atom_vector
        if (j==0) {// xyz coordinates in best_coord
          best_coord.clear();
          best_coord.reserve(atom_vector.size());
        }
        best_coord.push_back( atom_vector[j]->get_coordinates());
    }
	for ( size_t j = 0; j < bond_vector.size(); ++j ) { // stores bond_vector
        if (j==0) {// internal coordinates in best_bonds
          best_bonds.clear();
          best_bonds.reserve(bond_vector.size());
        }
        best_bonds.push_back( bond_vector[j]->get_coordinates());
    }
    anchor_first_best=anchor_first;
    anchor_second_best=anchor_second;
    anchor_third_best=anchor_third;
	return 1;
}

// =============================================================================
//     int recover_best_coordinates
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin recover_best_coordinates
///
/// @brief
///		 Restores coordinates from best_coord and best_bonds into atom_vector
/// and bond_vector containers
/// @detailed
///
/// @param
///
/// @global_read
///		reads from best_bonds
///		reads from best_coord
/// @global_write
///		writes to bond_vector
/// 	writes to atom_vector
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	12-27-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::recover_best_coordinates(){
	if(atom_vector.size()==best_coord.size()){
		for ( size_t j = 0; j < best_coord.size(); ++j ) { // assigns trial atoms to best atoms
			atom_vector[j]->set_coordinates(best_coord[j]);
		}
		 	//	std::cout << "recovering best coordinates." << std::endl;
	}
	else {
		std::cout << "Size of best_coord and atom_vector differ" << std::endl;
		std::cout << "best_coord coordinates not recovered" << std::endl;
		return -1;
	}
	if(bond_vector.size()==best_bonds.size()){
		for ( size_t j = 0; j < best_bonds.size(); ++j ) { // assigns trial atoms to best atoms
			bond_vector[j]->set_coordinates(best_bonds[j]);
		}
		 	//	std::cout << "recovering best coordinates." << std::endl;
	}
	else {
		std::cout << "Size of best_bonds and bond_vector differ" << std::endl;
		std::cout << "best_bonds coordinates not recovered" << std::endl;
		return -1;
	}
	set_anchors(anchor_first_best, anchor_second_best, anchor_third_best);
	recompute_ligand_interface=true;
	return 1;
}

// =============================================================================
//     int set_start_coordinates
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin set_start_coordinates
///
/// @brief
///		 Stores coordinates from atom_vector and bond_vector into start_coord
/// and start_bonds containers
/// @detailed
///
/// @param
///
/// @global_read
///		reads from bond_vector
///		reads from atom_vector
/// @global_write
///		writes to start_bonds
/// 	writes to start_coord
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	12-27-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::set_start_coordinates()
{
    for ( size_t j = 0; j < atom_vector.size(); ++j ) { // stores atom_vector
        if (j==0) {// xyz coordinates in best_coord
          start_coord.clear();
          start_coord.reserve(atom_vector.size());
        }
        start_coord.push_back( atom_vector[j]->get_coordinates());
    }
	for ( size_t j = 0; j < bond_vector.size(); ++j ) { // stores bond_vector
        if (j==0) {// internal coordinates in best_bonds
          start_bonds.clear();
          start_bonds.reserve(bond_vector.size());
        }
        start_bonds.push_back( bond_vector[j]->get_coordinates());
    }
    anchor_first_start=anchor_first;
    anchor_second_start=anchor_second;
    anchor_third_start=anchor_third;
	return 1;
}

// =============================================================================
//     int recover_start_coordinates
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin recover_start_coordinates
///
/// @brief
///		 Restores coordinates from start_coord and start_bonds into atom_vector
/// and bond_vector containers
/// @detailed
///
/// @param
///
/// @global_read
///		reads from start_bonds
///		reads from start_coord
/// @global_write
///		writes to bond_vector
/// 	writes to atom_vector
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	12-27-2005
////////////////////////////////////////////////////////////////////////////////
int
Ligand::recover_start_coordinates(){
	if(atom_vector.size()==start_coord.size()){
		for ( size_t j = 0; j < start_coord.size(); ++j ) { // assigns trial atoms to best atoms
			atom_vector[j]->set_coordinates(start_coord[j]);
		}
		 	//	std::cout << "recovering best coordinates." << std::endl;
	}
	else {
		std::cout << "Size of start_coord and atom_vector differ" << std::endl;
		std::cout << "start_coord coordinates not recovered" << std::endl;
		return -1;
	}
	if(bond_vector.size()==start_bonds.size()){//assigns trial atoms
		for ( size_t j = 0; j < start_bonds.size(); ++j ) { //to best atoms
			bond_vector[j]->set_coordinates(start_bonds[j]);
		}
		 	//	std::cout << "recovering start coordinates." << std::endl;
	}else{

		calculate_internal_coordinates(true);
		for ( size_t j = 0; j < start_bonds.size(); ++j ) { //to best atoms
			bond_vector[j]->set_coordinates(start_bonds[j]);
		}
	}
	set_anchors( anchor_first_start, anchor_second_start, anchor_third_start);
	recompute_ligand_interface=true;
	return 1;
}


// =============================================================================
//     int get_ligand_internal_energy
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_ligand_internal_energy
///
/// @brief
///		 if initializing the function will fill the ligand_atom_pair_energy list
/// with LigandAtomPairEnergy objects for the appropriate atom pairs. Atom pairs
/// that are not greater than three bonds distant will not be placed in the
/// ligand_atom_pair_energy list.
///
/// @detailed
///
/// @param  [in] bool initialize tells the function whther it needs to create
/// 	LigandAtomPairObjects.
///
/// @global_read
/// @global_write
///		writes to the ligand internal Energy fields
///
/// @remarks
///
/// @references
///
/// @authors
///		Kristian Kaufmann
/// @last_modified	2-27-2006
////////////////////////////////////////////////////////////////////////////////
int
Ligand::get_ligand_internal_energy(
	bool initialize
){
	//initialize
	// in this block we set which atom pairs should be evaluated
	// by which terms. The interactions greater than three bonds apart are
	// evaluated in the van der waals and solvation energy fields.
	// Interactions of atoms three bonds or less apart are are summed up in the
	// dihedralE term.
	// Hbond Energy is calculated over the acceptors and donors in the small
	// molecule.  This blocks purpose is to find the division between atoms three
	// bonds apart and those that aren't.
	if( initialize ){
		std::list< ligand::Ligand_AtomAP > neighbor_atoms; // non-owning list of pointers to atoms
		for( ligand::Atom_Itr current_atom=atom_vector.begin();
				current_atom!=atom_vector.end(); current_atom++){
		  neighbor_atoms.clear();

	    std::list< ligand::Ligand_AtomAP > bound_atoms_first;
	    get_bonded_atoms(bound_atoms_first,(*current_atom));

	    for( std::list< ligand::Ligand_AtomAP >::iterator first_shell_atoms=bound_atoms_first.begin();
	      first_shell_atoms!=bound_atoms_first.end(); first_shell_atoms++){

	      neighbor_atoms.push_back((*first_shell_atoms));
	      std::list< ligand::Ligand_AtomAP > bound_atoms_second;
	      get_bonded_atoms(bound_atoms_second,(*first_shell_atoms));
	      for(std::list< ligand::Ligand_AtomAP >::iterator second_shell_atoms=bound_atoms_second.begin();
	        second_shell_atoms!=bound_atoms_second.end(); second_shell_atoms++){

	        neighbor_atoms.push_back((*second_shell_atoms));
	        std::list< ligand::Ligand_AtomAP > bound_atoms_third;
	        get_bonded_atoms(bound_atoms_third,(*second_shell_atoms));
	        for(std::list< ligand::Ligand_AtomAP >::iterator third_shell_atoms=bound_atoms_third.begin();
	          third_shell_atoms!=bound_atoms_third.end(); third_shell_atoms++){

	          neighbor_atoms.push_back((*third_shell_atoms));
	        }
	      }
	    }

			// previous blocks found all atoms three bonds or less distance
			// from the current atom the nest block will construct the appropriate
			// LigandAtomPairEnergy objects
			// Since we want only only one pair energy per pair we set the loop
			// to start at the atom after the current atom. Since all atoms before
			//current atom would have already had the LigandAtomPairEnergy objects
			// constructed


			for(ligand::Atom_Itr next_atom=(current_atom+1);
				next_atom!=atom_vector.end(); next_atom++){

				if(find(neighbor_atoms.begin(),neighbor_atoms.end(),(*next_atom))
					== neighbor_atoms.end()){
					if(!((*current_atom)->Is_Virtual()) && !((*next_atom)->Is_Virtual())){
						LigandAtomPairEnergy * pairligand = new LigandAtomPairEnergy((*current_atom),(*next_atom));
	          if( runlevel_ns::runlevel >= runlevel_ns::verbose ) {
	            std::cout << "LigandAtomPair for Energy pdb numbers " << (ligand_atom_pair_energy.size()+1)<< " " <<         (*current_atom)->get_pdb_number() << " " << (*next_atom)->get_pdb_number() << std::endl;
	          }
						ligand_atom_pair_energy.push_back( *pairligand);
					}
				}//neighbor
			}//next_atom
		}// current_atom
	}// intialize
	//calculate retrieve int_repE, int_atrE, int_solE
	lig_int_repE=0.0;
	lig_int_atrE=0.0;
	lig_int_solvE=0.0;
	lig_int_dihedE=0.0;
	lig_int_coulombE=0.0;
	lig_int_hbE=0.0;
//	int i=1;
	for(std::list<LigandAtomPairEnergy>::iterator current_pair=
		ligand_atom_pair_energy.begin(); current_pair!=
		ligand_atom_pair_energy.end(); current_pair++){

		float repE_current=0.0;
		float atrE_current=0.0;
		float solvE_current=0.0;
		current_pair->get_energies(repE_current,atrE_current,solvE_current);
		lig_int_repE += repE_current;
		lig_int_atrE += atrE_current;
		lig_int_solvE += solvE_current;

//	  if( runlevel_ns::runlevel >= runlevel_ns::verbose && repE_current > 10 ) {
//              std::cout << "LigandAtomPair for Energy " << i << " " << repE_current << std::endl;
//    }
//	  i++;
	}

	// END of retrieve repE, atrE, solvE

	//calculate int_hBondE
	// the bulk of this code is borrowed directly from ligand.cc
	// the update_deriv option is set to false
	// However in the event that this information is needed
	// it can be readily added.

	FArray1D_float proton_coord(3), donor_coord(3);
	FArray1D_float accept_coord(3), acceptbase_coord(3);
	int hybrid;
	float energy;
	FArray2D_float deriv;
	bool update_deriv= { false };


	for(int current_acceptor=1; current_acceptor<hetero_atom_hbond_acc_count;
		current_acceptor++){

		//get acceptor atom and base coordinates
		copy_to_FArray(atom_vector[
			hetero_atom_hbond_acc(1,current_acceptor)]->get_coordinates(),
			accept_coord);
		copy_to_FArray(atom_vector[
			hetero_atom_hbond_acc(2,current_acceptor)]->get_coordinates(),
			acceptbase_coord);

		hybrid = aaproperties_pack::hybridization(atom_vector[hetero_atom_hbond_acc(1,
			current_acceptor)]->get_ros_atom_type());

		for(int current_donor=1; current_donor<hetero_atom_hbond_don_count;
			current_donor++){
			if(hetero_atom_hbond_don(2,current_donor)!=hetero_atom_hbond_acc(1,current_acceptor)){
				copy_to_FArray(atom_vector[
					hetero_atom_hbond_don(1,current_donor)]->get_coordinates(),
					proton_coord);
				copy_to_FArray(atom_vector[
					hetero_atom_hbond_don(2,current_donor)]->get_coordinates(),
					donor_coord);


			// if not -O-H
					if ( hetero_atom_hbond_don(4,current_donor) == -1 || fix_ligand_HO ) {
						//mj compute energy of hydrogen bond
						hb_energy_deriv(0,0,donor_coord(1),
							proton_coord(1),accept_coord(1),acceptbase_coord(1),
							acceptbase_coord(1),// in this case we don't care about 2nd bases
							hybrid,true,energy,update_deriv,deriv,0,0,false,false);

						if ( energy < hbonds::hbond_db::MAX_HB_ENERGY ) {lig_int_hbE += energy;}
					}

					// in case of -O-H optimize H position in ligand first
					else {

						////////////////////////////////////////////////
						//
						//                            X
						//                   o--H
						//                   | /
						//                   |/ 0.98A
						//                   O 109.5grad
						//                   |
						//                   |
						//                   B
						//
						////////////////////////////////////////////////

						// find optimized H positon
						double const sin109 = { 0.9426 * 0.98 };
						// sin( 70.5) * bondlength( O-H)
						double const cos109 = { 0.3338 * 0.98 };
						// cos( 70.5) * bondlength( O-H)
				 		static FArray1D_float opt_Hpos( 3 );
						triplet::xyzVector_double opt_Hpos_vect;
//kwk reset as xyzVectors		static FArray1D_float B_O_vect( 3 );
						triplet::xyzVector_double B_O_vect;
//kwk						static FArray1D_float O_X_vect( 3 );
						triplet::xyzVector_double O_X_vect;
//kwk						static FArray1D_float ort_vect( 3 );
						triplet::xyzVector_double ort_vect;
						triplet::xyzVector_double aatm_vect;

						aatm_vect=atom_vector[hetero_atom_hbond_acc(1,current_acceptor)]
							->get_coordinates();
						// compute B-O and O-X vector

						B_O_vect= atom_vector[hetero_atom_hbond_don(2,current_donor)]
							->get_coordinates()
							- atom_vector[hetero_atom_hbond_don(4,current_donor)]
							->get_coordinates();

						O_X_vect= aatm_vect - atom_vector[
							hetero_atom_hbond_don(2,current_donor)]->get_coordinates();

						// normalize B-O and O-X vector
						B_O_vect.normalize();
						O_X_vect.normalize();
						double cosangle = inner_product( B_O_vect, O_X_vect );
						cosangle = std::min( 1.0, std::max( -1.0, cosangle ) );
						ort_vect = O_X_vect - cosangle * B_O_vect;
						ort_vect.normalize();
						// compute H position in B-O-X plane
						opt_Hpos_vect = atom_vector[
							hetero_atom_hbond_don(2,current_donor)]->get_coordinates()
											+ B_O_vect *  cos109
											+ ort_vect *  sin109;
						opt_Hpos(1)=opt_Hpos_vect.x();
						opt_Hpos(2)=opt_Hpos_vect.y();
						opt_Hpos(3)=opt_Hpos_vect.z();
						//mj compute energy of hydrogen bond
						copy_to_FArray(atom_vector[
							hetero_atom_hbond_don(2,current_donor)]->get_coordinates(),
							donor_coord);
						hb_energy_deriv(0,0,donor_coord(1), opt_Hpos(1),
							accept_coord(1), acceptbase_coord(1), acceptbase_coord(1),
							//
							hybrid,true,energy,update_deriv,deriv,0,0,false,false);

						if ( energy < hbonds::hbond_db::MAX_HB_ENERGY ) {lig_int_hbE += energy;}
					}}
		}//current_donor loop
	}//current_acceptor loop

	//End of get HbondE


	//calculate coulombE
	for(ligand::Atom_Itr c_atom=atom_vector.begin();c_atom!=atom_vector.end();
			c_atom++){
		if(!((*c_atom)->Is_Virtual())){
		for(ligand::Atom_Itr n_atom=c_atom+1;n_atom!=atom_vector.end();n_atom++){
      //compute distance
			if(!((*n_atom)->Is_Virtual())){
				float E=0.0;
				float d2,limit2;
				d2=distance_squared((*c_atom)->get_coordinates(),
														(*n_atom)->get_coordinates());
				//mj compute limit
				limit2 = ( etable::fa_lj_radius((*c_atom)->get_ros_atom_type()) +
			 						etable::fa_lj_radius((*n_atom)->get_ros_atom_type()))*
			 					( etable::fa_lj_radius((*c_atom)->get_ros_atom_type()) +
			 						etable::fa_lj_radius((*n_atom)->get_ros_atom_type()));

				//mj compute energy
				simple_elec((*c_atom)->get_partial_charge(),
									(*n_atom)->get_partial_charge(),d2,limit2,E);
				lig_int_coulombE+=E;
			}}
		}}
	//End of CoulombE
	//calculate dihedralE
	for(ligand::Bond_Itr current_bond=bond_vector.begin();
		current_bond!=bond_vector.end(); current_bond++){
		double dihedralE_sum=0.0;
		size_t dihedralE_number=0;
		if((*current_bond)->IsRotable()){
			ligand::Ligand_AtomOP atom1, atom2, atom4, atom3;
			ligand::Ligand_BondAP parent_bond;
			std::list< ligand::Ligand_BondAP > sibling_bonds;
			std::list< ligand::Ligand_BondAP > child_bonds;
			double dihedralE_deriv;// unused now but will be incorporated into
														// minimization at later stage.
			double dihedral_current;
			double dihedralE_current;// dihedral energy of current tetrad of atoms
			                        // specifying the dihedral
			                        // currently the energy of all combinations
			                        // of non-hydrogen atoms is averaged to
			                        // find the energy of the torsion angle
			(*current_bond)->bonded_atoms(atom1, atom2);//middle atoms in the dihedral
			// finds out what type of torsion angle is in question.
			std::pair< atom_chem::LigandAtomType, atom_chem::LigandAtomType >
				atompairtype(
								atom1->get_ligand_atom_type(), atom2->get_ligand_atom_type());

			atom2->get_childbonds(child_bonds);
			if(!(atom1->Is_Root_Atom())){
				atom1->get_parentbond(parent_bond);
				parent_bond->bonded_atoms(atom4,atom1);
				if(atom4->get_element_type()!=atom_chem::HYDROGEN){
					for(std::list< BondSmallMolecule * >::iterator c_bond=child_bonds.begin();
							c_bond!=child_bonds.end();c_bond++){

						(*c_bond)->bonded_atoms(atom2,atom3);
						if(atom3->get_element_type()!=atom_chem::HYDROGEN){
							triplet::dihedral(atom4->get_coordinates(),
								atom1->get_coordinates(),atom2->get_coordinates(),
								atom3->get_coordinates(),dihedral_current);
							dihedral_current=(dihedral_current/180*utility::constants::d::pi);
							get_dihedral_energy(atompairtype, dihedral_current, dihedralE_current,
										dihedralE_deriv );
							dihedralE_sum+=dihedralE_current;
							dihedralE_number++;
						}
					}
				}
			}
			atom1->get_childbonds(sibling_bonds);
			for(std::list< ligand::Ligand_BondAP >::iterator c2_bond=sibling_bonds.begin();
					c2_bond!=sibling_bonds.end();c2_bond++){

				(*c2_bond)->bonded_atoms(atom1,atom4);
				if(atom4->get_element_type()!=atom_chem::HYDROGEN && atom4!=atom2){
          for(std::list< ligand::Ligand_BondAP >::iterator c_bond=child_bonds.begin();
              c_bond!=child_bonds.end();c_bond++){

            (*c_bond)->bonded_atoms(atom2,atom3);
            if(atom3->get_element_type()!=atom_chem::HYDROGEN){
              triplet::dihedral(atom4->get_coordinates(),
                atom1->get_coordinates(),atom2->get_coordinates(),
                atom3->get_coordinates(),dihedral_current);
              dihedral_current=(dihedral_current/180*utility::constants::d::pi);
              get_dihedral_energy(atompairtype, dihedral_current, dihedralE_current,
                    dihedralE_deriv );
              dihedralE_sum+=dihedralE_current;
							dihedralE_number++;
            }
          }
        }
			}
		}//If Rotable block
		if(dihedralE_number != 0){
			lig_int_dihedE+=dihedralE_sum/dihedralE_number;
		}
	}// end of for loop over all bonds
	// End of calculate dihedral E




	return 1;
}
// =============================================================================
//     int refold_ligand
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin refold_ligand
///
/// @brief
///    This function refolds based on the internal coordinates storded in the
///	parent bond of the atom.
///
/// @detailed
///
/// @param
///
/// @global_read
///   reads from anchor triplet::xyzVectors
///   reads from bond_vector
/// @global_write
///   writes to atom_vector
/// @remarks
///
/// @references
///
/// @authors
///   Kristian Kaufmann
/// @last_modified  03-28-2006
////////////////////////////////////////////////////////////////////////////////
int
Ligand::refold_ligand(){
	if(trial_roots.size()!=1){
		std::cout << "Can't refold ligands with multiple roots with current code";
		std::cout << std::endl;
		return -1;
	}else{
		FArray1D_bool up_to_date;
		up_to_date.dimension(atom_vector.size());
		for(size_t i=1;i<=atom_vector.size();i++){
			up_to_date(i)=false;
		}
		for(ligand::Atom_Itr current_atom=atom_vector.begin();
				current_atom!=atom_vector.end(); current_atom++){
			if(!(up_to_date((*current_atom)->get_index()))){
				refold_atom(up_to_date, (*current_atom));
			}
		}
	}
  return 1;
}

// =============================================================================
//     int refold_atom
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin refold_atom
///
/// @brief
///    This function refolds based on the internal coordinates storded in the
///	parent bond of the atom. Recursive calls itself until it finds an uptodate
/// atom or the root of the tree.
///
/// @detailed
///
/// @param Farray_1D_bool up_to_date atom coordinates
///        Atom * atom_to_refold
/// @global_read
///   reads from anchor triplet::xyzVectors of ligand
///   reads from bond_vector of ligand
/// @global_write
///   writes to atom_vector
/// @remarks
///
/// @references
///
/// @authors
///   Kristian Kaufmann
/// @last_modified  03-29-2006
////////////////////////////////////////////////////////////////////////////////
int
Ligand::refold_atom(
	FArray1Dp_bool up_to_date,
	ligand::Ligand_AtomOP atom_to_refold
){
	up_to_date.dimension(int(atom_vector.size()));
	if(!(atom_to_refold->Is_Root_Atom())){
		ligand::Ligand_BondAP parent_bond;
		ligand::Ligand_AtomOP parent_atom;
		atom_to_refold->get_parentbond(parent_bond);
		parent_bond->bonded_atoms(parent_atom, atom_to_refold);
		if(up_to_date(parent_atom->get_index())==false){
			refold_atom(up_to_date,parent_atom);
		}
		triplet::xyzVector< double > vector_A=parent_atom->get_coordinates();
		triplet::xyzVector< double > vector_B;
		triplet::xyzVector< double > vector_C;
		if(!(parent_atom->Is_Root_Atom())){
			ligand::Ligand_BondAP grand_parent_bond;
			ligand::Ligand_AtomOP grand_parent_atom;
			parent_atom->get_parentbond(grand_parent_bond);
			grand_parent_bond->bonded_atoms(grand_parent_atom,parent_atom);
			vector_B=grand_parent_atom->get_coordinates();
			if(!(grand_parent_atom->Is_Root_Atom())){
				ligand::Ligand_BondAP great_grand_parent_bond;
				ligand::Ligand_AtomOP great_grand_parent_atom;
				grand_parent_atom->get_parentbond(great_grand_parent_bond);
				great_grand_parent_bond->bonded_atoms(great_grand_parent_atom,
					grand_parent_atom);
				vector_C=great_grand_parent_atom->get_coordinates();
			}else{
				vector_C=anchor_first;
			}

		}else{
			vector_B=anchor_first;
			vector_C=anchor_second;
		}
		atom_to_refold->set_coordinates(vector_A, vector_B, vector_C,
			parent_bond->get_length(),  parent_bond->get_angle(),
			parent_bond->get_dihedral());
		up_to_date(atom_to_refold->get_index())=true;
		return 3;

	}else{
		if(up_to_date(atom_to_refold->get_index())==false){
			atom_to_refold->set_coordinates(anchor_third);
			up_to_date(atom_to_refold->get_index())=true;
			return 1;
		}
		return 2;
	}
	return -1;
}

// =============================================================================
//     int compute_ligand_conformations
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin compute_ligand_conformations
///
/// @brief
///    computes possible conformations of given ligand.
///
/// @detailed
///
/// @param
///
/// @global_read
///   reads from
///   reads from bond_vector of ligand
/// @global_write
///   writes to atom_vector
///		writes to bond_vector
///		writes to start_coord
///		writes to start_bonds
/// @remarks
///
/// @references
///
/// @authors
///   Kristian Kaufmann
/// @last_modified  04-05-2006
////////////////////////////////////////////////////////////////////////////////
int
Ligand::compute_ligand_conformations()
{


  // The first task is to obtain all the minima of the rotable
  // bonds from the minima file is the database. these will be store as
  // a list of pairs of pairs as follows below.
	std::vector< std::pair<
			std::pair<atom_chem::LigandAtomType,atom_chem::LigandAtomType>,
			std::vector< int > >
		> dihedral_minima;

	// a std::list of std::pairs with type ( std::pair of LigandAtomTypes )
	//and type ( std::vector of int )


	//container for rotable bond types as define by their Ligand atom types
	// in string form since the file will be read in terms of strings. This
	// makes the comparison easier
	std::list<std::pair<std::string,std::string> >
			temp_atompair;// temporary copy of needed atompairtypes

  // loop over all the bonds find the rotable types and storing the
  // ligandatomtypes as strings

  std::vector< ligand::Ligand_BondAP > rotable_bonds;
	for(ligand::Bond_Itr c_bond=bond_vector.begin(); c_bond!=bond_vector.end();
		c_bond++){

		if((*c_bond)->IsRotable()){
			rotable_bonds.push_back((*c_bond));
			ligand::Ligand_AtomAP atom1;
			ligand::Ligand_AtomAP atom2;
			(*c_bond)->bonded_atoms(atom1,atom2);
			std::pair< std::string , std::string > kind1, kind2;
			kind1.first=atom_chem::ligandatomtype_string[atom1->get_ligand_atom_type()];
			kind1.second=atom_chem::ligandatomtype_string[atom2->get_ligand_atom_type()];
			kind2.first=atom_chem::ligandatomtype_string[atom2->get_ligand_atom_type()];
			kind2.second=atom_chem::ligandatomtype_string[atom1->get_ligand_atom_type()];
			bool found_pair=false;
			for( std::list< std::pair< std::string,std::string > >::iterator
			       c_pair=temp_atompair.begin();
			       c_pair!=temp_atompair.end(); c_pair++){

				if((*c_pair)==kind1 || (*c_pair)==kind2 ){
					found_pair=true;
				}

			}
			if(!found_pair){
				temp_atompair.push_back(kind1);
			}
		}
	}

	// open the minima file
	utility::io::izstream iunit;
	iunit.clear();
	iunit.open(files_paths::data_path +
	"small_molecule_crystal_structure_dihedral_minima.txt");
	std::string atom1type_string, atom2type_string;
	size_t number_of_minima;
  // while loop iterates through the file until it finds all
  // the minima needed. It will check for failing stream and
  // end of file and deal with those cases
	while(!temp_atompair.empty()){
		iunit >> atom1type_string >> atom2type_string >> number_of_minima;
		if( iunit.eof()){
		}else if( iunit.fail()){
			std::cout << "small_molecule_crystal_structure_dihedral_minima.txt failed";
			std::cout << std::endl << " to open. Please check that it is ";
			std::cout << "in rosetta_database or that the file path is correct." <<  std::endl;
			iunit.clear();
			iunit.close();
			return -1;
		}
		// current pair type from file.
		std::pair< std::string, std::string > kind(atom1type_string,atom2type_string);

		std::list< std::pair < std::string, std::string > >::iterator c_pair=
			find(temp_atompair.begin(),temp_atompair.end(),kind);
		std::vector< int > minima;
		if(c_pair!=temp_atompair.end()){
			std::pair<atom_chem::LigandAtomType, atom_chem::LigandAtomType >
					atompair(atom_chem::get_ligandatomtype_from_string((*c_pair).first),
									atom_chem::get_ligandatomtype_from_string((*c_pair).second));
			minima.clear();
			minima.reserve(number_of_minima);

			for(size_t i=0;i<number_of_minima;i++){
				int minimum;
				iunit >> minimum;
				if( iunit.fail()){
					std::cout << "small_molecule_crystal_structure_dihedral_minima.txt failed";
					std::cout << std::endl << " on reading in " << atom1type_string;
					std::cout << " " << atom2type_string;
					std::cout << " pair. Please check the format of this pair." <<  std::endl;
					iunit.clear();
					iunit.close();
					return -1;
				}
				minima.push_back(minimum);

			}
			iunit.ignore( std::numeric_limits< std::streamsize >::max(), '\n' );
			temp_atompair.remove(*c_pair);// removes a pair that has been read

			std::pair<
				std::pair<atom_chem::LigandAtomType,atom_chem::LigandAtomType>,
				std::vector< int > > dihedral_pair;
			dihedral_pair.first=atompair;
			dihedral_pair.second=minima;															// that has been read.

			dihedral_minima.push_back(dihedral_pair);
		}else{
			// check for other permutation of kind
			kind.first=atom2type_string;
			kind.second=atom1type_string;
			c_pair=find(temp_atompair.begin(),temp_atompair.end(),kind);
			if(c_pair!=temp_atompair.end()){
      //pair of LigandAtomType to be push_back onto dihedral minima
			std::pair<atom_chem::LigandAtomType, atom_chem::LigandAtomType >
					atompair(atom_chem::get_ligandatomtype_from_string((*c_pair).first),
									atom_chem::get_ligandatomtype_from_string((*c_pair).second));
      //vector of minima to be push_back onto dihedral minima
			minima.clear();
			minima.reserve(number_of_minima);

			for(size_t i=0;i<number_of_minima;i++){
				int minimum;
				iunit >> minimum;
				if( iunit.fail()){
					std::cout << "small_molecule_crystal_structure_dihedral_minima.txt failed";
					std::cout << std::endl << " on reading in " << atom1type_string;
					std::cout << " " << atom2type_string;
					std::cout << " pair. Please check the format of this pair." <<  std::endl;
					iunit.clear();
					iunit.close();
					return -1;
				}
				minima.push_back(minimum);

			}
			iunit.ignore( std::numeric_limits< std::streamsize >::max(), '\n' );
			temp_atompair.remove(*c_pair);// removes a pair that has been read

			std::pair<
				std::pair< atom_chem::LigandAtomType,atom_chem::LigandAtomType > ,
				std::vector< int > > dihedral_pair;															// that has been read.
			dihedral_pair.first=atompair;
			dihedral_pair.second=minima;
			dihedral_minima.push_back(dihedral_pair);

			}// neither permutation matched therefore skip the rest of the line
			iunit.ignore( std::numeric_limits< std::streamsize >::max(), '\n' );
		}

		if(iunit.eof() && !(temp_atompair.empty())){
			std::cout << "Reached end of file without";
			std::cout << " finding minima for all atom pair types." << std::endl;
			std::cout << "Will set minima every thirty degress" << std::endl;

			for(std::list< std::pair< std::string,std::string > >::iterator
							c_atompair=temp_atompair.begin(); c_atompair!=temp_atompair.end();
							c_atompair++){

				minima.clear();
				minima.reserve(12);
				for(int i=-180;i<180;i+=30){
					minima.push_back(i);
				}
				std::pair<atom_chem::LigandAtomType, atom_chem::LigandAtomType >
					atompair(atom_chem::get_ligandatomtype_from_string((*c_atompair).first),
									atom_chem::get_ligandatomtype_from_string((*c_atompair).second));
				std::pair<
					std::pair<atom_chem::LigandAtomType,atom_chem::LigandAtomType>,
					std::vector< int > > dihedral_pair;
				dihedral_pair.first=atompair;
				dihedral_pair.second=minima;
				dihedral_minima.push_back(dihedral_pair);
			}
			temp_atompair.clear();
		}


	}
	iunit.clear();
	iunit.close();
	//now we have the minima and the rotable bonds of the ligand.
	// we need to generate the conformations
	// To do so we will select a random number of rotable bonds to rotate
	// and then rotate the bonds to dihedrals close to the minima
	// plus or minus 5 degrees

	//first store the start conformation in start_coord
	set_start_coordinates();

	std::multimap< float, ligand::LigandInternalCoord > conformations;
	// the multimap will store the best energy structures until the end of the
	// conformational search at which time they will be transfered over to the
	// ligand conformations vector.


	// following block of code stores a mapping of the rotable_bond to
	// the appropriate dihedral_minima entry
	std::vector<size_t> dihedral_type(rotable_bonds.size());
	if(runlevel_ns::runlevel >= runlevel_ns::inform ){
		std::cout << "There are " << rotable_bonds.size() << " dihedral angles being searched" << std::endl;
	}
	for(size_t i=0; i<rotable_bonds.size(); i++){
		dihedral_type[i]=0;
		ligand::Ligand_AtomAP atom1=NULL;
		ligand::Ligand_AtomAP atom2=NULL;
		rotable_bonds[i]->bonded_atoms(atom1,atom2);
		std::pair< atom_chem::LigandAtomType, atom_chem::LigandAtomType >
				atom_pair(atom1->get_ligand_atom_type(),
				 			atom2->get_ligand_atom_type());
		//finds appropriate minima and sets mapping.
		for(size_t j=0; j< dihedral_minima.size(); j++){
			if((dihedral_minima[j].first.first==atom_pair.first &&
				dihedral_minima[j].first.second==atom_pair.second) ||
				(dihedral_minima[j].first.first==atom_pair.second &&
				dihedral_minima[j].first.second==atom_pair.first)){

				dihedral_type[i]=j;
				break;
			}
		}
	}

	//kwk selecting number of ligand conformations.
	//kwk numbers based on number of Lys and ARG at a protein position with the given flags.
	//kwk
	size_t max_number_of_conformations=600;
	float exponent_number_rotable_bonds=2;
	size_t ex=0;
	if( design::active_rotamer_options.ex1 ){
			exponent_number_rotable_bonds=2.5;
			ex=1;
		if(design::active_rotamer_options.ex2){
			exponent_number_rotable_bonds=3.0;
			if(design::active_rotamer_options.ex3){
				exponent_number_rotable_bonds=4.0;
				if(design::active_rotamer_options.ex4){
					exponent_number_rotable_bonds=5.0;
				}
			}
		}
	}

	ligand::LigandInternalCoord current_int_conformation;
	size_t allowed_number_of_conformations=std::min(size_t(ceil(std::pow(float(rotable_bonds.size()+1),exponent_number_rotable_bonds))),
	    max_number_of_conformations);
	float min_rms=1000.0;
	for(int i=0; i<1000; i++){ //generates 1000 conformations with less than
	  for( size_t j=0; j<rotable_bonds.size();j++){
	  //chose minima to sample.
	    int minimum_angle=
	    dihedral_minima[dihedral_type[j]].second[
	        size_t(ran3()*dihedral_minima[dihedral_type[j]
	        ].second.size())
		];
	    // calculate delta to apply to the dihedral.
	    // first chose the final dihedral
	    // then get the current dihedral.
	    // the difference is the delta that needs to be applied.
	    double dihedral_angle= (double(minimum_angle)+(ran3()*10-5)*ex)
	      *utility::constants::d::pi_over_180;
	    ligand::Ligand_AtomAP atom1;
	    ligand::Ligand_AtomAP atom2;
	    rotable_bonds[j]->bonded_atoms(atom1, atom2);
	    std::list< ligand::Ligand_BondAP > child_bonds;
	    atom2->get_childbonds(child_bonds);
	    double current_dihedral=(*child_bonds.begin())->get_dihedral();
	    double delta_dihedral=dihedral_angle-current_dihedral;
	    twist_dihedral_radians(delta_dihedral, *rotable_bonds[j]);
	  }// for j
	  // computed different conformations now need to score and store.
	  get_ligand_internal_energy(false);
	  //kwk note to self weights need to be fit
	  float total_int_energy= param_pack::packer_misc_parameters::Wlig_int_rep *lig_int_repE
	    + param_pack::packer_misc_parameters::Wlig_int_atr *lig_int_atrE
	    + param_pack::packer_misc_parameters::Wlig_int_solv *lig_int_solvE
	    + param_pack::packer_misc_parameters::Wlig_int_dihed *lig_int_dihedE
	    + param_pack::packer_misc_parameters::Wlig_int_hb*lig_int_hbE
	    + param_pack::packer_misc_parameters::Wlig_int_cou*lig_int_coulombE;
	//		std::cout << total_int_energy << std::endl;
	  if( total_int_energy < 3*atom_vector.size() ){ // this is an arbitary value it needs to be confirmed

	    current_int_conformation=get_ligand_internal_conformation(*this);
	    std::pair< float , ligand::LigandInternalCoord > energy_conformation(
	      total_int_energy,current_int_conformation);
	    conformations.insert(energy_conformation);
	  }else{
	    i--;
	  }
	}// for i

	//kwk selecting only top scoring conformations 10 energy units is an arbitary number.
	// ideally it needs to be validated.

	float min_energy=(*conformations.begin()).first;
	std::multimap< float, ligand::LigandInternalCoord >::const_iterator last_conf=
		conformations.upper_bound( min_energy+float(2*rotable_bonds.size()) );
	for(std::multimap< float, ligand::LigandInternalCoord >::iterator c_conf=
		conformations.begin(); c_conf!=last_conf; c_conf++){
	  ligand_conformations.push_back((*c_conf).second);
	}

	std::list< ligand::LigandCartesianCoord > possible_conformations;
	std::list< ligand::LigandCartesianCoord > accepted_cartesian_conformations;
	//kwk loading lists of cartesian coord for rms check
	for( size_t l=0; l < ligand_conformations.size(); l++ ){
	  change_to_ligand_conformation(l);
//	  utility::io::ozstream pdbout("ligand_conf.pdb");
//	  make_pdb_hetero(pdbout, *this);
//	  pdbout.close();
	  if( l==0){
	    accepted_cartesian_conformations.push_back(
	    	get_ligand_cartesian_conformation(*this));
	  }else{
	  	possible_conformations.push_back(
	    	get_ligand_cartesian_conformation(*this));
	  }
	}
	std::list< ligand::LigandCartesianCoord >::iterator accepted_conformation=
	  possible_conformations.begin();
	float test_rms=10;
	while(accepted_cartesian_conformations.size() < allowed_number_of_conformations &&
	  test_rms > 0.2 ){

	  test_rms=calc_rms_maximal_minimal_rms(accepted_cartesian_conformations,
	    possible_conformations, accepted_conformation);
	  //std::cout << "Minimal RMS " << min_rms << std::endl;
	  if( test_rms > 0.2 ){
	    accepted_cartesian_conformations.push_back(*accepted_conformation);
	    possible_conformations.remove(*accepted_conformation);
      min_rms=test_rms;
	  }
	}

	//transfer accepted_cartesian_conformations into ligand_conformations
	ligand_conformations.clear();
	ligand_conformations.reserve(accepted_cartesian_conformations.size());
	for(std::list< ligand::LigandCartesianCoord >::iterator
	  c_cart_conf=accepted_cartesian_conformations.begin();
	  c_cart_conf!=accepted_cartesian_conformations.end();
	  c_cart_conf++){

	  set_ligand_cartesian_conformation(*c_cart_conf,*this);
	  ligand_conformations.push_back(get_ligand_internal_conformation(*this));
	}

//	if( runlevel_ns::runlevel >= runlevel_ns::inform){
		std::cout << ligand_conformations.size() <<
			" Small molecule conformations have been accepted" << std::endl;
		std::cout << "Maximal minimal RMS is: " << min_rms << std::endl;
		std::cout << "Maximal minimal RMS50 is: " << (min_rms/(1+std::log(std::sqrt(float(atom_vector.size())/50)))) << std::endl;
//	}
	// recover starting conformation and store in ligand_conformations.
	recover_start_coordinates();

	//find minimal rms to input conformation
	possible_conformations.clear();
	possible_conformations.push_back(get_ligand_cartesian_conformation(*this));
  min_rms=calc_rms_maximal_minimal_rms(accepted_cartesian_conformations,
	    possible_conformations, accepted_conformation);
	std::cout << "Minimal RMS to input structure " << min_rms << std::endl;
	std::cout << "Minimal RMS50 to input structre is: " << (min_rms/(1+std::log(std::sqrt(float(atom_vector.size())/50)))) << std::endl;
	get_ligand_internal_energy(false);
	float total_int_energy= param_pack::packer_misc_parameters::Wlig_int_rep *lig_int_repE
	    + param_pack::packer_misc_parameters::Wlig_int_atr *lig_int_atrE
	    + param_pack::packer_misc_parameters::Wlig_int_solv *lig_int_solvE
	    + param_pack::packer_misc_parameters::Wlig_int_dihed *lig_int_dihedE
	    + param_pack::packer_misc_parameters::Wlig_int_hb*lig_int_hbE
	    + param_pack::packer_misc_parameters::Wlig_int_cou*lig_int_coulombE;
	std::cout << "Minimum Internal Energy in ligand conformations " << min_energy << std::endl;
	std::cout << "Internal Energy of Input conformation " << total_int_energy << std::endl;
	if( use_input_ligand){
	  ligand_conformations.push_back(start_bonds);
	}

//	utility::io::ozstream pdbout("ligand_conf.pdb");
//	for(size_t k=0; k<ligand_conformations.size(); k++){
//		change_to_ligand_conformation(k);
//		make_pdb_hetero(pdbout, *this);
//	}
	recover_start_coordinates();
	return 1;
}

// =============================================================================
//     int change_to_ligand_conformation
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin change_to_ligand_conformation
///
/// @brief
///    switches to alternate conformation of the ligand
///
/// @detailed
///
/// @param
///
/// @global_read
///   reads from ligand_conformations
/// @global_write
///   writes to atom_vector
///		writes to bond_vector
/// @remarks
///
/// @references
///
/// @authors
///   Kristian Kaufmann
/// @last_modified  05-10-2006
////////////////////////////////////////////////////////////////////////////////

int
Ligand::change_to_ligand_conformation(
	size_t x
){
	if( x < ligand_conformations.size()){
		if(ligand_conformations[x].size()!=bond_vector.size()){
			std::cout << "conformation in ligand_conformations has more vectors than allowed for this small molecule" << std::endl;
			return -2;
		}
		for( size_t i=0; i<bond_vector.size(); i++){
			bond_vector[i]->set_coordinates((ligand_conformations[x])[i]);
			if( refold_ligand()!=1){
				std::cout << "Can't refold ligand in change_to_ligand_conformation" << std::endl;
				return -3;
			};
//kwk			recompute_ligand_interface=true;
		}
		return 1;
	}

	std::cout << "change_to_ligand_conformation was passed a out of range value." << std::endl;
	return -1;
}

// =============================================================================
//     void get_bonded_atoms
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin get_bonded_atoms
///
/// @brief
///
///
/// @detailed
///
/// @param [out] bonded_atoms
/// @param [in] first_atom
///
/// @global_read
///
/// @global_write
/// @remarks
///
/// @references
///
/// @authors
///   Kristian Kaufmann
/// @last_modified  05-10-2006
////////////////////////////////////////////////////////////////////////////////
void
Ligand::get_bonded_atoms(
	std::list< ligand::Ligand_AtomAP > & bonded_atoms,
	ligand::Ligand_AtomAP first_atom
){
  	bonded_atoms.clear();
  	ligand::Ligand_AtomAP atom1;
  	ligand::Ligand_AtomAP atom2;
  	ligand::Ligand_BondAP bond1;
  	std::list< ligand::Ligand_BondAP > bond_child;
  	if(!first_atom->Is_Root_Atom()){
  	  first_atom->get_parentbond(bond1);
  	  bond1->bonded_atoms(atom1,atom2);
  	  if( atom2==first_atom){
  	    bonded_atoms.push_back(atom1);
  	  }else{
  	    bonded_atoms.push_back(atom2);
  	  }
  	}
  	first_atom->get_childbonds(bond_child);
  	for(std::list< BondSmallMoleculeAP >::iterator current_bond=bond_child.begin();
  	  current_bond!=bond_child.end(); current_bond++){
			(*current_bond)->bonded_atoms(atom1,atom2);
			if( atom1==first_atom){
  	    bonded_atoms.push_back(atom2);
  	  }else{
  	    bonded_atoms.push_back(atom1);
  	  }
		}
  	return;
  }

// =============================================================================
//     void optimize_H
// =============================================================================

//////////////////////////////////////////////////////////////////////////////
/// @begin optimize_H
///
/// @brief Optimizes hydrogens according to the internal energy function
/// used primarly to get rid of clashes in the input structure.  Works
/// by rotating bonds that only effect hydrogens. Isn't a comprehensive approach.
/// should be replaced by a gradient minimization once the atom tree is integrated
/// into ligand usage.
///
/// @detailed
///
/// @param [in] first_atom
///
/// @global_read
///
/// @global_write
/// @remarks
///
/// @references
///
/// @authors
///   Kristian Kaufmann
/// @last_modified  06-26-2006
////////////////////////////////////////////////////////////////////////////////
void
Ligand::optimize_H(
){
  std::cout << "Entering ligand optimize_H" << std::endl;
	for( ligand::Atom_Itr c_atom=atom_vector.begin(); c_atom!=atom_vector.end();c_atom++){
	  std::list< ligand::Ligand_BondAP > childbonds;
	  ligand::Ligand_AtomAP atom1, atom2;
	  bool all_hydrogens=true;
	  (*c_atom)->get_childbonds(childbonds);
	  if( childbonds.size() !=0 ){
	    for( std::list< ligand::Ligand_BondAP >::iterator c_bond=childbonds.begin();
	      c_bond!=childbonds.end();c_bond++){

	      (*c_bond)->bonded_atoms(atom1,atom2);
	      if(atom2->get_element_type()!=atom_chem::HYDROGEN){
	        all_hydrogens=false;
	      }
	    }
	    if(all_hydrogens){
	      ligand::LigandCartesianCoord best_conformation;
        ligand::Ligand_BondAP pbond;
        (*c_atom)->get_parentbond(pbond);
	      float best_energy, current_energy;
	      best_conformation=get_ligand_cartesian_conformation( *this );
	      get_ligand_internal_energy(false);
	      best_energy=param_pack::packer_misc_parameters::Wlig_int_rep *lig_int_repE
          + param_pack::packer_misc_parameters::Wlig_int_atr *lig_int_atrE
          + param_pack::packer_misc_parameters::Wlig_int_solv *lig_int_solvE
          + param_pack::packer_misc_parameters::Wlig_int_dihed *lig_int_dihedE
          + param_pack::packer_misc_parameters::Wlig_int_hb*lig_int_hbE
          + param_pack::packer_misc_parameters::Wlig_int_cou*lig_int_coulombE;
	      double delta_dihedral=3*utility::constants::d::pi_over_180;
	      pbond->set_rotability(true);
	      for( size_t i=0; i<=360/childbonds.size(); i+=3){
	        twist_dihedral_radians(delta_dihedral,*pbond);
	        get_ligand_internal_energy(false);
	        current_energy=param_pack::packer_misc_parameters::Wlig_int_rep *lig_int_repE
            + param_pack::packer_misc_parameters::Wlig_int_atr *lig_int_atrE
            + param_pack::packer_misc_parameters::Wlig_int_solv *lig_int_solvE
            + param_pack::packer_misc_parameters::Wlig_int_dihed *lig_int_dihedE
            + param_pack::packer_misc_parameters::Wlig_int_hb*lig_int_hbE
            + param_pack::packer_misc_parameters::Wlig_int_cou*lig_int_coulombE;
	        if( current_energy < best_energy ){
	          best_energy=current_energy;
	          best_conformation=get_ligand_cartesian_conformation( *this );
	        }
	      }
        set_ligand_cartesian_conformation( best_conformation, *this);
	      pbond->set_rotability(false);
	    }
	  }
	}
  std::cout << "Exiting ligand optimize_H" << std::endl;
  return;
}
namespace ligand {
	Ligand * ligand_one = NULL;
  Ligand * ligand_two = NULL;
	std::vector<Ligand * > ligand_ptr_vector;
	bool ligand_flag = {false } ;
	bool ligand_mdlfile = { false };
	bool ligand_flexible = { false };
	std::list<std::pair<
		std::pair<atom_chem::LigandAtomType,atom_chem::LigandAtomType>,
		PeriodicSplineReader > > dihedral_splines;

	//bills deal with multiple ligands simultaneously
	namespace multi_lig {
		int n_lig = 0;
		int n_atoms_all_lig = 0;
		FArray1D_int list_n_atoms_lig( param::HETERO_ATOM_MAX() );
		FArray1D_int list_start_atoms_lig( param::HETERO_ATOM_MAX() );
		FArray1D_int list_aa_lig( param::MAX_N_LIG );
		FArray1D_int list_aav_lig( param::MAX_N_LIG );
		FArray3D_double multi_lig_coord( 3, param::MAX_N_ATOMS_ONE_LIG, param::MAX_N_LIG );
	}
}

