// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10744 $
//  $Date: 2006-10-16 17:42:40 -0700 (Mon, 16 Oct 2006) $
//  $Author: wollacott $

#ifndef INCLUDED_ligand_ns
#define INCLUDED_ligand_ns

// Rosetta Headers
#include "LigandAtomPairEnergy.h"
#include "atom_chem.h"

// Triplet Headers
#include "triplet/xyzVector.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>

//utility Headers
#include "utility/PeriodicSplineReader.h"

// C++ Headers
#include <vector>
#include <list>

//forward Declarations
class BondSmallMolecule;
class Atom;
namespace ligand{

	//kwk the following two typedefs may turn into class in time
	// so I am adding these ease the possible transition
	typedef std::vector< triplet::xyzVector < double > > LigandCartesianCoord;
	typedef std::vector< triplet::xyzVector < double > > LigandInternalCoord;
	typedef Atom * Ligand_AtomOP;
	typedef Atom * Ligand_AtomAP;
	typedef BondSmallMolecule * Ligand_BondAP;
}

class Ligand {

	public:
//==============================================================================
//
//     ligand_ns
//
//     Jens Meiler April 2003
//	   Kristian Kaufmann October 2005
//==============================================================================

//mj fields for hetero atoms, introduced for loop building and ligand docking
//mj and side chain packing for loop building only a simplified clash check is
//mj performed.  for this all atoms are mapped on atom types
//mj 1=N,2=CA,3=CB,4=C,5=O in hetero_atom_cent for docking/packing ROSETTA full
//mj atom types are necesarry => all atoms need to be mapped on the 25 ROSETTA
//mj full atom types in hetero_atom_type! this type is obtained from the PDB
//mj name of the atom.

//constructors and destructor
	Ligand();
	Ligand(Ligand & p);
	Ligand & operator=(Ligand & p);
	~Ligand();

	//MEMBER DATA
	bool use_input_ligand;
	bool fix_ligand_HO; // flag to disallow optimization of HO position
	// atom information: coordinates, type, centroid, name etc. see atom.h
	std::vector< ligand::Ligand_AtomOP > atom_vector;
	 // best_coordinates
	ligand::LigandInternalCoord best_bonds; // best internal coordinates
	ligand::LigandCartesianCoord best_coord;// best cartesian coordinates
	 // low_coordinates
	ligand::LigandInternalCoord start_bonds; // start internal coordinates
	ligand::LigandCartesianCoord start_coord;// start cartesian coordinates
	std::vector< BondSmallMolecule * > bond_vector; // owning pointers
	// of bonds between Atom objects in atom_vector
	std::vector< ligand::Ligand_AtomOP > trial_roots; // non-owning
	// pointers to Atom objects at the root of bond trees.


	std::vector< ligand::LigandInternalCoord > ligand_conformations;
	// internal coordinates of conformations for a flexible ligand
	size_t number_of_conformations;
	triplet::xyzVector< double > anchor_first_start; // anchors used during flexible
	triplet::xyzVector< double > anchor_second_start;// ligand docking
	triplet::xyzVector< double > anchor_third_start;
	triplet::xyzVector< double > anchor_first_best; // anchors used during flexible
	triplet::xyzVector< double > anchor_second_best;// ligand docking
	triplet::xyzVector< double > anchor_third_best;
	triplet::xyzVector< double > anchor_first; // anchors used during flexible
	triplet::xyzVector< double > anchor_second;// ligand docking
	triplet::xyzVector< double > anchor_third;
	size_t anchor_state;
	std::list<LigandAtomPairEnergy> ligand_atom_pair_energy;

	FArray1D_float hetero_born_radius; // Born radii
	float hetero_atom_total_charge; // total charge of heteroatoms
	FArray1D_int virtual_atom_bnd;
	 // index of hetero atom that is covalantly bond to a virtual atom
	FArray1D_int virtual_atom_map;
	 // index of amino_acid and atom that is currently mapped on a virtual atom
	FArray1D_string hetero_atom_resid;
	 // name of hetero residues
	int virtual_atom_count; // virtual atom count
	FArray2D_int hetero_atom_hbond_acc;
	 // pairs of hetero atoms that may accept a h-bond (e.g. >C=O)
	FArray2D_int hetero_atom_hbond_don;
	 // pairs of hetero atoms that may donate a h-bond (e.g. -O-H)
	int hetero_atom_hbond_acc_count;
	 // count of hetero atoms that may accept a h-bond (e.g. >C=O)
	int hetero_atom_hbond_don_count;
	 // count of hetero atoms that may donate a h-bond (e.g. -O-H)
	bool recompute_ligand_interface;
	 // flag that reports if interface needs to be recomputed
	int lig_neighbors;
	float lig_repE;
	float lig_atrE;
	float lig_solE;
	float lig_couE;
	float lig_h2oE;
	float lig_hbE;
	float lig_virE;
	float lig_sumE;
	float lig_sasE;
	float lig_int_repE;
	float lig_int_atrE;
	float lig_int_solvE;
	float lig_int_dihedE;
	float lig_int_coulombE;
	float lig_int_hbE;

// functions
	void
	get_FArray2D_of_coordinates(
		const std::vector < ligand::Ligand_AtomOP > & ligand_atom,
		FArray2D_float & het_coord
	);

	void
	get_FArray1D_of_charge(
		const std::vector < ligand::Ligand_AtomOP > & ligand_atom,
		FArray1D_float & het_charge
	);

	void
	get_FArray1D_of_atom_type(
		const std::vector < ligand::Ligand_AtomOP > & ligand_atom,
		FArray1D_int & het_atom_type
	);

	int
	setup_bond_graph(
	);

	int
	setup_bond_graph(
		std::list < triplet::xyzVector < size_t > > & bond_map,
		int root_atom
	);

	int
	get_bond_map(
		std::list < triplet::xyzVector < size_t > > & bond_map
	);

	int
	set_ring_rigid(
		BondSmallMolecule & bond,
		ligand::Ligand_AtomOP atom2,
		std::list< BondSmallMolecule * > & rigid_bonds
	);

	int
	set_ligand_atom_types(
	);


	size_t
	get_atom_closest_to_centroid(
	);

	int
	get_number_of_double_bonded_oxygens(
		ligand::Ligand_AtomOP atom1
	);

	int
	get_hybridization(
		ligand::Ligand_AtomOP atom1
	);

	int
	get_number_of_hydrogens(
		ligand::Ligand_AtomOP atom1
	);

	int
	get_number_of_aromatic_bonds(
		ligand::Ligand_AtomOP atom1
	);

	bool
	Are_Bonded(
		ligand::Ligand_AtomOP atom1,
		ligand::Ligand_AtomOP atom2
	);

	bool
	calculate_internal_coordinates(
		bool initialize
	);

	int
	twist_dihedral_radians(
	double dihedral,
	BondSmallMolecule & bond
	);

	int
	set_best_coordinates(
	);

	int
	recover_best_coordinates(
	);

	int
	set_start_coordinates(
	);

	int
	recover_start_coordinates(
	);

	inline
	int
	set_anchors(
		triplet::xyzVector< double > anchor_one,
		triplet::xyzVector< double > anchor_two,
		triplet::xyzVector< double > anchor_three
	){
		anchor_first=anchor_one;
		anchor_second=anchor_two;
		anchor_third=anchor_three;
		return 1;
	};

	int
	get_ligand_internal_energy(
	bool initialize
	);

	int
	refold_ligand(
	);

	int
	refold_atom(
		FArray1Dp_bool up_to_date,
		ligand::Ligand_AtomOP atom_to_refold
	);

	int
	compute_ligand_conformations(
	);

	int
	change_to_ligand_conformation(
		size_t x
	);


	void
	get_bonded_atoms(
	  std::list< ligand::Ligand_AtomAP > & bonded_atoms,
	  ligand::Ligand_AtomAP
	);

  void
  optimize_H(
  );

//==============================================================================


};//
namespace ligand{
	extern std::vector<Ligand * > ligand_ptr_vector;
	extern Ligand * ligand_one;
  extern Ligand * ligand_two;
	extern bool ligand_flag; // flag for reading, handling and writing potential ligands in docking/packing
	extern bool ligand_flexible;
	extern bool ligand_mdlfile;
	typedef std::vector<ligand::Ligand_AtomOP > ::iterator Atom_Itr;
	typedef std::vector< BondSmallMolecule * > ::iterator Bond_Itr;
	extern std::list < std::pair <
					std::pair<atom_chem::LigandAtomType,atom_chem::LigandAtomType>,
					PeriodicSplineReader > > dihedral_splines;

	//bills deal with multiple ligands simultaneously
	namespace multi_lig {
		extern int n_lig;
		extern int n_atoms_all_lig;
		extern FArray1D_int list_n_atoms_lig;
		extern FArray1D_int list_start_atoms_lig;
		extern FArray1D_int list_aa_lig;
		extern FArray1D_int list_aav_lig;
		extern FArray3D_double multi_lig_coord;
	}
	using namespace multi_lig;
}

#endif
