// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8698 $
//  $Date: 2006-06-05 22:50:03 -0700 (Mon, 05 Jun 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_hiv_trimer
#define INCLUDED_hiv_trimer


// package headers
#include <epigraft/epigraft_types.hh>

// Rosetta Headers
//#include "loop_class.h"
#include <pose_fwd.h>

// ObjexxFCL headers
#include <ObjexxFCL/ObjexxFCL.hh>

// numeric headers
#include <numeric/BodyPosition.fwd.hh>
#include <numeric/Quaternion.fwd.hh>
#include <numeric/xyzVector.fwd.hh>

// C++ Headers
#include <string>
#include <utility>
#include <vector>


namespace epigraft {
namespace legacy {


// typedefs
typedef std::vector< std::pair< Integer, numeric::Quaternion< Real > > > SO3;


void
hiv_trimer();

void
identify_interface_positions(
                             pose_ns::Pose & pose,        //trimer of proteins at minimum
                             bool const & glycan_attached,    // is glycan also attached?
                             bool const & Ab_attached,  // is antibody (1 copy, to monomer 1) also attached?
                             int const & nres_monomer,
                             int const & nres_glycan,
                             int const & nres_Ab,
                             FArray1D_bool const & natro_position, // positions on protein_trimer that cannot be minimized/repacked
                             FArray1D_bool & interface_position,
                             FArray1D_int & list_interface_positions
                             );


void
read_list_anchor_resnums(
                         FArray1D_int & list_anchor_resnums
                         );

bool
integer_is_even( int & num );


/// @brief read quaternion positions in id, w, x, y, z format
/// @param[out] list of pairs of quaternion id + quaternion
void
load_quaternions(
	std::string const & filename,
	SO3 & v
);


/// @brief compute centroid of backbone heavy atoms N,CA,C,O
numeric::xyzVector< Real >
backbone_centroid(
	Pose const & pose
);


/// @brief trimer translation based on distance
void
trimer_translation(
	Real const & distance,
	numeric::xyzVector< Real > & m1_t,
	numeric::xyzVector< Real > & m2_t,
	numeric::xyzVector< Real > & m3_t
);


/// @brief create trimer transforms given a quaternion and trimer distance
void
trimer_transforms(
	numeric::Quaternion< Real > const & q,
	Real const & translation_distance,
	numeric::BodyPosition< Real > & monomer1_transform,
	numeric::BodyPosition< Real > & monomer2_transform,
	numeric::BodyPosition< Real > & monomer3_transform
);


/// @brief transform Pose full_coord coordinates into external FArray3D
/// @param[in] offset  offsets last dimension when filling in FArray3D
void
transform_full_coord(
	Pose const & pose,
	numeric::BodyPosition< Real > const & bp,
	FArray3D< Real > & full_coord,
	Size const & offset = 0
);


/// @brief constructs a trimer Pose given appropriate transforms
void
create_trimer(
	numeric::Quaternion< Real > const & q,
	Real const & translation_distance,
	Pose const & monomer,
	Pose & trimer
);


}
}


#endif
