// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   additional_filters.hh
/// @brief  functions for additional filtering and statistics of matches
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_additional_filters_HH_
#define INCLUDED_epigraft_match_additional_filters_HH_

// package headers
#include <epigraft/match/match_types.hh>
#include <epigraft/match/MatchResult.fwd.hh>
#include <epigraft/GraftOptions.fwd.hh>

// utility headers
#include <utility/vector1.fwd.hh>


namespace epigraft{
namespace match {


/// @brief filters match results for given rms
void
strict_rms_filter(
	Real const & rms,
	utility::vector1< MatchResult > const & match_results,
	utility::vector1< MatchResult > & filtered_results
);

/// @brief filters match results to remove incomplete matches, ie if you want to match
/// @brief 3 epitope loops, then singleton and double matches will be removed
///vds
void
filter_out_incomplete_matches(
	std::size_t const & num_loops,
	utility::vector1< MatchResult > const & match_results,
	utility::vector1< MatchResult > & filtered_results
);

/// @brief filters match results for C-beta positions on the alanine scaffold that
/// @brief are close to any heavy atoms of the given filter structure
void
cbeta_spatial_filter(
	GraftOptions const & options,
	Pose & ala_scaffold,
	utility::vector1< MatchResult > const & match_results,
	Pose & filter_structure,
	utility::vector1< MatchResult > & filtered_results
);


/// @brief compute number of c-beta neighbors per component (heavy atoms only)
void
cbeta_neighbors_per_component(
	GraftOptions const & options,
	Pose & epitope,
	Pose & ala_scaffold,
	utility::vector1< MatchResult > & match_results
);


} // namespace match
} // namespace epigraft

#endif /*INCLUDED_epigraft_match_additional_filters_HH_*/
