// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   combi_match.hh
/// @brief  build multi-point matches from primary components and near neighbor criteria
/// @note   this is a rough match variant
/// @author Yih-En Andrew Ban (yab@u.washington.edu)
/// @author Bill Schief (schief@u.washington.edu)

#ifndef INCLUDED_epigraft_match_combi_match_HH_
#define INCLUDED_epigraft_match_combi_match_HH_

// package headers
#include <epigraft/match/match_types.hh>
#include <epigraft/match/MatchResult.fwd.hh>
#include <epigraft/AntibodyComplex.hh>
#include <epigraft/GraftOptions.hh>
#include <epigraft/LoopInfo.hh>

// utility headers
#include <utility/vector1.fwd.hh>


namespace epigraft {
namespace match {

/// @brief  build multi-point matches from primary components and near neighbor criteria
/// @note   this is a rough match variant
void
combi_match(
	GraftOptions const & options,
	AntibodyComplex & native,
	utility::vector1< LoopInfo > const & loops_to_scan,
	Pose & scaffold,
	utility::vector1< MatchResult > & singleton_matches,
	utility::vector1< MatchResult > & multiple_matches
);

} // match
} // epigraft

#endif /*INCLUDED_epigraft_match_combi_match_HH_*/
