// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   match_constants.hh
/// @brief  Constants for epigraft/match
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_match_constants_HH_
#define INCLUDED_epigraft_match_match_constants_HH_

// Objexx headers
#include <ObjexxFCL/FArray2D.hh>

// C++ headers
#include <cmath>

namespace epigraft {
namespace match {


static Real MATCH_INFINITY = INFINITY;
static Real const OCTREE_CUBE_SIZE = 6.0;
static ObjexxFCL::FArray2D< Real > FOUR_BY_FOUR_IDENTITY_REAL = ObjexxFCL::FArray2D< Real >::identity( 4 );

} // match
} // epigraft

#endif /*INCLUDED_epigraft_match_match_constants_HH_*/
