// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   match_io.hh
/// @brief  I/O for match.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_match_io_HH_
#define INCLUDED_epigraft_match_match_io_HH_

// package headers
#include <epigraft/match/match_types.hh>
#include <epigraft/match/MatchResult.fwd.hh>
#include <epigraft/AntibodyComplex.fwd.hh>
#include <epigraft/GraftOptions.fwd.hh>
#include <epigraft/LoopInfo.fwd.hh>

// utility headers
#include <utility/vector1.fwd.hh>

// C++ headers
#include <map>
#include <set>
#include <string>


namespace epigraft {
namespace match {


/// @brief match result from file (from output table), fill in as much data as possible
/// @brief from given file
void
match_results_from_file(
	std::string const & filename,
	utility::vector1< LoopInfo > loops_to_scan,
	std::map< std::string, utility::vector1< MatchResult > > & pdbs_to_match_results
);


/// @brief output pdb of loops given a match result
void
output_aligned_loops_pdb(
	Pose const & epitope,
	MatchResult const & match_result,
	std::string const & output_pdb_filename
);


/// @brief output pdb of pre-design structure given a match result
void
output_predesign_structure_pdb(
	Pose const & scaffold,
	Pose const & epitope,
	MatchResult const & match_result,
	std::set< Integer > const & keep_natro_residues,
	std::string const & output_pdb_filename
);


/// @brief output pdb of pre-design structure given a match result with Antibody
void
output_predesign_structure_pdb_with_Ab(
	Pose const & scaffold,
	Pose const & epitope,
	Pose const & antibody,
	MatchResult const & match_result,
	std::set< Integer > const & keep_natro_residues,
	std::string const & output_pdb_filename
);


} // namespace epigraft
} // namespace match

#endif /*INCLUDED_epigraft_match_match_io_HH_*/
