// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   match_types.hh
/// @brief  Types for epigraft/match
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_match_types_HH_
#define INCLUDED_epigraft_match_match_types_HH_

// epigraft headers
#include <epigraft/epigraft_types.hh>
#include <epigraft/match/align/AlignmentSystem.fwd.hh>

// numeric headers
#include <numeric/xyzVector.fwd.hh>

// utility headers
#include <utility/pointer/owning_ptr.fwd.hh>


namespace epigraft {
namespace match {


// typedefs
typedef utility::pointer::owning_ptr< epigraft::match::align::AlignmentSystem > AlignmentSystemOP;

// for try_rb_move -- originally taken from an old rootstock class
typedef Real Angle;
typedef Real Length;
typedef numeric::xyzVector< Real > Vector;
typedef numeric::xyzVector< Real > Point;


} // namespace match
} // namespace epigraft

#endif /*INCLUDED_epigraft_match_match_types_HH_*/
