// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   refine_matches.hh
/// @brief  functions for refining matches
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_refine_matches_HH_
#define INCLUDED_epigraft_match_refine_matches_HH_

// package headers
#include <epigraft/AntibodyComplex.fwd.hh>
#include <epigraft/GraftOptions.fwd.hh>
#include <epigraft/match/match_types.hh>
#include <epigraft/match/MatchResult.fwd.hh>

// rosetta headers
#include <param_aa.h>

// utility headers
#include <utility/vector1.fwd.hh>

// C++ headers
#include <set>


namespace epigraft{
namespace match {


/// @brief refine superposition protocol matches by min+repack
/// @details constructs temporary EpitopeScaffold object and calls
/// @details EpitopeScaffold::Ab_epitope_optimize() using both chi
/// @details and rb minimize, and then Epitope:Scaffold::repack_interface()
void
minrepack_superposition_matches(
	GraftOptions const & options,
	AntibodyComplex & native,
	Pose & scaffold,
	utility::vector1< MatchResult > & match_results,
	std::set< Integer > const & keep_natro_residues = std::set< Integer >(),
	bool const & output_pdb = false
);


/// @brief screen matches using repack
/// @details constructs temporary EpitopeScaffold object, converts
/// @details scaffold to either gly/hybrid ala-gly (with epitope sidechains), call
/// @details EpitopeScaffold::repack_interface(), and outputs the inter-clash
void
screen_matches_with_repack(
	GraftOptions const & options,
	AntibodyComplex & native,
	Pose & scaffold,
	utility::vector1< MatchResult > & match_results,
	std::set< Integer > const & keep_natro_residues = std::set< Integer >()
);


}
}

#endif /*INCLUDED_epigraft_match_refine_matches_HH_*/
