// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   rescore_matches.hh
/// @brief  Takes a set of matches and rescore with respect to their existing internal information.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_rescore_matches_HH_
#define INCLUDED_epigraft_match_rescore_matches_HH_

// package headers
#include <epigraft/match/match_types.hh>
#include <epigraft/match/MatchResult.fwd.hh>
#include <epigraft/AntibodyComplex.fwd.hh>
#include <epigraft/GraftOptions.fwd.hh>

// utility headers
#include <utility/vector1.fwd.hh>

// C++ headers
#include <set>


namespace epigraft {
namespace match {


/// @brief  Takes a set of matches and rescore with respect to their existing internal information.
void
rescore_matches(
	GraftOptions const & options,
	AntibodyComplex & native,
	Pose & scaffold,
	utility::vector1< MatchResult > & match_results,
	std::string const & scaffold_filename = "",
	std::set< Integer > const & user_specified_superposition_residues = std::set< Integer >()
);


/// @brief Take a match and rescore it with respect to its existing internal information.
/// @note  If rescoring a set of matches, use rescore_matches() instead, as it's more efficient.
void
rescore_match(
	GraftOptions const & options,
	AntibodyComplex & native,
	Pose & scaffold,
	MatchResult & match_result,
	std::string const & scaffold_filename = "",
	std::set< Integer > const & user_specified_superposition_residues = std::set< Integer >()
);


} // namespace match
} // namespace epigraft


#endif /*INCLUDED_epigraft_match_rescore_matches_HH_*/
