// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   try_fluid_ends.hh
/// @brief  functions for attempting recover/optimization by fluidizing endpoints
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_try_fluid_ends_HH_
#define INCLUDED_epigraft_match_try_fluid_ends_HH_


// package headers
#include <epigraft/match/match_types.hh>
#include <epigraft/match/MatchResult.fwd.hh>
#include <epigraft/GraftOptions.fwd.hh>
#include <epigraft/AntibodyComplex.fwd.hh>
#include <epigraft/conformation/FluidLandingResult.hh>

// utility headers
#include <utility/vector1.fwd.hh>


namespace epigraft {
namespace match {


/// @brief attempt recovery/optimization of *primary* match by fluidizing takeoff terminus (for single break only)
void
try_fluidizing_takeoff(
	GraftOptions const & options,
	AntibodyComplex & native,
	Pose & scaffold,
	utility::vector1< MatchResult > & match_results
);


/// @brief attempt recovery/optimization of all breaks by fluidizing landing termini (single and double breaks)
void
try_fluidizing_landing(
	GraftOptions const & options,
	AntibodyComplex & native,
	Pose & scaffold,
	utility::vector1< MatchResult > & match_results,
	Integer const & skip_component = 0
);


/// @brief get best fluid result w/ respect to rms
Integer
index_of_best_fluid_result(
	utility::vector1< epigraft::conformation::FluidLandingResult > const & results,
	Real const & original_rms
);


} // match
} // epigraft

#endif /*INCLUDED_epigraft_match_try_fluid_ends_HH_*/
