// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   try_rb_move.hh
/// @brief  functions for attempting recover/optimization by rb-move
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_match_try_rb_move_HH_
#define INCLUDED_epigraft_match_try_rb_move_HH_

// package headers
#include <epigraft/match/match_types.hh>
#include <epigraft/match/MatchResult.hh>
#include <epigraft/AntibodyComplex.hh>
#include <epigraft/GraftOptions.hh>

// utility headers
#include <utility/vector1.fwd.hh>

namespace epigraft {
namespace match {


/// @brief attempt recovery/optimization by rb-move
/// @note  all matches found here are designated 'ENDPOINT' (E) matches
void
try_rb_move(
	GraftOptions const & options,
	AntibodyComplex & native,
	Pose & scaffold,
	utility::vector1< MatchResult > const & match_results,
	utility::vector1< MatchResult > & rb_results
);


/// @brief perpendicular foot
/// @note  Finds perpendicular foot along vector vo->ve for a triangle defined by two vectors vo->ve and vo->rp.
/// @note  Depending upon the angle between vo->ve and vo->rp, it might not be the perpendicular foot.
/// @note  If the angle is 90 degrees, then vo is returned.  If the angle is obtuse, then the point that drops
/// @note  down from rp to make a right angle is returned.
inline
Point
perpendicular_foot(
	Point const & rp,
	Point const & vo,
	Point const & ve
);


} // match
} // epigraft

#endif /*INCLUDED_epigraft_match_try_rb_move_HH_*/
