// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   epigraft_rough_match.hh
/// @brief  Searches for additional graft locations on an existing epitope-scaffold.
/// @author Bill Schief (schief@u.washington.edu)
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef EPIGRAFT_ROUGH_MATCH_HH_
#define EPIGRAFT_ROUGH_MATCH_HH_

// package headers
#include <epigraft/LoopInfo.hh>
#include <epigraft/ScaffoldInfo.hh>

// rosetta headers
#include <pose.h>

// utility headers
#include <utility/vector1.fwd.hh>

namespace epigraft {

/// @brief rough match protocol
void
epigraft_rough_match();


/// @brief load input scaffold info
void
load_scaffold_info(
	std::string filename,
	utility::vector1< ScaffoldInfo > & v
);


/// @brief calculate chainbreak score
/// @param[out] nterm_rms
/// @param[out] cterm_rms
/// @param[out] chainbreak_rms
void
chainbreak(
	pose_ns::Pose const & p1,
	ResidueRange const & rr1,
	pose_ns::Pose const & p2,
	ResidueRange const & rr2,
	float & nterm_rms,
	float & cterm_rms,
	float & chainbreak_rms
);


/// @brief compare chain order between two poses
bool
compare_chain_order(
	pose_ns::Pose const & p1,
	pose_ns::Pose const & p2
);

} // namespace epigraft

#endif /*EPIGRAFT_ROUGH_MATCH_HH_*/
