// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   option_check.cc
/// @brief  Checks command line options to see if it's a valid Rosetta option.
/// @details  Checks command line options to see if it's a valid Rosetta option
/// @details  in any mode.  Will not check whether the option is applicable to
/// @details  the mode being executed.
/// @note  Contains a list of (hard coded) strings that Rosetta uses as options.
/// @author Sergey Menis (menis@u.washington.edu)
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

// unit headers
#include <epigraft/option_check.hh>

// rosetta headers
#include <namespace_options.h>

// C++ headers
#include <iostream>
#include <set>
#include <vector>


namespace epigraft {


/// @brief  Checks command line options to see if it's a valid Rosetta option.
/// @details  Checks command line options to see if it's a valid Rosetta option
/// @details  in any mode.  Will not check whether the option is applicable to
/// @details  the mode being executed.  Will echo all problematic options and
/// @details  return control to caller.
/// @return boolean indicating whether all the options are valid
bool
options_are_valid()
{
	using std::set;
	using std::string;

	set< string > known_options;

	// temporary testing options
	known_options.insert( "-water" );
	known_options.insert( "-tea" );
	known_options.insert( "-coffee" );
	known_options.insert( "-milk" );
	known_options.insert( "-port" );
	known_options.insert( "-juice" );
	known_options.insert( "-cola" );
	known_options.insert( "-wine" );
	known_options.insert( "-beer" );
	known_options.insert( "-bubble_tea" );
	known_options.insert( "-mango_lassi" );
	known_options.insert( "-vodka" );
	known_options.insert( "-tequila" );

	known_options.insert( "-decimated_multigraft" );
	known_options.insert( "-build_attempt_multiplier" );
	known_options.insert( "-max_refine_attempts_per_round" );

	// scratch options
	known_options.insert( "-input" );
	known_options.insert( "-output" );
	known_options.insert( "-loop_length" );
	known_options.insert( "-insert_after" );
	known_options.insert( "-library_index_start" );
	known_options.insert( "-library_length_minimum" );

	// add all options first
	known_options.insert( "-1hz6_pose_relax" );
	known_options.insert( "-9mer_frag_cutoff" );
	known_options.insert( "-Ab_first" );
	known_options.insert( "-Ab_epitope_optimize" );
	known_options.insert( "-Ab_epitope_optimize_including_rb" );
	known_options.insert( "-Ab_repack_cutoff" );
	known_options.insert( "-C4_C4" );
	known_options.insert( "-Cterminus" );
	known_options.insert( "-E_align" );
	known_options.insert( "-Eout" );
	known_options.insert( "-F" );
	known_options.insert( "-FAsearch" );
	known_options.insert( "-H3_filter" );
	known_options.insert( "-IUPAC" );
	known_options.insert( "-I_sc_filter" );
	known_options.insert( "-MB_limit_for_rpes" );
	known_options.insert( "-MC_cycles_fa" );
	known_options.insert( "-Motifs_bump_value" );
	known_options.insert( "-N" );
	known_options.insert( "-Nterminus" );
	known_options.insert( "-SS_align" );
	known_options.insert( "-S_align" );
	known_options.insert( "-Wdun_factor" );
	known_options.insert( "-Wgb" );
	known_options.insert( "-Wh2o_hb_factor" );
	known_options.insert( "-Wh2o_intra_factor" );
	known_options.insert( "-Wh2o_intro_factor" );
	known_options.insert( "-Whb_bb" );
	known_options.insert( "-Whb_bb_sc" );
	known_options.insert( "-Whb_sc" );
	known_options.insert( "-Whbond_factor" );
	known_options.insert( "-Wint_only" );
	known_options.insert( "-Wint_repack_only" );
	known_options.insert( "-Wint_score_only" );
	known_options.insert( "-Wlig_vir" );
	known_options.insert( "-Wligaa" );
	known_options.insert( "-WpH" );
	known_options.insert( "-Wpack_only" );
	known_options.insert( "-Wplane_total" );
	known_options.insert( "-Wsol_factor" );
	known_options.insert( "-Wsolv" );
	known_options.insert( "-abeta40" );
	known_options.insert( "-abeta_double" );
	known_options.insert( "-abeta_turn" );
	known_options.insert( "-abinitio" );
	known_options.insert( "-abinitio_temperature" );
	known_options.insert( "-abrelax" );
	known_options.insert( "-abrelax_filters" );
	known_options.insert( "-accept_all" );
	known_options.insert( "-acceptance_rate" );
	known_options.insert( "-add_on" );
	known_options.insert( "-adna" );
	known_options.insert( "-affin_incr" );
	known_options.insert( "-ala_scan_only" );
	known_options.insert( "-align" );
	known_options.insert( "-all" );
	known_options.insert( "-all_interface_stats" );
	known_options.insert( "-allow_AA_at_inter_design" );
	known_options.insert( "-allow_ALLAA_at_inter_despos" );
	known_options.insert( "-allow_any_ss_during_fragment_insertion" );
	known_options.insert( "-allow_rb_move" );
	known_options.insert( "-allow_rb_moves" );
	known_options.insert( "-allow_repack_Ab" );
	known_options.insert( "-allow_repack_epitope" );
	known_options.insert( "-allowed_intra_clash_increase" );
	known_options.insert( "-alpha_max" );
	known_options.insert( "-alpha_min" );
	known_options.insert( "-alter_seqs" );
	known_options.insert( "-alter_spec" );
	known_options.insert( "-alter_spec_format" );
	known_options.insert( "-alter_spec_mutlist" );
	known_options.insert( "-anchor_peptide" );
	known_options.insert( "-anchor_pos" );
	known_options.insert( "-angle_max" );
	known_options.insert( "-angle_perturb" );
	known_options.insert( "-angle_stretch_factor" );
	known_options.insert( "-angles" );
	known_options.insert( "-antibody_modeler" );
	known_options.insert( "-antiparallel_weight" );
	known_options.insert( "-apply_filters" );
	known_options.insert( "-args_file" );
	known_options.insert( "-assemble" );
	known_options.insert( "-atom_vdw_set" );
	known_options.insert( "-attach_by_bond" );
	known_options.insert( "-auto_resfile" );
	known_options.insert( "-backrub_mc" );
	known_options.insert( "-backrub_prob" );
	known_options.insert( "-backrub_test" );
	known_options.insert( "-barcode_energy_reweight" );
	known_options.insert( "-barcode_file" );
	known_options.insert( "-barcode_force_rotamer" );
	known_options.insert( "-barcode_from_fragments" );
	known_options.insert( "-barcode_from_fragments_length" );
	known_options.insert( "-barcode_from_fragments_loop_bias_score" );
	known_options.insert( "-barcode_from_fragments_use_loop_bias" );
	known_options.insert( "-barcode_mode" );
	known_options.insert( "-barcode_reweight" );
	known_options.insert( "-barcode_sspair_limit" );
	known_options.insert( "-barcode_stats" );
	known_options.insert( "-base" );
	known_options.insert( "-batch_id" );
	known_options.insert( "-bb" );
	known_options.insert( "-bb_bin_width" );
	known_options.insert( "-bb_min" );
	known_options.insert( "-bb_move" );
	known_options.insert( "-bb_only" );
	known_options.insert( "-begin" );
	known_options.insert( "-benchmark" );
	known_options.insert( "-beta_contact_feats" );
	known_options.insert( "-bk_min" );
	known_options.insert( "-blah.contacts" );
	known_options.insert( "-bmark_dir" );
	known_options.insert( "-bond_angle_params" );
	known_options.insert( "-bond_angle_tether" );
	known_options.insert( "-bond_angle_weight" );
	known_options.insert( "-bond_length_tether" );
	known_options.insert( "-bonds" );
	known_options.insert( "-bp" );
	known_options.insert( "-bs" );
	known_options.insert( "-bsasa_feats" );
	known_options.insert( "-build_cycles" );
	known_options.insert( "-build_loop" );
	known_options.insert( "-build_loops" );
	known_options.insert( "-build_with_adaptive" );
	known_options.insert( "-build_with_arm" );
	known_options.insert( "-build_with_screen" );
	known_options.insert( "-by_index" );
	known_options.insert( "-bzip_relax" );
	known_options.insert( "-bzip_swap" );
	known_options.insert( "-c1_symm_test" );
	known_options.insert( "-cb_reweight" );
	known_options.insert( "-cb_weight" );
	known_options.insert( "-cbeta_neighbors_distance_cutoff" );
	known_options.insert( "-ccd_closure" );
	known_options.insert( "-ccd_cycles" );
	known_options.insert( "-ccd_temperature" );
	known_options.insert( "-ccd_tol" );
	known_options.insert( "-cenlist_values" );
	known_options.insert( "-cenrlx" );
	known_options.insert( "-centroid" );
	known_options.insert( "-centroid_cutoff" );
	known_options.insert( "-centroid_information" );
	known_options.insert( "-centroid_pack_weight" );
	known_options.insert( "-centroid_score_cutoff" );
	known_options.insert( "-chain" );
	known_options.insert( "-chain_break_tol" );
	known_options.insert( "-chain_energies" );
	known_options.insert( "-chain_in_preferred_state" );
	known_options.insert( "-chain_in_ref_state" );
	known_options.insert( "-chain_inc" );
	known_options.insert( "-chain_limit" );
	known_options.insert( "-chainbreakE_limit" );
	known_options.insert( "-chainbreak_reweight" );
	known_options.insert( "-chainbreak_weight" );
	known_options.insert( "-chainbreak_weight_final" );
	known_options.insert( "-chainbreak_weight_start" );
	known_options.insert( "-chat" );
	known_options.insert( "-chbrk_filter" );
	known_options.insert( "-check_finish" );
	known_options.insert( "-check_homs" );
	known_options.insert( "-check_point" );
	known_options.insert( "-check_specific_sites" );
	known_options.insert( "-checkpoint" );
	known_options.insert( "-checkpoint_interval_minutes" );
	known_options.insert( "-checkpointing_interval" );
	known_options.insert( "-chi" );
	known_options.insert( "-chi_move" );
	known_options.insert( "-clash_check" );
	known_options.insert( "-clnt" );
	known_options.insert( "-close_as_ALA" );
	known_options.insert( "-close_as_GLY" );
	known_options.insert( "-close_chainbreaks" );
	known_options.insert( "-close_chainbreaks_cycle_ratio" );
	known_options.insert( "-closure_attempts" );
	known_options.insert( "-closure_reset_period" );
	known_options.insert( "-cluster" );
	known_options.insert( "-cluster_by_maxsub" );
	known_options.insert( "-cluster_design" );
	known_options.insert( "-cluster_frags" );
	known_options.insert( "-cluster_loop" );
	known_options.insert( "-cluster_size" );
	known_options.insert( "-co" );
	known_options.insert( "-colin" );
	known_options.insert( "-combi_match" );
	known_options.insert( "-combi_match_ca_distance" );
	known_options.insert( "-complementarity_design" );
	known_options.insert( "-complementarity_design_attempts" );
	known_options.insert( "-complementarity_design_cutoff" );
	known_options.insert( "-complementarity_design_cycles" );
	known_options.insert( "-complementarity_rb" );
	known_options.insert( "-complementarity_shell_cutoff" );
	known_options.insert( "-complementarity_shell_redesign" );
	known_options.insert( "-complementarity_shell_repack" );
	known_options.insert( "-compute_cbeta_neighbors" );
	known_options.insert( "-compute_glycine_pose" );
	known_options.insert( "-condorjob" );
	known_options.insert( "-constant_seed" );
	known_options.insert( "-contact_feats" );
	known_options.insert( "-contacts_file" );
	known_options.insert( "-conv_limit_mod" );
	known_options.insert( "-coord_cst_weight" );
	known_options.insert( "-coordcst" );
	known_options.insert( "-copy_native_chi_angles" );
	known_options.insert( "-copy_native_fold_tree" );
	known_options.insert( "-count_attempts" );
	known_options.insert( "-count_hairpins" );
	known_options.insert( "-covalent_from_cstfile" );
	known_options.insert( "-cpu_frac" );
	known_options.insert( "-cpu_run_time" );
	known_options.insert( "-cpu_run_timeout_factor" );
	known_options.insert( "-crank_size" );
	known_options.insert( "-crazy_angle_tether" );
	known_options.insert( "-crazy_fold_tree" );
	known_options.insert( "-crazy_tau" );
	known_options.insert( "-create_fasta" );
	known_options.insert( "-create_vall_torsions_file" );
	known_options.insert( "-cst" );
	known_options.insert( "-cstE_limit" );
	known_options.insert( "-cstW" );
	known_options.insert( "-cst_conformer" );
	known_options.insert( "-cst_design" );
	known_options.insert( "-cst_dockpert" );
	known_options.insert( "-cst_from_file" );
	known_options.insert( "-cst_loop" );
	known_options.insert( "-cst_loop_fix_loopsc" );
	known_options.insert( "-cst_min" );
	known_options.insert( "-cst_min_cycles" );
	known_options.insert( "-cst_mode" );
	known_options.insert( "-cst_opt" );
	known_options.insert( "-cst_score" );
	known_options.insert( "-cst_wt_disulf_angle" );
	known_options.insert( "-cst_wt_disulf_dihedral" );
	known_options.insert( "-cst_wt_disulf_distance" );
	known_options.insert( "-cstfile" );
	known_options.insert( "-cullpdb" );
	known_options.insert( "-cut1" );
	known_options.insert( "-cut2" );
	known_options.insert( "-cut3" );
	known_options.insert( "-cut4" );
	known_options.insert( "-cut_point" );
	known_options.insert( "-cutoff_Ab_epitope" );
	known_options.insert( "-cutoff_inter" );
	known_options.insert( "-cutoff_intra" );
	known_options.insert( "-cycles" );
	known_options.insert( "-d" );
	known_options.insert( "-db_annealer_file" );
	known_options.insert( "-ddg_bind_only" );
	known_options.insert( "-ddmi_dG_dSASA_ratio_filter" );
	known_options.insert( "-ddmi_dUns_filter" );
	known_options.insert( "-ddmi_dg_round1_thresh" );
	known_options.insert( "-ddmi_dg_thresh" );
	known_options.insert( "-debug" );
	known_options.insert( "-debug_annealer_design" );
	known_options.insert( "-debug_output" );
	known_options.insert( "-debug_rotamer_trials" );
	known_options.insert( "-decoy_status" );
	known_options.insert( "-decoyfeatures" );
	known_options.insert( "-decoystats" );
	known_options.insert( "-delay_at_start" );
	known_options.insert( "-deriv_check" );
	known_options.insert( "-description_file" );
	known_options.insert( "-design" );
	known_options.insert( "-design_after_closure" );
	known_options.insert( "-design_attempts" );
	known_options.insert( "-design_by_base" );
	known_options.insert( "-design_dock" );
	known_options.insert( "-design_in_pieces" );
	known_options.insert( "-design_inter" );
	known_options.insert( "-design_loops" );
	known_options.insert( "-design_min_inter" );
	known_options.insert( "-design_mutlist" );
	known_options.insert( "-design_neighbors" );
	known_options.insert( "-design_trials" );
	known_options.insert( "-desired_rms" );
	known_options.insert( "-desock" );
	known_options.insert( "-detect_covalent_bond" );
	known_options.insert( "-df_file" );
	known_options.insert( "-dfunc_dump" );
	known_options.insert( "-dihedral_deviation" );
	known_options.insert( "-dihedral_step" );
	known_options.insert( "-directed_design" );
	known_options.insert( "-disable_nb_list_hinge" );
	known_options.insert( "-disallow_hbond_ho2star" );
	known_options.insert( "-disallow_hbond_o4star" );
	known_options.insert( "-disallow_quench" );
	known_options.insert( "-disallow_zero_score_base_pair" );
	known_options.insert( "-dist_cutoff" );
	known_options.insert( "-distance_pdf_filename" );
	known_options.insert( "-distance_threshhold" );
	known_options.insert( "-disulf_filter" );
	known_options.insert( "-disulfide_jump_test" );
	known_options.insert( "-dna_bb_moves" );
	known_options.insert( "-dna_ddG" );
	known_options.insert( "-dna_decoystats" );
	known_options.insert( "-dna_interface" );
	known_options.insert( "-dna_loop_min" );
	known_options.insert( "-dna_minimize" );
	known_options.insert( "-dna_motifs" );
	known_options.insert( "-dna_scan" );
	known_options.insert( "-dna_verbose" );
	known_options.insert( "-dna_water_refine" );
	known_options.insert( "-dna_weights" );
	known_options.insert( "-do_1mers_in_last_round" );
	known_options.insert( "-do_2mers_in_last_half" );
	known_options.insert( "-do_farlx_checkpointing" );
	known_options.insert( "-do_minimize" );
	known_options.insert( "-do_minrep" );
	known_options.insert( "-do_pose_checkpointing" );
	known_options.insert( "-do_QC" );
	known_options.insert( "-do_rbmin" );
	known_options.insert( "-dock" );
	known_options.insert( "-dockFA" );
	known_options.insert( "-dock_cter" );
	known_options.insert( "-dock_des_min_inter" );
	known_options.insert( "-dock_flex" );
	known_options.insert( "-dock_keyres" );
	known_options.insert( "-dock_loop" );
	known_options.insert( "-dock_loops" );
	known_options.insert( "-dock_mcm" );
	known_options.insert( "-dock_mcm_loopmin" );
	known_options.insert( "-dock_mcm_rot_magnitude" );
	known_options.insert( "-dock_mcm_trans_magnitude" );
	known_options.insert( "-dock_min" );
	known_options.insert( "-dock_neighbor" );
	known_options.insert( "-dock_pert" );
	known_options.insert( "-dock_relax" );
	known_options.insert( "-dock_rtmin" );
	known_options.insert( "-dock_score_norepack" );
	known_options.insert( "-docking_hb_stats" );
	known_options.insert( "-docking_local_refine" );
	known_options.insert( "-docking_pose_symm_full" );
	known_options.insert( "-docking_pose_symm_looprlx" );
	known_options.insert( "-docking_pose_symm_loops" );
	known_options.insert( "-docking_pose_symm_subsystem" );
	known_options.insert( "-docking_pose_symmetry" );
	known_options.insert( "-docking_silent_input" );
	known_options.insert( "-docking_silent_input_file" );
	known_options.insert( "-domain_insertion" );
	known_options.insert( "-dpl" );
	known_options.insert( "-ds_outpdb_only" );
	known_options.insert( "-dssp_feats" );
	known_options.insert( "-dssppl" );
	known_options.insert( "-dummy" );
	known_options.insert( "-dummy_model" );
	known_options.insert( "-dummy_model_depth" );
	known_options.insert( "-dummy_model_power" );
	known_options.insert( "-dummy_model_reweight" );
	known_options.insert( "-dummy_model_score" );
	known_options.insert( "-dump_all_closure_attempt_structures" );
	known_options.insert( "-dump_closed" ); //vds
	known_options.insert( "-dump_frags" );
	known_options.insert( "-dump_minimized_pdb" );
	known_options.insert( "-dump_pdb" );
	known_options.insert( "-dump_predesign" );
	known_options.insert( "-dump_refined" ); //vds
	known_options.insert( "-dump_rotamers_pdb" );
	known_options.insert( "-dump_single_pdb" );
	known_options.insert( "-dump_someclosed" ); //vds
	known_options.insert( "-dump_structures" );
	known_options.insert( "-dump_symmetrical_pose" );
	known_options.insert( "-dun_sd_correction" );
	known_options.insert( "-dunbrack_close" );
	known_options.insert( "-dz_cutoff" );
	known_options.insert( "-ediff_cutoff" );
	known_options.insert( "-electron_density" );
	known_options.insert( "-electron_density_file" );
	known_options.insert( "-electron_density_reweight" );
	known_options.insert( "-electron_density_score" );
	known_options.insert( "-enable_dna" );
	known_options.insert( "-enable_ligand_aa" );
	known_options.insert( "-enable_rna" );
	known_options.insert( "-end" );
	known_options.insert( "-endres1" );
	known_options.insert( "-endres2" );
	known_options.insert( "-enrg_feat" );
	known_options.insert( "-env_psudo_co_eff" );
	known_options.insert( "-env_reweight" );
	known_options.insert( "-env_stats_file" );
	known_options.insert( "-enzyme_design" );
	known_options.insert( "-enzyme_vrot" );
	known_options.insert( "-epi_graft" );
	known_options.insert( "-epi_graft_design" );
	known_options.insert( "-epi_graft_match" );
	known_options.insert( "-epi_loop_info" );
	known_options.insert( "-epitope_optimize" );
	known_options.insert( "-epitope_rb_cycles" );
	known_options.insert( "-epitope_rb_min" );
	known_options.insert( "-epitope_rb_optimize" );
	known_options.insert( "-equiv_resfile" );
	known_options.insert( "-evol_recomb" );
	known_options.insert( "-evolution" );
	known_options.insert( "-ex1" );
	known_options.insert( "-ex1aro" );
	known_options.insert( "-ex1aro_exposed" );
	known_options.insert( "-ex1aro_half" );
	known_options.insert( "-ex2" );
	known_options.insert( "-ex2aro_exposed" );
	known_options.insert( "-ex2aro_only" );
	known_options.insert( "-ex3" );
	known_options.insert( "-ex4" );
	known_options.insert( "-exOH" );
	known_options.insert( "-ex_dna_waters" );
	known_options.insert( "-exact_match_vatom" );
	known_options.insert( "-exdb" );
	known_options.insert( "-expect" );
	known_options.insert( "-explicit_h2o" );
	known_options.insert( "-export_blueprint" );
	known_options.insert( "-export_resfile" );
	known_options.insert( "-extend" );
	known_options.insert( "-extra_score_asp_lys_weight" );
	known_options.insert( "-extra_score_hb_weight" );
	known_options.insert( "-extra_score_phe_dist_weight" );
	known_options.insert( "-extrachi_cutoff" );
	known_options.insert( "-extract" );
	known_options.insert( "-extract_segment" );
	known_options.insert( "-f" );
	known_options.insert( "-fa_atr_reweight" );
	known_options.insert( "-fa_atr_weight" );
	known_options.insert( "-fa_contact_feats" );
	known_options.insert( "-fa_dun_reweight " );
	known_options.insert( "-fa_gb_elec_reweigh" );
	known_options.insert( "-fa_h2o_reweight" );
	known_options.insert( "-fa_input" );
	known_options.insert( "-fa_lj_rep_slope" );
	known_options.insert( "-fa_max_dis" );
	known_options.insert( "-fa_output" );
	known_options.insert( "-fa_pH_reweight" );
	known_options.insert( "-fa_pair_reweight" );
	known_options.insert( "-fa_plane_reweight" );
	known_options.insert( "-fa_prob1b_reweight" );
	known_options.insert( "-fa_ref_reweight " );
	known_options.insert( "-fa_refine" );
	known_options.insert( "-fa_rep_reweight" );
	known_options.insert( "-fa_rep_weight" );
	known_options.insert( "-fa_sol_weight" );
	known_options.insert( "-fa_solv_reweight" );
	known_options.insert( "-fab1" );
	known_options.insert( "-fab2" );
	known_options.insert( "-fake_native" );
	known_options.insert( "-farlx" );
	known_options.insert( "-farlx_cycle_ratio" );
	known_options.insert( "-farlx_rot_trials" );
	known_options.insert( "-fast" );
	known_options.insert( "-fast_loop_farlx" );
	known_options.insert( "-fast_mc_low_pose" );
	known_options.insert( "-fast_refine" );
	known_options.insert( "-fast_relax" );
	known_options.insert( "-fast_relax_only" );
	known_options.insert( "-fast_rep_weight" );
	known_options.insert( "-favor_aromatic" );
	known_options.insert( "-favor_charged" );
	known_options.insert( "-favor_native_residue" );
	known_options.insert( "-favor_negatively_charged" );
	known_options.insert( "-favor_nonpolar" );
	known_options.insert( "-favor_polar" );
	known_options.insert( "-favor_positively_charged" );
	known_options.insert( "-featurize" );
	known_options.insert( "-fibril" );
	known_options.insert( "-filter1" );
	known_options.insert( "-filter1a" );
	known_options.insert( "-filter1b" );
	known_options.insert( "-filter2" );
	known_options.insert( "-filter_contact_feats" );
	known_options.insert( "-filter_jumps_with_barcode" );
	known_options.insert( "-filter_jumps_with_bonus" );
	known_options.insert( "-final_cycles" );
	known_options.insert( "-find_CBCB" );
	known_options.insert( "-find_disulf" );
	known_options.insert( "-find_unsat" );
	known_options.insert( "-fine_hb_categories" );
	known_options.insert( "-first_resnum_for_com" );
	known_options.insert( "-fix" );
	known_options.insert( "-fix_catalytic_aa" );
	known_options.insert( "-fix_disulf" );
	known_options.insert( "-fix_lig2" );
	known_options.insert( "-fix_ligand_HO" );
	known_options.insert( "-fix_mut" );
	known_options.insert( "-fix_natsc" );
	known_options.insert( "-fix_rigid_body" );
	known_options.insert( "-fix_target_seq" );
	known_options.insert( "-fixbb" );
	known_options.insert( "-fixseq" );
	known_options.insert( "-flex_nofilter" );
	known_options.insert( "-flex_peptide" );
	known_options.insert( "-flexible_ligand" );
	known_options.insert( "-flip_symmetric_sidechains" );
	known_options.insert( "-fluidize_landing" );
	known_options.insert( "-fluidize_takeoff" );
	known_options.insert( "-fold" );
	known_options.insert( "-fold_with_dunbrack" );
	known_options.insert( "-force_atom_tree" );
	known_options.insert( "-force_expand" );
	known_options.insert( "-force_refine" );
	known_options.insert( "-frag_dir" );
	known_options.insert( "-frag_insert_hinge" );
	known_options.insert( "-frag_match" );
	known_options.insert( "-frag_name" );
	known_options.insert( "-frag_size" );
	known_options.insert( "-frag_ss_feats" );
	known_options.insert( "-frag_weight_file" );
	known_options.insert( "-fragment_quality" );
	known_options.insert( "-fragments" );
	known_options.insert( "-frags" );
	known_options.insert( "-frags_name_prefix" );
	known_options.insert( "-frags_name_prefix_homolog" );
	known_options.insert( "-frags_name_prefix_query" );
	known_options.insert( "-frame_rate" );
	known_options.insert( "-free_energy" );
	known_options.insert( "-full_bb" );
	known_options.insert( "-full_filename" );
	known_options.insert( "-full_relax" );
	known_options.insert( "-full_repack" );
	known_options.insert( "-full_rt" );
	known_options.insert( "-full_sequence" );
	known_options.insert( "-full_ss" );
	known_options.insert( "-fullatom" );
	known_options.insert( "-fullatom_loop" );
	known_options.insert( "-funky_relax" );
	known_options.insert( "-funky_relax_onepdb" );
	known_options.insert( "-fv_linker" );
	known_options.insert( "-gen_born" );
	known_options.insert( "-generation" );
	known_options.insert( "-geometric_ramp" );
	known_options.insert( "-geometric_sol" );
	known_options.insert( "-geometric_sol_weight" );
	known_options.insert( "-getcoordcst" );
	known_options.insert( "-getloop" );
	known_options.insert( "-goofy_fold_tree" );
	known_options.insert( "-graft_with_Ab" );
	known_options.insert( "-grid_dock" );
	known_options.insert( "-grid_dock_and_design" );
	known_options.insert( "-grid_search_from_align" );
	known_options.insert( "-grow" );
	known_options.insert( "-grow_as_ALA" );
	known_options.insert( "-grow_as_GLY" );
	known_options.insert( "-gu_exempt" );
	known_options.insert( "-gush" );
	known_options.insert( "-h1" );
	known_options.insert( "-h2" );
	known_options.insert( "-h3" );
	known_options.insert( "-hack_tree" );
	known_options.insert( "-handedness_score" );
	known_options.insert( "-harmonic_constraint" );
	known_options.insert( "-hb_lrbb_reweight" );
	known_options.insert( "-hb_sc_reweight" );
	known_options.insert( "-hb_sc_weight" );
	known_options.insert( "-hb_srbb_reweight" );
	known_options.insert( "-hb_stats" );
	known_options.insert( "-help" );
	known_options.insert( "-hfr" );
	known_options.insert( "-high_nb" );
	known_options.insert( "-hinge" );
	known_options.insert( "-hinge_end" );
	known_options.insert( "-hinge_pert" );
	known_options.insert( "-hinge_start" );
	known_options.insert( "-homolog_distances" );
	known_options.insert( "-homolog_jumps" );
	known_options.insert( "-homolog_rescore" );
	known_options.insert( "-homolog_score_list" );
	known_options.insert( "-hs_reweight" );
	known_options.insert( "-hydrate_dna" );
	known_options.insert( "-hydrogen_interaction_cutoff" );
	known_options.insert( "-ideal_cst" );
	known_options.insert( "-idealize" );
	known_options.insert( "-idealize_before_relax" );
	known_options.insert( "-idealize_native" );
	known_options.insert( "-idl_breaks" );
	known_options.insert( "-idl_no_chain_break" );
	known_options.insert( "-ig_file" );
	known_options.insert( "-ignore_build_failure" );
	known_options.insert( "-ignore_refine_failure" );
	known_options.insert( "-ignore_sspair_barcode_in_score" );
	known_options.insert( "-inc_current" );
	known_options.insert( "-include_neighbor_base_stacks" );
	known_options.insert( "-increase_cycles" );
	known_options.insert( "-increment_barcode" );
	known_options.insert( "-increment_taboo" );
	known_options.insert( "-infiles" );
	known_options.insert( "-inform" );
	known_options.insert( "-init_T_size" );
	known_options.insert( "-inner_cycle_mcm_hinge" );
	known_options.insert( "-inner_cycles1" );
	known_options.insert( "-inner_cycles2" );
	known_options.insert( "-inner_cycles3" );
	known_options.insert( "-input_etable_" );
	known_options.insert( "-input_etables" );
	known_options.insert( "-input_file" );
	known_options.insert( "-input_pdb_has_Ab" );
	known_options.insert( "-input_pdbs_include_Ab" );
	known_options.insert( "-input_saxs_profile" );
	known_options.insert( "-insert_all" );
	known_options.insert( "-insertion_file" );
	known_options.insert( "-int_bb" );
	known_options.insert( "-int_chi" );
	known_options.insert( "-int_score" );
	known_options.insert( "-intafteroption: missing required arg: " );
	known_options.insert( "-inter_design_cutoff" );
	known_options.insert( "-interface" );
	known_options.insert( "-interface_ds" );
	known_options.insert( "-interface_electrostatic_complementarity_shift" );
	known_options.insert( "-intout" );
	known_options.insert( "-intout_by_pdb" );
	known_options.insert( "-intra_design_cutoff" );
	known_options.insert( "-inward_pointing" );
	known_options.insert( "-ise_movie" );
	known_options.insert( "-iterative_run" );
	known_options.insert( "-jacobian" );
	known_options.insert( "-jitter_amount" );
	known_options.insert( "-jitter_frag" );
	known_options.insert( "-jitter_variation" );
	known_options.insert( "-jjh_loops" );
	known_options.insert( "-jran" );
	known_options.insert( "-jump" );
	known_options.insert( "-jump1_downstream" );
	known_options.insert( "-jump1_upstream" );
	known_options.insert( "-jump2_downstream" );
	known_options.insert( "-jump2_upstream" );
	known_options.insert( "-jump_change_frequency" );
	known_options.insert( "-jump_point1" );
	known_options.insert( "-jump_point2" );
	known_options.insert( "-jump_pos1" );
	known_options.insert( "-jump_pos2" );
	known_options.insert( "-jump_relax" );
	known_options.insert( "-jumpamer" );
	known_options.insert( "-jumping" );
	known_options.insert( "-jumpout" );
	known_options.insert( "-jumps_file" );
	known_options.insert( "-jumps_from_barcode" );
	known_options.insert( "-just_even_residues" );
	known_options.insert( "-just_minimize_monomer" );
	known_options.insert( "-just_pair" );
	known_options.insert( "-just_smooth_cycles" );
	known_options.insert( "-keep_natro" );
	known_options.insert( "-keyname" );
	known_options.insert( "-kill_bab" );
	known_options.insert( "-kill_hairpins" );
	known_options.insert( "-kin_1d_weight" );
	known_options.insert( "-kin_3d" );
	known_options.insert( "-knot_filter" );
	known_options.insert( "-l" );
	known_options.insert( "-l1" );
	known_options.insert( "-l2" );
	known_options.insert( "-l3" );
	known_options.insert( "-l_chain" );
	known_options.insert( "-large_rotamer_set" );
	known_options.insert( "-last_resnum_for_com" );
	known_options.insert( "-lazy_ig" );
	known_options.insert( "-lfr" );
	known_options.insert( "-lig2_file" );
	known_options.insert( "-lig_looprlx" );
	known_options.insert( "-lig_looprlx_score_filter" );
	known_options.insert( "-lig_min" );
	known_options.insert( "-lig_virE_dmax" );
	known_options.insert( "-ligand" );
	known_options.insert( "-ligand_filter_count" );
	known_options.insert( "-ligand_filter_score" );
	known_options.insert( "-ligand_mdlfile" );
	known_options.insert( "-limit_perturb" );
	known_options.insert( "-linmem_ig" );
	known_options.insert( "-linmin_trials" );
	known_options.insert( "-list_anchor_resnums" );
	known_options.insert( "-list_conserved_exposed_residues" );
	known_options.insert( "-list_dock_conformations" );
	known_options.insert( "-list_graft_ranges" );
	known_options.insert( "-list_natro_in_epitope" );
	known_options.insert( "-list_scaff_info_for_add_on_epi_graft_design" );
	known_options.insert( "-list_scaff_info_for_epi_graft_design" );
	known_options.insert( "-list_scaff_pdb" );
	known_options.insert( "-list_superpos_scaff_info" );
	known_options.insert( "-list_trimer_conformations" );
	known_options.insert( "-lj_ramp_cycles" );
	known_options.insert( "-local" );
	known_options.insert( "-local_min_window" );
	known_options.insert( "-local_min_window_fragment_moves" );
	known_options.insert( "-localstrandpair_penalty" );
	known_options.insert( "-log_file" );
	known_options.insert( "-long_range_hb_weight" );
	known_options.insert( "-loop" );
	known_options.insert( "-loop_combine_rate" );
	known_options.insert( "-loop_farlx" );
	known_options.insert( "-loop_farlx_only" );
	known_options.insert( "-loop_farlx_random_cut" );
	known_options.insert( "-loop_file" );
	known_options.insert( "-loop_library" );
	known_options.insert( "-loop_model" );
	known_options.insert( "-loop_name" );
	known_options.insert( "-loop_only" );
	known_options.insert( "-loop_ranges" );
	known_options.insert( "-loop_skip_rate" );
	known_options.insert( "-loop_trials" );
	known_options.insert( "-loopout_file" );
	known_options.insert( "-looprlx" );
	known_options.insert( "-looprlx_cycle_ratio" );
	known_options.insert( "-looprlx_fix_natsc" );
	known_options.insert( "-looprlx_idealization" );
	known_options.insert( "-looprlx_nonideal_silent_output" );
	known_options.insert( "-loops" );
	known_options.insert( "-loops_subset" );
	known_options.insert( "-low_nb" );
	known_options.insert( "-make_packing_pdb" );
	known_options.insert( "-map_sequence" );
	known_options.insert( "-match" );
	known_options.insert( "-match_YR" );
	known_options.insert( "-match_all" );
//	known_options.insert( "-match_distance_epsilon" );
	known_options.insert( "-max_angle_disp_2" );
	known_options.insert( "-max_angle_disp_3" );
	known_options.insert( "-max_angle_disp_slope" );
	known_options.insert( "-max_bond_angle" );
	known_options.insert( "-max_chainbreak_rms_pre_closure" );
	known_options.insert( "-max_chainbreak_score" );
	known_options.insert( "-max_chainbreak_score_after_close" );
	known_options.insert( "-max_closure_attempts" );
	known_options.insert( "-max_closure_rms" );
	known_options.insert( "-max_ddg_fa_rep_gly" );
	known_options.insert( "-max_evalue" );
	known_options.insert( "-max_fa_rep_inter_gly_after_close" );
	known_options.insert( "-max_fa_rep_inter_gly_before_close" );
	known_options.insert( "-max_fa_rep_intra_gly_before_close" );
	known_options.insert( "-max_frags" );
	known_options.insert( "-max_inter_clash" );
	known_options.insert( "-max_intra_bumps" );
	known_options.insert( "-max_intra_clash" );
	known_options.insert( "-max_local_rama" );
	known_options.insert( "-max_loopsize_difference" );
	known_options.insert( "-max_match_width_delta" );
	known_options.insert( "-max_rough_match_width_delta" );
	known_options.insert( "-max_rama_score_increase" );
	known_options.insert( "-max_recursion_depth" );
	known_options.insert( "-max_res" );
	known_options.insert( "-max_rms_over_length" );
	known_options.insert( "-max_strand_dist_cutoff" );
	known_options.insert( "-mc_temp" );
	known_options.insert( "-mcm_cycles" );
	known_options.insert( "-mcm_rounds" );
	known_options.insert( "-mcmin_trials" );
	known_options.insert( "-mdlfile" );
	known_options.insert( "-measure_changed_environment" );
	known_options.insert( "-membrane" );
	known_options.insert( "-merge_feature_files" );
	known_options.insert( "-min2" );
	known_options.insert( "-min_bb" );
	known_options.insert( "-min_cluster_sim" );
	known_options.insert( "-min_evalue" );
	known_options.insert( "-min_interface" );
	known_options.insert( "-min_match_length" );
	known_options.insert( "-min_match_width" );
	known_options.insert( "-min_res" );
	known_options.insert( "-mini_resfile" );
	known_options.insert( "-minimalist_ig" );
	known_options.insert( "-minimize" );
	known_options.insert( "-minimize_all" );
	known_options.insert( "-minimize_disulf_chi" );
	known_options.insert( "-minimize_exclude_frag_in_crank" );
	known_options.insert( "-minimize_exclude_frag_in_wobble" );
	known_options.insert( "-minimize_exclude_helix" );
	known_options.insert( "-minimize_exclude_strand" );
	known_options.insert( "-minimize_rep_weight" );
	known_options.insert( "-minimize_rna" );
	known_options.insert( "-minimize_rot" );
	known_options.insert( "-minimize_separately" );
	known_options.insert( "-minimize_structures" );
	known_options.insert( "-minimize_vary_rb_angle" );
	known_options.insert( "-minimize_vary_rb_trans" );
	known_options.insert( "-minimize_w_Ab" );
	known_options.insert( "-minimize_wt_struct_only" );
	known_options.insert( "-mj_min" );
	known_options.insert( "-mod_etable" );
	known_options.insert( "-mod_hhrep" );
	known_options.insert( "-mod_hhrep_center" );
	known_options.insert( "-mod_hhrep_exponent" );
	known_options.insert( "-mod_hhrep_height" );
	known_options.insert( "-mod_hhrep_width" );
	known_options.insert( "-mode" );
	known_options.insert( "-monomer" );
	known_options.insert( "-monomer1" );
	known_options.insert( "-monomer_input" );
	known_options.insert( "-monomeric_protein" );
	known_options.insert( "-monomers" );
	known_options.insert( "-more_relax_cycles" );
	known_options.insert( "-motif_regions" );
	known_options.insert( "-motifs_close_enough" );
	known_options.insert( "-motifs_far_dist" );
	known_options.insert( "-motifs_match_weight" );
	known_options.insert( "-motifs_rots_required" );
	known_options.insert( "-move_anchor_points" );
	known_options.insert( "-moveable_closure_residues" );
	known_options.insert( "-movie" );
	known_options.insert( "-moviefile" );
	known_options.insert( "-mpi_task_distribution" );
	known_options.insert( "-ms_comp_list" );
	known_options.insert( "-ms_generations" );
	known_options.insert( "-ms_internal_states" );
	known_options.insert( "-ms_out_name" );
	known_options.insert( "-ms_pop_size" );
	known_options.insert( "-ms_ref_offset" );
	known_options.insert( "-ms_share_data" );
	known_options.insert( "-multi_chain" );
	known_options.insert( "-multi_cool_annealer" );
	known_options.insert( "-multigraft" );
	known_options.insert( "-multimer" );
	known_options.insert( "-multistate" );
	known_options.insert( "-mut_list" );
	known_options.insert( "-mut_mut_energies" );
	known_options.insert( "-mutate_cluster" );
	known_options.insert( "-mutin" );
	known_options.insert( "-mutlist" );
	known_options.insert( "-mutout" );
	known_options.insert( "-mvbb" );
	known_options.insert( "-n" );
	known_options.insert( "-n_design_iterations" );
	known_options.insert( "-n_design_output" );
	known_options.insert( "-n_designs_to_minimize" );
	known_options.insert( "-n_designs_to_refine" );
	known_options.insert( "-n_graft_res_allowed_bbmove_cterm" );
	known_options.insert( "-n_graft_res_allowed_bbmove_nterm" );
	known_options.insert( "-n_iterations" );
	known_options.insert( "-n_minrep_iterations" );
	known_options.insert( "-n_monomers" );
	known_options.insert( "-n_mutatpos" );
	known_options.insert( "-n_outer_cycles_for_refine_loops_with_ccd" );
	known_options.insert( "-n_refine_iterations" );
	known_options.insert( "-n_scaff_gap_res_allowed_bbmove_cterm" );
	known_options.insert( "-n_scaff_gap_res_allowed_bbmove_nterm" );
	known_options.insert( "-name_feat" );
	known_options.insert( "-nat_code" );
	known_options.insert( "-native_complex" );
	known_options.insert( "-natrot" );
	known_options.insert( "-nblist" );
	known_options.insert( "-ncyc_frag_hinge" );
	known_options.insert( "-ndecoys" );
	known_options.insert( "-ndruns" );
	known_options.insert( "-neighbor_repack" );
	known_options.insert( "-neighbor_rt" );
	known_options.insert( "-new_aa" );
	known_options.insert( "-new_centroid_packing" );
	known_options.insert( "-new_reader" );
	known_options.insert( "-nfrag" );
	known_options.insert( "-nfrags" );
	known_options.insert( "-no_clean" );
	known_options.insert( "-no_combine_if_fail" );
	known_options.insert( "-no_cst" );
	known_options.insert( "-no_design" );
	known_options.insert( "-no_farlx_rot_trials" );
	known_options.insert( "-no_filters" );
	known_options.insert( "-no_fragment_insertion" );
	known_options.insert( "-no_frags" );
	known_options.insert( "-no_his_his_pairE" );
	known_options.insert( "-no_idealize_loop_geometry" );
	known_options.insert( "-no_jump_compatibility_check" );
	known_options.insert( "-no_lever_moves" );
	known_options.insert( "-no_linmem_ig" );
	known_options.insert( "-no_loop" );
	known_options.insert( "-no_micromanage_termini" );
	known_options.insert( "-no_minimize_backbone" );
	known_options.insert( "-no_minimize_exclude_frag_in_crank" );
	known_options.insert( "-no_minimize_exclude_frag_in_wobble" );
	known_options.insert( "-no_minimize_rb" );
	known_options.insert( "-no_minimize_set_local_min" );
	known_options.insert( "-no_new_CG" );
	known_options.insert( "-no_optH" );
	known_options.insert( "-no_option_display" );
	known_options.insert( "-no_perturb" );
	known_options.insert( "-no_ramp_rep" );
	known_options.insert( "-no_single_match_output" );
	known_options.insert( "-no_partial_match_output" );
	known_options.insert( "-no_stringent_relax_before_stage2" );
	known_options.insert( "-no_stringentrelax_before_stage2" );
	known_options.insert( "-no_trials_trie" );
	known_options.insert( "-no_trie" );
	known_options.insert( "-no_vary_chi_before_stage2" );
	known_options.insert( "-nobb" );
	known_options.insert( "-nominimize1" );
	known_options.insert( "-nominimize2" );
	known_options.insert( "-norepack1" );
	known_options.insert( "-norepack2" );
	known_options.insert( "-norepack_disulf" );
	known_options.insert( "-nres" );
	known_options.insert( "-nres_Ab" );
	known_options.insert( "-nres_monomer" );
	known_options.insert( "-nres_target" );
	known_options.insert( "-nstruct" );
	known_options.insert( "-nterm_trim" );
	known_options.insert( "-ntrials" );
	known_options.insert( "-num_desired_loops" );
	known_options.insert( "-num_min_trials" );
	known_options.insert( "-num_rna_vdw_atoms_check" );
	known_options.insert( "-numadj_feats" );
	known_options.insert( "-number_3mer_frags" );
	known_options.insert( "-number_9mer_frags" );
	known_options.insert( "-numnodes" );
	known_options.insert( "-nwobble1_crank" );
	known_options.insert( "-nwobble2_crank" );
	known_options.insert( "-nwobble_wobble" );
	known_options.insert( "-o" );
	known_options.insert( "-obligate_loops" );
	known_options.insert( "-omega_weight" );
	known_options.insert( "-one_loop_file" );
	known_options.insert( "-one_segment_per_round" );
	known_options.insert( "-only_bb" );
	known_options.insert( "-only_rot" );
	known_options.insert( "-onlypack" );
	known_options.insert( "-optE" );
	known_options.insert( "-optE_ctsa" );
	known_options.insert( "-optE_inter" );
	known_options.insert( "-optE_jk" );
	known_options.insert( "-optE_rep_cut" );
	known_options.insert( "-optimize_rmsd" );
	known_options.insert( "-outer_cycle_mcm_hinge" );
	known_options.insert( "-outer_cycles1" );
	known_options.insert( "-outer_cycles2" );
	known_options.insert( "-outer_cycles3" );
	known_options.insert( "-outfile" );
	known_options.insert( "-output_" );
	known_options.insert( "-output_aligned_loops" );
	known_options.insert( "-output_all" );
	known_options.insert( "-output_all_contacts" );
	known_options.insert( "-output_centroids" );
	known_options.insert( "-output_chi_silent" );
	known_options.insert( "-output_debug_pdbs" );
	known_options.insert( "-output_dot_kinemage" );
	known_options.insert( "-output_ensemble_stats" );
	known_options.insert( "-output_etables" );
	known_options.insert( "-output_fasta" );
	known_options.insert( "-output_file" );
	known_options.insert( "-output_filter" );
	known_options.insert( "-output_flavor" );
	known_options.insert( "-output_hbond_info" );
	known_options.insert( "-output_interaction_graph_memory_usage" );
	known_options.insert( "-output_loops_built" );
	known_options.insert( "-output_mabo_input" );
	known_options.insert( "-output_pdb" );
	known_options.insert( "-output_pdb_gz" );
	known_options.insert( "-output_pdbs" );
	known_options.insert( "-output_position_hetatm" );
	known_options.insert( "-output_predesign_structure" );
	known_options.insert( "-output_predesign_structure_with_Ab" );
	known_options.insert( "-output_saxs_profile" );
	known_options.insert( "-output_scorefile_gz" );
	known_options.insert( "-output_silent_gz" );
	known_options.insert( "-output_structure" );
	known_options.insert( "-output_structures" );
	known_options.insert( "-output_sum_ensemble_stats" );
	known_options.insert( "-overwrite" );
	known_options.insert( "-override_pdb_output_path" );
	known_options.insert( "-p" );
	known_options.insert( "-p5c_helix" );
	known_options.insert( "-pH" );
	known_options.insert( "-pH_titration" );
	known_options.insert( "-pKa" );
	known_options.insert( "-pack_bump_cutoff" );
	known_options.insert( "-pack_in_parallel" );
	known_options.insert( "-pack_low_temp_annealing" );
	known_options.insert( "-packer_precompute_only" );
	known_options.insert( "-packer_wtsfile" );
	known_options.insert( "-packing_absolute_rms_occ" );
	known_options.insert( "-packing_cavity_burial_probe_radius" );
	known_options.insert( "-packing_heavy_atoms_only" );
	known_options.insert( "-packing_max_cluster_ball_radius" );
	known_options.insert( "-packing_max_hole_radius" );
	known_options.insert( "-packing_max_hole_sasa" );
	known_options.insert( "-packing_min_cluster_ball_radius" );
	known_options.insert( "-packing_min_cluster_size_aspiration" );
	known_options.insert( "-packing_min_cluster_surface_area" );
	known_options.insert( "-packing_min_cluster_volume" );
	known_options.insert( "-packing_min_hole_radius" );
	known_options.insert( "-packing_relative_rms_occ" );
	known_options.insert( "-pair_energy_file" );
	known_options.insert( "-pair_feats" );
	known_options.insert( "-pair_feats_bulge" );
	known_options.insert( "-pair_psudo_co_eff" );
	known_options.insert( "-pair_reweight" );
	known_options.insert( "-pair_stats_file" );
	known_options.insert( "-paircutoffs" );
	known_options.insert( "-pairing_file" );
	known_options.insert( "-pairwise_rmsd" );
	known_options.insert( "-parallel_weight" );
	known_options.insert( "-partner2_begin" );
	known_options.insert( "-paths" );
	known_options.insert( "-pause_after_graphics" );
	known_options.insert( "-pc_reweight" );
	known_options.insert( "-pdbfile" );
	known_options.insert( "-pdbout" );
	known_options.insert( "-pdbstats" );
	known_options.insert( "-pdebug" );
	known_options.insert( "-pdna" );
	known_options.insert( "-peace_break" );
	known_options.insert( "-peptide_pert" );
	known_options.insert( "-perc_finish_tol" );
	known_options.insert( "-permute" );
	known_options.insert( "-pert_acc_prob" );
	known_options.insert( "-pert_size" );
	known_options.insert( "-perturbe_starting" );
	known_options.insert( "-phi_start" );
	known_options.insert( "-phospho_ser" );
	known_options.insert( "-pick_rna_fragments" );
	known_options.insert( "-pivot_residues" );
	known_options.insert( "-pmut" );
	known_options.insert( "-pmut_scan" );
	known_options.insert( "-point_mut_energies" );
	known_options.insert( "-point_mutation" );
	known_options.insert( "-poke_filter" );
	known_options.insert( "-poly_ala" );
	known_options.insert( "-pose" );
	known_options.insert( "-pose1" );
	known_options.insert( "-pose_abinitio" );
	known_options.insert( "-pose_barcode_stats" );
	known_options.insert( "-pose_benchmark" );
	known_options.insert( "-pose_deriv_check" );
	known_options.insert( "-pose_disulf" );
	known_options.insert( "-pose_fold_and_dock" );
	known_options.insert( "-pose_idealize" );
	known_options.insert( "-pose_idlz" );
	known_options.insert( "-pose_looping" );
	known_options.insert( "-pose_loops_file" );
	known_options.insert( "-pose_relax" );
	known_options.insert( "-pose_relax_deriv_check" );
	known_options.insert( "-pose_relax_fragment_moves" );
	known_options.insert( "-pose_relax_symm" );
	known_options.insert( "-pose_rhiju" );
	known_options.insert( "-pose_score" );
	known_options.insert( "-pose_silent_out" );
	known_options.insert( "-pose_sse" );
	known_options.insert( "-pose_stats" );
	known_options.insert( "-pose_symm_jump_moves_during_relax" );
	known_options.insert( "-pose_symm_n_monomers" );
	known_options.insert( "-post_modify_restart" );
	known_options.insert( "-post_relax" );
	known_options.insert( "-postmin" );
	known_options.insert( "-prefix" );
	known_options.insert( "-premin" );
	known_options.insert( "-prepack_full" );
	known_options.insert( "-prepack_rtmin" );
	known_options.insert( "-prepare_native" );
	known_options.insert( "-prepare_native_dimer" );
	known_options.insert( "-prepare_parents" );
	known_options.insert( "-preserve_header" );
	known_options.insert( "-printmap" );
	known_options.insert( "-prna" );
	known_options.insert( "-prob_stats" );
	known_options.insert( "-probe_specificity" );
	known_options.insert( "-profile" );
	known_options.insert( "-protein" );
	known_options.insert( "-protein_complex" );
	known_options.insert( "-protein_name_prefix" );
	known_options.insert( "-protein_name_prefix_homolog" );
	known_options.insert( "-protein_name_prefix_query" );
	known_options.insert( "-quaternions" );
	known_options.insert( "-quiet" );
	known_options.insert( "-r" );
	known_options.insert( "-rama_check" );
	known_options.insert( "-rand_SS_wt" );
	known_options.insert( "-rand_cst_res_wt" );
	known_options.insert( "-rand_envpair_res_wt" );
	known_options.insert( "-random_frag" );
	known_options.insert( "-random_loop" );
	known_options.insert( "-randomize_moveable_phipsi" );
	known_options.insert( "-random_parallel_antiparallel" );
	known_options.insert( "-randomize1" );
	known_options.insert( "-randomize2" );
	known_options.insert( "-rb" );
	known_options.insert( "-rb_angle_deviation" );
	known_options.insert( "-rb_angle_step" );
	known_options.insert( "-rb_cube_side_length" );
	known_options.insert( "-rb_move" );
	known_options.insert( "-rb_translation_step" );
	known_options.insert( "-read_all_chains" );
	known_options.insert( "-read_enzyme_cst" );
	known_options.insert( "-read_hetero_h2o" );
	known_options.insert( "-read_input_charge" );
	known_options.insert( "-read_interaction_graph" );
	known_options.insert( "-read_old_header" );
	known_options.insert( "-read_patches" );
	known_options.insert( "-realafteroption: missing required arg: " );
	known_options.insert( "-record_annealer_trajectory" );
	known_options.insert( "-record_irms_before_relax" );
	known_options.insert( "-recovery_rms_epsilon" );
	known_options.insert( "-reduce_templates" );
	known_options.insert( "-ref_resfile" );
	known_options.insert( "-refine" );
	known_options.insert( "-refine_with_Ab_after_design" );
	known_options.insert( "-refine_cycles" );
	known_options.insert( "-refine_loop" );
	known_options.insert( "-refine_loops" );
	known_options.insert( "-refine_with_classic" );
	known_options.insert( "-refine_with_constraints" );
	known_options.insert( "-refine_with_minrepack" );
	known_options.insert( "-refine_only" );
	known_options.insert( "-refold" );
	known_options.insert( "-regionfile" );
	known_options.insert( "-regions" );
	known_options.insert( "-relax" );
	known_options.insert( "-relax_rtmin" );
	known_options.insert( "-relax_score_filter" );
	known_options.insert( "-relax_unbound" );
	known_options.insert( "-remark_output" );
	known_options.insert( "-repE_limit" );
	known_options.insert( "-repack" );
	known_options.insert( "-repack_Ab" );
	known_options.insert( "-repack_epitope" );
	known_options.insert( "-design_epitope" );
	known_options.insert( "-repack_inter" );
	known_options.insert( "-repack_neighbors" );
	known_options.insert( "-repack_only" );
	known_options.insert( "-repack_period" );
	known_options.insert( "-repack_rep_weight" );
	known_options.insert( "-repack_trp" );
	known_options.insert( "-repeat" );
	known_options.insert( "-repeatin" );
	known_options.insert( "-repeatout" );
	known_options.insert( "-report_chi" );
	known_options.insert( "-res_dependent" );
	known_options.insert( "-res_enrg_feats" );
	known_options.insert( "-resample_mode" );
	known_options.insert( "-rescore" );
	known_options.insert( "-resfile" );
	known_options.insert( "-restart_from" );
	known_options.insert( "-reverse_comp" );
	known_options.insert( "-reversion_trials" );
	known_options.insert( "-rg_max" );
	known_options.insert( "-rg_reweight" );
	known_options.insert( "-rg_weight" );
	known_options.insert( "-rhiju_gridsearch" );
	known_options.insert( "-rhiju_mcm" );
	known_options.insert( "-rhiju_relax" );
	known_options.insert( "-rigid_body_cycles" );
	known_options.insert( "-rigid_body_frequency" );
	known_options.insert( "-ring_tether" );
	known_options.insert( "-rms" );
	known_options.insert( "-rms_cutoff" );
	known_options.insert( "-rms_feat" );
	known_options.insert( "-rms_shift" );
	known_options.insert( "-rmsd_threshold" );
	known_options.insert( "-rmsd_tol" );
	known_options.insert( "-rna_axis_weight" );
	known_options.insert( "-rna_base_pair_xy" );
	known_options.insert( "-rna_basepair_database" );
	known_options.insert( "-rna_basepair_radius_cutoff" );
	known_options.insert( "-rna_basepair_stagger_cutoff" );
	known_options.insert( "-rna_bp_h_weight" );
	known_options.insert( "-rna_bp_s_weight" );
	known_options.insert( "-rna_bp_w_weight" );
	known_options.insert( "-rna_bs_weight" );
	known_options.insert( "-rna_bulge_weight" );
	known_options.insert( "-rna_centroid_information" );
	known_options.insert( "-rna_contact_weight" );
	known_options.insert( "-rna_featurizer" );
	known_options.insert( "-rna_frag_allpairs" );
	known_options.insert( "-rna_fragments_classes_test" );
	known_options.insert( "-rna_from_scratch" );
	known_options.insert( "-rna_fullatom_minimize" );
	known_options.insert( "-rna_icoor_fix" );
	known_options.insert( "-rna_long_range_contact_weight" );
	known_options.insert( "-rna_pdb_stats" );
	known_options.insert( "-rna_read_jumps" );
	known_options.insert( "-rna_sasa" );
	known_options.insert( "-rna_sasa_file" );
	known_options.insert( "-rna_sasa_weight" );
	known_options.insert( "-rna_score" );
	known_options.insert( "-rna_stagger_weight" );
	known_options.insert( "-rna_vall" );
	known_options.insert( "-rna_vdw_parameter" );
	known_options.insert( "-rna_vdw_scale" );
	known_options.insert( "-rna_verbose" );
	known_options.insert( "-rot_angle_X_delta" );
	known_options.insert( "-rot_angle_X_max" );
	known_options.insert( "-rot_angle_X_min" );
	known_options.insert( "-rot_angle_Y_delta" );
	known_options.insert( "-rot_angle_Y_max" );
	known_options.insert( "-rot_angle_Y_min" );
	known_options.insert( "-rot_angle_Z_delta" );
	known_options.insert( "-rot_angle_Z_max" );
	known_options.insert( "-rot_angle_Z_min" );
	known_options.insert( "-rot_angle_delta" );
	known_options.insert( "-rot_angle_max" );
	known_options.insert( "-rot_angle_min" );
	known_options.insert( "-rot_mag" );
	known_options.insert( "-rot_mag_smooth" );
	known_options.insert( "-rot_opt" );
	known_options.insert( "-rot_pert" );
	known_options.insert( "-rot_pert_input" );
	known_options.insert( "-rotamer_explosion" );
	known_options.insert( "-rotamer_feats" );
	known_options.insert( "-rotamerize" );
	known_options.insert( "-rotation_perturb_magnitude" );
	known_options.insert( "-rotmag" );
	known_options.insert( "-rough_match" );
	known_options.insert( "-rough_match_ca_dist_cutoff" );
	known_options.insert( "-rough_match_ca_distance" );
	known_options.insert( "-rough_match_closure_rms" );
	known_options.insert( "-rough_match_for_input_superpos" );
	known_options.insert( "-rounds" );
	known_options.insert( "-rsd_wt_helix" );
	known_options.insert( "-rsd_wt_loop" );
	known_options.insert( "-rsd_wt_strand" );
	known_options.insert( "-rsigma_reweight" );
	known_options.insert( "-rss_feats" );
	known_options.insert( "-rtmin" );
	known_options.insert( "-run_level" );
	known_options.insert( "-s" );
	known_options.insert( "-s1" );
	known_options.insert( "-s2" );
	known_options.insert( "-s_max" );
	known_options.insert( "-s_min" );
	known_options.insert( "-s_shift" );
	known_options.insert( "-safe" );
	known_options.insert( "-safety" );
	known_options.insert( "-salvage_jumps" );
	known_options.insert( "-sasa_feats" );
	known_options.insert( "-sasa_monte_carlo" );
	known_options.insert( "-sasa_monte_carlo_period" );
	known_options.insert( "-sasapack_bvalues" );
	known_options.insert( "-saxs_model" );
	known_options.insert( "-saxs_model_power" );
	known_options.insert( "-saxs_model_reweight" );
	known_options.insert( "-saxs_model_score" );
	known_options.insert( "-saxs_model_weight" );
	known_options.insert( "-sc_min" );
	known_options.insert( "-sc_only" );
	known_options.insert( "-scaff_first" );
	known_options.insert( "-scaffold" );
	known_options.insert( "-scaffold_first" );
	known_options.insert( "-scale" );
	known_options.insert( "-scale_axis_stagger_by_xy_score" );
	known_options.insert( "-scale_inner_iterations" );
	known_options.insert( "-scale_outer_iterations" );
	known_options.insert( "-scale_rna_torsion_tether" );
	known_options.insert( "-scan_ss_minimum_content" );
	known_options.insert( "-scan_ss_use_any" );
	known_options.insert( "-scan_randomize_moveable" );
	known_options.insert( "-scan_randomize_cutpoints" );
	known_options.insert( "-scan_randomize_ss" );
	known_options.insert( "-scarlet" );
	known_options.insert( "-score" );
	known_options.insert( "-score_all_loops" );
	known_options.insert( "-score_contact_calpha" );
	known_options.insert( "-score_contact_distance" );
	known_options.insert( "-score_contact_file" );
	known_options.insert( "-score_contact_flag" );
	known_options.insert( "-score_contact_fullatom" );
	known_options.insert( "-score_contact_readindist" );
	known_options.insert( "-score_contact_seq_sep" );
	known_options.insert( "-score_contact_threshold" );
	known_options.insert( "-score_contact_weight" );
	known_options.insert( "-score_delta0" );
	known_options.insert( "-score_delta1" );
	known_options.insert( "-score_delta5" );
	known_options.insert( "-score_filter" );
	known_options.insert( "-score_filter_cutoff" );
	known_options.insert( "-score_only" );
	known_options.insert( "-score_oxygens" );
	known_options.insert( "-score_wtsfile" );
	known_options.insert( "-scorefile" );
	known_options.insert( "-scorefilter" );
	known_options.insert( "-scorefxn" );
	known_options.insert( "-screen" );
	known_options.insert( "-screen_with_repack" );
	known_options.insert( "-seed_offset" );
	known_options.insert( "-segment_num" );
	known_options.insert( "-segments" );
	known_options.insert( "-separate_centroid_pack_score" );
	known_options.insert( "-seq_sep_scale" );
	known_options.insert( "-sequential" );
	known_options.insert( "-series" );
	known_options.insert( "-server_models" );
	known_options.insert( "-set_anchor_at_closest_point" );
	known_options.insert( "-set_interface_cutoff" );
	known_options.insert( "-setup_atom_tree" );
	known_options.insert( "-sheet1" );
	known_options.insert( "-sheet_from_barcode" );
	known_options.insert( "-sheet_reweight" );
	known_options.insert( "-shift_amount" );
	known_options.insert( "-shift_option" );
	known_options.insert( "-shiftx" );
	known_options.insert( "-shifty" );
	known_options.insert( "-shiftz" );
	known_options.insert( "-short_interface" );
	known_options.insert( "-short_range_hb_weight" );
	known_options.insert( "-shorten_long_terminal_loop" );
	known_options.insert( "-show_bond_angles" );
	known_options.insert( "-silent" );
	known_options.insert( "-silent_file" );
	known_options.insert( "-silent_input" );
	known_options.insert( "-silent_mode" );
	known_options.insert( "-sim_aneal" );
	known_options.insert( "-simple_elec" );
	known_options.insert( "-site_repack" );
	known_options.insert( "-site_rt" );
	known_options.insert( "-size" );
	known_options.insert( "-skip_C2N_align" );
	known_options.insert( "-skip_N2C_align" );
	known_options.insert( "-skip_abeta_filter" );
	known_options.insert( "-skip_best_fdev_cutoff" );
	known_options.insert( "-skip_fragment_moves" );
	known_options.insert( "-skip_missing_residues" );
	known_options.insert( "-skip_new_score_pose" );
	known_options.insert( "-skip_rama" );
	known_options.insert( "-skip_score" );
	known_options.insert( "-skip_scorefile_check" );
	known_options.insert( "-slavetag" );
	known_options.insert( "-slide_contact_frequency" );
	known_options.insert( "-slide_increment" );
	known_options.insert( "-small_perturbation" );
	known_options.insert( "-small_radii" );
	known_options.insert( "-smart_scorefilter" );
	known_options.insert( "-smm" );
	known_options.insert( "-smooth_etable" );
	known_options.insert( "-smooth_etable_ljweight" );
	known_options.insert( "-smooth_etable_solvweight" );
	known_options.insert( "-smooth_moves" );
	known_options.insert( "-soft_rep" );
	known_options.insert( "-soft_rep_design" );
	known_options.insert( "-solvate" );
	known_options.insert( "-spacing" );
	known_options.insert( "-sparse_trajectory" );
	known_options.insert( "-spatial_filter" );
	known_options.insert( "-spatial_filter_min_cbeta" );
	known_options.insert( "-spatial_filter_max_cbeta" );
	known_options.insert( "-spatial_filter_distance_cutoff" );
	known_options.insert( "-spin" );
	known_options.insert( "-sqc" );
	known_options.insert( "-srvip" );
	known_options.insert( "-srvport" );
	known_options.insert( "-ss_feats" );
	known_options.insert( "-ss_independent_hb_wt" );
	known_options.insert( "-ss_reweight" );
	known_options.insert( "-ss_vdw" );
	known_options.insert( "-ssblocks" );
	known_options.insert( "-ssweight_for_homolog" );
	known_options.insert( "-stage0_design" );
	known_options.insert( "-stage0_rb_minrepack" );
	known_options.insert( "-stage2_cycles" );
	known_options.insert( "-stage2_lj_rep_weight" );
	known_options.insert( "-stage2_repack_period" );
	known_options.insert( "-staged_minimize" );
	known_options.insert( "-start" );
	known_options.insert( "-start_from_extend" );
	known_options.insert( "-start_pdb" );
	known_options.insert( "-start_structure" );
	known_options.insert( "-starting_complex" );
	known_options.insert( "-starting_lj_rep_weight" );
	known_options.insert( "-startres1" );
	known_options.insert( "-startres2" );
	known_options.insert( "-status" );
	known_options.insert( "-std_water" );
	known_options.insert( "-store_n_best_closures" );
	known_options.insert( "-store_n_best_designs" );
	known_options.insert( "-store_top_design_per_backbone" );
	known_options.insert( "-strand_dist_cutoff" );
	known_options.insert( "-stretch_factor" );
	known_options.insert( "-stretch_strand_dist_cutoff" );
	known_options.insert( "-stringent_relax" );
	known_options.insert( "-stringent_relax_before_stage2" );
	known_options.insert( "-stringentrelax_before_stage2" );
	known_options.insert( "-strip_native_rotamers" );
	known_options.insert( "-subset_rmsd" );
	known_options.insert( "-sum_stats" );
	known_options.insert( "-superposition_minrepack_refine" );
	known_options.insert( "-surface" );
	known_options.insert( "-survive_rate" );
	known_options.insert( "-sym_des_units" );
	known_options.insert( "-symm_type" );
	known_options.insert( "-symmetry" );
	known_options.insert( "-t" );
	known_options.insert( "-t32s3" );
	known_options.insert( "-taboo" );
	known_options.insert( "-taboo_continuous" );
	known_options.insert( "-taboo_diagnosis" );
	known_options.insert( "-taboo_file" );
	known_options.insert( "-taboo_header" );
	known_options.insert( "-taboo_mode" );
	known_options.insert( "-taboo_penalize_trace" );
	known_options.insert( "-taboo_penalize_tried" );
	known_options.insert( "-taboo_tenure" );
	known_options.insert( "-tail" );
	known_options.insert( "-tail_fix_helix" );
	known_options.insert( "-target" );
	known_options.insert( "-termini" );
	known_options.insert( "-termini_residue_skip" );
	known_options.insert( "-terse_output" );
	known_options.insert( "-test" );
	known_options.insert( "-test_generic_rama" );
	known_options.insert( "-test_new_ss" );
	known_options.insert( "-testjumps" );
	known_options.insert( "-tether_to_ideal_geometry" );
	known_options.insert( "-thread" );
	known_options.insert( "-three_body_gridsearch" );
	known_options.insert( "-three_body_morph" );
	known_options.insert( "-three_body_relax" );
	known_options.insert( "-three_body_search" );
	known_options.insert( "-threebody" );
	known_options.insert( "-tight_core_analysis" );
	known_options.insert( "-tight_core_thres" );
	known_options.insert( "-tight_memory_restrictions" );
	known_options.insert( "-timelimit" );
	known_options.insert( "-timer" );
	known_options.insert( "-tolerance" );
	known_options.insert( "-topology_filter" );
	known_options.insert( "-topology_info" );
	known_options.insert( "-torsion_feats" );
	known_options.insert( "-torsions" );
	known_options.insert( "-trajectory" );
	known_options.insert( "-trans_X_delta" );
	known_options.insert( "-trans_X_max" );
	known_options.insert( "-trans_X_min" );
	known_options.insert( "-trans_Y_delta" );
	known_options.insert( "-trans_Y_max" );
	known_options.insert( "-trans_Y_min" );
	known_options.insert( "-trans_Z_delta" );
	known_options.insert( "-trans_Z_max" );
	known_options.insert( "-trans_Z_min" );
	known_options.insert( "-trans_dist_delta" );
	known_options.insert( "-trans_dist_max" );
	known_options.insert( "-trans_dist_min" );
	known_options.insert( "-trans_mag" );
	known_options.insert( "-trans_mag_smooth" );
	known_options.insert( "-translate_1D_boltzmann" );
	known_options.insert( "-translate_1D_search" );
	known_options.insert( "-translate_search" );
	known_options.insert( "-translation_perturb_magnitude" );
	known_options.insert( "-transmag" );
	known_options.insert( "-trials_trie" );
	known_options.insert( "-trim" );
	known_options.insert( "-trimer_distance" );
	known_options.insert( "-trimer_scores_file" );
	known_options.insert( "-try_both_his_tautomers" );
	known_options.insert( "-try_rotamers" );
	known_options.insert( "-turn" );
	known_options.insert( "-turn_begin" );
	known_options.insert( "-turn_cluster" );
	known_options.insert( "-turn_end" );
	known_options.insert( "-twist_1D_search" );
	known_options.insert( "-two_rounds_ddmi" );
	known_options.insert( "-unbound_start" );
	known_options.insert( "-unboundrot" );
	known_options.insert( "-unix_paths" );
	known_options.insert( "-use_Ab" );
	known_options.insert( "-use_abs_tolerance" );
	known_options.insert( "-use_actual_centroids" );
	known_options.insert( "-use_alpha_rama" );
	known_options.insert( "-use_atom_weights" );
	known_options.insert( "-use_aw" );
	known_options.insert( "-use_barcode_to_score" );
	known_options.insert( "-use_bbind_conformer" );
	known_options.insert( "-use_bw" );
	known_options.insert( "-use_conformer" );
	known_options.insert( "-use_crankshaft" );
	known_options.insert( "-use_cst_for_rbmin" );
	known_options.insert( "-use_disulf_logfile" );
	known_options.insert( "-use_electrostatic_repulsion" );
	known_options.insert( "-use_epitope_sidechain_during_clash_check" );
	known_options.insert( "-use_fold_constraints_no_minimize" );
	known_options.insert( "-use_full_sidechain_inter_clash" );
	known_options.insert( "-use_h2o" );
	known_options.insert( "-use_hb" );
	known_options.insert( "-use_homolog_cendist_stats" );
	known_options.insert( "-use_homolog_cendist_stats_in_farlx" );
	known_options.insert( "-use_homolog_env_stats" );
	known_options.insert( "-use_homolog_env_stats_in_farlx" );
	known_options.insert( "-use_homolog_pair_stats" );
	known_options.insert( "-use_homolog_pair_stats_in_farlx" );
	known_options.insert( "-use_inexact_line_search" );
	known_options.insert( "-use_input_bond" );
	known_options.insert( "-use_input_cb" );
	known_options.insert( "-use_input_from_match" );
	known_options.insert( "-use_input_rotamer" );
	known_options.insert( "-use_input_sc" );
	known_options.insert( "-use_mdl_connect" );
	known_options.insert( "-use_monte_carlo" );
	known_options.insert( "-use_native_centroid" );
	known_options.insert( "-use_nblist" );
	known_options.insert( "-use_non_monotone_line_search" );
	known_options.insert( "-use_old_graft_info_format" );
	known_options.insert( "-use_packing_etables_always" );
	known_options.insert( "-use_pdb_numbering" );
	known_options.insert( "-use_pdbseq" );
	known_options.insert( "-use_protocol_2" );
	known_options.insert( "-use_random_top_frags" );
	known_options.insert( "-use_rg" );
	known_options.insert( "-use_rotamer_trials" );
	known_options.insert( "-use_rsigma" );
	known_options.insert( "-use_sasa_pack_score" );
	known_options.insert( "-use_score10d" );
	known_options.insert( "-use_score10d_min" );
	known_options.insert( "-use_score12" );
	known_options.insert( "-use_sequence_biased_fragments" );
	known_options.insert( "-use_spatial_cluster" );
	known_options.insert( "-use_sspair" );
	known_options.insert( "-use_symmetry" );
	known_options.insert( "-use_time_as_seed" );
	known_options.insert( "-use_trie" );
	known_options.insert( "-use_weighted_frags" );
	known_options.insert( "-user" );
	known_options.insert( "-user_seq" );
	known_options.insert( "-vall" );
	known_options.insert( "-vall_torsione" );
	known_options.insert( "-var_recorder_file" );
	known_options.insert( "-variable_fragments" );
	known_options.insert( "-variable_regions" );
	known_options.insert( "-vary_all_bond_angles" );
	known_options.insert( "-vary_all_bond_angles_before_stage2" );
	known_options.insert( "-vary_all_bond_distances" );
	known_options.insert( "-vary_all_bond_distances_before_stage2" );
	known_options.insert( "-vary_bond_angles" );
	known_options.insert( "-vary_bond_geometry" );
	known_options.insert( "-vary_bond_geometry_RNA" );
	known_options.insert( "-vary_bond_geometry_no_hydrogens" );
	known_options.insert( "-vary_bonds" );
	known_options.insert( "-vary_cb_bond" );
	known_options.insert( "-vary_chi_before_stage1" );
	known_options.insert( "-vary_chi_before_stage2" );
	known_options.insert( "-vary_omega" );
	known_options.insert( "-vary_sidechain_bond_angles" );
	known_options.insert( "-vary_sidechain_bond_angles_before_stage2" );
	known_options.insert( "-vdw_cutoff" );
	known_options.insert( "-vdw_max" );
	known_options.insert( "-vdw_reweight" );
	known_options.insert( "-vdw_weight" );
	known_options.insert( "-verbose" );
	known_options.insert( "-verbose_output" );
	known_options.insert( "-version" );
	known_options.insert( "-vrot_perc" );
	known_options.insert( "-vrot_repmaxE" );
	known_options.insert( "-wait_on_graphics" );
	known_options.insert( "-watchdog" );
	known_options.insert( "-watchdog_time" );
	known_options.insert( "-watson_crick_reweight" );
	known_options.insert( "-weightfile" );
	known_options.insert( "-wiggle_jxn" );
	known_options.insert( "-window" );
	known_options.insert( "-wobble_CCD" );
	known_options.insert( "-wobble_size" );
	known_options.insert( "-write_interaction_graph" );
	known_options.insert( "-yap" );
	known_options.insert( "-z" );
	known_options.insert( "-zero_constraint_sd" );

	// now check all options
	set< string >::const_iterator end = known_options.end();
	bool everything_ok = true;
	for ( int i = 1; i < options::arg_count; ++i ) {
		if ( options::arg_vector[ i ][ 0 ] == '-' ) {

			if ( known_options.find( options::arg_vector[ i ] ) == end ) {
				// print unknown option
				std::cerr << "WARNING: option unknown   " << options::arg_vector[ i ] << std::endl;
				everything_ok = false;
			}

		}
	}

	// safety
	known_options.clear();

	return everything_ok;
}


} // namespace epigraft
