// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   option_check.hh
/// @brief  Checks command line options to see if it's a valid Rosetta option.
/// @details  Checks command line options to see if it's a valid Rosetta option
/// @details  in any mode.  Will not check whether the option is applicable to
/// @details  the mode being executed.
/// @note  Contains a list of (hard coded) strings that Rosetta uses as options.
/// @author Sergey Menis (menis@u.washington.edu)
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_option_check_HH_
#define INCLUDED_epigraft_option_check_HH_


namespace epigraft {


/// @brief  Checks command line options to see if it's a valid Rosetta option.
/// @details  Checks command line options to see if it's a valid Rosetta option
/// @details  in any mode.  Will not check whether the option is applicable to
/// @details  the mode being executed.  Will echo all problematic options and
/// @details  return control to caller.
/// @return boolean indicating whether all the options are valid
bool
options_are_valid();


} // namespace epigraft

#endif /*INCLUDED_epigraft_option_check_HH_*/
