// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   fragment_assembly.hh
/// @brief  simple fragment assembly routines, primarily for screening
/// @brief  of shorter unknown sequences that may be somewhat unstructured
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_epigraft_prediction_fragment_assembly_HH_
#define INCLUDED_epigraft_prediction_fragment_assembly_HH_


// epigraft headers
#include <epigraft/epigraft_types.hh>


namespace epigraft {
namespace prediction {


/// @brief   pick fragments for a given sequence using vall
/// @warning remember to update max res by e.g. pose_update_MAX_RES() call
///          before calling this routine
/// @return  true if fragments were picked, else false
bool
pick_fragments(
	String const & sequence,
	String const & secondary_structure,
	Integer const & n_fragments = 200
);


/// @brief  given a sequence string, approximate structure using fragments
/// @brief  and no compaction terms
/// @return true if assembled, false otherwise
void
fragment_assemble(
	String const & sequence,
	Pose & pose
);


/// @brief do fragment assembly for mper
void
mper();


} // namespace prediction
} // namespace epigraft

#endif /*INCLUDED_epigraft_prediction_fragment_assembly_HH_*/
