// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/constants.hh
/// @brief  Common numeric constants in varying precisions
/// @author Frank M. D'Ippolito (Objexx@objexx.com)
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @note   The 'constants' namespace and the namespaces within it
//          do not correspond to any package

#ifndef INCLUDED_numeric_constants_HH
#define INCLUDED_numeric_constants_HH


namespace numeric {
namespace constants {


// float
namespace f {

	typedef  float  Type;

	extern Type const zero;
	extern Type const one;
	extern Type const two;
	extern Type const pi;
	extern Type const pi_2;              // 2 * pi
	extern Type const pi_over_2;         // pi / 2
	extern Type const pi_over_3;         // pi / 3
	extern Type const pi_2_over_3;       // ( 2 * pi ) / 3
	extern Type const pi_over_180;       // pi / 180
	extern Type const degrees_to_radians;
	extern Type const deg2rad;
	extern Type const radians_to_degrees;
	extern Type const rad2deg;

} // namespace f


// double
namespace d {

	typedef  double  Type;

	extern Type const zero;
	extern Type const one;
	extern Type const two;
	extern Type const pi;
	extern Type const pi_2;             // 2 * pi
	extern Type const pi_over_2;        // pi / 2
	extern Type const pi_over_3;        // pi / 3
	extern Type const pi_2_over_3;      // ( 2 * pi ) / 3
	extern Type const pi_over_180;      // pi / 180
	extern Type const degrees_to_radians;
	extern Type const deg2rad;
	extern Type const radians_to_degrees;
	extern Type const rad2deg;

} // namespace d


// long double
namespace ld {

	typedef  long double  Type;

	extern Type const zero;
	extern Type const one;
	extern Type const two;
	extern Type const pi;
	extern Type const pi_2;             // 2 * pi
	extern Type const pi_over_2;        // pi / 2
	extern Type const pi_over_3;        // pi / 3
	extern Type const pi_2_over_3;      // ( 2 * pi ) / 3
	extern Type const pi_over_180;      // pi / 180
	extern Type const degrees_to_radians;
	extern Type const deg2rad;
	extern Type const radians_to_degrees;
	extern Type const rad2deg;

} // namespace ld


} // namespace constants
} // namespace numeric


#endif // INCLUDED_numeric_constants_HH
