// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/xyzMatrix.fwd.hh
/// @brief  numeric::xyzMatrix forward declarations
/// @author Frank M. D'Ippolito (Objexx@objexx.com)
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_numeric_xyzMatrix_FWD_HH
#define INCLUDED_numeric_xyzMatrix_FWD_HH


// C++ headers
#include <cstddef>


namespace numeric {


// Forward
template< typename > class xyzMatrix;


// Types
typedef  xyzMatrix< bool >                xyzMatrix_bool;
typedef  xyzMatrix< short int >           xyzMatrix_short;
typedef  xyzMatrix< int >                 xyzMatrix_int;
typedef  xyzMatrix< long int >            xyzMatrix_long;
typedef  xyzMatrix< unsigned short int >  xyzMatrix_ushort;
typedef  xyzMatrix< unsigned int >        xyzMatrix_uint;
typedef  xyzMatrix< unsigned long int >   xyzMatrix_ulong;
typedef  xyzMatrix< std::size_t >         xyzMatrix_size_t;
typedef  xyzMatrix< std::size_t >         xyzMatrix_size;
typedef  xyzMatrix< float >               xyzMatrix_float;
typedef  xyzMatrix< double >              xyzMatrix_double;
typedef  xyzMatrix< long double >         xyzMatrix_longdouble;
typedef  xyzMatrix< char >                xyzMatrix_char;
typedef  xyzMatrix< unsigned char >       xyzMatrix_uchar;
typedef  xyzMatrix< signed char >         xyzMatrix_schar;


} // namespace numeric


#endif // INCLUDED_numeric_xyzMatrix_FWD_HH

