// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   platform/macos/10.4/32/ppc/gcc/platform/types.hh
/// @brief  Platform-specific types for MacOS 10.4 on 32-bit PPC with GCC
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)
/// @note   This can probably be promoted to platform/macos.


#ifndef INCLUDED_platform_types_HH
#define INCLUDED_platform_types_HH


// C++ headers
#include <stdint.h>


/// @brief Scalable size types
#include <sys/types.h>


namespace platform {


namespace file {


/// @brief Are file/path names case sensitive?
bool const CASE_SENSITIVE( true );

/// @brief Volume specifier used?
bool const VOLUME_USED( false );

/// @brief File path separator
char const PATH_SEPARATOR( '/' );


} // namespace file


} // namespace platform


#endif // INCLUDED_platform_types_HH
