// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   platform/windows/32/msvc/platform/types.hh
/// @brief  Platform-specific types for 32-bit Windows with MS VC++
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_platform_types_HH
#define INCLUDED_platform_types_HH


// Windows SDK headers
#include <basetsd.h>


/// @brief Fixed size types
typedef  INT32  int32_t; // 32-bit unsigned integer
typedef  UINT32 uint32_t; // 32-bit unsigned integer
typedef  INT64  int64_t; // 64-bit signed integer
typedef  UINT64  uint64_t; // 64-bit unsigned integer


/// @brief Scalable size types
// intptr_t  Pointer-sized signed integer
// uintptr_t  Pointer-sized unsigned integer
typedef  long int  ssize_t; // Signed size


namespace platform {

typedef size_t       Size;
typedef ssize_t      SSize;
typedef size_t       uint;

namespace file {


/// @brief Are file/path names case sensitive?
bool const CASE_SENSITIVE( false );

/// @brief Volume specifier used?
bool const VOLUME_USED( true );

/// @brief File path separator
char const PATH_SEPARATOR( '\\' );


} // namespace file


} // namespace platform


#endif // INCLUDED_platform_types_HH
