// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/basic_sys_util.hh
/// @brief  All system functions in utility that have no other home
/// @author David Kim (dekim@u.washington.edu)


#ifndef INCLUDED_utility_basic_sys_util_HH
#define INCLUDED_utility_basic_sys_util_HH


// Package headers
#include <utility/exit.hh> // For historic reasons (exit used to be here)

// C++ headers
#include <string>


namespace utility {


/// @brief Sleep for a specified number of seconds
void
sys_sleep( double const seconds );


/// @brief Generate timestamp string
std::string
timestamp();


} // namespace utility


#endif // INCLUDED_utility_basic_sys_util_HH
