// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/boinc/boinc_util.hh
/// @brief  Wrappers to make BOINC work
/// @author David Kim (dekim@u.washington.edu)


#ifndef INCLUDED_utility_boinc_boinc_util_HH
#define INCLUDED_utility_boinc_boinc_util_HH


// C++ headers
#include <string>


namespace utility {
namespace boinc {


/// @brief Start BOINC
void
initialize();


/// @brief Convert logical file names to physical names
void
resolve_filename( std::string & filename );


} // namespace boinc
} // namespace utility


#endif // INCLUDED_utility_boinc_boinc_util_HH
